/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SideModel<T> {
    private final List<AttachedToolWindow<T>> myAllTools;
    private final VisiblePair<T> myLeftVisibleTools;
    private final VisiblePair<T> myRightVisibleTools;
    private final List<Listener<T>> myListeners;
    private final Project myProject;
    private T myContext;
    private AttachedToolWindow<T> myVisibleAutoHideTool;

    SideModel(@NotNull Project project) {
        if (project == null) {
            SideModel.$$$reportNull$$$0(0);
        }
        this.myAllTools = new ArrayList<AttachedToolWindow<T>>(8);
        this.myLeftVisibleTools = new VisiblePair();
        this.myRightVisibleTools = new VisiblePair();
        this.myListeners = new ArrayList<Listener<T>>(2);
        this.myProject = project;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setContext(T context) {
        this.myContext = context;
        this.myAllTools.forEach(tool -> tool.setContext(context));
    }

    public T getContext() {
        return this.myContext;
    }

    public void addListener(@NotNull Listener<T> listener2) {
        if (listener2 == null) {
            SideModel.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener2);
    }

    @NotNull
    public List<AttachedToolWindow<T>> getAllTools() {
        List<AttachedToolWindow<T>> list = this.myAllTools;
        if (list == null) {
            SideModel.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow> getVisibleTools(@NotNull Side side) {
        if (side == null) {
            SideModel.$$$reportNull$$$0(3);
        }
        List<AttachedToolWindow> list = this.getVisibleTools(side.isLeft()).asList();
        if (list == null) {
            SideModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow> getHiddenTools(@NotNull Side side) {
        if (side == null) {
            SideModel.$$$reportNull$$$0(5);
        }
        List<AttachedToolWindow> list = this.myAllTools.stream().filter(tool -> tool.isMinimized() && !tool.isDetached() && !tool.isAutoHide() && tool.isLeft() == side.isLeft()).collect(Collectors.toList());
        if (list == null) {
            SideModel.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow> getTopTools(@NotNull Side side) {
        if (side == null) {
            SideModel.$$$reportNull$$$0(7);
        }
        List<AttachedToolWindow> list = this.myAllTools.stream().filter(tool -> !tool.isDetached() && tool.isLeft() == side.isLeft() && (!tool.isSplit() || tool.isAutoHide())).collect(Collectors.toList());
        if (list == null) {
            SideModel.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow> getBottomTools(@NotNull Side side) {
        if (side == null) {
            SideModel.$$$reportNull$$$0(9);
        }
        List<AttachedToolWindow> list = this.myAllTools.stream().filter(tool -> !tool.isDetached() && tool.isLeft() == side.isLeft() && tool.isSplit() && !tool.isAutoHide()).collect(Collectors.toList());
        if (list == null) {
            SideModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public AttachedToolWindow<T> getVisibleAutoHideTool() {
        return this.myVisibleAutoHideTool;
    }

    @NotNull
    public List<AttachedToolWindow<T>> getHiddenSliders() {
        List<AttachedToolWindow<T>> list = this.myAllTools.stream().filter(tool -> tool.isAutoHide() && !tool.isDetached() && tool.isMinimized()).collect(Collectors.toList());
        if (list == null) {
            SideModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<AttachedToolWindow<T>> getDetachedTools() {
        List<AttachedToolWindow<T>> list = this.myAllTools.stream().filter(AttachedToolWindow::isDetached).collect(Collectors.toList());
        if (list == null) {
            SideModel.$$$reportNull$$$0(12);
        }
        return list;
    }

    public void setTools(@NotNull List<AttachedToolWindow<T>> tools) {
        if (tools == null) {
            SideModel.$$$reportNull$$$0(13);
        }
        tools.forEach(this::add);
        this.updateLocally();
    }

    private void add(@NotNull AttachedToolWindow<T> tool) {
        VisiblePair<T> visible;
        if (tool == null) {
            SideModel.$$$reportNull$$$0(14);
        }
        this.myAllTools.add(tool);
        if (!(tool.isMinimized() || tool.isDetached() || (visible = this.getVisibleTools(tool.isLeft())).setIfEmpty(tool))) {
            tool.setMinimized(true);
        }
    }

    public void changeToolSettingsAfterDragAndDrop(@NotNull AttachedToolWindow<T> tool, @NotNull Side side, @NotNull Split split, int wantedSideToolIndex) {
        if (tool == null) {
            SideModel.$$$reportNull$$$0(15);
        }
        if (side == null) {
            SideModel.$$$reportNull$$$0(16);
        }
        if (split == null) {
            SideModel.$$$reportNull$$$0(17);
        }
        tool.setLeft(side.isLeft());
        tool.setSplit(split.isBottom());
        List<AttachedToolWindow> list = split.isBottom() ? this.getBottomTools(side) : this.getTopTools(side);
        int index = list.indexOf(tool);
        if (index != wantedSideToolIndex && wantedSideToolIndex >= 0 && wantedSideToolIndex < list.size()) {
            int insertAfter = index < wantedSideToolIndex ? 1 : 0;
            this.myAllTools.remove(tool);
            this.myAllTools.add(this.myAllTools.indexOf(list.get(wantedSideToolIndex)) + insertAfter, tool);
        }
        this.update(Collections.singletonList(tool), EventType.UPDATE_TOOL_ORDER);
    }

    public void update(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.PropertyType typeOfChange) {
        if (tool == null) {
            SideModel.$$$reportNull$$$0(18);
        }
        if (typeOfChange == null) {
            SideModel.$$$reportNull$$$0(19);
        }
        this.update(Collections.singletonList(tool), typeOfChange == AttachedToolWindow.PropertyType.DETACHED ? EventType.UPDATE_DETACHED_WINDOW : EventType.UPDATE);
    }

    public void updateLocally() {
        this.myLeftVisibleTools.removeBoth();
        this.myRightVisibleTools.removeBoth();
        this.update(this.myAllTools, EventType.LOCAL_UPDATE);
    }

    private void update(@NotNull List<AttachedToolWindow<T>> tools, @NotNull EventType eventType) {
        if (tools == null) {
            SideModel.$$$reportNull$$$0(20);
        }
        if (eventType == null) {
            SideModel.$$$reportNull$$$0(21);
        }
        for (AttachedToolWindow<T> tool : tools) {
            this.getVisibleTools(true).remove(tool);
            this.getVisibleTools(false).remove(tool);
            if (this.myVisibleAutoHideTool == tool) {
                this.myVisibleAutoHideTool = null;
            }
            if (tool.isMinimized() || tool.isDetached()) continue;
            if (tool.isAutoHide()) {
                if (this.myVisibleAutoHideTool != null) {
                    this.myVisibleAutoHideTool.setMinimized(true);
                }
                this.myVisibleAutoHideTool = tool;
                continue;
            }
            AttachedToolWindow<T> old = this.getVisibleTools(tool.isLeft()).set(tool.isSplit(), tool);
            if (old == null || old == tool) continue;
            old.setMinimized(true);
        }
        this.notifyListeners(eventType);
    }

    public void swap() {
        this.myAllTools.forEach(tool -> tool.setLeft(!tool.isLeft()));
        this.myLeftVisibleTools.swap(this.myRightVisibleTools);
        this.notifyListeners(EventType.SWAP);
    }

    private void notifyListeners(@NotNull EventType type) {
        if (type == null) {
            SideModel.$$$reportNull$$$0(22);
        }
        this.myListeners.forEach(listener2 -> listener2.modelChanged(this, type));
    }

    @NotNull
    private VisiblePair<T> getVisibleTools(boolean isLeft) {
        VisiblePair<T> visiblePair = isLeft ? this.myLeftVisibleTools : this.myRightVisibleTools;
        if (visiblePair == null) {
            SideModel.$$$reportNull$$$0(23);
        }
        return visiblePair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 11, 12, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/workbench/SideModel";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "split";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfChange";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/workbench/SideModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTools";
                break;
            }
            case 4: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleTools";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHiddenTools";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopTools";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBottomTools";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getHiddenSliders";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetachedTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 23: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleTools";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHiddenTools";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTopTools";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBottomTools";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setTools";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "changeToolSettingsAfterDragAndDrop";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "notifyListeners";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 10, 11, 12, 23 -> new IllegalStateException(string);
        };
    }

    public static class VisiblePair<T> {
        @Nullable
        public AttachedToolWindow<T> myTop;
        @Nullable
        public AttachedToolWindow<T> myBottom;

        @Nullable
        public AttachedToolWindow<T> get(boolean isSplit) {
            return isSplit ? this.myBottom : this.myTop;
        }

        @Nullable
        public AttachedToolWindow<T> set(boolean isSplit, @Nullable AttachedToolWindow<T> tool) {
            AttachedToolWindow<T> old = this.get(isSplit);
            if (isSplit) {
                this.myBottom = tool;
            } else {
                this.myTop = tool;
            }
            return old;
        }

        public boolean setIfEmpty(@NotNull AttachedToolWindow<T> tool) {
            if (tool == null) {
                VisiblePair.$$$reportNull$$$0(0);
            }
            if (this.get(tool.isSplit()) != null) {
                return false;
            }
            this.set(tool.isSplit(), tool);
            return true;
        }

        public void remove(@NotNull AttachedToolWindow<T> tool) {
            if (tool == null) {
                VisiblePair.$$$reportNull$$$0(1);
            }
            if (this.myTop == tool) {
                this.myTop = null;
            }
            if (this.myBottom == tool) {
                this.myBottom = null;
            }
        }

        public void removeBoth() {
            this.myTop = null;
            this.myBottom = null;
        }

        public void swap(@NotNull VisiblePair<T> other) {
            if (other == null) {
                VisiblePair.$$$reportNull$$$0(2);
            }
            this.myTop = other.set(false, this.myTop);
            this.myBottom = other.set(true, this.myBottom);
        }

        @NotNull
        public List<AttachedToolWindow> asList() {
            if (this.myTop == null && this.myBottom == null) {
                ImmutableList immutableList = ImmutableList.of();
                if (immutableList == null) {
                    VisiblePair.$$$reportNull$$$0(3);
                }
                return immutableList;
            }
            if (this.myTop == null || this.myBottom == null) {
                ImmutableList immutableList = ImmutableList.of(this.myTop == null ? this.myBottom : this.myTop);
                if (immutableList == null) {
                    VisiblePair.$$$reportNull$$$0(4);
                }
                return immutableList;
            }
            ImmutableList immutableList = ImmutableList.of(this.myTop, this.myBottom);
            if (immutableList == null) {
                VisiblePair.$$$reportNull$$$0(5);
            }
            return immutableList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/workbench/SideModel$VisiblePair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/workbench/SideModel$VisiblePair";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setIfEmpty";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "swap";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static enum EventType {
        UPDATE,
        UPDATE_DETACHED_WINDOW,
        LOCAL_UPDATE,
        SWAP,
        UPDATE_TOOL_ORDER;

    }

    public static interface Listener<T> {
        public void modelChanged(@NotNull SideModel<T> var1, @NotNull EventType var2);
    }
}

