/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.adtui.stdui.Chunk;
import com.android.tools.adtui.stdui.EmptyStatePanel;
import com.android.tools.adtui.stdui.IconChunk;
import com.android.tools.adtui.stdui.LabelData;
import com.android.tools.adtui.stdui.NewLineChunk;
import com.android.tools.adtui.stdui.TextChunk;
import com.android.tools.adtui.stdui.UrlData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class WorkBenchLoadingPanel
extends JPanel {
    private final JBLoadingPanel myLoadingPanel;
    private Color myMessagePanelTextColor;
    private EmptyStatePanel myMessagePanel;

    public WorkBenchLoadingPanel(LayoutManager manager, @NotNull Disposable parent, int startDelayMs) {
        if (parent == null) {
            WorkBenchLoadingPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myMessagePanelTextColor = StudioColorsKt.getHelpText();
        this.myMessagePanel = null;
        this.myLoadingPanel = new JBLoadingPanel(manager, parent, startDelayMs);
        super.add((Component)this.myLoadingPanel);
    }

    public void startLoading() {
        this.resumeLoading();
        this.myLoadingPanel.startLoading();
    }

    public void stopLoading() {
        this.resumeLoading();
        this.myLoadingPanel.stopLoading();
    }

    public void setLoadingText(String text) {
        this.myLoadingPanel.setLoadingText(text);
    }

    @VisibleForTesting
    public boolean isLoading() {
        return this.myLoadingPanel.isLoading();
    }

    @VisibleForTesting
    public boolean hasError() {
        return this.myMessagePanel != null;
    }

    boolean isLoadingOrHasError() {
        return this.isLoading() || this.hasError();
    }

    @Override
    public Component add(Component comp) {
        return this.myLoadingPanel.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        return this.myLoadingPanel.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.myLoadingPanel.add(comp, constraints);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myLoadingPanel.getPreferredSize();
    }

    public void abortLoading(String message, Icon icon) {
        this.abortLoading(message, icon, null);
    }

    public void abortLoading(@NotNull String message, Icon icon, ActionData actionData) {
        if (message == null) {
            WorkBenchLoadingPanel.$$$reportNull$$$0(1);
        }
        this.abortLoading(message, icon, null, actionData);
    }

    public void abortLoading(@NotNull String message, Icon icon, UrlData helpUrlData, ActionData actionData) {
        if (message == null) {
            WorkBenchLoadingPanel.$$$reportNull$$$0(2);
        }
        if (this.myMessagePanel != null) {
            super.remove(this.myMessagePanel);
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        if (icon != null) {
            chunks.add(new IconChunk(icon));
        }
        boolean firstLine = true;
        for (String line : StringUtil.splitByLines((String)message)) {
            if (!firstLine) {
                chunks.add(NewLineChunk.INSTANCE);
            }
            firstLine = false;
            chunks.add(new TextChunk(line));
        }
        this.myMessagePanel = new EmptyStatePanel(new LabelData(chunks.toArray(new Chunk[0])), helpUrlData, actionData, this.myMessagePanelTextColor);
        super.remove((Component)this.myLoadingPanel);
        super.add(this.myMessagePanel);
    }

    private void resumeLoading() {
        if (this.myMessagePanel != null) {
            super.remove(this.myMessagePanel);
            super.add((Component)this.myLoadingPanel);
            this.myMessagePanel = null;
        }
    }

    public void setMessagePanelTextColor(@NotNull Color color) {
        if (color == null) {
            WorkBenchLoadingPanel.$$$reportNull$$$0(3);
        }
        this.myMessagePanelTextColor = color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/workbench/WorkBenchLoadingPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "abortLoading";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setMessagePanelTextColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

