/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreviewBase;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.util.ChangeDiffRequestProducerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRCombinedDiffPreview;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRCombinedDiffPreviewBase;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "filesManager", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "producerFactory", "Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "(Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;)V", "doOpenPreview", "", "requestFocus", "intellij.vcs.github"})
public final class GHPRCombinedDiffPreview
extends GHPRCombinedDiffPreviewBase {
    @Nullable
    private final GHPRDataProvider dataProvider;
    @NotNull
    private final GHPRFilesManager filesManager;

    public GHPRCombinedDiffPreview(@Nullable GHPRDataProvider dataProvider, @NotNull GHPRFilesManager filesManager, @NotNull ChangeDiffRequestProducerFactory producerFactory, @NotNull ChangesTree tree) {
        Intrinsics.checkNotNullParameter((Object)filesManager, (String)"filesManager");
        Intrinsics.checkNotNullParameter((Object)producerFactory, (String)"producerFactory");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        super(dataProvider, filesManager, producerFactory, tree, filesManager);
        this.dataProvider = dataProvider;
        this.filesManager = filesManager;
    }

    @Override
    public boolean doOpenPreview(boolean requestFocus) {
        GHPRIdentifier prId;
        String sourceId = this.getId(this.getTree());
        GHPRDataProvider gHPRDataProvider = this.dataProvider;
        GHPRIdentifier gHPRIdentifier = prId = gHPRDataProvider != null ? gHPRDataProvider.getId() : null;
        if (prId == null) {
            this.filesManager.createAndOpenNewPRDiffPreviewFile(sourceId, true, requestFocus);
        } else {
            this.filesManager.createAndOpenDiffPreviewFile(prId, sourceId, requestFocus);
        }
        return true;
    }
}

