/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.collaboration.api.data.GraphQLRequestPagination;
import com.intellij.collaboration.api.dto.GraphQLNodesDTO;
import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GHPullRequestReviewEvent;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestPendingReviewDTO;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewComment;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.api.data.request.GHPullRequestDraftReviewThread;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRReviewService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHServiceUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u0001:\u00017B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ>\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J6\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016JF\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010 \u001a\u00020!H\u0016JL\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0016J&\u0010)\u001a\b\u0012\u0004\u0012\u00020#0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0011H\u0016J*\u0010+\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010,0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J$\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0'0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0011H\u0016J<\u00101\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010,0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010$\u001a\u00020%2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J&\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0011H\u0016J.\u00103\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u0011H\u0016J&\u00105\u001a\b\u0012\u0004\u0012\u0002060\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "addComment", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewComment;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "reviewId", "", "body", "commitSha", "fileName", "diffLine", "", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "replyToCommentId", "addThread", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "line", "side", "Lcom/intellij/diff/util/Side;", "startLine", "canComment", "", "createReview", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestPendingReviewDTO;", "event", "Lorg/jetbrains/plugins/github/api/data/GHPullRequestReviewEvent;", "threads", "", "Lorg/jetbrains/plugins/github/api/data/request/GHPullRequestDraftReviewThread;", "deleteComment", "commentId", "deleteReview", "", "loadPendingReview", "loadReviewThreads", "resolveThread", "id", "submitReview", "unresolveThread", "updateComment", "newText", "updateReviewBody", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReview;", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRReviewServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRReviewServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewServiceImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n10#2:142\n*S KotlinDebug\n*F\n+ 1 GHPRReviewServiceImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewServiceImpl\n*L\n139#1:142\n*E\n"})
public final class GHPRReviewServiceImpl
implements GHPRReviewService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressManager progressManager;
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private static final Logger LOG;

    public GHPRReviewServiceImpl(@NotNull ProgressManager progressManager, @NotNull GHPRSecurityService securityService, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.progressManager = progressManager;
        this.securityService = securityService;
        this.requestExecutor = requestExecutor;
        this.repository = repository;
    }

    @Override
    public boolean canComment() {
        return this.securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.READ);
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestPendingReviewDTO> loadPendingReview(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestPendingReviewDTO>(this, progressIndicator, pullRequestId){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$pullRequestId = $pullRequestId;
                super(1);
            }

            @Nullable
            public final GHPullRequestPendingReviewDTO invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestPendingReviewDTO)CollectionsKt.singleOrNull((List)((GraphQLNodesDTO)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(this.$progressIndicator, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.pendingReviews(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$pullRequestId.getId()))).getNodes());
            }
        }), LOG, "Error occurred while loading pending review");
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHPullRequestReviewThread>> loadReviewThreads(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, List<? extends GHPullRequestReviewThread>>(this, pullRequestId){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                super(1);
            }

            @NotNull
            public final List<GHPullRequestReviewThread> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new SimpleGHGQLPagesLoader<T>(GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0), (Function1)new Function1<GraphQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHPullRequestReviewThread>>>(this.this$0, this.$pullRequestId){
                    final /* synthetic */ GHPRReviewServiceImpl this$0;
                    final /* synthetic */ GHPRIdentifier $pullRequestId;
                    {
                        this.this$0 = $receiver;
                        this.$pullRequestId = $pullRequestId;
                        super(1);
                    }

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHPullRequestReviewThread>> invoke(@NotNull GraphQLRequestPagination p) {
                        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                        return GHGQLRequests.PullRequest.INSTANCE.reviewThreads(GHPRReviewServiceImpl.access$getRepository$p(this.this$0), this.$pullRequestId.getNumber(), p);
                    }
                }, false, 0, 12, null).loadAll(it);
            }
        }), LOG, "Error occurred while loading review threads");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestPendingReviewDTO> createReview(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @Nullable GHPullRequestReviewEvent event, @Nullable String body2, @Nullable String commitSha, @Nullable List<GHPullRequestDraftReviewThread> threads) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestPendingReviewDTO>(this, progressIndicator, pullRequestId, event, body2, commitSha, threads){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ GHPullRequestReviewEvent $event;
            final /* synthetic */ String $body;
            final /* synthetic */ String $commitSha;
            final /* synthetic */ List<GHPullRequestDraftReviewThread> $threads;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$pullRequestId = $pullRequestId;
                this.$event = $event;
                this.$body = $body;
                this.$commitSha = $commitSha;
                this.$threads = $threads;
                super(1);
            }

            @NotNull
            public final GHPullRequestPendingReviewDTO invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestPendingReviewDTO)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(this.$progressIndicator, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.create(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$pullRequestId.getId(), this.$event, this.$body, this.$commitSha, this.$threads));
            }
        }), LOG, "Error occurred while creating review");
    }

    @Override
    @NotNull
    public CompletableFuture<? extends Object> submitReview(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String reviewId, @NotNull GHPullRequestReviewEvent event, @Nullable String body2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Object>(this, progressIndicator, reviewId, event, body2){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ String $reviewId;
            final /* synthetic */ GHPullRequestReviewEvent $event;
            final /* synthetic */ String $body;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$reviewId = $reviewId;
                this.$event = $event;
                this.$body = $body;
                super(1);
            }

            @NotNull
            public final Object invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(this.$progressIndicator, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.submit(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$reviewId, this.$event, this.$body));
            }
        }), LOG, "Error occurred while submitting review");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReview> updateReviewBody(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestReview>(this, progressIndicator, reviewId, newText){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ String $reviewId;
            final /* synthetic */ String $newText;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$reviewId = $reviewId;
                this.$newText = $newText;
                super(1);
            }

            @NotNull
            public final GHPullRequestReview invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestReview)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(this.$progressIndicator, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.updateBody(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$reviewId, this.$newText));
            }
        }), LOG, "Error occurred while updating review");
    }

    @Override
    @NotNull
    public CompletableFuture<? extends Object> deleteReview(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String reviewId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Object>(this, progressIndicator, reviewId){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ String $reviewId;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$reviewId = $reviewId;
                super(1);
            }

            @NotNull
            public final Object invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(this.$progressIndicator, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.delete(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$reviewId));
            }
        }), LOG, "Error occurred while deleting review");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewComment> addComment(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String reviewId, @NotNull String replyToCommentId, @NotNull String body2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)replyToCommentId, (String)"replyToCommentId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestReviewComment>(this, reviewId, replyToCommentId, body2){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ String $reviewId;
            final /* synthetic */ String $replyToCommentId;
            final /* synthetic */ String $body;
            {
                this.this$0 = $receiver;
                this.$reviewId = $reviewId;
                this.$replyToCommentId = $replyToCommentId;
                this.$body = $body;
                super(1);
            }

            @NotNull
            public final GHPullRequestReviewComment invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestReviewComment)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.addComment(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$reviewId, this.$replyToCommentId, this.$body));
            }
        }), LOG, "Error occurred while adding review thread reply");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewComment> addComment(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull String body2, @NotNull String commitSha, @NotNull String fileName, int diffLine) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestReviewComment>(this, progressIndicator, reviewId, body2, commitSha, fileName, diffLine){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ String $reviewId;
            final /* synthetic */ String $body;
            final /* synthetic */ String $commitSha;
            final /* synthetic */ String $fileName;
            final /* synthetic */ int $diffLine;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$reviewId = $reviewId;
                this.$body = $body;
                this.$commitSha = $commitSha;
                this.$fileName = $fileName;
                this.$diffLine = $diffLine;
                super(1);
            }

            @NotNull
            public final GHPullRequestReviewComment invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestReviewComment)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(this.$progressIndicator, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.addComment(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$reviewId, this.$body, this.$commitSha, this.$fileName, this.$diffLine));
            }
        }), LOG, "Error occurred while adding review comment");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestPendingReviewDTO> deleteComment(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestPendingReviewDTO>(this, commentId){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ String $commentId;
            {
                this.this$0 = $receiver;
                this.$commentId = $commentId;
                super(1);
            }

            @NotNull
            public final GHPullRequestPendingReviewDTO invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestPendingReviewDTO)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.deleteComment(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$commentId));
            }
        }), LOG, "Error occurred while deleting review comment");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewComment> updateComment(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String commentId, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestReviewComment>(this, commentId, newText){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ String $commentId;
            final /* synthetic */ String $newText;
            {
                this.this$0 = $receiver;
                this.$commentId = $commentId;
                this.$newText = $newText;
                super(1);
            }

            @NotNull
            public final GHPullRequestReviewComment invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestReviewComment)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.updateComment(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$commentId, this.$newText));
            }
        }), LOG, "Error occurred while updating review comment");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> addThread(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull String body2, int line, @NotNull Side side, int startLine, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestReviewThread>(this, reviewId, body2, line, side, startLine, fileName){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ String $reviewId;
            final /* synthetic */ String $body;
            final /* synthetic */ int $line;
            final /* synthetic */ Side $side;
            final /* synthetic */ int $startLine;
            final /* synthetic */ String $fileName;
            {
                this.this$0 = $receiver;
                this.$reviewId = $reviewId;
                this.$body = $body;
                this.$line = $line;
                this.$side = $side;
                this.$startLine = $startLine;
                this.$fileName = $fileName;
                super(1);
            }

            @NotNull
            public final GHPullRequestReviewThread invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestReviewThread)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.addThread(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$reviewId, this.$body, this.$line, this.$side, this.$startLine, this.$fileName));
            }
        }), LOG, "Error occurred while adding review thread");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> resolveThread(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestReviewThread>(this, id){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final GHPullRequestReviewThread invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestReviewThread)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.resolveThread(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$id));
            }
        }), LOG, "Error occurred while resolving review thread");
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> unresolveThread(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestReviewThread>(this, id){
            final /* synthetic */ GHPRReviewServiceImpl this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(1);
            }

            @NotNull
            public final GHPullRequestReviewThread invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (GHPullRequestReviewThread)GHPRReviewServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.Review.INSTANCE.unresolveThread(GHPRReviewServiceImpl.access$getRepository$p(this.this$0).getServerPath(), this.$id));
            }
        }), LOG, "Error occurred while unresolving review thread");
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRReviewServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHRepositoryCoordinates access$getRepository$p(GHPRReviewServiceImpl $this) {
        return $this.repository;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRReviewService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewServiceImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

