/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.selector;

import com.intellij.collaboration.auth.ui.LoadingAccountsDetailsProvider;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import com.intellij.collaboration.ui.util.SwingBindingsKt;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorComponentFactory;
import git4idea.remote.hosting.ui.RepositoryAndAccountSelectorViewModel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.AuthorizationType;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GHAccountsDetailsProvider;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.ui.selector.GHRepositoryAndAccountSelectorViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.selector.GHSelectorErrorStatusPresenter;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "vm", "Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorViewModel;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/ui/selector/GHRepositoryAndAccountSelectorViewModel;Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;)V", "create", "Ljavax/swing/JComponent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "createLoginButtons", "", "Ljavax/swing/JButton;", "createPopupLoginActions", "Ljavax/swing/AbstractAction;", "repo", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "loginToGhe", "", "forceNew", "loginToGithub", "authType", "Lorg/jetbrains/plugins/github/authentication/AuthorizationType;", "intellij.vcs.github"})
public final class GHRepositoryAndAccountSelectorComponentFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryAndAccountSelectorViewModel vm;
    @NotNull
    private final GHAccountManager accountManager;

    public GHRepositoryAndAccountSelectorComponentFactory(@NotNull Project project, @NotNull GHRepositoryAndAccountSelectorViewModel vm2, @NotNull GHAccountManager accountManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)vm2), (String)"vm");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        this.project = project;
        this.vm = vm2;
        this.accountManager = accountManager;
    }

    @NotNull
    public final JComponent create(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        GHAccountsDetailsProvider accountDetailsProvider = new GHAccountsDetailsProvider(scope, this.accountManager);
        GHSelectorErrorStatusPresenter errorPresenter2 = new GHSelectorErrorStatusPresenter(this.project, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GHRepositoryAndAccountSelectorComponentFactory.access$getVm$p(this.this$0).submitSelection();
            }
        }));
        RepositoryAndAccountSelectorComponentFactory repositoryAndAccountSelectorComponentFactory = new RepositoryAndAccountSelectorComponentFactory((RepositoryAndAccountSelectorViewModel)this.vm);
        Function1 function1 = (Function1)new Function1<GHGitRepositoryMapping, String>(this){
            final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String invoke(@NotNull GHGitRepositoryMapping mapping) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
                Iterable $this$map$iv = (Iterable)GHRepositoryAndAccountSelectorComponentFactory.access$getVm$p(this.this$0).getRepositoriesState().getValue();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getRepository());
                }
                List allRepositories = (List)destination$iv$iv;
                return GHUIUtil.INSTANCE.getRepositoryDisplayName(allRepositories, mapping.getRepository(), true);
            }
        };
        LoadingAccountsDetailsProvider loadingAccountsDetailsProvider = (LoadingAccountsDetailsProvider)accountDetailsProvider;
        Function1 function12 = (Function1)new Function1<GHGitRepositoryMapping, List<? extends Action>>(this){
            final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<Action> invoke(@NotNull GHGitRepositoryMapping it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHRepositoryAndAccountSelectorComponentFactory.access$createPopupLoginActions(this.this$0, it);
            }
        };
        String string = GithubBundle.message("pull.request.view.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.view.list\")");
        return repositoryAndAccountSelectorComponentFactory.create(scope, function1, loadingAccountsDetailsProvider, function12, string, this.createLoginButtons(scope), (ErrorStatusPresenter)errorPresenter2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<JButton> createLoginButtons(CoroutineScope scope) {
        void $this$createLoginButtons_u24lambda_u244;
        JButton $this$createLoginButtons_u24lambda_u242;
        JButton $this$createLoginButtons_u24lambda_u241;
        JButton jButton;
        Object[] objectArray = new JButton[3];
        JButton jButton2 = jButton = new JButton(GithubBundle.message("action.Github.Accounts.AddGHAccount.text", new Object[0]));
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        CollaborationToolsUIUtil.INSTANCE.setDefault($this$createLoginButtons_u24lambda_u241, true);
        $this$createLoginButtons_u24lambda_u241.setOpaque(false);
        $this$createLoginButtons_u24lambda_u241.addActionListener(arg_0 -> GHRepositoryAndAccountSelectorComponentFactory.createLoginButtons$lambda$1$lambda$0(this, arg_0));
        SwingBindingsKt.bindVisibilityIn((JComponent)$this$createLoginButtons_u24lambda_u241, (CoroutineScope)scope, (Flow)((Flow)this.vm.getGithubLoginAvailableState()));
        SwingBindingsKt.bindDisabledIn((JComponent)$this$createLoginButtons_u24lambda_u241, (CoroutineScope)scope, (Flow)((Flow)this.vm.getBusyState()));
        Unit unit = Unit.INSTANCE;
        objectArray2[n] = jButton;
        String string = GithubBundle.message("action.Github.Accounts.AddGHAccountWithToken.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.Github.A\u2026GHAccountWithToken.text\")");
        $this$createLoginButtons_u24lambda_u241 = jButton = new ActionLink(string, (Function1)new Function1<ActionEvent, Unit>(this){
            final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (GHRepositoryAndAccountSelectorComponentFactory.access$loginToGithub(this.this$0, false, AuthorizationType.TOKEN)) {
                    GHRepositoryAndAccountSelectorComponentFactory.access$getVm$p(this.this$0).submitSelection();
                }
            }
        });
        n = 1;
        objectArray2 = objectArray;
        boolean bl2 = false;
        $this$createLoginButtons_u24lambda_u242.setAutoHideOnDisable(false);
        SwingBindingsKt.bindVisibilityIn((JComponent)$this$createLoginButtons_u24lambda_u242, (CoroutineScope)scope, (Flow)((Flow)this.vm.getGithubLoginAvailableState()));
        SwingBindingsKt.bindDisabledIn((JComponent)$this$createLoginButtons_u24lambda_u242, (CoroutineScope)scope, (Flow)((Flow)this.vm.getBusyState()));
        unit = Unit.INSTANCE;
        objectArray2[n] = jButton;
        $this$createLoginButtons_u24lambda_u242 = jButton = new JButton(GithubBundle.message("action.Github.Accounts.AddGHEAccount.text", new Object[0]));
        n = 2;
        objectArray2 = objectArray;
        boolean bl3 = false;
        CollaborationToolsUIUtil.INSTANCE.setDefault((JButton)$this$createLoginButtons_u24lambda_u244, true);
        $this$createLoginButtons_u24lambda_u244.setOpaque(false);
        $this$createLoginButtons_u24lambda_u244.addActionListener(arg_0 -> GHRepositoryAndAccountSelectorComponentFactory.createLoginButtons$lambda$4$lambda$3(this, arg_0));
        SwingBindingsKt.bindVisibilityIn((JComponent)((JComponent)$this$createLoginButtons_u24lambda_u244), (CoroutineScope)scope, (Flow)((Flow)this.vm.getGheLoginAvailableState()));
        SwingBindingsKt.bindDisabledIn((JComponent)((JComponent)$this$createLoginButtons_u24lambda_u244), (CoroutineScope)scope, (Flow)((Flow)this.vm.getBusyState()));
        unit = Unit.INSTANCE;
        objectArray2[n] = jButton;
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final List<AbstractAction> createPopupLoginActions(GHGitRepositoryMapping repo) {
        List list;
        boolean isDotComServer;
        Object object = repo;
        boolean bl = object != null && (object = ((GHGitRepositoryMapping)object).getRepository()) != null && (object = ((GHRepositoryCoordinates)object).getServerPath()) != null ? ((GithubServerPath)object).isGithubDotCom() : (isDotComServer = false);
        if (isDotComServer) {
            Object[] objectArray = new AbstractAction[2];
            String string = GithubBundle.message("action.Github.Accounts.AddGHAccount.text", new Object[0]);
            objectArray[0] = new AbstractAction(this, string){
                final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(@Nullable ActionEvent e) {
                    GHRepositoryAndAccountSelectorComponentFactory.access$loginToGithub(this.this$0, true, AuthorizationType.OAUTH);
                }
            };
            string = GithubBundle.message("action.Github.Accounts.AddGHAccountWithToken.text", new Object[0]);
            objectArray[1] = new AbstractAction(this, string){
                final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(@Nullable ActionEvent e) {
                    GHRepositoryAndAccountSelectorComponentFactory.access$loginToGithub(this.this$0, true, AuthorizationType.TOKEN);
                }
            };
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            String string = GithubBundle.message("action.Github.Accounts.AddGHEAccount.text", new Object[0]);
            list = CollectionsKt.listOf((Object)new AbstractAction(this, repo, string){
                final /* synthetic */ GHRepositoryAndAccountSelectorComponentFactory this$0;
                final /* synthetic */ GHGitRepositoryMapping $repo;
                {
                    this.this$0 = $receiver;
                    this.$repo = $repo;
                    super($super_call_param$1);
                }

                public void actionPerformed(@Nullable ActionEvent e) {
                    GHGitRepositoryMapping gHGitRepositoryMapping = this.$repo;
                    Intrinsics.checkNotNull((Object)gHGitRepositoryMapping);
                    GHRepositoryAndAccountSelectorComponentFactory.access$loginToGhe(this.this$0, true, gHGitRepositoryMapping);
                }
            });
        }
        return list;
    }

    private final boolean loginToGithub(boolean forceNew, AuthorizationType authType) {
        GithubAccount account = (GithubAccount)((Object)this.vm.getAccountSelectionState().getValue());
        if (account == null || forceNew) {
            GithubAccount githubAccount;
            GithubAccount githubAccount2;
            GHAccountAuthData gHAccountAuthData = GHAccountsUtil.requestNewAccount$default(GithubServerPath.DEFAULT_SERVER, null, this.project, null, authType, 8, null);
            if (gHAccountAuthData != null && (githubAccount2 = gHAccountAuthData.getAccount()) != null) {
                GithubAccount githubAccount3;
                GithubAccount it = githubAccount3 = githubAccount2;
                boolean bl = false;
                this.vm.getAccountSelectionState().setValue((Object)it);
                githubAccount = githubAccount3;
            } else {
                githubAccount = null;
            }
            return githubAccount != null;
        }
        if (Intrinsics.areEqual((Object)this.vm.getMissingCredentialsState().getValue(), (Object)true)) {
            return GHAccountsUtil.requestReLogin$default(account, this.project, null, authType, 4, null) != null;
        }
        return false;
    }

    private final boolean loginToGhe(boolean forceNew, GHGitRepositoryMapping repo) {
        GithubServerPath server = repo.getRepository().getServerPath();
        GithubAccount account = (GithubAccount)((Object)this.vm.getAccountSelectionState().getValue());
        if (account == null || forceNew) {
            GHAccountAuthData gHAccountAuthData;
            GHAccountAuthData gHAccountAuthData2 = GHAccountsUtil.requestNewAccount$default(server, null, this.project, null, null, 24, null);
            if (gHAccountAuthData2 != null) {
                GHAccountAuthData gHAccountAuthData3;
                GHAccountAuthData it = gHAccountAuthData3 = gHAccountAuthData2;
                boolean bl = false;
                this.vm.getAccountSelectionState().setValue((Object)it.getAccount());
                gHAccountAuthData = gHAccountAuthData3;
            } else {
                gHAccountAuthData = null;
            }
            return gHAccountAuthData != null;
        }
        if (Intrinsics.areEqual((Object)this.vm.getMissingCredentialsState().getValue(), (Object)true)) {
            return GHAccountsUtil.requestReLogin$default(account, this.project, null, AuthorizationType.TOKEN, 4, null) != null;
        }
        return false;
    }

    private static final void createLoginButtons$lambda$1$lambda$0(GHRepositoryAndAccountSelectorComponentFactory this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.loginToGithub(false, AuthorizationType.OAUTH)) {
            this$0.vm.submitSelection();
        }
    }

    private static final void createLoginButtons$lambda$4$lambda$3(GHRepositoryAndAccountSelectorComponentFactory this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)this$0.vm.getRepoSelectionState().getValue();
        if (gHGitRepositoryMapping == null) {
            return;
        }
        GHGitRepositoryMapping repo = gHGitRepositoryMapping;
        if (this$0.loginToGhe(false, repo)) {
            this$0.vm.submitSelection();
        }
    }

    public static final /* synthetic */ GHRepositoryAndAccountSelectorViewModel access$getVm$p(GHRepositoryAndAccountSelectorComponentFactory $this) {
        return $this.vm;
    }

    public static final /* synthetic */ List access$createPopupLoginActions(GHRepositoryAndAccountSelectorComponentFactory $this, GHGitRepositoryMapping repo) {
        return $this.createPopupLoginActions(repo);
    }

    public static final /* synthetic */ boolean access$loginToGithub(GHRepositoryAndAccountSelectorComponentFactory $this, boolean forceNew, AuthorizationType authType) {
        return $this.loginToGithub(forceNew, authType);
    }

    public static final /* synthetic */ boolean access$loginToGhe(GHRepositoryAndAccountSelectorComponentFactory $this, boolean forceNew, GHGitRepositoryMapping repo) {
        return $this.loginToGhe(forceNew, repo);
    }
}

