/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020\u0005H\u0014J\b\u0010'\u001a\u00020\u0005H\u0014J\b\u0010(\u001a\u00020)H\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\f0\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0019R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010 R\u0011\u0010\"\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/github/ui/GithubCreateGistDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "", "secret", "", "openInBrowser", "copyLink", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ZZZ)V", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "accounts", "", "accountsModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "kotlin.jvm.PlatformType", "browserCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "copyLinkCheckBox", "description", "getDescription", "()Ljava/lang/String;", "descriptionField", "Lcom/intellij/ui/components/JBTextArea;", "getFileName", "fileNameField", "Lcom/intellij/ui/components/JBTextField;", "isCopyURL", "()Z", "isOpenInBrowser", "isSecret", "secretCheckBox", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "getDimensionServiceKey", "getHelpId", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubCreateGistDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubCreateGistDialog.kt\norg/jetbrains/plugins/github/ui/GithubCreateGistDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class GithubCreateGistDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @Nullable
    private final JBTextField fileNameField;
    @NotNull
    private final JBTextArea descriptionField;
    @NotNull
    private final JBCheckBox secretCheckBox;
    @NotNull
    private final JBCheckBox browserCheckBox;
    @NotNull
    private final JBCheckBox copyLinkCheckBox;
    @NotNull
    private final Set<GithubAccount> accounts;
    @NotNull
    private final CollectionComboBoxModel<GithubAccount> accountsModel;

    /*
     * WARNING - void declaration
     */
    public GithubCreateGistDialog(@NotNull Project project, @NlsSafe @Nullable String fileName, boolean secret, boolean openInBrowser, boolean copyLink) {
        void $this$descriptionField_u24lambda_u240;
        JBTextArea jBTextArea;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true);
        this.project = project;
        this.fileNameField = fileName != null ? new JBTextField(fileName) : null;
        JBTextArea jBTextArea2 = jBTextArea = new JBTextArea();
        GithubCreateGistDialog githubCreateGistDialog = this;
        boolean bl = false;
        $this$descriptionField_u24lambda_u240.setLineWrap(true);
        githubCreateGistDialog.descriptionField = jBTextArea;
        this.secretCheckBox = new JBCheckBox(GithubBundle.message("create.gist.dialog.secret", new Object[0]), secret);
        this.browserCheckBox = new JBCheckBox(GithubBundle.message("create.gist.dialog.open.browser", new Object[0]), openInBrowser);
        this.copyLinkCheckBox = new JBCheckBox(GithubBundle.message("create.gist.dialog.copy.url", new Object[0]), copyLink);
        this.accounts = GHAccountsUtil.getAccounts();
        List list = CollectionsKt.toMutableList((Collection)this.accounts);
        GithubAccount githubAccount = GHAccountsUtil.getDefaultAccount(this.project);
        if (githubAccount == null) {
            githubAccount = (GithubAccount)((Object)CollectionsKt.firstOrNull((Iterable)this.accounts));
        }
        this.accountsModel = new CollectionComboBoxModel(list, (Object)githubAccount);
        this.setTitle(GithubBundle.message("create.gist.dialog.title", new Object[0]));
        this.init();
    }

    @Nullable
    public final String getFileName() {
        JBTextField jBTextField = this.fileNameField;
        return jBTextField != null ? jBTextField.getText() : null;
    }

    @NotNull
    public final String getDescription() {
        String string = this.descriptionField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptionField.text");
        return string;
    }

    public final boolean isSecret() {
        return this.secretCheckBox.isSelected();
    }

    public final boolean isOpenInBrowser() {
        return this.browserCheckBox.isSelected();
    }

    public final boolean isCopyURL() {
        return this.copyLinkCheckBox.isSelected();
    }

    @Nullable
    public final GithubAccount getAccount() {
        return (GithubAccount)((Object)this.accountsModel.getSelected());
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ GithubCreateGistDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                JBTextField jBTextField = GithubCreateGistDialog.access$getFileNameField$p(this.this$0);
                if (jBTextField != null) {
                    JBTextField it = jBTextField;
                    boolean bl = false;
                    String string = GithubBundle.message("create.gist.dialog.filename.field", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"create.gist.dialog.filename.field\")");
                    $this$panel.row(string, (Function1)new Function1<Row, Unit>(it){
                        final /* synthetic */ JBTextField $it;
                        {
                            this.$it = $it;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            $this$row.cell((JComponent)this.$it).align((Align)AlignX.FILL.INSTANCE);
                        }
                    });
                }
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GithubCreateGistDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = GithubBundle.message("create.gist.dialog.description.field", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"create.gist.dialog.description.field\")");
                        $this$row.label(string).align((Align)AlignY.TOP.INSTANCE);
                        $this$row.scrollCell((JComponent)GithubCreateGistDialog.access$getDescriptionField$p(this.this$0)).align(Align.FILL);
                    }
                }), (int)1, null).layout(RowLayout.LABEL_ALIGNED).resizableRow();
                $this$panel.row("", (Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ GithubCreateGistDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)GithubCreateGistDialog.access$getSecretCheckBox$p(this.this$0));
                        $this$row.cell((JComponent)GithubCreateGistDialog.access$getBrowserCheckBox$p(this.this$0));
                        $this$row.cell((JComponent)GithubCreateGistDialog.access$getCopyLinkCheckBox$p(this.this$0));
                    }
                });
                if (GithubCreateGistDialog.access$getAccountsModel$p(this.this$0).getSize() != 1) {
                    String string = GithubBundle.message("create.gist.dialog.create.for.field", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"create.gist.dialog.create.for.field\")");
                    $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ GithubCreateGistDialog this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)GithubCreateGistDialog.access$getAccountsModel$p(this.this$0)), null, (int)2, null).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)new Function2<ValidationInfoBuilder, ComboBox<GithubAccount>, ValidationInfo>(this.this$0){
                                final /* synthetic */ GithubCreateGistDialog this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2);
                                }

                                @Nullable
                                public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull ComboBox<GithubAccount> it) {
                                    ValidationInfo validationInfo;
                                    Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                                    Intrinsics.checkNotNullParameter(it, (String)"it");
                                    if (GithubCreateGistDialog.access$getAccountsModel$p(this.this$0).getSelected() == null) {
                                        String string = GithubBundle.message("dialog.message.account.cannot.be.empty", new Object[0]);
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"dialog.message.account.cannot.be.empty\")");
                                        validationInfo = $this$validationOnApply.error(string);
                                    } else {
                                        validationInfo = null;
                                    }
                                    return validationInfo;
                                }
                            }).resizableColumn();
                            if (GithubCreateGistDialog.access$getAccountsModel$p(this.this$0).getSize() == 0) {
                                $this$row.cell((JComponent)GHAccountsUtil.INSTANCE.createAddAccountLink(GithubCreateGistDialog.access$getProject$p(this.this$0), (CollectionComboBoxModel<GithubAccount>)GithubCreateGistDialog.access$getAccountsModel$p(this.this$0)));
                            }
                        }
                    });
                }
            }
        }));
    }

    @NotNull
    protected String getHelpId() {
        return "github.create.gist.dialog";
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Github.CreateGistDialog";
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.descriptionField;
    }

    public static final /* synthetic */ JBTextField access$getFileNameField$p(GithubCreateGistDialog $this) {
        return $this.fileNameField;
    }

    public static final /* synthetic */ JBTextArea access$getDescriptionField$p(GithubCreateGistDialog $this) {
        return $this.descriptionField;
    }

    public static final /* synthetic */ JBCheckBox access$getSecretCheckBox$p(GithubCreateGistDialog $this) {
        return $this.secretCheckBox;
    }

    public static final /* synthetic */ JBCheckBox access$getBrowserCheckBox$p(GithubCreateGistDialog $this) {
        return $this.browserCheckBox;
    }

    public static final /* synthetic */ JBCheckBox access$getCopyLinkCheckBox$p(GithubCreateGistDialog $this) {
        return $this.copyLinkCheckBox;
    }

    public static final /* synthetic */ CollectionComboBoxModel access$getAccountsModel$p(GithubCreateGistDialog $this) {
        return $this.accountsModel;
    }

    public static final /* synthetic */ Project access$getProject$p(GithubCreateGistDialog $this) {
        return $this.project;
    }
}

