/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.api.stacktrace;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.CodeNavigator;
import com.android.tools.inspectors.common.api.stacktrace.StackFrameParser;
import com.android.tools.inspectors.common.api.stacktrace.ThreadId;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class StackTraceModel
extends AspectModel<Aspect> {
    private static final int INVALID_INDEX = -1;
    @NotNull
    private final CodeNavigator myCodeNavigator;
    @NotNull
    private ThreadId myThreadId;
    @NotNull
    private List<CodeLocation> myStackFrames;
    private int mySelectedIndex;

    public StackTraceModel(@NotNull CodeNavigator codeNavigator) {
        if (codeNavigator == null) {
            StackTraceModel.$$$reportNull$$$0(0);
        }
        this.mySelectedIndex = -1;
        this.myCodeNavigator = codeNavigator;
        this.myStackFrames = Collections.emptyList();
        this.myThreadId = ThreadId.INVALID_THREAD_ID;
    }

    public void setStackFrames(@NotNull ThreadId threadId, @NotNull List<CodeLocation> stackFrames) {
        if (threadId == null) {
            StackTraceModel.$$$reportNull$$$0(1);
        }
        if (stackFrames == null) {
            StackTraceModel.$$$reportNull$$$0(2);
        }
        this.updateStackFrames(threadId, (List<CodeLocation>)ImmutableList.copyOf(stackFrames));
    }

    public void setStackFrames(@NotNull String trace) {
        if (trace == null) {
            StackTraceModel.$$$reportNull$$$0(3);
        }
        this.updateStackFrames(ThreadId.INVALID_THREAD_ID, Arrays.stream(trace.split("\\n")).map(StackFrameParser::parseFrame).collect(Collectors.toList()));
    }

    public void clearStackFrames() {
        this.updateStackFrames(ThreadId.INVALID_THREAD_ID, Collections.emptyList());
    }

    @NotNull
    public CodeNavigator getCodeNavigator() {
        CodeNavigator codeNavigator = this.myCodeNavigator;
        if (codeNavigator == null) {
            StackTraceModel.$$$reportNull$$$0(4);
        }
        return codeNavigator;
    }

    private void updateStackFrames(@NotNull ThreadId threadId, @NotNull List<CodeLocation> stackFrames) {
        if (threadId == null) {
            StackTraceModel.$$$reportNull$$$0(5);
        }
        if (stackFrames == null) {
            StackTraceModel.$$$reportNull$$$0(6);
        }
        this.clearSelection();
        this.myStackFrames = stackFrames;
        this.myThreadId = threadId;
        this.changed(Aspect.STACK_FRAMES);
    }

    @NotNull
    public ThreadId getThreadId() {
        ThreadId threadId = this.myThreadId;
        if (threadId == null) {
            StackTraceModel.$$$reportNull$$$0(7);
        }
        return threadId;
    }

    @NotNull
    public List<CodeLocation> getCodeLocations() {
        List<CodeLocation> list = this.myStackFrames;
        if (list == null) {
            StackTraceModel.$$$reportNull$$$0(8);
        }
        return list;
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    public Type getSelectedType() {
        if (this.mySelectedIndex >= 0 && this.mySelectedIndex < this.myStackFrames.size()) {
            return Type.STACK_FRAME;
        }
        if (this.mySelectedIndex == this.myStackFrames.size()) {
            return Type.THREAD_ID;
        }
        return Type.INVALID;
    }

    public void setSelectedIndex(int index) {
        int size = this.myStackFrames.size() + (ThreadId.INVALID_THREAD_ID.equals(this.myThreadId) ? 0 : 1);
        int newIndex = index >= 0 && index < size ? index : -1;
        boolean indexChanging = newIndex != this.mySelectedIndex;
        this.mySelectedIndex = newIndex;
        if (indexChanging) {
            this.changed(Aspect.SELECTED_LOCATION);
            if (this.getSelectedType() == Type.STACK_FRAME) {
                this.myCodeNavigator.navigate(this.myStackFrames.get(this.mySelectedIndex));
            }
        }
    }

    public void clearSelection() {
        this.setSelectedIndex(-1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeNavigator";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/inspectors/common/api/stacktrace/StackTraceModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/inspectors/common/api/stacktrace/StackTraceModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeNavigator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setStackFrames";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateStackFrames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static enum Aspect {
        STACK_FRAMES,
        SELECTED_LOCATION;

    }

    public static enum Type {
        INVALID,
        STACK_FRAME,
        THREAD_ID;

    }
}

