/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.inspectors.common.ui.dataviewer;

import com.android.tools.inspectors.common.ui.dataviewer.DataViewer;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijDataViewer
implements DataViewer {
    private static final int RAW_VIEWER_MAX_STRING_LENGTH = 500;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final DataViewer.Style myStyle;

    public static IntellijDataViewer createRawTextViewer(@NotNull byte[] content, Boolean isEditable) {
        if (content == null) {
            IntellijDataViewer.$$$reportNull$$$0(0);
        }
        JTextArea textArea = new JTextArea(new String(content, 0, Math.min(content.length, 500)));
        textArea.setLineWrap(true);
        textArea.setEditable(isEditable);
        textArea.setBackground(null);
        textArea.setOpaque(false);
        return new IntellijDataViewer(textArea, DataViewer.Style.RAW);
    }

    public static IntellijDataViewer createRawTextViewer(@NotNull byte[] content) {
        if (content == null) {
            IntellijDataViewer.$$$reportNull$$$0(1);
        }
        return IntellijDataViewer.createRawTextViewer(content, false);
    }

    @NotNull
    public static IntellijDataViewer createPrettyViewerIfPossible(@NotNull Project project, byte[] content, @Nullable FileType fileType, boolean formatted) {
        if (project == null) {
            IntellijDataViewer.$$$reportNull$$$0(2);
        }
        try {
            PsiFile psiFile;
            Language language;
            EditorFactory editorFactory = EditorFactory.getInstance();
            String contentStr = new String(content).replace("\r\n", "\n");
            DataViewer.Style style = DataViewer.Style.RAW;
            Document document = null;
            if (fileType instanceof LanguageFileType && !(language = ((LanguageFileType)fileType).getLanguage()).is((Language)PlainTextLanguage.INSTANCE) && (psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(language, (CharSequence)contentStr)) != null) {
                if (formatted) {
                    ReformatCodeProcessor processor = new ReformatCodeProcessor(psiFile, false);
                    processor.run();
                }
                if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile)) != null) {
                    style = DataViewer.Style.PRETTY;
                }
            }
            if (document == null) {
                document = editorFactory.createDocument(contentStr.toCharArray());
            }
            EditorEx editor = (EditorEx)editorFactory.createViewer(document);
            editor.setCaretVisible(false);
            EditorSettings settings = editor.getSettings();
            settings.setLineNumbersShown(false);
            settings.setLineMarkerAreaShown(false);
            settings.setUseSoftWraps(true);
            settings.setSoftMargins(Collections.emptyList());
            settings.setRightMarginShown(false);
            settings.setFoldingOutlineShown(true);
            CodeFoldingManager.getInstance((Project)project).updateFoldRegions((Editor)editor);
            if (fileType != null) {
                editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, fileType));
            }
            Disposer.register((Disposable)project, () -> editorFactory.releaseEditor((Editor)editor));
            return new IntellijDataViewer(editor.getComponent(), style);
        }
        catch (AssertionError | Exception e) {
            return IntellijDataViewer.createInvalidViewer();
        }
    }

    @NotNull
    public static IntellijDataViewer createInvalidViewer() {
        JLabel component = new JLabel("No preview available", 0);
        component.setFont((Font)JBFont.label().asPlain());
        return new IntellijDataViewer(component, DataViewer.Style.INVALID);
    }

    private IntellijDataViewer(@NotNull JComponent component, @NotNull DataViewer.Style style) {
        if (component == null) {
            IntellijDataViewer.$$$reportNull$$$0(3);
        }
        if (style == null) {
            IntellijDataViewer.$$$reportNull$$$0(4);
        }
        this.myComponent = component;
        this.myStyle = style;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            IntellijDataViewer.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public DataViewer.Style getStyle() {
        DataViewer.Style style = this.myStyle;
        if (style == null) {
            IntellijDataViewer.$$$reportNull$$$0(6);
        }
        return style;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/inspectors/common/ui/dataviewer/IntellijDataViewer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/inspectors/common/ui/dataviewer/IntellijDataViewer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRawTextViewer";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPrettyViewerIfPossible";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

