/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintBundle;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.checks.CallSuperDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;

public class AndroidLintMissingSuperCallInspection
extends AndroidLintInspectionBase {
    public AndroidLintMissingSuperCallInspection() {
        super(LintBundle.message("android.lint.inspections.missing.super.call", new Object[0]), CallSuperDetector.ISSUE);
    }

    @Override
    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, final @Nullable LintFix fixData) {
        if (startElement == null) {
            AndroidLintMissingSuperCallInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintMissingSuperCallInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintMissingSuperCallInspection.$$$reportNull$$$0(2);
        }
        LintIdeQuickFix[] lintIdeQuickFixArray = new LintIdeQuickFix[]{new DefaultLintQuickFix("Add super call", true){

            @Override
            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                if (startElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)startElement)) {
                    return;
                }
                PsiMethod superMethod = LintFix.getMethod((LintFix)fixData, (String)"method");
                if (startElement.getLanguage() == JavaLanguage.INSTANCE) {
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethod.class);
                    if (method == null || method.isConstructor()) {
                        return;
                    }
                    Project project = startElement.getProject();
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                    PsiStatement superStatement = factory.createStatementFromText(this.buildSuperStatement(method, superMethod), null);
                    PsiCodeBlock body = method.getBody();
                    if (body != null) {
                        PsiStatement[] statements = body.getStatements();
                        if (statements.length > 0) {
                            body.addBefore((PsiElement)superStatement, (PsiElement)statements[0]);
                        } else {
                            PsiWhiteSpace whiteSpace = (PsiWhiteSpace)PsiTreeUtil.getChildOfType((PsiElement)method.getBody(), PsiWhiteSpace.class);
                            if (whiteSpace != null && whiteSpace.getText().startsWith("\n\n")) {
                                method.getBody().replace((PsiElement)factory.createCodeBlock());
                                body = method.getBody();
                            }
                            body.add((PsiElement)superStatement);
                        }
                        PsiElement shortened = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)body);
                        CodeStyleManager.getInstance((Project)project).reformat(shortened);
                    }
                } else if (startElement.getLanguage() == KotlinLanguage.INSTANCE) {
                    KtExpression body;
                    Project project = startElement.getProject();
                    KtPsiFactory factory = new KtPsiFactory(project);
                    KtNamedFunction method = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)startElement, KtNamedFunction.class);
                    if (method == null) {
                        return;
                    }
                    String superCall = this.buildSuperStatement(method, superMethod);
                    KtExpression superStatement = factory.createExpression(superCall);
                    KtBlockExpression bodyBlock = method.getBodyBlockExpression();
                    if (bodyBlock == null && (body = method.getBodyExpression()) != null) {
                        PsiElement eq = null;
                        for (PsiElement prev = body.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
                            if (!(prev instanceof TreeElement) || ((TreeElement)prev).getElementType() != KtTokens.EQ) continue;
                            eq = prev;
                            break;
                        }
                        PsiElement parent = body.getParent();
                        bodyBlock = factory.createSingleStatementBlock(body, null, null);
                        body.delete();
                        if (eq != null) {
                            eq.delete();
                        }
                        bodyBlock = (KtBlockExpression)parent.add((PsiElement)bodyBlock);
                    }
                    if (bodyBlock != null) {
                        PsiElement lBrace = bodyBlock.getLBrace();
                        if (lBrace != null) {
                            bodyBlock.addAfter((PsiElement)superStatement, lBrace);
                        } else {
                            List statements = bodyBlock.getStatements();
                            if (!statements.isEmpty()) {
                                bodyBlock.addBefore((PsiElement)superStatement, (PsiElement)statements.get(0));
                            }
                        }
                    }
                }
            }

            @NotNull
            private String buildSuperStatement(PsiMethod method, PsiMethod superMethod) {
                PsiClass containingClass;
                PsiMethod[] superMethods;
                StringBuilder methodCallText = new StringBuilder();
                if (superMethod == null && (superMethods = method.findSuperMethods()).length > 0) {
                    superMethod = superMethods[0];
                }
                if (superMethod != null && (containingClass = superMethod.getContainingClass()) != null && containingClass.isInterface()) {
                    methodCallText.append(containingClass.getQualifiedName()).append('.');
                }
                methodCallText.append("super.").append(method.getName()).append('(');
                PsiParameter[] parameters = method.getParameterList().getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    methodCallText.append(parameters[i].getName());
                    if (i + 1 == parameters.length) continue;
                    methodCallText.append(",");
                }
                methodCallText.append(");");
                String string = methodCallText.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            private String buildSuperStatement(KtNamedFunction method, PsiMethod superMethod) {
                StringBuilder methodCallText = new StringBuilder();
                methodCallText.append("super.").append(method.getName()).append('(');
                List parameters = method.getValueParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    methodCallText.append(((KtParameter)parameters.get(i)).getName());
                    if (i + 1 == parameters.size()) continue;
                    methodCallText.append(",");
                }
                methodCallText.append(")");
                String string = methodCallText.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                if (startElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (contextType == null) {
                    1.$$$reportNull$$$0(7);
                }
                return super.isApplicable(startElement, endElement, contextType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 1: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/lint/common/AndroidLintMissingSuperCallInspection$1";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contextType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintMissingSuperCallInspection$1";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildSuperStatement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "apply";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "isApplicable";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4 -> new IllegalStateException(string);
                };
            }
        }};
        if (lintIdeQuickFixArray == null) {
            AndroidLintMissingSuperCallInspection.$$$reportNull$$$0(3);
        }
        return lintIdeQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/AndroidLintMissingSuperCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/AndroidLintMissingSuperCallInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

