/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;

public class AndroidQuickfixContexts {

    public static class DesignerContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private static final DesignerContext INSTANCE = new DesignerContext();

        private DesignerContext() {
            super(TYPE);
        }

        @NotNull
        public static DesignerContext getInstance() {
            DesignerContext designerContext = INSTANCE;
            if (designerContext == null) {
                DesignerContext.$$$reportNull$$$0(0);
            }
            return designerContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/common/AndroidQuickfixContexts$DesignerContext", "getInstance"));
        }
    }

    public static class EditorPreviewContext
    extends EditorContext {
        public EditorPreviewContext(@NotNull Editor editor, @Nullable PsiFile file) {
            if (editor == null) {
                EditorPreviewContext.$$$reportNull$$$0(0);
            }
            super(editor, file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/lint/common/AndroidQuickfixContexts$EditorPreviewContext", "<init>"));
        }
    }

    public static class EditorContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private final Editor myEditor;
        private final PsiFile myFile;

        private EditorContext(@NotNull Editor editor, @Nullable PsiFile file) {
            if (editor == null) {
                EditorContext.$$$reportNull$$$0(0);
            }
            super(TYPE);
            this.myEditor = editor;
            this.myFile = file;
        }

        @Nullable
        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = this.myEditor;
            if (editor == null) {
                EditorContext.$$$reportNull$$$0(1);
            }
            return editor;
        }

        @Override
        @Nullable
        public Editor getEditor(@NotNull PsiFile file) {
            if (file == null) {
                EditorContext.$$$reportNull$$$0(2);
            }
            if (this.isPreviewFile(file)) {
                return this.myEditor;
            }
            return super.getEditor(file);
        }

        @Override
        @Nullable
        public Document getDocument(@NotNull PsiFile file) {
            if (file == null) {
                EditorContext.$$$reportNull$$$0(3);
            }
            if (this.isPreviewFile(file)) {
                return this.myEditor.getDocument();
            }
            return super.getDocument(file);
        }

        private boolean isPreviewFile(@NotNull PsiFile file) {
            if (file == null) {
                EditorContext.$$$reportNull$$$0(4);
            }
            return file == this.myFile || this.myFile != null && IntentionPreviewUtils.isIntentionPreviewActive() && file.getName().equals(this.myFile.getName());
        }

        @NotNull
        public static EditorContext getInstance(@NotNull Editor editor, @Nullable PsiFile file) {
            if (editor == null) {
                EditorContext.$$$reportNull$$$0(5);
            }
            return new EditorContext(editor, file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/AndroidQuickfixContexts$EditorContext";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/AndroidQuickfixContexts$EditorContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocument";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isPreviewFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class BatchContext
    extends Context {
        public static final ContextType TYPE = new ContextType();
        private static final BatchContext INSTANCE = new BatchContext();

        private BatchContext() {
            super(TYPE);
        }

        @NotNull
        public static BatchContext getInstance() {
            BatchContext batchContext = INSTANCE;
            if (batchContext == null) {
                BatchContext.$$$reportNull$$$0(0);
            }
            return batchContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/lint/common/AndroidQuickfixContexts$BatchContext", "getInstance"));
        }
    }

    public static class ContextType {
        private ContextType() {
        }
    }

    public static abstract class Context {
        private final ContextType myType;

        private Context(@NotNull ContextType type) {
            if (type == null) {
                Context.$$$reportNull$$$0(0);
            }
            this.myType = type;
        }

        @NotNull
        public ContextType getType() {
            ContextType contextType = this.myType;
            if (contextType == null) {
                Context.$$$reportNull$$$0(1);
            }
            return contextType;
        }

        @Nullable
        public Editor getEditor(@NotNull PsiFile file) {
            Editor editor;
            if (file == null) {
                Context.$$$reportNull$$$0(2);
            }
            if ((editor = IntentionBasedInspectionKt.findExistingEditor((PsiElement)file)) != null) {
                return editor;
            }
            return PsiEditorUtil.findEditor((PsiElement)file);
        }

        @Nullable
        public Document getDocument(@NotNull PsiFile file) {
            if (file == null) {
                Context.$$$reportNull$$$0(3);
            }
            return PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/AndroidQuickfixContexts$Context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/AndroidQuickfixContexts$Context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocument";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

