/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.ide.common.blame.SourcePosition;
import com.android.utils.PositionXmlParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class DomPsiConverter {
    private static final DomNodeList EMPTY = new DomNodeList(){

        @Override
        @NotNull
        public DomNode item(int i) {
            throw new IllegalArgumentException();
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        void add(@NotNull DomNode node) {
            if (node == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/lint/common/DomPsiConverter$1", "add"));
        }
    };
    @Nullable
    private static final NamedNodeMap EMPTY_ATTRIBUTES = new NamedNodeMap(){

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        @Nullable
        public Node getNamedItem(String s) {
            return null;
        }

        @Override
        @Nullable
        public Node getNamedItemNS(String s, String s2) throws DOMException {
            return null;
        }

        @Override
        @NotNull
        public Node setNamedItem(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItem(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node item(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Node setNamedItemNS(Node node) throws DOMException {
            return null;
        }

        @Override
        @NotNull
        public Node removeNamedItemNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }
    };

    private DomPsiConverter() {
    }

    @Nullable
    public static Document convert(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            DomPsiConverter.$$$reportNull$$$0(0);
        }
        try {
            XmlDocument xmlDocument = xmlFile.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            return DomPsiConverter.convert(xmlDocument, xmlFile);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            String path = xmlFile.getName();
            VirtualFile virtualFile = xmlFile.getVirtualFile();
            if (virtualFile != null) {
                path = virtualFile.getPath();
            }
            throw new RuntimeException("Could not convert file " + path, e);
        }
    }

    @NotNull
    private static Document convert(@NotNull XmlDocument document, @NotNull XmlFile xmlFile) {
        if (document == null) {
            DomPsiConverter.$$$reportNull$$$0(1);
        }
        if (xmlFile == null) {
            DomPsiConverter.$$$reportNull$$$0(2);
        }
        return new DomDocument(document, xmlFile);
    }

    @Nullable
    public static DomNode findNodeAt(Document document, int offset) {
        assert (document instanceof DomDocument);
        return DomPsiConverter.findElementAt((DomDocument)document, offset);
    }

    @Nullable
    public static DomNode findElementAt(DomNode element, int offset) {
        TextRange range = element.getTextRange();
        if (range == null) {
            return null;
        }
        if (!range.containsOffset(offset)) {
            return null;
        }
        DomNode child = element.getLastChild();
        if (child == null) {
            return null;
        }
        while (child != null) {
            DomNode match = DomPsiConverter.findElementAt(child, offset);
            if (match != null) {
                return match;
            }
            child = child.getPreviousSibling();
        }
        return element;
    }

    @NotNull
    public static TextRange getTextRange(@NotNull Node node) {
        if (node == null) {
            DomPsiConverter.$$$reportNull$$$0(3);
        }
        if (!(node instanceof DomNode)) {
            SourcePosition position = PositionXmlParser.getPosition((Node)node);
            return position != SourcePosition.UNKNOWN ? new TextRange(position.getStartOffset(), position.getEndOffset()) : new TextRange(0, 0);
        }
        DomNode domNode = (DomNode)node;
        TextRange textRange = domNode.getTextRange();
        if (textRange == null) {
            DomPsiConverter.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    public static TextRange trim(Node node, TextRange range) {
        String text;
        if (node.getNodeType() == 3 && node instanceof DomText && (text = ((DomNode)node).myElement.getText()) != null) {
            for (int i = 0; i < text.length(); ++i) {
                int j;
                if (Character.isWhitespace(text.charAt(i))) continue;
                if (i <= 0) break;
                for (j = text.length() - 1; j > i && Character.isWhitespace(text.charAt(j)); --j) {
                }
                return TextRange.create((int)(range.getStartOffset() + i), (int)(range.getEndOffset() - (text.length() - 1 - j)));
            }
        }
        return range;
    }

    @NotNull
    public static TextRange getTextNameRange(@NotNull Node node) {
        XmlElement nameElement;
        if (node == null) {
            DomPsiConverter.$$$reportNull$$$0(5);
        }
        if (!(node instanceof DomNode)) {
            TextRange range = DomPsiConverter.getTextRange(node);
            if (node.getNodeType() == 1) {
                String tag = node.getNodeName();
                int start = range.getStartOffset() + 1;
                return new TextRange(start, start + tag.length());
            }
            if (node.getNodeType() == 2) {
                String name = node.getNodeName();
                int start = range.getStartOffset();
                return new TextRange(start, start + name.length());
            }
            TextRange textRange = range;
            if (textRange == null) {
                DomPsiConverter.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        if (node.getNodeType() == 1 && element instanceof XmlTag) {
            String tag = node.getNodeName();
            int index = element.getText().indexOf(tag);
            if (index != -1) {
                TextRange textRange = element.getTextRange();
                int start = textRange.getStartOffset() + index;
                return new TextRange(start, start + tag.length());
            }
        } else if (node.getNodeType() == 2 && element instanceof XmlAttribute && (nameElement = ((XmlAttribute)element).getNameElement()) != null) {
            TextRange textRange = nameElement.getTextRange();
            if (textRange == null) {
                DomPsiConverter.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            DomPsiConverter.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getTextValueRange(@NotNull Node node) {
        XmlAttributeValue valueElement;
        if (node == null) {
            DomPsiConverter.$$$reportNull$$$0(9);
        }
        if (!(node instanceof DomNode)) {
            TextRange range = DomPsiConverter.getTextRange(node);
            if (node.getNodeType() == 2) {
                String name = node.getNodeValue();
                int end = range.getEndOffset() - 1;
                int start = end - name.length();
                if (start >= range.getStartOffset()) {
                    return new TextRange(start, end);
                }
            }
            TextRange textRange = range;
            if (textRange == null) {
                DomPsiConverter.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        DomNode domNode = (DomNode)node;
        XmlElement element = domNode.myElement;
        TextRange textRange = element.getTextRange();
        if (node.getNodeType() == 2 && element instanceof XmlAttribute && (valueElement = ((XmlAttribute)element).getValueElement()) != null) {
            TextRange textRange2 = valueElement.getValueTextRange();
            if (textRange2 == null) {
                DomPsiConverter.$$$reportNull$$$0(11);
            }
            return textRange2;
        }
        TextRange textRange3 = textRange;
        if (textRange3 == null) {
            DomPsiConverter.$$$reportNull$$$0(12);
        }
        return textRange3;
    }

    @Nullable
    public static XmlElement getPsiElement(@NotNull Node node) {
        if (node == null) {
            DomPsiConverter.$$$reportNull$$$0(13);
        }
        if (node instanceof DomNode) {
            DomNode domNode = (DomNode)node;
            return domNode.myElement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/DomPsiConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextNameRange";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextValueRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTextNameRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextValueRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static class DomDocument
    extends DomNode
    implements Document {
        @NotNull
        private final XmlDocument myPsiDocument;
        private final XmlFile myFile;
        @Nullable
        private DomElement myRoot;

        private DomDocument(@NotNull XmlDocument document, @NotNull XmlFile file) {
            if (document == null) {
                DomDocument.$$$reportNull$$$0(0);
            }
            if (file == null) {
                DomDocument.$$$reportNull$$$0(1);
            }
            super(null, null, (XmlElement)document);
            this.myPsiDocument = document;
            this.myFile = file;
        }

        @Override
        public String lookupPrefix(String s) {
            Element docElement = this.getDocumentElement();
            return docElement != null ? docElement.lookupPrefix(s) : null;
        }

        @Override
        public String lookupNamespaceURI(String s) {
            Element docElement = this.getDocumentElement();
            return docElement != null ? docElement.lookupNamespaceURI(s) : null;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @Nullable
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public short getNodeType() {
            return 9;
        }

        @Override
        @NotNull
        public DomNodeList getChildNodes() {
            if (this.myChildren == null) {
                DomNodeList list;
                this.myChildren = list = new DomNodeList();
                for (PsiElement element = this.myPsiDocument.getFirstChild(); element != null; element = element.getNextSibling()) {
                    DomNode node;
                    if (element instanceof XmlTag) {
                        if (this.myRoot != null && this.myRoot.myTag == element) {
                            list.add(this.myRoot);
                            continue;
                        }
                        node = new DomElement((Document)this, (DomNode)this, (XmlTag)element);
                        if (this.myRoot == null) {
                            this.myRoot = node;
                        }
                        list.add(node);
                        continue;
                    }
                    if (element instanceof XmlComment) {
                        node = new DomComment((Document)this, (DomNode)this, (XmlComment)element);
                        list.add(node);
                        continue;
                    }
                    if (!(element instanceof XmlText)) continue;
                    node = new DomText((Document)this, (DomNode)this, (XmlText)element);
                    list.add(node);
                }
            }
            DomNodeList domNodeList = this.myChildren;
            if (domNodeList == null) {
                DomDocument.$$$reportNull$$$0(2);
            }
            return domNodeList;
        }

        @Override
        @Nullable
        public Object getUserData(String s) {
            if (s.equals(PsiFile.class.getName())) {
                return this.myFile;
            }
            return null;
        }

        @Override
        @NotNull
        public DocumentType getDoctype() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DOMImplementation getImplementation() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Element getDocumentElement() {
            if (this.myRoot == null) {
                XmlTag rootTag = this.myPsiDocument.getRootTag();
                if (rootTag == null) {
                    return null;
                }
                this.myRoot = new DomElement((Document)this, (DomNode)this, rootTag);
            }
            return this.myRoot;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagName(String s) {
            Element root = this.getDocumentElement();
            if (root != null) {
                NodeList nodeList = root.getElementsByTagName(s);
                if (nodeList == null) {
                    DomDocument.$$$reportNull$$$0(3);
                }
                return nodeList;
            }
            DomNodeList domNodeList = EMPTY;
            if (domNodeList == null) {
                DomDocument.$$$reportNull$$$0(4);
            }
            return domNodeList;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagNameNS(String s, String s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element createElement(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DocumentFragment createDocumentFragment() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Text createTextNode(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Comment createComment(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public CDATASection createCDATASection(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ProcessingInstruction createProcessingInstruction(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr createAttribute(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public EntityReference createEntityReference(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node importNode(Node node, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element createElementNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr createAttributeNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element getElementById(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getInputEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getXmlEncoding() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getXmlStandalone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setXmlStandalone(boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getXmlVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setXmlVersion(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getStrictErrorChecking() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStrictErrorChecking(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getDocumentURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDocumentURI(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node adoptNode(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public DOMConfiguration getDomConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalizeDocument() {
        }

        @Override
        @NotNull
        public Node renameNode(Node node, String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/DomPsiConverter$DomDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter$DomDocument";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildNodes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsByTagName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class DomNode
    implements Node {
        @Nullable
        protected final Document myOwner;
        @Nullable
        protected final DomNode myParent;
        @NotNull
        protected final XmlElement myElement;
        @Nullable
        protected DomNodeList myChildren;
        @Nullable
        protected DomNode myNext;
        @Nullable
        protected DomNode myPrevious;

        protected DomNode(@Nullable Document owner, @Nullable DomNode parent, @NotNull XmlElement element) {
            if (element == null) {
                DomNode.$$$reportNull$$$0(0);
            }
            this.myOwner = owner;
            this.myParent = parent;
            this.myElement = element;
        }

        @Override
        @Nullable
        public Node getParentNode() {
            return this.myParent;
        }

        @Override
        @NotNull
        public DomNodeList getChildNodes() {
            if (this.myChildren == null) {
                PsiElement[] children = this.myElement.getChildren();
                if (children.length > 0) {
                    DomNodeList list;
                    this.myChildren = list = new DomNodeList();
                    assert (this.myOwner != null);
                    for (PsiElement child : children) {
                        if (child instanceof XmlTag) {
                            list.add(new DomElement(this.myOwner, this, (XmlTag)child));
                            continue;
                        }
                        if (child instanceof XmlText) {
                            list.add(new DomText(this.myOwner, this, (XmlText)child));
                            continue;
                        }
                        if (!(child instanceof XmlComment)) continue;
                        list.add(new DomComment(this.myOwner, this, (XmlComment)child));
                    }
                } else {
                    this.myChildren = EMPTY;
                }
            }
            DomNodeList domNodeList = this.myChildren;
            if (domNodeList == null) {
                DomNode.$$$reportNull$$$0(1);
            }
            return domNodeList;
        }

        @Override
        @Nullable
        public DomNode getFirstChild() {
            DomNodeList childNodes = this.getChildNodes();
            if (childNodes.getLength() > 0) {
                return childNodes.item(0);
            }
            return null;
        }

        @Override
        @Nullable
        public DomNode getLastChild() {
            DomNodeList childNodes = this.getChildNodes();
            if (childNodes.getLength() > 0) {
                return childNodes.item(0);
            }
            return null;
        }

        @Override
        @Nullable
        public DomNode getPreviousSibling() {
            return this.myPrevious;
        }

        @Override
        @Nullable
        public DomNode getNextSibling() {
            return this.myNext;
        }

        @Override
        @Nullable
        public NamedNodeMap getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Document getOwnerDocument() {
            return this.myOwner;
        }

        @Override
        public void setNodeValue(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node insertBefore(Node node, Node node2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node replaceChild(Node node, Node node2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeChild(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node appendChild(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasChildNodes() {
            return this.getChildNodes().getLength() > 0;
        }

        @Override
        @NotNull
        public Node cloneNode(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void normalize() {
        }

        @Override
        public boolean isSupported(String s, String s2) {
            return false;
        }

        @Override
        @NotNull
        public String getNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getPrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrefix(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public String getLocalName() {
            return null;
        }

        @Override
        public boolean hasAttributes() {
            return false;
        }

        @Override
        @Nullable
        public String getBaseURI() {
            return null;
        }

        @Override
        public short compareDocumentPosition(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.myElement.getText();
        }

        @Override
        public void setTextContent(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSameNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String lookupPrefix(String s) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class, (boolean)false);
            return tag != null ? tag.getPrefixByNamespace(s) : null;
        }

        @Override
        public boolean isDefaultNamespace(String s) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String lookupNamespaceURI(String s) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class, (boolean)false);
            return tag != null ? tag.getNamespaceByPrefix(s) : null;
        }

        @Override
        public boolean isEqualNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object getFeature(String s, String s2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object setUserData(String s, Object o, UserDataHandler userDataHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public Object getUserData(String s) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String getData() throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void setData(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public int getLength() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public String substringData(int i, int i2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void appendData(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void insertData(int i, String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void deleteData(int i, int i2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public void replaceData(int i, int i2, String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        public TextRange getTextRange() {
            return this.myElement.getTextRange();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/DomPsiConverter$DomNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter$DomNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class DomText
    extends DomNode
    implements Text {
        @NotNull
        private final XmlText myText;

        private DomText(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlText text) {
            if (owner == null) {
                DomText.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                DomText.$$$reportNull$$$0(1);
            }
            if (text == null) {
                DomText.$$$reportNull$$$0(2);
            }
            super(owner, parent, (XmlElement)text);
            this.myText = text;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlText)this.myText).getText());
            if (string == null) {
                DomText.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        @NotNull
        public Text splitText(int i) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isElementContentWhitespace() {
            String s = this.myText.getText();
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(s.charAt(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public String getData() throws DOMException {
            String string = this.getNodeValue();
            if (string == null) {
                DomText.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getWholeText() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Text replaceWholeText(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/DomPsiConverter$DomText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter$DomText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class DomNodeList
    implements NodeList {
        protected final List<DomNode> myChildren = new ArrayList<DomNode>();

        private DomNodeList() {
        }

        @Override
        @NotNull
        public DomNode item(int i) {
            DomNode domNode = this.myChildren.get(i);
            if (domNode == null) {
                DomNodeList.$$$reportNull$$$0(0);
            }
            return domNode;
        }

        @Override
        public int getLength() {
            return this.myChildren.size();
        }

        void add(@NotNull DomNode node) {
            int size;
            if (node == null) {
                DomNodeList.$$$reportNull$$$0(1);
            }
            if ((size = this.myChildren.size()) > 0) {
                DomNode last;
                node.myPrevious = last = this.myChildren.get(size - 1);
                last.myNext = node;
            }
            this.myChildren.add(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/DomPsiConverter$DomNodeList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "item";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter$DomNodeList";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DomAttr
    extends DomNode
    implements Attr {
        @NotNull
        private final DomElement myOwner;
        @NotNull
        private final XmlAttribute myAttribute;

        private DomAttr(@NotNull Document document, @NotNull DomElement owner, @NotNull XmlAttribute attribute) {
            if (document == null) {
                DomAttr.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                DomAttr.$$$reportNull$$$0(1);
            }
            if (attribute == null) {
                DomAttr.$$$reportNull$$$0(2);
            }
            super(document, null, (XmlElement)attribute);
            this.myOwner = owner;
            this.myAttribute = attribute;
        }

        @Override
        @NotNull
        public String getNodeName() {
            String string = this.getName();
            if (string == null) {
                DomAttr.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            String string = this.getValue();
            if (string == null) {
                DomAttr.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        @NotNull
        public String getName() {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlAttribute)this.myAttribute).getName());
            if (string == null) {
                DomAttr.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        public boolean getSpecified() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String getValue() {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> {
                String value = this.myAttribute.getDisplayValue();
                return value == null ? "" : value;
            });
            if (string == null) {
                DomAttr.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        public String getLocalName() {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlAttribute)this.myAttribute).getLocalName());
            if (string == null) {
                DomAttr.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPrefix() {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlAttribute)this.myAttribute).getNamespacePrefix());
            if (string == null) {
                DomAttr.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @NotNull
        public String getNamespaceURI() {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlAttribute)this.myAttribute).getNamespace());
            if (string == null) {
                DomAttr.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Override
        public void setValue(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Element getOwnerElement() {
            DomElement domElement = this.myOwner;
            if (domElement == null) {
                DomAttr.$$$reportNull$$$0(10);
            }
            return domElement;
        }

        @Override
        @NotNull
        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isId() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attribute";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/DomPsiConverter$DomAttr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter$DomAttr";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeValue";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocalName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceURI";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    private static class DomComment
    extends DomNode
    implements Comment {
        @NotNull
        private final XmlComment myComment;

        private DomComment(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlComment comment) {
            if (owner == null) {
                DomComment.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                DomComment.$$$reportNull$$$0(1);
            }
            if (comment == null) {
                DomComment.$$$reportNull$$$0(2);
            }
            super(owner, parent, (XmlElement)comment);
            this.myComment = comment;
        }

        @Override
        @Nullable
        public String getNodeName() {
            return null;
        }

        @Override
        @NotNull
        public String getNodeValue() throws DOMException {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlComment)this.myComment).getCommentText());
            if (string == null) {
                DomComment.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public short getNodeType() {
            return 8;
        }

        @Override
        @NotNull
        public String getTextContent() throws DOMException {
            String string = this.getNodeValue();
            if (string == null) {
                DomComment.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getData() throws DOMException {
            String string = this.getNodeValue();
            if (string == null) {
                DomComment.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/DomPsiConverter$DomComment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter$DomComment";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextContent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class DomElement
    extends DomNode
    implements Element {
        private final XmlTag myTag;
        @Nullable
        private NamedNodeMap myAttributes;

        private DomElement(@NotNull Document owner, @NotNull DomNode parent, @NotNull XmlTag tag) {
            if (owner == null) {
                DomElement.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                DomElement.$$$reportNull$$$0(1);
            }
            if (tag == null) {
                DomElement.$$$reportNull$$$0(2);
            }
            super(owner, parent, (XmlElement)tag);
            this.myTag = tag;
        }

        @Override
        @NotNull
        public String getNodeName() {
            String string = this.getTagName();
            if (string == null) {
                DomElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public String getNodeValue() throws DOMException {
            return null;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        @NotNull
        public String getPrefix() {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)this.myTag).getNamespacePrefix());
            if (string == null) {
                DomElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getNamespaceURI() {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)this.myTag).getNamespace());
            if (string == null) {
                DomElement.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        public NamedNodeMap getAttributes() {
            NamedNodeMap namedNodeMap = (NamedNodeMap)ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myAttributes == null) {
                    XmlAttribute[] attributes = this.myTag.getAttributes();
                    this.myAttributes = attributes.length == 0 ? EMPTY_ATTRIBUTES : new DomNamedNodeMap(this, attributes);
                }
                return this.myAttributes;
            });
            if (namedNodeMap == null) {
                DomElement.$$$reportNull$$$0(6);
            }
            return namedNodeMap;
        }

        @Override
        @NotNull
        public String getTagName() {
            String string = (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)this.myTag).getName());
            if (string == null) {
                DomElement.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @Nullable
        public String getLocalName() {
            return (String)ApplicationManager.getApplication().runReadAction(() -> ((XmlTag)this.myTag).getLocalName());
        }

        @Override
        @NotNull
        public String getAttribute(@NotNull String name) {
            Node node;
            if (name == null) {
                DomElement.$$$reportNull$$$0(8);
            }
            if ((node = this.getAttributes().getNamedItem(name)) != null) {
                String string = node.getNodeValue();
                if (string == null) {
                    DomElement.$$$reportNull$$$0(9);
                }
                return string;
            }
            return "";
        }

        @Override
        @NotNull
        public String getAttributeNS(@NotNull String namespace, @NotNull String name) throws DOMException {
            Node node;
            if (namespace == null) {
                DomElement.$$$reportNull$$$0(10);
            }
            if (name == null) {
                DomElement.$$$reportNull$$$0(11);
            }
            if ((node = this.getAttributes().getNamedItemNS(namespace, name)) != null) {
                String string = node.getNodeValue();
                if (string == null) {
                    DomElement.$$$reportNull$$$0(12);
                }
                return string;
            }
            return "";
        }

        @Override
        @Nullable
        public Attr getAttributeNodeNS(@NotNull String namespace, @NotNull String name) throws DOMException {
            Node node;
            if (namespace == null) {
                DomElement.$$$reportNull$$$0(13);
            }
            if (name == null) {
                DomElement.$$$reportNull$$$0(14);
            }
            if ((node = this.getAttributes().getNamedItemNS(namespace, name)) != null) {
                return (Attr)node;
            }
            return null;
        }

        @Override
        @Nullable
        public Attr getAttributeNode(@NotNull String name) {
            Node node;
            if (name == null) {
                DomElement.$$$reportNull$$$0(15);
            }
            if ((node = this.getAttributes().getNamedItem(name)) != null) {
                return (Attr)node;
            }
            return null;
        }

        @Override
        public boolean hasAttribute(@NotNull String name) {
            if (name == null) {
                DomElement.$$$reportNull$$$0(16);
            }
            return this.getAttributes().getNamedItem(name) != null;
        }

        @Override
        public boolean hasAttributeNS(@NotNull String namespace, @NotNull String name) throws DOMException {
            if (namespace == null) {
                DomElement.$$$reportNull$$$0(17);
            }
            if (name == null) {
                DomElement.$$$reportNull$$$0(18);
            }
            return this.getAttributes().getNamedItemNS(namespace, name) != null;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagName(@NotNull String s) {
            DomNodeList childNodes;
            if (s == null) {
                DomElement.$$$reportNull$$$0(19);
            }
            if ((childNodes = this.getChildNodes()) == EMPTY) {
                DomNodeList domNodeList = EMPTY;
                if (domNodeList == null) {
                    DomElement.$$$reportNull$$$0(20);
                }
                return domNodeList;
            }
            DomNodeList matches = new DomNodeList();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = childNodes.item(i);
                if (!s.equals(node.getNodeName())) continue;
                matches.add((DomNode)node);
            }
            DomNodeList domNodeList = matches;
            if (domNodeList == null) {
                DomElement.$$$reportNull$$$0(21);
            }
            return domNodeList;
        }

        @Override
        @NotNull
        public NodeList getElementsByTagNameNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr setAttributeNode(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr removeAttributeNode(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttributeNS(String s, String s2, String s3) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAttributeNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAttribute(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAttribute(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Attr setAttributeNodeNS(Attr attr) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public TypeInfo getSchemaTypeInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttribute(String s, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNS(String s, String s2, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIdAttributeNode(Attr attr, boolean b) throws DOMException {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7, 9, 12, 20, 21 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/common/DomPsiConverter$DomElement";
                    break;
                }
                case 8: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 10: 
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter$DomElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceURI";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTagName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttribute";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributeNS";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsByTagName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 20: 
                case 21: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttribute";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributeNS";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributeNodeNS";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributeNode";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "hasAttribute";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "hasAttributeNS";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsByTagName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7, 9, 12, 20, 21 -> new IllegalStateException(string);
            };
        }
    }

    private static class DomNamedNodeMap
    implements NamedNodeMap {
        @NotNull
        protected final Map<String, DomNode> myMap;
        @NotNull
        protected final Map<String, Map<String, DomNode>> myNsMap;
        @NotNull
        protected final List<DomNode> mItems;

        private DomNamedNodeMap(@NotNull DomElement element, @NotNull XmlAttribute[] attributes) {
            if (element == null) {
                DomNamedNodeMap.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                DomNamedNodeMap.$$$reportNull$$$0(1);
            }
            int count = attributes.length;
            int namespaceCount = 0;
            for (XmlAttribute attribute : attributes) {
                if (attribute.getNamespace().isEmpty()) continue;
                ++namespaceCount;
            }
            this.myMap = new HashMap<String, DomNode>(count - namespaceCount);
            this.myNsMap = new HashMap<String, Map<String, DomNode>>(namespaceCount);
            this.mItems = new ArrayList<DomNode>(count);
            assert (element.myOwner != null);
            for (XmlAttribute attribute : attributes) {
                DomAttr attr = new DomAttr(element.myOwner, element, attribute);
                this.mItems.add(attr);
                String namespace = attribute.getNamespace();
                if (!namespace.isEmpty()) {
                    Map<String, DomNode> map = this.myNsMap.get(namespace);
                    if (map == null) {
                        map = new HashMap<String, DomNode>();
                        this.myNsMap.put(namespace, map);
                    }
                    map.put(attribute.getLocalName(), attr);
                    continue;
                }
                this.myMap.put(attribute.getName(), attr);
            }
        }

        @Override
        public Node item(int i) {
            return this.mItems.get(i);
        }

        @Override
        public int getLength() {
            return this.mItems.size();
        }

        @Override
        public Node getNamedItem(@NotNull String s) {
            if (s == null) {
                DomNamedNodeMap.$$$reportNull$$$0(2);
            }
            return this.myMap.get(s);
        }

        @Override
        @Nullable
        public Node getNamedItemNS(@NotNull String namespace, @NotNull String name) throws DOMException {
            Map<String, DomNode> map;
            if (namespace == null) {
                DomNamedNodeMap.$$$reportNull$$$0(3);
            }
            if (name == null) {
                DomNamedNodeMap.$$$reportNull$$$0(4);
            }
            if ((map = this.myNsMap.get(namespace)) != null) {
                return map.get(name);
            }
            return null;
        }

        @Override
        @NotNull
        public Node setNamedItem(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItem(String s) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node setNamedItemNS(Node node) throws DOMException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Node removeNamedItemNS(String s, String s2) throws DOMException {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/lint/common/DomPsiConverter$DomNamedNodeMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNamedItem";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNamedItemNS";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

