/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidLintLintBaselineInspection;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintExternalAnnotator;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeIssueRegistry;
import com.android.tools.idea.lint.common.LintIdeRequest;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.Sets;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.testFramework.LightVirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LintGlobalInspectionContext
implements GlobalInspectionContextExtension<LintGlobalInspectionContext> {
    static final Key<LintGlobalInspectionContext> ID = Key.create((String)"LintGlobalInspectionContext");
    private Map<Issue, Map<File, List<LintProblemData>>> myResults;
    private LintBaseline myBaseline;
    private Issue myEnabledIssue;

    @NotNull
    public Key<LintGlobalInspectionContext> getID() {
        Key<LintGlobalInspectionContext> key = ID;
        if (key == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void performPreRunActivities(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        if (globalTools == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(1);
        }
        if (localTools == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(2);
        }
        if (context == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(3);
        }
        try {
            this.doAnalyze(globalTools, localTools, context);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Throwable e) {
            Logger.getInstance(LintGlobalInspectionContext.class).error(e);
        }
    }

    private void doAnalyze(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        List<Tools> dynamicTools;
        boolean runningSingleInspection;
        if (globalTools == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(4);
        }
        if (localTools == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(5);
        }
        if (context == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(6);
        }
        Project project = context.getProject();
        LintIdeSupport ideSupport = LintIdeSupport.get();
        if (!ideSupport.canAnalyze(project)) {
            return;
        }
        if (globalTools.stream().noneMatch(it -> it.getShortName().startsWith("AndroidLint"))) {
            return;
        }
        Set<Issue> issues = LintExternalAnnotator.Companion.getIssuesFromInspections(project, null);
        if (issues.isEmpty()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        boolean bl = runningSingleInspection = localTools.isEmpty() && globalTools.size() == 1;
        if (runningSingleInspection) {
            Tools tool = globalTools.get(0);
            String id = tool.getShortName().substring("AndroidLint".length());
            Issue issue = LintIdeIssueRegistry.get().getIssue(id);
            if (issue != null && !issue.isEnabledByDefault()) {
                issues = Collections.singleton(issue);
                issue.setEnabledByDefault(true);
                this.myEnabledIssue = issue;
            }
        }
        HashMap<Issue, Map<File, List<LintProblemData>>> problemMap = new HashMap<Issue, Map<File, List<LintProblemData>>>();
        AnalysisScope scope = context.getRefManager().getScope();
        if (scope == null && (scope = AndroidLintLintBaselineInspection.ourRerunScope) == null) {
            return;
        }
        LintBatchResult lintResult = new LintBatchResult(project, problemMap, scope, issues);
        LintIdeClient client = ideSupport.createBatchClient(lintResult);
        EnumSet lintScope = EnumSet.copyOf(Scope.ALL);
        lintScope.remove(Scope.CLASS_FILE);
        lintScope.remove(Scope.ALL_CLASS_FILES);
        lintScope.remove(Scope.JAVA_LIBRARIES);
        ArrayList<VirtualFile> files = null;
        ArrayList<Module> modules = new ArrayList<Module>();
        int scopeType = scope.getScopeType();
        switch (scopeType) {
            case 4: {
                ModuleWithDependenciesScope s;
                Object searchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
                if (!(searchScope instanceof ModuleWithDependenciesScope) || (s = (ModuleWithDependenciesScope)searchScope).isSearchInLibraries()) break;
                modules.add(s.getModule());
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                files = new ArrayList<VirtualFile>();
                Object searchScope = (SearchScope)ReadAction.compute(() -> ((AnalysisScope)scope).toSearchScope());
                if (searchScope instanceof LocalSearchScope) {
                    LocalSearchScope localSearchScope = (LocalSearchScope)searchScope;
                    PsiElement[] elements = localSearchScope.getScope();
                    ArrayList<VirtualFile> finalFiles = files;
                    ApplicationManager.getApplication().runReadAction(() -> {
                        for (PsiElement element : elements) {
                            VirtualFile virtualFile;
                            if (!(element instanceof PsiFile)) continue;
                            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                            if (module != null && !modules.contains(module)) {
                                modules.add(module);
                            }
                            if ((virtualFile = ((PsiFile)element).getVirtualFile()) == null || virtualFile instanceof LightVirtualFile) continue;
                            finalFiles.add(virtualFile);
                        }
                    });
                } else {
                    final ArrayList<VirtualFile> finalList = files;
                    scope.accept(new PsiElementVisitor(){

                        public void visitFile(@NotNull PsiFile file) {
                            VirtualFile virtualFile;
                            if (file == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if ((virtualFile = file.getVirtualFile()) != null) {
                                finalList.add(virtualFile);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/lint/common/LintGlobalInspectionContext$1", "visitFile"));
                        }
                    });
                }
                if (files.isEmpty()) {
                    files = null;
                    break;
                }
                lintScope = null;
                break;
            }
            case 1: {
                modules.addAll(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                Logger.getInstance(this.getClass()).warn("Unexpected inspection scope " + scope + ", " + scopeType);
            }
        }
        if (modules.isEmpty()) {
            for (Object module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!scope.containsModule((Module)module)) continue;
                modules.add((Module)module);
            }
            if (modules.isEmpty() && files != null) {
                for (VirtualFile file : files) {
                    Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                    if (module == null || modules.contains(module)) continue;
                    modules.add(module);
                }
            }
            if (modules.isEmpty()) {
                AnalysisScope scopeRef = scope;
                AnalysisScope narrowed = (AnalysisScope)ReadAction.compute(() -> scopeRef.getNarrowedComplementaryScope(project));
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    if (!narrowed.containsModule(module)) continue;
                    modules.add(module);
                }
            }
        }
        LintIdeRequest request = new LintIdeRequest(client, project, files, modules, false);
        request.setScope(lintScope);
        LintDriver lint = client.createDriver(request);
        this.myBaseline = null;
        Module severityModule = null;
        for (Module module : modules) {
            String path;
            File baselineFile;
            if (severityModule == null && ideSupport.getSeverityOverrides(module) != null) {
                severityModule = module;
            }
            if ((baselineFile = ideSupport.getBaselineFile(client, module)) == null || AndroidLintLintBaselineInspection.ourSkipBaselineNextRun) continue;
            if (!baselineFile.isAbsolute() && (path = module.getProject().getBasePath()) != null) {
                baselineFile = new File(FileUtilRt.toSystemDependentName((String)path), baselineFile.getPath());
            }
            this.myBaseline = new LintBaseline((LintClient)client, baselineFile);
            lint.setBaseline(this.myBaseline);
            if (!baselineFile.isFile()) {
                this.myBaseline.setWriteOnClose(true);
                break;
            }
            if (!AndroidLintLintBaselineInspection.ourUpdateBaselineNextRun) break;
            this.myBaseline.setRemoveFixed(true);
            this.myBaseline.setWriteOnClose(true);
            break;
        }
        lint.analyze();
        if (!runningSingleInspection && (dynamicTools = AndroidLintInspectionBase.getDynamicTools(project)) != null) {
            if (dynamicTools.size() == 1) {
                for (Tools tool : dynamicTools) {
                    String name = tool.getShortName();
                    boolean alreadyRegistered = false;
                    for (Tools registered : globalTools) {
                        if (!registered.getShortName().equals(name)) continue;
                        alreadyRegistered = true;
                        break;
                    }
                    if (alreadyRegistered) continue;
                    globalTools.add(tool);
                }
            } else {
                HashSet registeredNames = Sets.newHashSetWithExpectedSize((int)dynamicTools.size());
                for (Tools registered : globalTools) {
                    registeredNames.add(registered.getShortName());
                }
                for (Tools tool : dynamicTools) {
                    if (registeredNames.contains(tool.getShortName())) continue;
                    globalTools.add(tool);
                }
            }
        }
        AndroidLintLintBaselineInspection.clearNextRunState();
        lint.setAnalysisStartTime(startTime);
        ideSupport.logSession(lint, severityModule, lintResult);
        this.myResults = problemMap;
    }

    @Nullable
    public Map<Issue, Map<File, List<LintProblemData>>> getResults() {
        return this.myResults;
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper<?, ?>> inspections, @NotNull GlobalInspectionContext context) {
        if (inspections == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(7);
        }
        if (context == null) {
            LintGlobalInspectionContext.$$$reportNull$$$0(8);
        }
        if (this.myBaseline != null) {
            if (this.myBaseline.getWriteOnClose()) {
                ApplicationManager.getApplication().runReadAction(() -> this.myBaseline.close());
            }
            if (this.myBaseline.getWriteOnClose()) {
                String message = this.myBaseline.getRemoveFixed() ? String.format(Locale.US, "Updated baseline file %1$s<br>Removed %2$d issues<br>%3$s remaining", this.myBaseline.getFile().getName(), this.myBaseline.getFixedCount(), Lint.describeCounts((int)this.myBaseline.getFoundErrorCount(), (int)this.myBaseline.getFoundWarningCount(), (boolean)false, (boolean)true)) : String.format(Locale.US, "Created baseline file %1$s<br>%2$d issues will be filtered out", this.myBaseline.getFile().getName(), this.myBaseline.getTotalCount());
                new NotificationGroup("Wrote Baseline", NotificationDisplayType.BALLOON, true, null, null, null, PluginId.getId((String)"org.jetbrains.android")).createNotification(message, NotificationType.INFORMATION).notify(context.getProject());
            }
        }
    }

    public void cleanup() {
        if (this.myEnabledIssue != null) {
            this.myEnabledIssue.setEnabledByDefault(false);
            this.myEnabledIssue = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/LintGlobalInspectionContext";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/LintGlobalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performPreRunActivities";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doAnalyze";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performPostRunActivities";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

