/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class LintIdeGradleVisitor
extends GradleVisitor {
    private static List<String> getClosureNames(GrClosableBlock closure) {
        GrReferenceExpression invokedExpression;
        GrMethodCall parent;
        ArrayList<String> result = new ArrayList<String>(2);
        if (closure.getParent() instanceof GrMethodCall && (parent = (GrMethodCall)closure.getParent()).getInvokedExpression() instanceof GrReferenceExpression && (invokedExpression = (GrReferenceExpression)parent.getInvokedExpression()).getReferenceName() != null) {
            result.add(invokedExpression.getReferenceName());
            if (invokedExpression.isQualified()) {
                GrReferenceExpression qualifierReferenceExpression;
                GrExpression qualifierExpression = invokedExpression.getQualifierExpression();
                if (qualifierExpression instanceof GrReferenceExpression && (qualifierReferenceExpression = (GrReferenceExpression)qualifierExpression).getReferenceName() != null) {
                    result.add(qualifierReferenceExpression.getReferenceName());
                }
            } else {
                GrReferenceExpression parent2InvokedExpression;
                GrMethodCall parent2;
                GrClosableBlock parentClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)closure, GrClosableBlock.class, (boolean)true);
                if (parentClosableBlock != null && parentClosableBlock.getParent() instanceof GrMethodCall && (parent2 = (GrMethodCall)parentClosableBlock.getParent()).getInvokedExpression() instanceof GrReferenceExpression && (parent2InvokedExpression = (GrReferenceExpression)parent2.getInvokedExpression()).getReferenceName() != null) {
                    result.add(parent2InvokedExpression.getReferenceName());
                }
            }
        }
        return result;
    }

    private static List<String> getReferenceExpressionNames(GrReferenceExpression referenceExpression) {
        ArrayList<String> result = new ArrayList<String>(3);
        if (referenceExpression.getReferenceName() != null) {
            GrReferenceExpression qualifierReferenceExpression;
            result.add(referenceExpression.getReferenceName());
            if (referenceExpression.isQualified() && referenceExpression.getQualifierExpression() instanceof GrReferenceExpression && (qualifierReferenceExpression = (GrReferenceExpression)referenceExpression.getQualifierExpression()).getReferenceName() != null) {
                GrReferenceExpression qualifierQualifierReferenceExpression;
                result.add(qualifierReferenceExpression.getReferenceName());
                if (qualifierReferenceExpression.isQualified() && qualifierReferenceExpression.getQualifierExpression() instanceof GrReferenceExpression && (qualifierQualifierReferenceExpression = (GrReferenceExpression)qualifierReferenceExpression.getQualifierExpression()).getReferenceName() != null) {
                    result.add(qualifierQualifierReferenceExpression.getReferenceName());
                }
            }
        }
        return result;
    }

    private static void extractMethodCallArguments(GrMethodCall methodCall, List<String> unnamed, Map<String, String> named) {
        GrArgumentList argumentList = methodCall.getArgumentList();
        for (GroovyPsiElement groovyPsiElement : argumentList.getAllArguments()) {
            if (groovyPsiElement instanceof GrNamedArgument) {
                Object value;
                GrNamedArgument namedArgument = (GrNamedArgument)groovyPsiElement;
                GrExpression expression = namedArgument.getExpression();
                if (!(expression instanceof GrLiteral) || (value = ((GrLiteral)expression).getValue()) == null) continue;
                named.put(namedArgument.getLabelName(), value.toString());
                continue;
            }
            if (!(groovyPsiElement instanceof GrExpression)) continue;
            unnamed.add(groovyPsiElement.getText());
        }
    }

    public void visitBuildScript(final @NotNull GradleContext context, final @NotNull List<? extends GradleScanner> detectors) {
        if (context == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(0);
        }
        if (detectors == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = LintIdeUtilsKt.getPsiFile((Context)context);
                if (!(psiFile instanceof GroovyFile)) {
                    return;
                }
                GroovyFile groovyFile = (GroovyFile)psiFile;
                groovyFile.accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

                    public void visitClosure(@NotNull GrClosableBlock closure) {
                        List<String> closureNames;
                        if (closure == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((closureNames = LintIdeGradleVisitor.getClosureNames(closure)).size() != 0) {
                            for (PsiElement element : closure.getChildren()) {
                                GrExpression rValue;
                                String parentParentName;
                                String parentName;
                                String property;
                                List<String> names;
                                GrReferenceExpression propertyRef;
                                GrExpression lValue;
                                GrMethodCallExpression assignment;
                                String value;
                                if (element instanceof GrApplicationStatement) {
                                    String parentParentName2;
                                    GrApplicationStatement call = (GrApplicationStatement)element;
                                    GrExpression propertyExpression = call.getInvokedExpression();
                                    GrCommandArgumentList argumentList = call.getArgumentList();
                                    if (!(propertyExpression instanceof GrReferenceExpression)) continue;
                                    GrReferenceExpression propertyRef2 = (GrReferenceExpression)propertyExpression;
                                    List<String> names2 = LintIdeGradleVisitor.getReferenceExpressionNames(propertyRef2);
                                    names2.addAll(closureNames);
                                    String property2 = names2.get(0);
                                    String parentName2 = names2.size() > 1 ? names2.get(1) : null;
                                    String string = parentParentName2 = names2.size() > 2 ? names2.get(2) : null;
                                    if (property2 == null || parentName2 == null || argumentList == null) continue;
                                    value = argumentList.getText();
                                    for (GradleScanner detector : detectors) {
                                        detector.checkDslPropertyAssignment(context, property2, value, parentName2, parentParentName2, (Object)propertyRef2, (Object)argumentList, (Object)call);
                                    }
                                    continue;
                                }
                                if (element instanceof GrMethodCallExpression) {
                                    assignment = (GrMethodCallExpression)element;
                                    lValue = assignment.getInvokedExpression();
                                    if (!(lValue instanceof GrReferenceExpression)) continue;
                                    propertyRef = (GrReferenceExpression)lValue;
                                    names = LintIdeGradleVisitor.getReferenceExpressionNames(propertyRef);
                                    names.addAll(closureNames);
                                    property = names.get(0);
                                    parentName = names.size() > 1 ? names.get(1) : null;
                                    String string = parentParentName = names.size() > 2 ? names.get(2) : null;
                                    if (property == null || parentName == null) continue;
                                    GrExpression[] list = assignment.getArgumentList().getExpressionArguments();
                                    if (list.length == 1) {
                                        GrExpression rValue2 = list[0];
                                        String value2 = rValue2.getText();
                                        for (GradleScanner detector : detectors) {
                                            detector.checkDslPropertyAssignment(context, property, value2, parentName, parentParentName, (Object)lValue, (Object)rValue2, (Object)assignment);
                                        }
                                        continue;
                                    }
                                    HashMap<String, String> namedArguments = new HashMap<String, String>();
                                    ArrayList<String> unnamedArguments = new ArrayList<String>();
                                    LintIdeGradleVisitor.extractMethodCallArguments((GrMethodCall)assignment, unnamedArguments, namedArguments);
                                    for (GradleScanner detector : detectors) {
                                        detector.checkMethodCall(context, property, parentName, parentParentName, namedArguments, unnamedArguments, (Object)assignment);
                                    }
                                    continue;
                                }
                                if (!(element instanceof GrAssignmentExpression) || !((lValue = (assignment = (GrAssignmentExpression)element).getLValue()) instanceof GrReferenceExpression)) continue;
                                propertyRef = (GrReferenceExpression)lValue;
                                names = LintIdeGradleVisitor.getReferenceExpressionNames(propertyRef);
                                names.addAll(closureNames);
                                property = names.get(0);
                                parentName = names.size() > 1 ? names.get(1) : null;
                                String string = parentParentName = names.size() > 2 ? names.get(2) : null;
                                if (property == null || parentName == null || (rValue = assignment.getRValue()) == null) continue;
                                value = rValue.getText();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, property, value, parentName, parentParentName, (Object)lValue, (Object)rValue, (Object)assignment);
                                }
                                if (parentName.equals("ext") || !property.equals("minSdkVersion") && !property.equals("targetSdkVersion")) continue;
                                int lValueEnd = lValue.getTextRange().getEndOffset();
                                int rValueStart = rValue.getTextRange().getStartOffset();
                                assert (lValueEnd <= rValueStart);
                                DefaultPosition startPosition = new DefaultPosition(-1, -1, lValueEnd);
                                DefaultPosition endPosition = new DefaultPosition(-1, -1, rValueStart);
                                Location location = Location.create((File)context.file, (Position)startPosition, (Position)endPosition);
                                String message = String.format("Do not use assignment with the %1$s property (remove the '=')", property);
                                context.report(GradleDetector.IDE_SUPPORT, location, message, null);
                            }
                        }
                        super.visitClosure(closure);
                    }

                    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                        GrExpression invokedExpression;
                        GrClosableBlock block;
                        if (applicationStatement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        ArrayList parentNames = (block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)applicationStatement, GrClosableBlock.class, (boolean)true)) != null ? LintIdeGradleVisitor.getClosureNames(block) : new ArrayList(0);
                        String statementName = applicationStatement.getInvokedExpression().getText();
                        HashMap<String, String> namedArguments = new HashMap<String, String>();
                        ArrayList<String> unnamedArguments = new ArrayList<String>();
                        LintIdeGradleVisitor.extractMethodCallArguments((GrMethodCall)applicationStatement, unnamedArguments, namedArguments);
                        if (parentNames.size() == 0 && unnamedArguments.size() == 1 && namedArguments.isEmpty() && (invokedExpression = applicationStatement.getInvokedExpression()) instanceof GrReferenceExpression) {
                            String parentParentName;
                            GrReferenceExpression referenceExpression = (GrReferenceExpression)invokedExpression;
                            List<String> names = LintIdeGradleVisitor.getReferenceExpressionNames(referenceExpression);
                            String name = names.size() > 0 ? names.get(0) : null;
                            String parentName = names.size() > 1 ? names.get(1) : "";
                            String string = parentParentName = names.size() > 2 ? names.get(2) : null;
                            if (name != null) {
                                String value = (String)unnamedArguments.get(0);
                                GrCommandArgumentList argumentList = applicationStatement.getArgumentList();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, name, value, parentName, parentParentName, (Object)invokedExpression, (Object)argumentList, (Object)applicationStatement);
                                }
                            }
                        }
                        String parentName = parentNames.size() > 0 ? (String)parentNames.get(0) : null;
                        String parentParentName = parentNames.size() > 1 ? (String)parentNames.get(1) : null;
                        for (GradleScanner detector : detectors) {
                            detector.checkMethodCall(context, statementName, parentName, parentParentName, namedArguments, unnamedArguments, (Object)applicationStatement);
                        }
                        super.visitApplicationStatement(applicationStatement);
                    }

                    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                        GrExpression lvalue;
                        GrClosableBlock block;
                        if (expression == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if ((block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)expression, GrClosableBlock.class, (boolean)true)) == null && (lvalue = expression.getLValue()) instanceof GrReferenceExpression) {
                            GrReferenceExpression lvalueRef = (GrReferenceExpression)lvalue;
                            List<String> names = LintIdeGradleVisitor.getReferenceExpressionNames(lvalueRef);
                            String name = names.size() > 0 ? names.get(0) : null;
                            String parentName = names.size() > 1 ? names.get(1) : "";
                            String parentParentName = names.size() > 2 ? names.get(2) : null;
                            GrExpression rvalue = expression.getRValue();
                            if (name != null && rvalue != null) {
                                String value = rvalue.getText();
                                for (GradleScanner detector : detectors) {
                                    detector.checkDslPropertyAssignment(context, name, value, parentName, parentParentName, (Object)lvalue, (Object)rvalue, (Object)expression);
                                }
                            }
                        }
                        super.visitAssignmentExpression(expression);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "closure";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "applicationStatement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "expression";
                                break;
                            }
                        }
                        objectArray2[1] = "com/android/tools/idea/lint/common/LintIdeGradleVisitor$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitClosure";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitApplicationStatement";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitAssignmentExpression";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        });
    }

    public int getStartOffset(@NotNull GradleContext context, @NotNull Object cookie) {
        int startOffset;
        if (context == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(2);
        }
        if (cookie == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(3);
        }
        if ((startOffset = super.getStartOffset(context, cookie)) != -1) {
            return startOffset;
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset();
    }

    @NotNull
    public Location createLocation(@NotNull GradleContext context, @NotNull Object cookie) {
        if (context == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(4);
        }
        if (cookie == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(5);
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        Location location = Location.create((File)context.file, (Position)new DefaultPosition(-1, -1, start), (Position)new DefaultPosition(-1, -1, end)).withSource((Object)element);
        if (location == null) {
            LintIdeGradleVisitor.$$$reportNull$$$0(6);
        }
        return location;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectors";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookie";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/LintIdeGradleVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/LintIdeGradleVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitBuildScript";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createLocation";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

