/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Option;
import com.android.tools.lint.detector.api.TextFormat;
import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.editor.Editor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LintInspectionDescriptionLinkHandler
extends TooltipLinkHandler {
    public String getDescription(@NotNull String refSuffix, @NotNull Editor editor) {
        Issue issue;
        if (refSuffix == null) {
            LintInspectionDescriptionLinkHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LintInspectionDescriptionLinkHandler.$$$reportNull$$$0(1);
        }
        if ((issue = new BuiltinIssueRegistry().getIssue(refSuffix)) == null) {
            issue = AndroidLintInspectionBase.findIssueByShortName(editor.getProject(), refSuffix);
        }
        if (issue != null) {
            List urls;
            String html = issue.getExplanation(TextFormat.HTML);
            StringBuilder sb = new StringBuilder(html);
            sb.append("<br><br>Issue id: ").append(issue.getId());
            List options = issue.getOptions();
            if (!options.isEmpty()) {
                sb.append("<br><br>");
                String optionsHtml = Option.Companion.describe(options, TextFormat.HTML, true);
                sb.append(optionsHtml);
            }
            if (!(urls = issue.getMoreInfo()).isEmpty()) {
                sb.append("<br><br>More info:<br>");
                for (String url : urls) {
                    sb.append("<a href=\"").append(url).append("\">").append(url).append("</a><br>");
                }
            }
            Vendor vendor = issue.getVendor();
            IssueRegistry registry = issue.getRegistry();
            if (vendor == null && registry != null) {
                vendor = registry.getVendor();
            }
            if (vendor != null) {
                sb.append("<br>\n");
                vendor.describeInto(sb, TextFormat.HTML, "");
            }
            return sb.toString().replace("\n", "");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refSuffix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/lint/common/LintInspectionDescriptionLinkHandler";
        objectArray[2] = "getDescription";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

