/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.CreateFileQuickFix;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.ImportPath;

public class ReplaceStringQuickFix
extends DefaultLintQuickFix {
    @RegExp
    private final String myRegexp;
    private final String myNewValue;
    private boolean myShortenNames;
    private boolean myFormat;
    private List<String> myImports;
    private SmartPsiFileRange myRange;
    private String myExpandedNewValue;
    private String mySelectPattern;

    public ReplaceStringQuickFix(@Nullable String name, @Nullable String familyName, @Nullable @RegExp String regexp, @NotNull String newValue) {
        if (newValue == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(0);
        }
        super(name, familyName);
        this.myNewValue = newValue;
        if (regexp != null && ((String)regexp).indexOf(40) == -1 && !((String)regexp).equals("_lint_insert_begin_") && !((String)regexp).equals("_lint_insert_end_")) {
            regexp = "(" + Pattern.quote((String)regexp) + ")";
        }
        this.myRegexp = regexp;
    }

    public static DefaultLintQuickFix create(@Nullable PsiFile file, LintFix.ReplaceString lintFix) {
        String pattern = lintFix.getOldPattern();
        String oldString = lintFix.getOldString();
        Object regexp = pattern != null ? pattern : (oldString != null ? ("_lint_insert_begin_".equals(oldString) || "_lint_insert_end_".equals(oldString) ? oldString : "(" + Pattern.quote(oldString) + ")") : null);
        String displayName = lintFix.getDisplayName();
        String familyName = lintFix.getFamilyName();
        String replacement = lintFix.getReplacement();
        String selectPattern = lintFix.getSelectPattern();
        Location range = lintFix.getRange();
        ReplaceStringQuickFix fix = new ReplaceStringQuickFix(displayName, familyName, (String)regexp, replacement);
        fix.myShortenNames = lintFix.getShortenNames();
        fix.myFormat = lintFix.getReformat();
        fix.mySelectPattern = selectPattern;
        fix.myImports = lintFix.getImports();
        if (range != null && file != null) {
            PsiFile rangeFile = file;
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)range.getFile(), (boolean)false);
            if (virtualFile != null) {
                PsiFile psiFile = file.getManager().findFile(virtualFile);
                if (psiFile != null) {
                    rangeFile = psiFile;
                }
            } else {
                File path = range.getFile();
                return new CreateFileQuickFix(path, replacement, null, null, false, lintFix.getDisplayName(), familyName);
            }
            Position start = range.getStart();
            Position end = range.getEnd();
            if (start != null && end != null) {
                SmartPointerManager manager = SmartPointerManager.getInstance((Project)rangeFile.getProject());
                int startOffset = start.getOffset();
                int endOffset = end.getOffset();
                if (endOffset >= startOffset) {
                    TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
                    fix.myRange = manager.createSmartPsiFileRangePointer(rangeFile, textRange);
                }
            }
        }
        return fix;
    }

    public ReplaceStringQuickFix setShortenNames(boolean shortenNames) {
        this.myShortenNames = shortenNames;
        return this;
    }

    public ReplaceStringQuickFix setFormat(boolean format) {
        this.myFormat = format;
        return this;
    }

    public ReplaceStringQuickFix setSelectPattern(String selectPattern) {
        this.mySelectPattern = selectPattern;
        return this;
    }

    public void setRange(SmartPsiFileRange range) {
        this.myRange = range;
    }

    @Override
    @Nullable
    public SmartPsiFileRange getRange() {
        return this.myRange;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            if (this.myNewValue.isEmpty()) {
                return "Delete";
            }
            String string = "Replace with " + this.myNewValue;
            if (string == null) {
                ReplaceStringQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return super.getFamilyName();
    }

    @Nullable
    protected String getNewValue() {
        return this.myExpandedNewValue != null ? this.myExpandedNewValue : this.myNewValue;
    }

    protected void editBefore(@NotNull Document document) {
        if (document == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(3);
        }
    }

    protected void editAfter(@NotNull Document document) {
        if (document == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(4);
        }
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiFile fileContainingRange;
        if (startElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(7);
        }
        PsiFile file = startElement.getContainingFile();
        if (this.myRange != null && (fileContainingRange = this.myRange.getContainingFile()) != null && !fileContainingRange.equals(file.getOriginalFile())) {
            file = fileContainingRange;
        }
        if (file == null) {
            return;
        }
        Project project = file.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = context.getDocument(file);
        if (document != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            this.editBefore(document);
            TextRange replaceRange = this.getRange(startElement, endElement, true);
            if (replaceRange != null) {
                Segment range;
                Segment range2;
                Pattern pattern;
                Matcher matcher;
                String newValue = this.getNewValue();
                if (newValue == null) {
                    newValue = "";
                }
                if (ReplaceStringQuickFix.whitespaceOnly(newValue)) {
                    replaceRange = ReplaceStringQuickFix.includeFullLineIfOnlySpace(document, replaceRange);
                }
                int replaceStart = replaceRange.getStartOffset();
                int replaceEnd = replaceRange.getEndOffset();
                document.replaceString(replaceStart, replaceEnd, (CharSequence)newValue);
                this.editAfter(document);
                documentManager.commitDocument(document);
                if (this.mySelectPattern != null && context instanceof AndroidQuickfixContexts.EditorContext && file.isPhysical() && (matcher = (pattern = Pattern.compile(this.mySelectPattern)).matcher(document.getText())).find(replaceStart)) {
                    int selectEnd;
                    int selectStart;
                    if (matcher.groupCount() > 0) {
                        selectStart = matcher.start(1);
                        selectEnd = matcher.end(1);
                    } else {
                        selectStart = matcher.start();
                        selectEnd = matcher.end();
                    }
                    Editor editor = context.getEditor(file);
                    if (editor != null) {
                        editor.getSelectionModel().setSelection(selectStart, selectEnd);
                    }
                }
                SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
                TextRange resultTextRange = TextRange.from((int)replaceStart, (int)newValue.length());
                SmartPsiFileRange resultSmartRange = pointerManager.createSmartPsiFileRangePointer(file, resultTextRange);
                if (this.myImports != null && !this.myImports.isEmpty()) {
                    if (file instanceof PsiJavaFile) {
                        PsiJavaFile javaFile = (PsiJavaFile)file;
                        ReplaceStringQuickFix.addJavaImports(javaFile, this.myImports);
                    } else if (file instanceof KtFile) {
                        KtFile ktFile = (KtFile)file;
                        ReplaceStringQuickFix.addKotlinImports(ktFile, this.myImports);
                    }
                }
                if (this.myShortenNames && (range2 = resultSmartRange.getPsiRange()) != null) {
                    TextRange textRange = new TextRange(range2.getStartOffset(), range2.getEndOffset());
                    if (file instanceof PsiJavaFile) {
                        ReplaceStringQuickFix.shortenJavaReferencesInRange(file, textRange);
                    } else if (file instanceof KtFile) {
                        KtFile ktFile = (KtFile)file;
                        ShortenReferencesFacility.Companion.getInstance().shorten(ktFile, textRange);
                    }
                }
                if (this.myFormat && (range = resultSmartRange.getPsiRange()) != null) {
                    CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
                    codeStyleManager.reformatRange((PsiElement)file, range.getStartOffset(), range.getEndOffset());
                }
            }
        }
    }

    @Override
    @Nullable
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(10);
        }
        if (this.myRange != null && !file.getOriginalFile().equals(this.myRange.getContainingFile())) {
            return IntentionPreviewInfo.EMPTY;
        }
        return super.generatePreview(project, editor, file);
    }

    private static void addJavaImports(PsiJavaFile javaFile, List<String> imports) {
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        Project project = javaFile.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope psiSearchScope = GlobalSearchScope.allScope((Project)project);
        PsiElementFactory psiFactory = psiFacade.getElementFactory();
        for (String symbol : imports) {
            String containingClassName;
            PsiClass containingClass;
            if (ReplaceStringQuickFix.alreadyImported(importList, symbol)) continue;
            PsiClass cls = psiFacade.findClass(symbol, psiSearchScope);
            if (cls != null) {
                importList.add((PsiElement)psiFactory.createImportStatement(cls));
                continue;
            }
            int lastDot = symbol.lastIndexOf(46);
            if (lastDot == -1 || (containingClass = psiFacade.findClass(containingClassName = symbol.substring(0, lastDot), psiSearchScope)) == null) continue;
            String memberName = symbol.substring(lastDot + 1);
            importList.add((PsiElement)psiFactory.createImportStaticStatement(containingClass, memberName));
        }
    }

    private static void addKotlinImports(KtFile ktFile, List<String> imports) {
        KtImportList importList = ktFile.getImportList();
        if (importList == null) {
            return;
        }
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)ktFile);
        for (String symbol : imports) {
            if (ReplaceStringQuickFix.alreadyImported(importList, symbol)) continue;
            KtImportDirective importDirective = psiFactory.createImportDirective(new ImportPath(new FqName(symbol), false));
            importList.add((PsiElement)importDirective);
        }
    }

    private static boolean alreadyImported(PsiImportList imports, String candidate) {
        for (PsiImportStatementBase importStatement : imports.getAllImportStatements()) {
            PsiJavaCodeReferenceElement ref = importStatement.getImportReference();
            if (ref == null || !candidate.equals(ref.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean alreadyImported(KtImportList imports, String candidate) {
        for (KtImportDirective importDirective : imports.getImports()) {
            FqName ref = importDirective.getImportedFqName();
            if (ref == null || !candidate.equals(ref.asString())) continue;
            return true;
        }
        return false;
    }

    private static void shortenJavaReferencesInRange(PsiFile file, TextRange range) {
        PsiElement startPsi = file.findElementAt(range.getStartOffset());
        PsiElement endPsi = file.findElementAt(range.getEndOffset() - 1);
        if (startPsi == null || endPsi == null) {
            return;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)startPsi, (PsiElement)endPsi);
        if (commonParent == null) {
            return;
        }
        ArrayList<PsiElement> psiInRange = new ArrayList<PsiElement>();
        ReplaceStringQuickFix.collectDisjointDescendantsCoveringRange(commonParent, range, psiInRange);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)file.getProject());
        for (PsiElement psiElement : psiInRange) {
            if (!psiElement.isValid()) continue;
            javaCodeStyleManager.shortenClassReferences(psiElement);
        }
    }

    private static void collectDisjointDescendantsCoveringRange(PsiElement parent, TextRange fileRange, List<PsiElement> out) {
        for (PsiElement child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            TextRange childRange = child.getTextRange();
            if (childRange == null || childRange.isEmpty()) continue;
            if (fileRange.contains(childRange)) {
                out.add(child);
                continue;
            }
            if (!fileRange.intersectsStrict(childRange)) continue;
            ReplaceStringQuickFix.collectDisjointDescendantsCoveringRange(child, fileRange, out);
        }
    }

    private static boolean whitespaceOnly(@NotNull String text) {
        if (text == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(11);
        }
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static TextRange includeFullLineIfOnlySpace(@NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(12);
        }
        if (range == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(13);
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int lineStart = DocumentUtil.getLineStartOffset((int)startOffset, (Document)document);
        int lineEnd = DocumentUtil.getLineEndOffset((int)startOffset, (Document)document);
        if (lineEnd < endOffset) {
            return range;
        }
        String prefix = document.getText(new TextRange(lineStart, startOffset));
        String suffix = document.getText(new TextRange(endOffset, lineEnd));
        if (ReplaceStringQuickFix.whitespaceOnly(prefix) && ReplaceStringQuickFix.whitespaceOnly(suffix)) {
            return new TextRange(lineStart, lineEnd + 1);
        }
        return range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private TextRange getRange(PsiElement startElement, PsiElement endElement, boolean computeReplacement) {
        int end;
        int start;
        if (!startElement.isValid() || !endElement.isValid()) {
            return null;
        }
        if (this.myRange != null) {
            PsiFile file = this.myRange.getContainingFile();
            if (file == null) {
                return null;
            }
            Segment segment = this.myRange.getRange();
            if (segment == null) return null;
            start = segment.getStartOffset();
            end = segment.getEndOffset();
            if (this.myRegexp != null && !"_lint_insert_begin_".equals(this.myRegexp) && !"_lint_insert_end_".equals(this.myRegexp)) {
                startElement = file.findElementAt(start);
                endElement = file.findElementAt(end);
                if (startElement == null || endElement == null) {
                    return null;
                }
            }
        } else {
            start = startElement.getTextOffset();
            end = endElement.getTextOffset() + endElement.getTextLength();
        }
        if (this.myRegexp == null) return new TextRange(start, end);
        if ("_lint_insert_begin_".equals(this.myRegexp)) {
            return new TextRange(start, start);
        }
        if ("_lint_insert_end_".equals(this.myRegexp)) {
            return new TextRange(end, end);
        }
        try {
            String sequence;
            Pattern pattern = Pattern.compile(this.myRegexp, 8);
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            if (parent != null && parent.getTextRange().containsRange(start, end)) {
                TextRange parentRange = parent.getTextRange();
                int offset = parentRange.getStartOffset();
                sequence = parent.getText().substring(start - offset, end - offset);
            } else {
                String text = startElement.getContainingFile().getText();
                sequence = text.substring(start, end);
            }
            Matcher matcher = pattern.matcher(sequence);
            if (!matcher.find()) return null;
            end = start;
            if (matcher.groupCount() > 0) {
                if (this.myRegexp.contains("target")) {
                    try {
                        start += matcher.start("target");
                        end += matcher.end("target");
                    }
                    catch (IllegalArgumentException ignore) {
                        start += matcher.start(1);
                        end += matcher.end(1);
                    }
                } else {
                    start += matcher.start(1);
                    end += matcher.end(1);
                }
            } else {
                start += matcher.start();
                end += matcher.end();
            }
            if (!computeReplacement || this.myExpandedNewValue != null) return new TextRange(start, end);
            this.myExpandedNewValue = LintFix.ReplaceString.expandBackReferences((String)this.myNewValue, (Matcher)matcher);
            return new TextRange(start, end);
        }
        catch (Exception e) {
            Logger.getInstance(ReplaceStringQuickFix.class).warn("Invalid regular expression " + this.myRegexp);
            return null;
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(14);
        }
        if (endElement == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(15);
        }
        if (contextType == null) {
            ReplaceStringQuickFix.$$$reportNull$$$0(16);
        }
        return this.getRange(startElement, endElement, false) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/common/ReplaceStringQuickFix";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/common/ReplaceStringQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "editBefore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editAfter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "whitespaceOnly";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "includeFullLineIfOnlySpace";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

