/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.injection.Injectable;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.InjectionUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectLanguageAction
implements IntentionAction,
LowPriorityAction {
    public static final String LAST_INJECTED_LANGUAGE = "LAST_INJECTED_LANGUAGE";
    public static final Key<Processor<? super PsiLanguageInjectionHost>> FIX_KEY = Key.create((String)"inject fix key");
    private static final FixPresenter DEFAULT_FIX_PRESENTER = (editor, range, pointer, text, handler) -> {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        HintManager.getInstance().showQuestionHint(editor, text, range.getStartOffset(), range.getEndOffset(), new QuestionAction(){

            public boolean execute() {
                return handler.process((Object)pointer.getElement());
            }
        });
    };

    @NotNull
    public static List<Injectable> getAllInjectables() {
        Language[] languages = InjectedLanguage.getAvailableLanguages();
        ArrayList<Injectable> list = new ArrayList<Injectable>();
        for (Language language : languages) {
            list.add(Injectable.fromLanguage((Language)language));
        }
        list.addAll(Arrays.asList((ReferenceInjector[])ReferenceInjector.EXTENSION_POINT_NAME.getExtensions()));
        Collections.sort(list);
        ArrayList<Injectable> arrayList = list;
        if (arrayList == null) {
            InjectLanguageAction.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public String getText() {
        String string = IntelliLangBundle.message("intelliLang.inject.language.action.text", new Object[0]);
        if (string == null) {
            InjectLanguageAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            InjectLanguageAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiLanguageInjectionHost host;
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(5);
        }
        if ((host = InjectLanguageAction.findInjectionHost(editor, file)) == null) {
            return false;
        }
        if (!InjectionUtils.isInjectLanguageActionEnabled((PsiElement)host)) {
            return false;
        }
        List injectedPsi = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host);
        if (injectedPsi == null || injectedPsi.isEmpty()) {
            return !InjectedReferencesContributor.isInjected(file.findReferenceAt(editor.getCaretModel().getOffset()));
        }
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiLanguageInjectionHost host;
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(8);
        }
        if ((host = InjectLanguageAction.findInjectionHost(editor, file)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                InjectLanguageAction.$$$reportNull$$$0(9);
            }
            return intentionPreviewInfo;
        }
        String text = StringUtil.shortenTextWithEllipsis((String)ElementManipulators.getValueText((PsiElement)host), (int)40, (int)10);
        return new IntentionPreviewInfo.Html(IntelliLangBundle.message("intelliLang.inject.language.action.preview", text));
    }

    @Nullable
    protected static PsiLanguageInjectionHost findInjectionHost(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(10);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(11);
        }
        if (editor instanceof EditorWindow) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost fileLanguageHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiLanguageInjectionHost.class, (boolean)false);
        if (fileLanguageHost != null && fileLanguageHost.isValidHost()) {
            return fileLanguageHost;
        }
        FileViewProvider vp = file.getViewProvider();
        for (Language language : vp.getLanguages()) {
            PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)vp.findElementAt(offset, language), PsiLanguageInjectionHost.class, (boolean)false);
            if (host == null || !host.isValidHost()) continue;
            return host;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(13);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(14);
        }
        InjectLanguageAction.doChooseLanguageToInject(editor, (Processor<? super Injectable>)((Processor)injectable -> {
            InjectLanguageAction.invokeImpl(project, editor, file, injectable);
            return false;
        }));
    }

    public static void invokeImpl(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Injectable injectable) {
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(16);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(17);
        }
        if (injectable == null) {
            InjectLanguageAction.$$$reportNull$$$0(18);
        }
        InjectLanguageAction.invokeImpl(project, editor, file, injectable, DEFAULT_FIX_PRESENTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeImpl(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Injectable injectable, @NotNull FixPresenter fixPresenter) {
        PsiLanguageInjectionHost host;
        if (project == null) {
            InjectLanguageAction.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            InjectLanguageAction.$$$reportNull$$$0(20);
        }
        if (file == null) {
            InjectLanguageAction.$$$reportNull$$$0(21);
        }
        if (injectable == null) {
            InjectLanguageAction.$$$reportNull$$$0(22);
        }
        if (fixPresenter == null) {
            InjectLanguageAction.$$$reportNull$$$0(23);
        }
        if ((host = InjectLanguageAction.findInjectionHost(editor, file)) == null) {
            return;
        }
        if (InjectLanguageAction.defaultFunctionalityWorked(host, injectable.getId())) {
            return;
        }
        try {
            host.putUserData(FIX_KEY, null);
            Language language = injectable.toLanguage();
            for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
                if (!support.isApplicableTo(host) || !support.addInjectionInPlace(language, host)) continue;
                return;
            }
            if (TemporaryPlacesRegistry.getInstance(project).getLanguageInjectionSupport().addInjectionInPlace(language, host)) {
                Processor fixer = (Processor)host.getUserData(FIX_KEY);
                String text = IntelliLangBundle.message("intelliLang.temporary.injected", StringUtil.escapeXmlEntities((String)language.getDisplayName()));
                if (fixer != null) {
                    SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)host);
                    String fixText = text + "<br>" + (fixer instanceof MyFixAction ? ((MyFixAction)fixer).getText() : IntelliLangBundle.message("intelliLang.suggest.insert.annotation", new Object[0])) + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
                    fixPresenter.showFix(editor, host.getTextRange(), (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer, fixText, (Processor<? super PsiLanguageInjectionHost>)((Processor)host1 -> {
                        List files = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)host1);
                        if (files != null) {
                            for (Pair pair : files) {
                                PsiFile psiFile = (PsiFile)pair.first;
                                LanguageInjectionSupport languageInjectionSupport = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
                                if (languageInjectionSupport == null) continue;
                                languageInjectionSupport.removeInjectionInPlace((PsiLanguageInjectionHost)host1);
                            }
                        } else {
                            LanguageInjectionSupport support = (LanguageInjectionSupport)host1.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
                            if (support != null && support.removeInjection((PsiElement)host)) {
                                host1.getManager().dropPsiCaches();
                            }
                        }
                        return fixer.process(host1);
                    }));
                } else {
                    HintManager.getInstance().showInformationHint(editor, text);
                }
            }
        }
        finally {
            if (injectable.getLanguage() != null) {
                FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
            } else {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host, String id) {
        return Configuration.getProjectInstance(host.getProject()).setHostInjectionEnabled(host, Collections.singleton(id), true);
    }

    public static boolean doChooseLanguageToInject(Editor editor, Processor<? super Injectable> onChosen) {
        ColoredListCellRenderer<Injectable> renderer = new ColoredListCellRenderer<Injectable>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Injectable> list, Injectable language, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.setIcon(language.getIcon());
                this.append(language.getDisplayName());
                String description = language.getAdditionalDescription();
                if (description != null) {
                    this.append(description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/intellij/plugins/intelliLang/inject/InjectLanguageAction$2", "customizeCellRenderer"));
            }
        };
        List<Injectable> injectables = InjectLanguageAction.getAllInjectables();
        String lastInjectedId = PropertiesComponent.getInstance().getValue(LAST_INJECTED_LANGUAGE);
        Injectable lastInjected = lastInjectedId != null ? (Injectable)ContainerUtil.find(injectables, injectable -> lastInjectedId.equals(injectable.getId())) : null;
        Dimension minSize = new JLabel(PlainTextLanguage.INSTANCE.getDisplayName(), EmptyIcon.ICON_16, 2).getMinimumSize();
        minSize.height *= 4;
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder(injectables).setRenderer((ListCellRenderer)renderer).setItemChosenCallback(injectable -> {
            onChosen.process(injectable);
            PropertiesComponent.getInstance().setValue(LAST_INJECTED_LANGUAGE, injectable.getId());
        }).setMinSize(minSize).setNamerForFiltering(language -> language.getDisplayName());
        if (lastInjected != null) {
            builder = builder.setSelectedValue((Object)lastInjected, true);
        }
        builder.createPopup().showInBestPositionFor(editor);
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void addFixer(@NotNull PsiLanguageInjectionHost host, Processor<? super PsiLanguageInjectionHost> annotationFixer, @NlsContexts.PopupContent String text) {
        if (host == null) {
            InjectLanguageAction.$$$reportNull$$$0(24);
        }
        host.putUserData(FIX_KEY, InjectLanguageAction.withFixName(annotationFixer, text));
    }

    public static Processor<? super PsiLanguageInjectionHost> withFixName(Processor<? super PsiLanguageInjectionHost> fix, @NlsContexts.PopupContent String text) {
        return new MyFixAction(text, fix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/InjectLanguageAction";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixPresenter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInjectables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/InjectLanguageAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findInjectionHost";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addFixer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24 -> new IllegalArgumentException(string);
        };
    }

    public static interface FixPresenter {
        public void showFix(@NotNull Editor var1, @NotNull TextRange var2, @NotNull SmartPsiElementPointer<PsiLanguageInjectionHost> var3, @NotNull @Nls String var4, @NotNull Processor<? super PsiLanguageInjectionHost> var5);
    }

    private static final class MyFixAction
    implements Processor<PsiLanguageInjectionHost> {
        private final @NlsContexts.PopupContent String myText;
        private final Processor<? super PsiLanguageInjectionHost> myFix;

        private MyFixAction(@NlsContexts.PopupContent String text, Processor<? super PsiLanguageInjectionHost> fix) {
            this.myText = text;
            this.myFix = fix;
        }

        @NlsContexts.PopupContent
        public String getText() {
            return this.myText;
        }

        public boolean process(PsiLanguageInjectionHost host) {
            return this.myFix.process((Object)host);
        }
    }
}

