/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder;

import com.android.tools.pixelprobe.decoder.Decoder;
import com.android.tools.pixelprobe.util.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

final class JpegDecoder
extends Decoder {
    private static final byte[] JPEG_HEADER = Bytes.fromHexString("ffd8");

    JpegDecoder() {
        super("jpg", "jpeg");
    }

    @Override
    public boolean accept(InputStream in) {
        try {
            byte[] data = new byte[JPEG_HEADER.length];
            int read = in.read(data);
            if (read == JPEG_HEADER.length) {
                return Arrays.equals(data, JPEG_HEADER);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

