/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmInstr;
import org.jetbrains.kotlin.wasm.ir.WasmInstrWithLocation;
import org.jetbrains.kotlin.wasm.ir.WasmIrExpressionBuilderKt;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J-\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ1\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u0007H\u0002R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder;", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "expression", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmInstr;", "(Ljava/util/List;)V", "eatEverythingUntilLevel", "", "Ljava/lang/Integer;", "getExpression", "()Ljava/util/List;", "lastInstructionIndex", "value", "numberOfNestedBlocks", "getNumberOfNestedBlocks", "()I", "setNumberOfNestedBlocks", "(I)V", "isPseudoInstruction", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmOp;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;)Z", "addInstruction", "", "op", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "immediates", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;[Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate;)V", "buildInstr", "getCurrentEatLevel", "(Lorg/jetbrains/kotlin/wasm/ir/WasmOp;)Ljava/lang/Integer;", "trimInstructionsUntil", "index", "wasm.ir"})
@SourceDebugExtension(value={"SMAP\nWasmIrExpressionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmIrExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n378#2,7:118\n1#3:125\n*S KotlinDebug\n*F\n+ 1 WasmIrExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmIrExpressionBuilder\n*L\n35#1:118,7\n*E\n"})
public final class WasmIrExpressionBuilder
extends WasmExpressionBuilder {
    @NotNull
    private final List<WasmInstr> expression;
    @Nullable
    private Integer eatEverythingUntilLevel;
    private int lastInstructionIndex;
    private int numberOfNestedBlocks;

    /*
     * WARNING - void declaration
     */
    public WasmIrExpressionBuilder(@NotNull List<WasmInstr> expression) {
        int n;
        int n2;
        block1: {
            void $this$indexOfLast$iv;
            Intrinsics.checkNotNullParameter(expression, (String)"expression");
            List<WasmInstr> list = this.expression = expression;
            WasmIrExpressionBuilder wasmIrExpressionBuilder = this;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                WasmInstr it = (WasmInstr)iterator$iv.previous();
                boolean bl = false;
                if (!(!this.isPseudoInstruction(it.getOperator()))) continue;
                n2 = iterator$iv.nextIndex();
                break block1;
            }
            n2 = -1;
        }
        wasmIrExpressionBuilder.lastInstructionIndex = n = n2;
    }

    @NotNull
    public final List<WasmInstr> getExpression() {
        return this.expression;
    }

    private final void addInstruction(WasmOp op, SourceLocation location, WasmImmediate[] immediates) {
        ((Collection)this.expression).add(new WasmInstrWithLocation(op, (List<? extends WasmImmediate>)ArraysKt.toList((Object[])immediates), location));
        if (!this.isPseudoInstruction(op)) {
            this.lastInstructionIndex = CollectionsKt.getLastIndex(this.expression);
        }
    }

    private final Integer getCurrentEatLevel(WasmOp op) {
        Integer n = this.eatEverythingUntilLevel;
        if (n == null) {
            return null;
        }
        int eatLevel = n;
        if (this.getNumberOfNestedBlocks() == eatLevel && WasmIrExpressionBuilderKt.access$isInCfgNode(op)) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        if (this.getNumberOfNestedBlocks() < eatLevel) {
            this.eatEverythingUntilLevel = null;
            return null;
        }
        return eatLevel;
    }

    @Override
    public void buildInstr(@NotNull WasmOp op, @NotNull SourceLocation location, WasmImmediate ... immediates) {
        Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)immediates, (String)"immediates");
        Integer currentEatUntil = this.getCurrentEatLevel(op);
        if (currentEatUntil != null) {
            if (currentEatUntil <= this.getNumberOfNestedBlocks()) {
                return;
            }
        } else if (WasmIrExpressionBuilderKt.access$isOutCfgNode(op)) {
            this.eatEverythingUntilLevel = this.getNumberOfNestedBlocks();
            this.addInstruction(op, location, immediates);
            return;
        }
        if (this.lastInstructionIndex == -1) {
            this.addInstruction(op, location, immediates);
            return;
        }
        WasmInstr lastInstruction = this.expression.get(this.lastInstructionIndex);
        WasmOp lastOperator = lastInstruction.getOperator();
        if ((op == WasmOp.DROP || op == WasmOp.UNREACHABLE) && WasmIrExpressionBuilderKt.access$pureStacklessInstruction(lastOperator)) {
            this.trimInstructionsUntil(this.lastInstructionIndex);
            return;
        }
        if (lastOperator == WasmOp.LOCAL_SET && op == WasmOp.LOCAL_GET) {
            WasmSymbol<WasmLocal> localSetNumber;
            Object object = CollectionsKt.firstOrNull(lastInstruction.getImmediates());
            WasmImmediate.LocalIdx localIdx = object instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)object : null;
            WasmSymbol<WasmLocal> wasmSymbol = localSetNumber = localIdx != null ? localIdx.getValue() : null;
            if (localSetNumber != null) {
                WasmSymbol<WasmLocal> localGetNumber;
                Object object2 = ArraysKt.firstOrNull((Object[])immediates);
                WasmImmediate.LocalIdx localIdx2 = object2 instanceof WasmImmediate.LocalIdx ? (WasmImmediate.LocalIdx)object2 : null;
                WasmSymbol<WasmLocal> wasmSymbol2 = localGetNumber = localIdx2 != null ? localIdx2.getValue() : null;
                if (Intrinsics.areEqual(localGetNumber, localSetNumber)) {
                    this.trimInstructionsUntil(this.lastInstructionIndex);
                    this.addInstruction(WasmOp.LOCAL_TEE, location, immediates);
                    return;
                }
            }
        }
        this.addInstruction(op, location, immediates);
    }

    private final void trimInstructionsUntil(int index) {
        AddToStdlibKt.trimToSize(this.expression, (int)index);
        this.lastInstructionIndex = index - 1;
    }

    @Override
    public int getNumberOfNestedBlocks() {
        return this.numberOfNestedBlocks;
    }

    @Override
    public void setNumberOfNestedBlocks(int value) {
        boolean bl;
        boolean bl2 = bl = value >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "end without matching block";
            throw new AssertionError((Object)string);
        }
        this.numberOfNestedBlocks = value;
    }

    private final boolean isPseudoInstruction(WasmOp $this$isPseudoInstruction) {
        return $this$isPseudoInstruction.getOpcode() == 65535;
    }
}

