/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.Version;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.AgpVersionIncompatible;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooNew;
import com.android.tools.idea.gradle.project.sync.AgpVersionTooOld;
import com.android.tools.idea.gradle.project.sync.ModelConsumerVersion;
import com.android.tools.idea.gradle.project.sync.SyncActionOptions;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibility;
import com.android.tools.idea.gradle.project.upgrade.AndroidGradlePluginCompatibilityKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"LATEST_KNOWN_ANDROID_GRADLE_PLUGIN_VERSION", "Lcom/android/ide/common/repository/AgpVersion;", "getLATEST_KNOWN_ANDROID_GRADLE_PLUGIN_VERSION", "()Lcom/android/ide/common/repository/AgpVersion;", "MINIMUM_SUPPORTED_AGP_VERSION", "getMINIMUM_SUPPORTED_AGP_VERSION", "MODEL_CONSUMER_VERSION", "Lcom/android/tools/idea/gradle/project/sync/ModelConsumerVersion;", "getMODEL_CONSUMER_VERSION", "()Lcom/android/tools/idea/gradle/project/sync/ModelConsumerVersion;", "checkAgpVersionCompatibility", "", "minimumModelConsumerVersion", "agpVersion", "syncOptions", "Lcom/android/tools/idea/gradle/project/sync/SyncActionOptions;", "intellij.android.projectSystem.gradle.sync"})
public final class AgpCompatibilityKt {
    @NotNull
    private static final AgpVersion LATEST_KNOWN_ANDROID_GRADLE_PLUGIN_VERSION;
    @NotNull
    private static final AgpVersion MINIMUM_SUPPORTED_AGP_VERSION;
    @NotNull
    private static final ModelConsumerVersion MODEL_CONSUMER_VERSION;

    @NotNull
    public static final AgpVersion getLATEST_KNOWN_ANDROID_GRADLE_PLUGIN_VERSION() {
        return LATEST_KNOWN_ANDROID_GRADLE_PLUGIN_VERSION;
    }

    @NotNull
    public static final AgpVersion getMINIMUM_SUPPORTED_AGP_VERSION() {
        return MINIMUM_SUPPORTED_AGP_VERSION;
    }

    @NotNull
    public static final ModelConsumerVersion getMODEL_CONSUMER_VERSION() {
        return MODEL_CONSUMER_VERSION;
    }

    public static final void checkAgpVersionCompatibility(@Nullable ModelConsumerVersion minimumModelConsumerVersion, @NotNull AgpVersion agpVersion, @NotNull SyncActionOptions syncOptions) {
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        Intrinsics.checkNotNullParameter((Object)syncOptions, (String)"syncOptions");
        if (minimumModelConsumerVersion != null && syncOptions.getFlags().getStudioFlagSupportFutureAgpVersions()) {
            if (agpVersion.compareTo(MINIMUM_SUPPORTED_AGP_VERSION) < 0) {
                throw new AgpVersionTooOld(agpVersion);
            }
            if (minimumModelConsumerVersion.compareTo(MODEL_CONSUMER_VERSION) > 0) {
                throw new AgpVersionTooNew(agpVersion);
            }
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[AndroidGradlePluginCompatibilityKt.computeAndroidGradlePluginCompatibility(agpVersion, LATEST_KNOWN_ANDROID_GRADLE_PLUGIN_VERSION).ordinal()]) {
            case 1: {
                throw new AgpVersionTooOld(agpVersion);
            }
            case 2: {
                if (syncOptions.getFlags().getStudioFlagDisableForcedUpgrades()) break;
                throw new AgpVersionIncompatible(agpVersion);
            }
            case 3: {
                if (syncOptions.getFlags().getStudioFlagDisableForcedUpgrades()) break;
                throw new AgpVersionTooNew(agpVersion);
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static {
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        LATEST_KNOWN_ANDROID_GRADLE_PLUGIN_VERSION = AgpVersion.Companion.parse(string);
        MINIMUM_SUPPORTED_AGP_VERSION = AgpVersion.Companion.parse("3.2.0");
        MODEL_CONSUMER_VERSION = new ModelConsumerVersion(64, 0, "Android Studio Giraffe");
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AndroidGradlePluginCompatibility.values().length];
            try {
                nArray[AndroidGradlePluginCompatibility.BEFORE_MINIMUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.DIFFERENT_PREVIEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.AFTER_MAXIMUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.COMPATIBLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AndroidGradlePluginCompatibility.DEPRECATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

