/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ExceptionUtil;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public final class ReflectedProject {
    private static final Logger LOG = Logger.getInstance(ReflectedProject.class);
    private static final List<SoftReference<Pair<ReflectedProject, ClassLoader>>> ourProjects = new ArrayList<SoftReference<Pair<ReflectedProject, ClassLoader>>>();
    private static final ReentrantLock ourProjectsLock = new ReentrantLock();
    public static final String ANT_PROJECT_CLASS = "org.apache.tools.ant.Project";
    public static final String COMPONENT_HELPER_CLASS = "org.apache.tools.ant.ComponentHelper";
    private final Object myProject;
    private Map<String, Class<?>> myTaskDefinitions;
    private Map<String, Class<?>> myDataTypeDefinitions;
    private Map<String, Collection<Class<?>>> myRestrictedDefinitions;
    private Map<String, String> myProperties;
    private Class<?> myTargetClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReflectedProject getProject(ClassLoader classLoader) {
        ourProjectsLock.lock();
        try {
            Iterator<SoftReference<Pair<ReflectedProject, ClassLoader>>> iterator = ourProjects.iterator();
            while (iterator.hasNext()) {
                SoftReference<Pair<ReflectedProject, ClassLoader>> ref = iterator.next();
                Pair<ReflectedProject, ClassLoader> pair = ref.get();
                if (pair == null) {
                    iterator.remove();
                    continue;
                }
                if (pair.second != classLoader) continue;
                ReflectedProject reflectedProject = (ReflectedProject)pair.first;
                return reflectedProject;
            }
        }
        finally {
            ourProjectsLock.unlock();
        }
        ReflectedProject reflectedProj = new ReflectedProject(classLoader);
        ourProjectsLock.lock();
        try {
            ourProjects.add(new SoftReference<Pair>(Pair.create((Object)reflectedProj, (Object)classLoader)));
        }
        finally {
            ourProjectsLock.unlock();
        }
        return reflectedProj;
    }

    ReflectedProject(ClassLoader classLoader) {
        Object project = null;
        try {
            Class<?> projectClass = classLoader.loadClass(ANT_PROJECT_CLASS);
            project = projectClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = projectClass.getMethod("init", new Class[0]);
            method.invoke(project, new Object[0]);
            method = projectClass.getMethod("getTaskDefinitions", new Class[0]);
            this.myTaskDefinitions = (Map)method.invoke(project, new Object[0]);
            method = projectClass.getMethod("getDataTypeDefinitions", new Class[0]);
            this.myDataTypeDefinitions = (Map)method.invoke(project, new Object[0]);
            method = projectClass.getMethod("getProperties", new Class[0]);
            this.myProperties = (Map)method.invoke(project, new Object[0]);
            this.myTargetClass = classLoader.loadClass("org.apache.tools.ant.Target");
            try {
                this.myRestrictedDefinitions = new HashMap();
                Class<?> componentHelperClass = classLoader.loadClass(COMPONENT_HELPER_CLASS);
                Object helper = componentHelperClass.getMethod("getComponentHelper", projectClass).invoke(null, project);
                componentHelperClass.getMethod("getDefinition", String.class).invoke(helper, "ant");
                Method getRestrictedDef = componentHelperClass.getDeclaredMethod("getRestrictedDefinition", new Class[0]);
                getRestrictedDef.setAccessible(true);
                Map restrictedDefinitions = (Map)getRestrictedDef.invoke(helper, new Object[0]);
                for (Map.Entry entry : restrictedDefinitions.entrySet()) {
                    ArrayList<Class> classes = new ArrayList<Class>();
                    for (Object typeDef : (Collection)entry.getValue()) {
                        try {
                            classes.add((Class)typeDef.getClass().getMethod("getTypeClass", projectClass).invoke(typeDef, project));
                        }
                        catch (Throwable throwable) {}
                    }
                    this.myRestrictedDefinitions.put((String)entry.getKey(), classes);
                }
            }
            catch (Throwable throwable) {
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            Throwable cause = ExceptionUtil.getRootCause((Throwable)e);
            if (cause instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)cause;
            }
            LOG.info(e);
            project = null;
        }
        this.myProject = project;
    }

    @Nullable
    public Map<String, Class<?>> getTaskDefinitions() {
        return this.myTaskDefinitions;
    }

    @Nullable
    public Map<String, Class<?>> getDataTypeDefinitions() {
        return this.myDataTypeDefinitions;
    }

    public Map<String, Collection<Class<?>>> getRestrictedDefinitions() {
        return this.myRestrictedDefinitions;
    }

    public Map<String, String> getProperties() {
        return this.myProperties;
    }

    public Class<?> getTargetClass() {
        return this.myTargetClass;
    }

    @Nullable
    public Object getProject() {
        return this.myProject;
    }
}

