/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.lang.ant.dom.AntBooleanConverterDefaultFalse;
import com.intellij.lang.ant.dom.AntBooleanConverterDefaultTrue;
import com.intellij.lang.ant.dom.AntDomDefaultTargetConverter;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntPathConverter;
import com.intellij.lang.ant.dom.TargetResolver;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericAttributeValue;

public abstract class AntDomAnt
extends AntDomElement {
    public static final String DEFAULT_ANTFILE_NAME = "build.xml";

    @Attribute(value="antfile")
    @Convert(value=AntFilePathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getAntFilePath();

    @Attribute(value="dir")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getAntFileDir();

    @Attribute(value="target")
    @Convert(value=AntDomDefaultTargetConverter.class)
    public abstract GenericAttributeValue<TargetResolver.Result> getDefaultTarget();

    @Attribute(value="output")
    @Convert(value=AntPathConverter.class)
    public abstract GenericAttributeValue<PsiFileSystemItem> getOutputtFileName();

    @Attribute(value="inheritall")
    @Convert(value=AntBooleanConverterDefaultTrue.class)
    public abstract GenericAttributeValue<Boolean> isInheritAllProperties();

    @Attribute(value="inheritrefs")
    @Convert(value=AntBooleanConverterDefaultFalse.class)
    public abstract GenericAttributeValue<Boolean> isInheritRefsProperties();

    @Attribute(value="usenativebasedir")
    @Convert(value=AntBooleanConverterDefaultFalse.class)
    public abstract GenericAttributeValue<Boolean> isUseNativeBasedir();

    public static class AntFilePathConverter
    extends AntPathConverter {
        public AntFilePathConverter() {
            super(true);
        }

        @Override
        @NlsSafe
        protected String getPathResolveRoot(ConvertContext context, AntDomProject antProject) {
            AntDomAnt antElement = (AntDomAnt)context.getInvocationElement().getParentOfType(AntDomAnt.class, false);
            if (antElement != null) {
                VirtualFile vFile;
                PsiFileSystemItem dir = (PsiFileSystemItem)antElement.getAntFileDir().getValue();
                if (dir == null && ((Boolean)antElement.isInheritAllProperties().getValue()).booleanValue()) {
                    dir = antProject.getProjectBasedir();
                }
                if (dir != null && (vFile = dir.getVirtualFile()) != null) {
                    return vFile.getPath();
                }
            }
            return super.getPathResolveRoot(context, antProject);
        }

        @Override
        protected String getAttributeDefaultValue(ConvertContext context, GenericAttributeValue attribValue) {
            return AntDomAnt.DEFAULT_ANTFILE_NAME;
        }
    }
}

