/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importer;

import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import java.util.HashMap;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importer.EclipseCodeStyleSchemeImporter;
import org.jetbrains.idea.eclipse.importer.EclipseFormatterOptions;

public class EclipseCodeStylePropertiesImporter
implements EclipseFormatterOptions {
    public void importProperties(@NotNull Properties eclipseProperties2, @NotNull CodeStyleSettings settings) throws SchemeImportException {
        if (eclipseProperties2 == null) {
            EclipseCodeStylePropertiesImporter.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            EclipseCodeStylePropertiesImporter.$$$reportNull$$$0(1);
        }
        HashMap<String, String> eclipseStringPropsMap = new HashMap<String, String>();
        for (String key : eclipseProperties2.stringPropertyNames()) {
            String value = eclipseProperties2.getProperty(key);
            if (value == null) continue;
            eclipseStringPropsMap.put(key, value);
        }
        EclipseCodeStyleSchemeImporter.importCodeStyleSettings(eclipseStringPropsMap, settings);
    }

    public void importOptimizeImportsSettings(@NotNull Properties uiPreferences, @NotNull CodeStyleSettings settings) {
        if (uiPreferences == null) {
            EclipseCodeStylePropertiesImporter.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            EclipseCodeStylePropertiesImporter.$$$reportNull$$$0(3);
        }
        JavaCodeStyleSettings javaSettings2 = (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
        EclipseCodeStylePropertiesImporter.importOrderOfImports(uiPreferences, javaSettings2);
        EclipseCodeStylePropertiesImporter.importStarImportThresholds(uiPreferences, javaSettings2);
        javaSettings2.LAYOUT_STATIC_IMPORTS_SEPARATELY = true;
        javaSettings2.PACKAGES_TO_USE_IMPORT_ON_DEMAND.copyFrom(new PackageEntryTable());
    }

    private static void importOrderOfImports(@NotNull Properties uiPreferences, @NotNull JavaCodeStyleSettings javaSettings2) {
        String oderOfImportsValue;
        if (uiPreferences == null) {
            EclipseCodeStylePropertiesImporter.$$$reportNull$$$0(4);
        }
        if (javaSettings2 == null) {
            EclipseCodeStylePropertiesImporter.$$$reportNull$$$0(5);
        }
        if ((oderOfImportsValue = uiPreferences.getProperty("org.eclipse.jdt.ui.importorder")) != null) {
            String[] chunks;
            PackageEntryTable importLayoutTable = new PackageEntryTable();
            importLayoutTable.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
            for (String importString : chunks = oderOfImportsValue.split(";")) {
                if (importString.trim().isEmpty()) continue;
                boolean isStatic = importString.startsWith("#");
                importString = StringUtil.trimStart((String)importString, (String)"#");
                importLayoutTable.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                importLayoutTable.addEntry(new PackageEntry(isStatic, importString, true));
            }
            if (importLayoutTable.getEntryCount() > 0) {
                importLayoutTable.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                importLayoutTable.addEntry(PackageEntry.ALL_OTHER_IMPORTS_ENTRY);
                javaSettings2.getImportLayoutTable().copyFrom(importLayoutTable);
            }
        }
    }

    private static void importStarImportThresholds(@NotNull Properties uiPreferences, @NotNull JavaCodeStyleSettings javaSettings2) {
        if (uiPreferences == null) {
            EclipseCodeStylePropertiesImporter.$$$reportNull$$$0(6);
        }
        if (javaSettings2 == null) {
            EclipseCodeStylePropertiesImporter.$$$reportNull$$$0(7);
        }
        javaSettings2.CLASS_COUNT_TO_USE_IMPORT_ON_DEMAND = EclipseCodeStylePropertiesImporter.parseThreshold(uiPreferences.getProperty("org.eclipse.jdt.ui.ondemandthreshold"));
        javaSettings2.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND = EclipseCodeStylePropertiesImporter.parseThreshold(uiPreferences.getProperty("org.eclipse.jdt.ui.staticondemandthreshold"));
    }

    private static int parseThreshold(@Nullable String s) {
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 99;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eclipseProperties";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiPreferences";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSettings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/eclipse/importer/EclipseCodeStylePropertiesImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "importProperties";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "importOptimizeImportsSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "importOrderOfImports";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "importStarImportThresholds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

