/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.spell;

import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.word.HeuristicWordTokenizer;
import ai.grazie.spell.GrazieSpeller;
import ai.grazie.spell.Speller;
import ai.grazie.spell.dictionary.RuleDictionary;
import ai.grazie.spell.language.LanguageModel;
import ai.grazie.spell.lists.WordListWithFrequency;
import ai.grazie.spell.suggestion.filter.SuggestionFilter;
import ai.grazie.spell.suggestion.ranker.SuggestionRanker;
import ai.grazie.spell.utils.UtilsKt;
import ai.grazie.utils.mpp.PlatformKt;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lai/grazie/spell/GrazieSpeller;", "Lai/grazie/spell/Speller;", "model", "Lai/grazie/spell/language/LanguageModel;", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "(Lai/grazie/spell/language/LanguageModel;Lai/grazie/nlp/tokenizer/Tokenizer;)V", "config", "Lai/grazie/spell/GrazieSpeller$UserConfig;", "(Lai/grazie/spell/GrazieSpeller$UserConfig;)V", "isAlien", "", "word", "", "isMisspelled", "caseSensitive", "suggestAndRank", "", "", "max", "", "UserConfig", "gec-spell-engine-local"})
@SourceDebugExtension(value={"SMAP\nGrazieSpeller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpeller.kt\nai/grazie/spell/GrazieSpeller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1271#2,2:181\n1285#2,4:183\n1054#2:188\n1054#2:189\n1#3:187\n*S KotlinDebug\n*F\n+ 1 GrazieSpeller.kt\nai/grazie/spell/GrazieSpeller\n*L\n163#1:181,2\n163#1:183,4\n173#1:188\n177#1:189\n*E\n"})
public final class GrazieSpeller
implements Speller {
    @NotNull
    private final UserConfig config;

    public GrazieSpeller(@NotNull UserConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public GrazieSpeller(@NotNull LanguageModel model, @NotNull Tokenizer tokenizer) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this(new UserConfig(model, tokenizer));
    }

    public /* synthetic */ GrazieSpeller(LanguageModel languageModel, Tokenizer tokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tokenizer = new HeuristicWordTokenizer(true, false);
        }
        this(languageModel, tokenizer);
    }

    @Override
    public boolean isMisspelled(@NotNull String word, boolean caseSensitive) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        PlatformKt.forPlatform(new Function0<Unit>(caseSensitive){
            final /* synthetic */ boolean $caseSensitive;
            {
                this.$caseSensitive = $caseSensitive;
                super(0);
            }

            public final void invoke() {
                if (!this.$caseSensitive) {
                    boolean bl = false;
                    String string2 = "NSpell does not support non case-sensitive requests";
                    throw new IllegalArgumentException(string2.toString());
                }
            }
        }, isMisspelled.2.INSTANCE);
        if (this.config.getDictionary().getRules().check(word) == RuleDictionary.Result.CORRECT) {
            return false;
        }
        WordListWithFrequency dictionary = this.config.getDictionary().getDictionary();
        if (!dictionary.contains(word, caseSensitive)) {
            Object normalized;
            Object object = this.config.getLanguageModel().getNormalizer();
            if (object == null || (object = object.normalize(word)) == null) {
                object = word;
            }
            if (Intrinsics.areEqual((Object)(normalized = object), (Object)word) || !dictionary.contains((String)normalized, caseSensitive)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAlien(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return (Boolean)this.config.getDictionary().isAlien().invoke((Object)word);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Double> suggestAndRank(@NotNull String word, int max) {
        WordListWithFrequency dictionary;
        LinkedHashSet<String> suggested;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (!Speller.isMisspelled$default(this, word, false, 2, null)) {
            return MapsKt.emptyMap();
        }
        HashMap<String, Double> result2 = new HashMap<String, Double>();
        if (this.config.getDictionary().getRules().check(word) == RuleDictionary.Result.INCORRECT) {
            void $this$associateWith$iv;
            Iterable iterable = this.config.getDictionary().getRules().suggest(word);
            HashMap<String, Double> hashMap = result2;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string2 = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                Double d = 1.0;
                map.put(t, d);
            }
            hashMap.putAll(result$iv);
        }
        if (!(!(suggested = (dictionary = this.config.getDictionary().getDictionary()).suggest(word)).contains(""))) {
            boolean $i$a$-check-GrazieSpeller$suggestAndRank$32 = false;
            String $i$a$-check-GrazieSpeller$suggestAndRank$32 = "Empty suggestion was provided by dictionary " + dictionary + " for input word '" + word + "'";
            throw new IllegalStateException($i$a$-check-GrazieSpeller$suggestAndRank$32.toString());
        }
        Map<String, Double> ranked = this.config.getModel().getRanker().score(word, suggested);
        Map<String, Double> filtered = this.config.getModel().getFilter().filter(ranked);
        Object $this$sortedByDescending$iv2 = filtered.entrySet();
        boolean $i$f$sortedByDescending = false;
        for (Object $this$sortedByDescending$iv2 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        })) {
            String key2 = (String)$this$sortedByDescending$iv2.getKey();
            double value = ((Number)$this$sortedByDescending$iv2.getValue()).doubleValue();
            result2.putIfAbsent(key2, value);
        }
        Set set = result2.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"result.entries");
        Iterable $this$sortedByDescending$iv3 = set;
        boolean $i$f$sortedByDescending2 = false;
        return UtilsKt.toMap(CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv3, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
            }
        }), (int)max));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\nH\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\u0002\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig;", "", "model", "Lai/grazie/spell/language/LanguageModel;", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "(Lai/grazie/spell/language/LanguageModel;Lai/grazie/nlp/tokenizer/Tokenizer;)V", "dictionary", "Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "languageModel", "Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "(Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;Lai/grazie/spell/language/LanguageModel;Lai/grazie/spell/GrazieSpeller$UserConfig$Model;)V", "getDictionary", "()Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "getLanguageModel", "()Lai/grazie/spell/language/LanguageModel;", "getModel", "()Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Dictionary", "Model", "gec-spell-engine-local"})
    public static final class UserConfig {
        @NotNull
        private final Dictionary dictionary;
        @NotNull
        private final LanguageModel languageModel;
        @NotNull
        private final Model model;

        public UserConfig(@NotNull Dictionary dictionary, @NotNull LanguageModel languageModel, @NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            Intrinsics.checkNotNullParameter((Object)languageModel, (String)"languageModel");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            this.dictionary = dictionary;
            this.languageModel = languageModel;
            this.model = model;
        }

        @NotNull
        public final Dictionary getDictionary() {
            return this.dictionary;
        }

        @NotNull
        public final LanguageModel getLanguageModel() {
            return this.languageModel;
        }

        @NotNull
        public final Model getModel() {
            return this.model;
        }

        public UserConfig(@NotNull LanguageModel model, @NotNull Tokenizer tokenizer) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
            this(new Dictionary(tokenizer, model.getWords(), model.isAlien(), model.getRules()), model, new Model(model.getFilter(), model.getRanker()));
        }

        public /* synthetic */ UserConfig(LanguageModel languageModel, Tokenizer tokenizer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                tokenizer = new HeuristicWordTokenizer(true, false);
            }
            this(languageModel, tokenizer);
        }

        @NotNull
        public final Dictionary component1() {
            return this.dictionary;
        }

        @NotNull
        public final LanguageModel component2() {
            return this.languageModel;
        }

        @NotNull
        public final Model component3() {
            return this.model;
        }

        @NotNull
        public final UserConfig copy(@NotNull Dictionary dictionary, @NotNull LanguageModel languageModel, @NotNull Model model) {
            Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
            Intrinsics.checkNotNullParameter((Object)languageModel, (String)"languageModel");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new UserConfig(dictionary, languageModel, model);
        }

        public static /* synthetic */ UserConfig copy$default(UserConfig userConfig, Dictionary dictionary, LanguageModel languageModel, Model model, int n, Object object) {
            if ((n & 1) != 0) {
                dictionary = userConfig.dictionary;
            }
            if ((n & 2) != 0) {
                languageModel = userConfig.languageModel;
            }
            if ((n & 4) != 0) {
                model = userConfig.model;
            }
            return userConfig.copy(dictionary, languageModel, model);
        }

        @NotNull
        public String toString() {
            return "UserConfig(dictionary=" + this.dictionary + ", languageModel=" + this.languageModel + ", model=" + this.model + ")";
        }

        public int hashCode() {
            int result2 = this.dictionary.hashCode();
            result2 = result2 * 31 + this.languageModel.hashCode();
            result2 = result2 * 31 + this.model.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserConfig)) {
                return false;
            }
            UserConfig userConfig = (UserConfig)other;
            if (!Intrinsics.areEqual((Object)this.dictionary, (Object)userConfig.dictionary)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.languageModel, (Object)userConfig.languageModel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.model, (Object)userConfig.model);
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u000bH\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig$Dictionary;", "", "tokenizer", "Lai/grazie/nlp/tokenizer/Tokenizer;", "dictionary", "Lai/grazie/spell/lists/WordListWithFrequency;", "isAlien", "Lkotlin/Function1;", "", "", "rules", "Lai/grazie/spell/dictionary/RuleDictionary;", "(Lai/grazie/nlp/tokenizer/Tokenizer;Lai/grazie/spell/lists/WordListWithFrequency;Lkotlin/jvm/functions/Function1;Lai/grazie/spell/dictionary/RuleDictionary;)V", "getDictionary", "()Lai/grazie/spell/lists/WordListWithFrequency;", "()Lkotlin/jvm/functions/Function1;", "getRules", "()Lai/grazie/spell/dictionary/RuleDictionary;", "getTokenizer", "()Lai/grazie/nlp/tokenizer/Tokenizer;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "gec-spell-engine-local"})
        public static final class Dictionary {
            @Nullable
            private final Tokenizer tokenizer;
            @NotNull
            private final WordListWithFrequency dictionary;
            @NotNull
            private final Function1<String, Boolean> isAlien;
            @NotNull
            private final RuleDictionary rules;

            public Dictionary(@Nullable Tokenizer tokenizer, @NotNull WordListWithFrequency dictionary, @NotNull Function1<? super String, Boolean> isAlien, @NotNull RuleDictionary rules2) {
                Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
                Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
                Intrinsics.checkNotNullParameter((Object)rules2, (String)"rules");
                this.tokenizer = tokenizer;
                this.dictionary = dictionary;
                this.isAlien = isAlien;
                this.rules = rules2;
            }

            public /* synthetic */ Dictionary(Tokenizer tokenizer, WordListWithFrequency wordListWithFrequency, Function1 function1, RuleDictionary ruleDictionary, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    tokenizer = new HeuristicWordTokenizer(true, false);
                }
                this(tokenizer, wordListWithFrequency, (Function1<? super String, Boolean>)function1, ruleDictionary);
            }

            @Nullable
            public final Tokenizer getTokenizer() {
                return this.tokenizer;
            }

            @NotNull
            public final WordListWithFrequency getDictionary() {
                return this.dictionary;
            }

            @NotNull
            public final Function1<String, Boolean> isAlien() {
                return this.isAlien;
            }

            @NotNull
            public final RuleDictionary getRules() {
                return this.rules;
            }

            @Nullable
            public final Tokenizer component1() {
                return this.tokenizer;
            }

            @NotNull
            public final WordListWithFrequency component2() {
                return this.dictionary;
            }

            @NotNull
            public final Function1<String, Boolean> component3() {
                return this.isAlien;
            }

            @NotNull
            public final RuleDictionary component4() {
                return this.rules;
            }

            @NotNull
            public final Dictionary copy(@Nullable Tokenizer tokenizer, @NotNull WordListWithFrequency dictionary, @NotNull Function1<? super String, Boolean> isAlien, @NotNull RuleDictionary rules2) {
                Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
                Intrinsics.checkNotNullParameter(isAlien, (String)"isAlien");
                Intrinsics.checkNotNullParameter((Object)rules2, (String)"rules");
                return new Dictionary(tokenizer, dictionary, isAlien, rules2);
            }

            public static /* synthetic */ Dictionary copy$default(Dictionary dictionary, Tokenizer tokenizer, WordListWithFrequency wordListWithFrequency, Function1 function1, RuleDictionary ruleDictionary, int n, Object object) {
                if ((n & 1) != 0) {
                    tokenizer = dictionary.tokenizer;
                }
                if ((n & 2) != 0) {
                    wordListWithFrequency = dictionary.dictionary;
                }
                if ((n & 4) != 0) {
                    function1 = dictionary.isAlien;
                }
                if ((n & 8) != 0) {
                    ruleDictionary = dictionary.rules;
                }
                return dictionary.copy(tokenizer, wordListWithFrequency, function1, ruleDictionary);
            }

            @NotNull
            public String toString() {
                return "Dictionary(tokenizer=" + this.tokenizer + ", dictionary=" + this.dictionary + ", isAlien=" + this.isAlien + ", rules=" + this.rules + ")";
            }

            public int hashCode() {
                int result2 = this.tokenizer == null ? 0 : this.tokenizer.hashCode();
                result2 = result2 * 31 + this.dictionary.hashCode();
                result2 = result2 * 31 + this.isAlien.hashCode();
                result2 = result2 * 31 + this.rules.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Dictionary)) {
                    return false;
                }
                Dictionary dictionary = (Dictionary)other;
                if (!Intrinsics.areEqual((Object)this.tokenizer, (Object)dictionary.tokenizer)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.dictionary, (Object)dictionary.dictionary)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.isAlien, dictionary.isAlien)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.rules, (Object)dictionary.rules);
            }
        }

        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lai/grazie/spell/GrazieSpeller$UserConfig$Model;", "", "filter", "Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "ranker", "Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "(Lai/grazie/spell/suggestion/filter/SuggestionFilter;Lai/grazie/spell/suggestion/ranker/SuggestionRanker;)V", "getFilter", "()Lai/grazie/spell/suggestion/filter/SuggestionFilter;", "getRanker", "()Lai/grazie/spell/suggestion/ranker/SuggestionRanker;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gec-spell-engine-local"})
        public static final class Model {
            @NotNull
            private final SuggestionFilter filter;
            @NotNull
            private final SuggestionRanker ranker;

            public Model(@NotNull SuggestionFilter filter2, @NotNull SuggestionRanker ranker) {
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
                this.filter = filter2;
                this.ranker = ranker;
            }

            @NotNull
            public final SuggestionFilter getFilter() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker getRanker() {
                return this.ranker;
            }

            @NotNull
            public final SuggestionFilter component1() {
                return this.filter;
            }

            @NotNull
            public final SuggestionRanker component2() {
                return this.ranker;
            }

            @NotNull
            public final Model copy(@NotNull SuggestionFilter filter2, @NotNull SuggestionRanker ranker) {
                Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                Intrinsics.checkNotNullParameter((Object)ranker, (String)"ranker");
                return new Model(filter2, ranker);
            }

            public static /* synthetic */ Model copy$default(Model model, SuggestionFilter suggestionFilter, SuggestionRanker suggestionRanker, int n, Object object) {
                if ((n & 1) != 0) {
                    suggestionFilter = model.filter;
                }
                if ((n & 2) != 0) {
                    suggestionRanker = model.ranker;
                }
                return model.copy(suggestionFilter, suggestionRanker);
            }

            @NotNull
            public String toString() {
                return "Model(filter=" + this.filter + ", ranker=" + this.ranker + ")";
            }

            public int hashCode() {
                int result2 = this.filter.hashCode();
                result2 = result2 * 31 + this.ranker.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Model)) {
                    return false;
                }
                Model model = (Model)other;
                if (!Intrinsics.areEqual((Object)this.filter, (Object)model.filter)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.ranker, (Object)model.ranker);
            }
        }
    }
}

