/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.diagnostic.PluginException;
import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.grammar.strategy.StrategyUtils;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u0004\u0018\u00010\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/grazie/text/StrategyTextExtractor;", "", "strategy", "Lcom/intellij/grazie/grammar/strategy/GrammarCheckingStrategy;", "(Lcom/intellij/grazie/grammar/strategy/GrammarCheckingStrategy;)V", "buildTextContent", "Lcom/intellij/grazie/text/TextContent;", "root", "Lcom/intellij/psi/PsiElement;", "extractText", "roots", "", "trimLeadingQuotesAndSpaces", "content", "Companion", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nStrategyTextExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrategyTextExtractor.kt\ncom/intellij/grazie/text/StrategyTextExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,91:1\n766#2:92\n857#2,2:93\n1603#2,9:95\n1855#2:104\n1856#2:106\n1612#2:107\n1603#2,9:108\n1855#2:117\n1856#2:119\n1612#2:120\n766#2:121\n857#2,2:122\n1045#2:125\n1549#2:127\n1620#2,3:128\n1#3:105\n1#3:118\n10#4:124\n10#4:126\n*S KotlinDebug\n*F\n+ 1 StrategyTextExtractor.kt\ncom/intellij/grazie/text/StrategyTextExtractor\n*L\n18#1:92\n18#1:93,2\n19#1:95,9\n19#1:104\n19#1:106\n19#1:107\n20#1:108,9\n20#1:117\n20#1:119\n20#1:120\n57#1:121\n57#1:122,2\n65#1:125\n76#1:127\n76#1:128,3\n19#1:105\n20#1:118\n60#1:124\n69#1:126\n*E\n"})
public final class StrategyTextExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GrammarCheckingStrategy strategy;

    public StrategyTextExtractor(@NotNull GrammarCheckingStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.strategy = strategy;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TextContent extractText(@NotNull List<? extends PsiElement> roots) {
        TextContent it$iv$iv;
        boolean bl;
        Object it;
        boolean bl2;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        TokenSet wsTokens = this.strategy.getWhiteSpaceTokens();
        Iterable iterable = roots;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            PsiElement it2 = (PsiElement)element$iv$iv2;
            boolean bl3 = false;
            if (!(!(it2 instanceof PsiCompiledElement) && !wsTokens.contains(PsiTreeUtilKt.getElementType((PsiElement)it2)))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (PsiElement)element$iv$iv;
            boolean bl4 = false;
            if (this.buildTextContent((PsiElement)it) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (TextContent)element$iv$iv;
            boolean bl5 = false;
            if (this.trimLeadingQuotesAndSpaces((TextContent)it) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fragments = (List)destination$iv$iv;
        return TextContent.joinWithWhitespace('\n', fragments);
    }

    private final TextContent trimLeadingQuotesAndSpaces(TextContent content) {
        int trimSuffix;
        String text2 = ((Object)content).toString();
        int trimPrefix = StrategyUtils.INSTANCE.quotesOffset$intellij_grazie_core(text2);
        if (!(trimPrefix <= (trimSuffix = text2.length() - trimPrefix))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        while (trimSuffix > trimPrefix && CharsKt.isWhitespace((char)text2.charAt(trimSuffix - 1))) {
            --trimSuffix;
        }
        while (trimSuffix > trimPrefix && CharsKt.isWhitespace((char)text2.charAt(trimPrefix))) {
            ++trimPrefix;
        }
        if (trimSuffix <= trimPrefix) {
            return null;
        }
        if (trimPrefix > 0 || trimSuffix < text2.length()) {
            return content.excludeRange(new TextRange(trimSuffix, text2.length())).excludeRange(new TextRange(0, trimPrefix));
        }
        return content;
    }

    /*
     * WARNING - void declaration
     */
    private final TextContent buildTextContent(PsiElement root) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        TextContent.TextDomain textDomain = Companion.convertDomain(this.strategy.getContextRootTextDomain(root));
        if (textDomain == null) {
            throw new IllegalArgumentException("Non-text " + root.getClass() + " in " + this.strategy.getClass());
        }
        TextContent.TextDomain domain = textDomain;
        TextContent textContent = TextContentBuilder.FromPsi.withUnknown(arg_0 -> StrategyTextExtractor.buildTextContent$lambda$3(root, this, arg_0)).excluding(arg_0 -> StrategyTextExtractor.buildTextContent$lambda$4(root, this, arg_0)).build(root, domain, new TextRange(0, root.getTextLength()));
        if (textContent == null) {
            return null;
        }
        TextContent content = textContent;
        LinkedHashSet<IntRange> stealthyRanges = this.strategy.getStealthyRanges(root, content);
        Iterable $this$filter$iv = stealthyRanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IntRange it = (IntRange)element$iv$iv;
            boolean bl = false;
            if (!(it.getFirst() <= it.getLast() && it.getLast() < content.length())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        if (filtered.size() != stealthyRanges.size()) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(StrategyTextExtractor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            PluginException.logPluginError((Logger)logger, (String)(this.strategy + " produced invalid stealthy ranges " + stealthyRanges + " in a text of length " + content.length()), null, this.strategy.getClass());
        }
        Iterable $this$sortedBy$iv = filtered;
        int $i$f$sortedBy = 0;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IntRange it = (IntRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFirst());
                it = (IntRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
            }
        });
        $i$f$sortedBy = sorted.size();
        for (int i = 1; i < $i$f$sortedBy; ++i) {
            if (((IntRange)sorted.get(i - 1)).getLast() < ((IntRange)sorted.get(i)).getFirst()) continue;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(StrategyTextExtractor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            PluginException.logPluginError((Logger)logger, (String)(this.strategy + " produced intersecting stealthy ranges " + sorted.get(i - 1) + " and " + sorted.get(i)), null, this.strategy.getClass());
            return null;
        }
        Iterable i = sorted;
        TextContent textContent2 = content;
        boolean $i$f$map = false;
        void $i$f$logger = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IntRange bl = (IntRange)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new TextContent.Exclusion(it.getFirst(), it.getLast() + 1, false));
        }
        return textContent2.excludeRanges((List)destination$iv$iv2);
    }

    private static final GrammarCheckingStrategy.ElementBehavior buildTextContent$getBehavior(PsiElement $root, StrategyTextExtractor this$0, PsiElement element) {
        return element != $root && this$0.strategy.isMyContextRoot(element) ? GrammarCheckingStrategy.ElementBehavior.ABSORB : this$0.strategy.getElementBehavior($root, element);
    }

    private static final boolean buildTextContent$lambda$3(PsiElement $root, StrategyTextExtractor this$0, PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
        return StrategyTextExtractor.buildTextContent$getBehavior($root, this$0, e) == GrammarCheckingStrategy.ElementBehavior.ABSORB;
    }

    private static final boolean buildTextContent$lambda$4(PsiElement $root, StrategyTextExtractor this$0, PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
        return StrategyTextExtractor.buildTextContent$getBehavior($root, this$0, e) == GrammarCheckingStrategy.ElementBehavior.STEALTH;
    }

    @JvmStatic
    @Nullable
    public static final TextContent.TextDomain convertDomain(@NotNull GrammarCheckingStrategy.TextDomain domain) {
        return Companion.convertDomain(domain);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grazie/text/StrategyTextExtractor$Companion;", "", "()V", "convertDomain", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "domain", "Lcom/intellij/grazie/grammar/strategy/GrammarCheckingStrategy$TextDomain;", "intellij.grazie.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final TextContent.TextDomain convertDomain(@NotNull GrammarCheckingStrategy.TextDomain domain) {
            Intrinsics.checkNotNullParameter((Object)((Object)domain), (String)"domain");
            return switch (WhenMappings.$EnumSwitchMapping$0[domain.ordinal()]) {
                case 1 -> TextContent.TextDomain.LITERALS;
                case 2 -> TextContent.TextDomain.COMMENTS;
                case 3 -> TextContent.TextDomain.DOCUMENTATION;
                case 4 -> TextContent.TextDomain.PLAIN_TEXT;
                default -> null;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GrammarCheckingStrategy.TextDomain.values().length];
                try {
                    nArray[GrammarCheckingStrategy.TextDomain.LITERALS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GrammarCheckingStrategy.TextDomain.COMMENTS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GrammarCheckingStrategy.TextDomain.DOCS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GrammarCheckingStrategy.TextDomain.PLAIN_TEXT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

