/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.exp.BashCompletionManager;
import org.jetbrains.plugins.terminal.exp.CommandHistoryManager;
import org.jetbrains.plugins.terminal.exp.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalCompletionManager;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.ZshCompletionManager;
import org.jetbrains.plugins.terminal.util.ShellIntegration;
import org.jetbrains.plugins.terminal.util.ShellIntegrationKt;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 82\u00020\u00012\u00020\u00022\u00020\u0003:\u00018B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010#\u001a\u00070$\u00a2\u0006\u0002\b%2\u0006\u0010&\u001a\u00020$H\u0002J\b\u0010'\u001a\u00020\"H\u0002J\b\u0010(\u001a\u00020 H\u0002J\u0015\u0010)\u001a\u00020*2\u000b\u0010+\u001a\u00070$\u00a2\u0006\u0002\b%H\u0016J\b\u0010,\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\u0006\u00102\u001a\u00020*J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020*J\b\u00106\u001a\u00020*H\u0007J\u0006\u00107\u001a\u00020*R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/ui/ComponentContainer;", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "commandExecutor", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/exp/TerminalSession;Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;)V", "charSize", "Ljava/awt/Dimension;", "getCharSize", "()Ljava/awt/Dimension;", "commandHistoryManager", "Lorg/jetbrains/plugins/terminal/exp/CommandHistoryManager;", "commandHistoryPresenter", "Lorg/jetbrains/plugins/terminal/exp/CommandHistoryPresenter;", "completionManager", "Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionManager;", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "editorTextField", "Lcom/intellij/ui/LanguageTextField;", "promptLabel", "Ljavax/swing/JLabel;", "computePromptText", "", "Lcom/intellij/openapi/util/NlsSafe;", "directory", "createPromptLabel", "createPromptTextField", "directoryChanged", "", "newDirectory", "dispose", "getBackground", "Ljava/awt/Color;", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "handleEnterPressed", "isFocused", "", "onCommandHistoryClosed", "reset", "showCommandHistory", "Companion", "intellij.terminal"})
public final class TerminalPromptPanel
extends JPanel
implements ComponentContainer,
ShellCommandListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalCommandExecutor commandExecutor;
    @NotNull
    private final LanguageTextField editorTextField;
    @NotNull
    private final JLabel promptLabel;
    @Nullable
    private final TerminalCompletionManager completionManager;
    @NotNull
    private final CommandHistoryManager commandHistoryManager;
    @NotNull
    private final CommandHistoryPresenter commandHistoryPresenter;
    @NotNull
    private static final Key<TerminalPromptPanel> KEY;
    private static final int LEFT_INSET = 7;

    public TerminalPromptPanel(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalSession session, @NotNull TerminalCommandExecutor commandExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        this.project = project;
        this.settings = settings;
        this.commandExecutor = commandExecutor;
        this.editorTextField = this.createPromptTextField();
        this.promptLabel = this.createPromptLabel();
        String string = TerminalProjectOptionsProvider.Companion.getInstance(this.project).getStartingDirectory();
        if (string == null) {
            string = "";
        }
        this.promptLabel.setText(this.computePromptText(string));
        ShellIntegration shellIntegration = session.getShellIntegration();
        ShellType shellType = shellIntegration != null ? shellIntegration.getShellType() : null;
        this.completionManager = switch (shellType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shellType.ordinal()]) {
            case 1 -> new ZshCompletionManager(session);
            case 2 -> new BashCompletionManager(session);
            default -> null;
        };
        this.commandHistoryManager = new CommandHistoryManager(session);
        this.commandHistoryPresenter = new CommandHistoryPresenter(this.project, (Editor)this.getEditor());
        this.getEditor().putUserData(TerminalSession.Companion.getKEY(), (Object)session);
        this.getEditor().putUserData(TerminalCompletionManager.Companion.getKEY(), (Object)this.completionManager);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getCachedPsiFile((Document)this.getEditor().getDocument());
        if (psiFile == null) {
            throw new IllegalStateException("Psi file is null for prompt text field".toString());
        }
        PsiFile psiFile2 = psiFile;
        ShellIntegration shellIntegration2 = session.getShellIntegration();
        psiFile2.putUserData(ShellIntegrationKt.getSHELL_TYPE_KEY(), (Object)(shellIntegration2 != null ? shellIntegration2.getShellType() : null));
        TerminalSession.addCommandListener$default(session, this, null, 2, null);
        Border border = JBUI.Borders.customLine((Color)UIUtil.getTextFieldBackground(), (int)6, (int)0, (int)6, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"customLine(UIUtil.getTex\u2026Background(), 6, 0, 6, 0)");
        Border innerBorder = border;
        Border border2 = JBUI.Borders.customLineTop((Color)JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
        Intrinsics.checkNotNullExpressionValue((Object)border2, (String)"customLineTop(JBUI.Curre\u2026ns.separatorForeground())");
        Border outerBorder = border2;
        this.setBorder(JBUI.Borders.compound((Border)outerBorder, (Border)innerBorder));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.promptLabel);
        this.add(Box.createRigidArea((Dimension)new JBDimension(0, 4)));
        this.add((Component)this.editorTextField);
    }

    private final EditorImpl getEditor() {
        EditorEx editorEx = this.editorTextField.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return (EditorImpl)editorEx;
    }

    private final Document getDocument() {
        Document document = this.editorTextField.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editorTextField.document");
        return document;
    }

    @NotNull
    public final Dimension getCharSize() {
        return new Dimension(this.getEditor().getCharHeight(), this.getEditor().getLineHeight());
    }

    private final LanguageTextField createPromptTextField() {
        Language language = FileTypes.PLAIN_TEXT.getLanguage();
        Project project = this.project;
        LanguageTextField textField2 = new LanguageTextField(language, project){

            public void setBackground(@Nullable Color bg) {
            }
        };
        textField2.setDisposedWith((Disposable)this);
        textField2.setBorder((Border)JBUI.Borders.emptyLeft((int)JBUI.scale((int)7)));
        textField2.setAlignmentX(0.0f);
        EditorEx editorEx = textField2.getEditor(true);
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor = (EditorImpl)editorEx;
        editor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor.setBackgroundColor(UIUtil.getTextFieldBackground());
        Project $this$createPromptTextField_u24lambda_u240 = project = editor.getColorsScheme();
        boolean bl = false;
        $this$createPromptTextField_u24lambda_u240.setEditorFontName(this.settings.getTerminalFont().getFontName());
        $this$createPromptTextField_u24lambda_u240.setEditorFontSize(this.settings.getTerminalFont().getSize());
        $this$createPromptTextField_u24lambda_u240.setLineSpacing(this.settings.getLineSpacing());
        editor.getSettings().setBlockCursor(true);
        editor.putUserData(KEY, (Object)this);
        return textField2;
    }

    private final JLabel createPromptLabel() {
        JLabel label = new JLabel();
        label.setFont(EditorUtil.getEditorFont());
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)JBUI.scale((int)7)));
        label.setAlignmentX(0.0f);
        return label;
    }

    @Override
    public void directoryChanged(@NotNull String newDirectory) {
        Intrinsics.checkNotNullParameter((Object)newDirectory, (String)"newDirectory");
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, newDirectory){
            final /* synthetic */ TerminalPromptPanel this$0;
            final /* synthetic */ String $newDirectory;
            {
                this.this$0 = $receiver;
                this.$newDirectory = $newDirectory;
                super(0);
            }

            public final void invoke() {
                TerminalPromptPanel.access$getPromptLabel$p(this.this$0).setText(TerminalPromptPanel.access$computePromptText(this.this$0, this.$newDirectory));
            }
        }), (int)1, null);
    }

    private final String computePromptText(String directory) {
        String string;
        if (!Intrinsics.areEqual((Object)directory, (Object)SystemProperties.getUserHome())) {
            String string2 = FileUtil.getLocationRelativeToUserHome((String)directory);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n      FileUtil.getLoca\u2026UserHome(directory)\n    }");
        } else {
            string = "~";
        }
        return string;
    }

    @RequiresEdt
    public final void reset() {
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TerminalPromptPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TerminalPromptPanel.access$getDocument(this.this$0).setText((CharSequence)"");
            }
        }));
    }

    public final void handleEnterPressed() {
        String string = this.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
        this.commandExecutor.startCommandExecution(string);
    }

    public final void showCommandHistory() {
        List<String> history = this.commandHistoryManager.getHistory();
        if (!((Collection)history).isEmpty()) {
            this.commandHistoryPresenter.showCommandHistory(history);
        }
    }

    public final void onCommandHistoryClosed() {
        this.commandHistoryPresenter.onCommandHistoryClosed();
    }

    public final boolean isFocused() {
        return this.getEditor().getContentComponent().hasFocus();
    }

    @Override
    @NotNull
    public Color getBackground() {
        Color color = UIUtil.getTextFieldBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTextFieldBackground()");
        return color;
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        EditorComponentImpl editorComponentImpl = this.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"editor.contentComponent");
        return (JComponent)editorComponentImpl;
    }

    public void dispose() {
    }

    public static final /* synthetic */ JLabel access$getPromptLabel$p(TerminalPromptPanel $this) {
        return $this.promptLabel;
    }

    public static final /* synthetic */ String access$computePromptText(TerminalPromptPanel $this, String directory) {
        return $this.computePromptText(directory);
    }

    public static final /* synthetic */ Document access$getDocument(TerminalPromptPanel $this) {
        return $this.getDocument();
    }

    static {
        Key key = Key.create((String)"TerminalPromptPanel");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(\"TerminalPromptPanel\")");
        KEY = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptPanel$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptPanel;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "LEFT_INSET", "", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<TerminalPromptPanel> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShellType.values().length];
            try {
                nArray[ShellType.ZSH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShellType.BASH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

