/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.TerminalModelListenerEx;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalTextBufferEx;", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "width", "", "height", "styleState", "Lcom/jediterm/terminal/model/StyleState;", "(IILcom/jediterm/terminal/model/StyleState;)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/exp/TerminalModelListenerEx;", "addModelListener", "", "listener", "Lcom/jediterm/terminal/model/TerminalModelListener;", "removeModelListener", "writeString", "x", "y", "str", "Lcom/jediterm/terminal/model/CharBuffer;", "intellij.terminal"})
public final class TerminalTextBufferEx
extends TerminalTextBuffer {
    @NotNull
    private final List<TerminalModelListenerEx> listeners;

    public TerminalTextBufferEx(int width, int height, @NotNull StyleState styleState) {
        Intrinsics.checkNotNullParameter((Object)styleState, (String)"styleState");
        super(width, height, styleState);
        this.listeners = new CopyOnWriteArrayList();
    }

    public void writeString(int x, int y, @NotNull CharBuffer str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        super.writeString(x, y, str);
        for (TerminalModelListenerEx listener : this.listeners) {
            String string = str.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.toString()");
            listener.textWritten(x, y, string);
        }
    }

    public void addModelListener(@NotNull TerminalModelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super.addModelListener(listener);
        if (listener instanceof TerminalModelListenerEx) {
            this.listeners.add((TerminalModelListenerEx)listener);
        }
    }

    public void removeModelListener(@NotNull TerminalModelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super.removeModelListener(listener);
        TypeIntrinsics.asMutableCollection((Object)this.listeners).remove(listener);
    }
}

