/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.terminal.ui.TtyConnectorAccessor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.TtyConnector;
import java.awt.Color;
import java.awt.Component;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.exp.PlainTerminalController;
import org.jetbrains.plugins.terminal.exp.TerminalBlocksController;
import org.jetbrains.plugins.terminal.exp.TerminalContentController;
import org.jetbrains.plugins.terminal.exp.TerminalController;
import org.jetbrains.plugins.terminal.exp.TerminalSession;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007H\u0016J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eH\u0016J\b\u0010(\u001a\u00020\u001cH\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J\b\u0010*\u001a\u00020\u001eH\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0.2\u0006\u0010/\u001a\u000200H\u0007J\b\u00101\u001a\u00020\u001cH\u0016J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020,H\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u000206H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalWidgetImpl;", "Lcom/intellij/terminal/ui/TerminalWidget;", "project", "Lcom/intellij/openapi/project/Project;", "terminalSettings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/openapi/Disposable;)V", "controller", "Lorg/jetbrains/plugins/terminal/exp/TerminalContentController;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "termSize", "Lcom/jediterm/core/util/TermSize;", "getTermSize", "()Lcom/jediterm/core/util/TermSize;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "getTerminalTitle", "()Lcom/intellij/terminal/TerminalTitle;", "ttyConnectorAccessor", "Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "getTtyConnectorAccessor", "()Lcom/intellij/terminal/ui/TtyConnectorAccessor;", "wrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "addNotification", "", "notificationComponent", "Ljavax/swing/JComponent;", "disposable", "addTerminationCallback", "onTerminated", "Ljava/lang/Runnable;", "parentDisposable", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "dispose", "getComponent", "getPreferredFocusableComponent", "hasFocus", "", "initialize", "Ljava/util/concurrent/CompletableFuture;", "options", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "requestFocus", "setCursorVisible", "visible", "writePlainMessage", "message", "", "TerminalPlaceholder", "intellij.terminal"})
public final class TerminalWidgetImpl
implements TerminalWidget {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase terminalSettings;
    @NotNull
    private final Wrapper wrapper;
    @NotNull
    private final TerminalTitle terminalTitle;
    @NotNull
    private final TtyConnectorAccessor ttyConnectorAccessor;
    @NotNull
    private final TerminalSession session;
    @NotNull
    private TerminalContentController controller;

    public TerminalWidgetImpl(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase terminalSettings, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)terminalSettings, (String)"terminalSettings");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.terminalSettings = terminalSettings;
        this.wrapper = new Wrapper();
        this.terminalTitle = new TerminalTitle();
        this.ttyConnectorAccessor = new TtyConnectorAccessor();
        this.session = new TerminalSession(this.terminalSettings);
        this.controller = new TerminalPlaceholder();
        this.wrapper.setContent(this.controller.getComponent());
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.session);
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.controller));
    }

    @NotNull
    public TerminalTitle getTerminalTitle() {
        return this.terminalTitle;
    }

    @Nullable
    public TermSize getTermSize() {
        return this.controller.getTerminalSize();
    }

    @NotNull
    public TtyConnectorAccessor getTtyConnectorAccessor() {
        return this.ttyConnectorAccessor;
    }

    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        TerminalController terminalController = this.session.getController();
        CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Unit)");
        terminalController.resize(initialTermSize, RequestOrigin.User, completableFuture);
        this.getTtyConnectorAccessor().setTtyConnector(ttyConnector);
        this.session.start(ttyConnector);
    }

    @RequiresEdt(generateAssertion=false)
    @NotNull
    public final CompletableFuture<TermSize> initialize(@NotNull ShellStartupOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.session.setShellIntegration(options.getShellIntegration());
        Disposer.dispose((Disposable)((Disposable)this.controller));
        ShellIntegration shellIntegration = options.getShellIntegration();
        this.controller = (shellIntegration != null ? shellIntegration.getWithCommandBlocks() : false) ? (TerminalContentController)new TerminalBlocksController(this.project, this.session, this.terminalSettings) : (TerminalContentController)new PlainTerminalController(this.project, this.session, this.terminalSettings);
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.controller));
        JComponent jComponent = this.controller.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"controller.component");
        JComponent component = jComponent;
        this.wrapper.setContent(component);
        CompletionStage completionStage = TerminalUiUtils.INSTANCE.awaitComponentLayout(component, (Disposable)this.controller).thenApply(arg_0 -> TerminalWidgetImpl.initialize$lambda$0((Function1)new Function1<Unit, TermSize>(this){
            final /* synthetic */ TerminalWidgetImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final TermSize invoke(Unit it) {
                return TerminalWidgetImpl.access$getController$p(this.this$0).getTerminalSize();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"@RequiresEdt(generateAss\u2026tTerminalSize()\n    }\n  }");
        return completionStage;
    }

    public void writePlainMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public void setCursorVisible(boolean visible) {
    }

    public boolean hasFocus() {
        return this.controller.isFocused();
    }

    public void requestFocus() {
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.getPreferredFocusableComponent(), true);
    }

    public void addNotification(@NotNull JComponent notificationComponent, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)notificationComponent, (String)"notificationComponent");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
    }

    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.wrapper;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        JComponent jComponent = this.controller.getPreferredFocusableComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"controller.preferredFocusableComponent");
        return jComponent;
    }

    private static final TermSize initialize$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (TermSize)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ TerminalContentController access$getController$p(TerminalWidgetImpl $this) {
        return $this.controller;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalWidgetImpl$TerminalPlaceholder;", "Lorg/jetbrains/plugins/terminal/exp/TerminalContentController;", "()V", "panel", "Ljavax/swing/JPanel;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusableComponent", "getTerminalSize", "Lcom/jediterm/core/util/TermSize;", "isFocused", "", "intellij.terminal"})
    private static final class TerminalPlaceholder
    implements TerminalContentController {
        @NotNull
        private final JPanel panel = new JPanel(){

            @NotNull
            public Color getBackground() {
                Color color = UIUtil.getTextFieldBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTextFieldBackground()");
                return color;
            }
        };

        @Override
        @Nullable
        public TermSize getTerminalSize() {
            return null;
        }

        @Override
        public boolean isFocused() {
            return false;
        }

        @NotNull
        public JComponent getComponent() {
            return this.panel;
        }

        @NotNull
        public JComponent getPreferredFocusableComponent() {
            return this.panel;
        }

        public void dispose() {
        }
    }
}

