/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.folding;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.folding.AndroidFoldingSettings;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\tH\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u000f*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0007*\u00020\u001aH\u0002J'\u0010\u001f\u001a\u0004\u0018\u00010\u000f*\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0082\u0010J\f\u0010%\u001a\u00020\u0004*\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "()V", "isFoldingEnabled", "", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "formatArguments", "", "callExpression", "Lorg/jetbrains/uast/UCallExpression;", "formatString", "getPlaceholderText", "node", "Lcom/intellij/lang/ASTNode;", "isCollapsedByDefault", "getAndroidResourceType", "Lcom/android/resources/ResourceType;", "getAndroidResourceValue", "Lorg/jetbrains/uast/UReferenceExpression;", "resources", "Lcom/android/tools/idea/res/LocalResourceRepository;", "call", "getFoldingDescriptor", "getResourceValue", "Lcom/android/ide/common/resources/ResourceRepository;", "type", "name", "referenceConfig", "Lcom/android/ide/common/resources/configuration/FolderConfiguration;", "isFoldableGetResourceValueCall", "Companion", "intellij.android.kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nResourceFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFoldingBuilder.kt\norg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n26#2:273\n37#3,2:274\n1#4:276\n*S KotlinDebug\n*F\n+ 1 ResourceFoldingBuilder.kt\norg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder\n*L\n83#1:273\n95#1:274,2\n*E\n"})
public final class ResourceFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isFoldingEnabled = AndroidFoldingSettings.getInstance().isCollapseAndroidStrings();
    private static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final int FOLD_MAX_LENGTH = 60;
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    @NotNull
    private static final List<ResourceType> RESOURCE_TYPES;

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        StudioResourceRepositoryManager studioResourceRepositoryManager = StudioResourceRepositoryManager.getInstance((PsiElement)element);
        if (studioResourceRepositoryManager == null || (studioResourceRepositoryManager = studioResourceRepositoryManager.getAppResources()) == null) {
            return null;
        }
        StudioResourceRepositoryManager appResources = studioResourceRepositoryManager;
        UastContext uastContext = (UastContext)element.getProject().getService(UastContext.class);
        if (uastContext == null) {
            return null;
        }
        UastContext uastContext2 = uastContext;
        UElement uElement = uastContext2.convertElement(element, null, null);
        return uElement != null ? ResourceFoldingBuilder.getPlaceholderText$unwrapReferenceAndGetValue(uElement, this, (LocalResourceRepository)appResources) : null;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!(root instanceof KtFile) || quick && !UNIT_TEST_MODE || !this.isFoldingEnabled || AndroidFacet.getInstance((PsiElement)root) == null) {
            boolean $i$f$emptyArray = false;
            return new FoldingDescriptor[0];
        }
        UElement file = UastContextKt.toUElement((PsiElement)root);
        ArrayList<FoldingDescriptor> result = new ArrayList<FoldingDescriptor>();
        UElement uElement = file;
        if (uElement != null) {
            uElement.accept((UastVisitor)new AbstractUastVisitor(this, result){
                final /* synthetic */ ResourceFoldingBuilder this$0;
                final /* synthetic */ ArrayList<FoldingDescriptor> $result;
                {
                    this.this$0 = $receiver;
                    this.$result = $result;
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        FoldingDescriptor foldingDescriptor = ResourceFoldingBuilder.access$getFoldingDescriptor(this.this$0, (UReferenceExpression)node);
                        if (foldingDescriptor == null) break block0;
                        FoldingDescriptor foldingDescriptor2 = foldingDescriptor;
                        ArrayList<FoldingDescriptor> arrayList = this.$result;
                        FoldingDescriptor it = foldingDescriptor2;
                        boolean bl = false;
                        arrayList.add(it);
                    }
                    return super.visitSimpleNameReferenceExpression(node);
                }
            });
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FoldingDescriptor[0]);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.isFoldingEnabled;
    }

    private final FoldingDescriptor getFoldingDescriptor(UReferenceExpression $this$getFoldingDescriptor) {
        UElement getResourceValueCall;
        PsiElement psiElement = $this$getFoldingDescriptor.resolve();
        if (psiElement == null) {
            return null;
        }
        PsiElement resolved = psiElement;
        ResourceType resourceType = this.getAndroidResourceType(resolved);
        if (resourceType == null) {
            return null;
        }
        ResourceType resourceType2 = resourceType;
        if (!RESOURCE_TYPES.contains(resourceType2)) {
            return null;
        }
        UElement uElement = $this$getFoldingDescriptor.getUastParent();
        UQualifiedReferenceExpression uQualifiedReferenceExpression = uElement instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement : null;
        UReferenceExpression element = uQualifiedReferenceExpression != null ? (UReferenceExpression)uQualifiedReferenceExpression : $this$getFoldingDescriptor;
        UElement uElement2 = element.getUastParent();
        UCallExpression uCallExpression = uElement2 instanceof UCallExpression ? (UCallExpression)uElement2 : null;
        if (uCallExpression != null) {
            UElement it = uElement2 = uCallExpression;
            boolean bl = false;
            v4 = this.isFoldableGetResourceValueCall((UCallExpression)it) ? uElement2 : null;
        } else {
            v4 = getResourceValueCall = null;
        }
        if (getResourceValueCall != null) {
            UQualifiedReferenceExpression qualifiedCall;
            uElement2 = getResourceValueCall.getUastParent();
            UQualifiedReferenceExpression uQualifiedReferenceExpression2 = qualifiedCall = uElement2 instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)uElement2 : null;
            if (Intrinsics.areEqual((Object)(uQualifiedReferenceExpression2 != null ? uQualifiedReferenceExpression2.getSelector() : null), (Object)getResourceValueCall)) {
                return ResourceFoldingBuilder.getFoldingDescriptor$createFoldingDescriptor((UElement)qualifiedCall);
            }
            return ResourceFoldingBuilder.getFoldingDescriptor$createFoldingDescriptor(getResourceValueCall);
        }
        return ResourceFoldingBuilder.getFoldingDescriptor$createFoldingDescriptor((UElement)element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFoldableGetResourceValueCall(UCallExpression $this$isFoldableGetResourceValueCall) {
        if (Intrinsics.areEqual((Object)$this$isFoldableGetResourceValueCall.getMethodName(), (Object)"getString")) return true;
        if (Intrinsics.areEqual((Object)$this$isFoldableGetResourceValueCall.getMethodName(), (Object)"getText")) return true;
        if (Intrinsics.areEqual((Object)$this$isFoldableGetResourceValueCall.getMethodName(), (Object)"getInteger")) return true;
        String string = $this$isFoldableGetResourceValueCall.getMethodName();
        if (string != null ? StringsKt.startsWith$default((String)string, (String)"getDimension", (boolean)false, (int)2, null) : false) return true;
        String string2 = $this$isFoldableGetResourceValueCall.getMethodName();
        if (string2 == null) return false;
        boolean bl = StringsKt.startsWith$default((String)string2, (String)"getQuantityString", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    private final ResourceType getAndroidResourceType(PsiElement $this$getAndroidResourceType) {
        PsiElement psiElement = $this$getAndroidResourceType.getParent();
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return null;
        }
        PsiClass elementType = psiClass;
        PsiElement psiElement2 = elementType.getParent();
        PsiClass psiClass2 = psiElement2 instanceof PsiClass ? (PsiClass)psiElement2 : null;
        if (psiClass2 == null) {
            return null;
        }
        PsiClass elementPackage = psiClass2;
        if (!Intrinsics.areEqual((Object)"R", (Object)elementPackage.getName())) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)elementPackage.getQualifiedName(), (Object)"android.R")) {
            ResourceType resourceType;
            String string = elementType.getName();
            if (string != null) {
                String p0 = string;
                boolean bl = false;
                resourceType = ResourceType.fromClassName((String)p0);
            } else {
                resourceType = null;
            }
            return resourceType;
        }
        return null;
    }

    private final String getAndroidResourceValue(UReferenceExpression $this$getAndroidResourceValue, LocalResourceRepository resources, UCallExpression call) {
        String text;
        FolderConfiguration folderConfiguration;
        PsiElement psiElement = $this$getAndroidResourceValue.resolve();
        if (psiElement == null || (psiElement = this.getAndroidResourceType(psiElement)) == null) {
            return null;
        }
        PsiElement resourceType = psiElement;
        FolderConfiguration $this$getAndroidResourceValue_u24lambda_u242 = folderConfiguration = new FolderConfiguration();
        boolean bl = false;
        $this$getAndroidResourceValue_u24lambda_u242.setLocaleQualifier(new LocaleQualifier("xx"));
        FolderConfiguration referenceConfig = folderConfiguration;
        String string = $this$getAndroidResourceValue.getResolvedName();
        if (string == null) {
            return null;
        }
        String key = string;
        String string2 = this.getResourceValue((ResourceRepository)resources, (ResourceType)resourceType, key, referenceConfig);
        if (string2 == null) {
            return null;
        }
        String resourceValue = string2;
        UCallExpression uCallExpression = call;
        String string3 = text = uCallExpression != null ? this.formatArguments(uCallExpression, resourceValue) : resourceValue;
        if (resourceType == ResourceType.STRING || resourceType == ResourceType.PLURALS) {
            char c = '\"';
            String string4 = StringUtil.shortenTextWithEllipsis((String)text, (int)58, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"shortenTextWithEllipsis(\u2026, FOLD_MAX_LENGTH - 2, 0)");
            String string5 = string4;
            return c + string5 + "\"";
        }
        if (text.length() <= 1) {
            return key + ": " + text;
        }
        return StringUtil.shortenTextWithEllipsis((String)text, (int)60, (int)0);
    }

    static /* synthetic */ String getAndroidResourceValue$default(ResourceFoldingBuilder resourceFoldingBuilder, UReferenceExpression uReferenceExpression, LocalResourceRepository localResourceRepository, UCallExpression uCallExpression, int n, Object object) {
        if ((n & 2) != 0) {
            uCallExpression = null;
        }
        return resourceFoldingBuilder.getAndroidResourceValue(uReferenceExpression, localResourceRepository, uCallExpression);
    }

    private final String getResourceValue(ResourceRepository $this$getResourceValue, ResourceType type, String name, FolderConfiguration referenceConfig) {
        while (true) {
            ResourceType referencedType;
            char[] cArray;
            ResourceValue resourceValue = ResourceRepositoryUtil.getConfiguredValue((ResourceRepository)$this$getResourceValue, (ResourceType)type, (String)name, (FolderConfiguration)referenceConfig);
            String string = resourceValue != null ? resourceValue.getValue() : null;
            if (string == null) {
                return null;
            }
            String value = string;
            if (!StringsKt.startsWith$default((CharSequence)value, (char)'@', (boolean)false, (int)2, null)) {
                return value;
            }
            String string2 = value.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            Object object = new char[]{'/'};
            char[] it = object = (Object)StringsKt.split$default((CharSequence)string2, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            if ((it.size() == 2 ? object : null) == null) {
                return value;
            }
            cArray = cArray;
            String referencedTypeName = (String)cArray.get(0);
            String referencedName = (String)cArray.get(1);
            if (ResourceType.fromXmlValue((String)referencedTypeName) == null) {
                return value;
            }
            ResourceFoldingBuilder resourceFoldingBuilder = this_;
            ResourceRepository resourceRepository = $this$getResourceValue;
            FolderConfiguration folderConfiguration = referenceConfig;
            ResourceFoldingBuilder this_ = resourceFoldingBuilder;
            $this$getResourceValue = resourceRepository;
            type = referencedType;
            name = referencedName;
            referenceConfig = folderConfiguration;
        }
    }

    private final String formatArguments(UCallExpression callExpression, String formatString) {
        if (!StringsKt.contains$default((CharSequence)formatString, (char)'%', (boolean)false, (int)2, null)) {
            return formatString;
        }
        List args = callExpression.getValueArguments();
        if (args.isEmpty() || !((UExpression)CollectionsKt.first((List)args)).isPsiValid()) {
            return formatString;
        }
        if (args.size() >= 3 && Intrinsics.areEqual((Object)"getQuantityString", (Object)callExpression.getMethodName())) {
            args = args.subList(1, args.size());
        }
        Matcher matcher = FORMAT.matcher(formatString);
        int index = 0;
        int prevIndex = 0;
        int nextNumber = 1;
        int start = 0;
        StringBuilder sb = new StringBuilder(2 * formatString.length());
        while (matcher.find(index)) {
            if (Intrinsics.areEqual((Object)"%", (Object)matcher.group(6))) {
                index = matcher.end();
                continue;
            }
            int matchStart = matcher.start();
            while (prevIndex < matchStart) {
                char c = formatString.charAt(prevIndex);
                if (c == '\\') {
                    ++prevIndex;
                }
                ++prevIndex;
            }
            if (prevIndex > matchStart) {
                index = prevIndex;
                continue;
            }
            index = matcher.end();
            int number = 0;
            String numberString = matcher.group(1);
            if (numberString != null) {
                String string = numberString.substring(0, numberString.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                numberString = string;
                number = Integer.parseInt(numberString);
                nextNumber = number + 1;
            } else {
                number = nextNumber++;
            }
            if (number <= 0 || number >= args.size()) continue;
            UExpression argExpression = (UExpression)args.get(number);
            Object value = argExpression.evaluate();
            if (value == null) {
                value = ((UExpression)args.get(number)).asSourceString();
            }
            for (int i = start; i < matchStart; ++i) {
                sb.append(formatString.charAt(i));
            }
            sb.append("{");
            sb.append(value);
            sb.append('}');
            start = index;
        }
        int n = formatString.length();
        for (int i = start; i < n; ++i) {
            sb.append(formatString.charAt(i));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final String getPlaceholderText$unwrapReferenceAndGetValue(UElement $this$getPlaceholderText_u24unwrapReferenceAndGetValue, ResourceFoldingBuilder this$0, LocalResourceRepository resources) {
        String string;
        Object object;
        UElement uElement;
        while ((uElement = $this$getPlaceholderText_u24unwrapReferenceAndGetValue) instanceof UQualifiedReferenceExpression) {
            UExpression uExpression = ((UQualifiedReferenceExpression)$this$getPlaceholderText_u24unwrapReferenceAndGetValue).getSelector();
            object = resources;
            $this$getPlaceholderText_u24unwrapReferenceAndGetValue = (UElement)uExpression;
            resources = object;
        }
        if (uElement instanceof UCallExpression) {
            object = CollectionsKt.firstOrNull((List)((UCallExpression)$this$getPlaceholderText_u24unwrapReferenceAndGetValue).getValueArguments());
            UReferenceExpression uReferenceExpression = object instanceof UReferenceExpression ? (UReferenceExpression)object : null;
            string = uReferenceExpression != null ? this$0.getAndroidResourceValue(uReferenceExpression, resources, (UCallExpression)$this$getPlaceholderText_u24unwrapReferenceAndGetValue) : null;
        } else {
            UReferenceExpression uReferenceExpression = $this$getPlaceholderText_u24unwrapReferenceAndGetValue instanceof UReferenceExpression ? (UReferenceExpression)$this$getPlaceholderText_u24unwrapReferenceAndGetValue : null;
            string = uReferenceExpression != null ? ResourceFoldingBuilder.getAndroidResourceValue$default(this$0, uReferenceExpression, resources, null, 2, null) : null;
        }
        return string;
    }

    private static final FoldingDescriptor getFoldingDescriptor$createFoldingDescriptor(UElement $this$getFoldingDescriptor_u24createFoldingDescriptor) {
        FoldingDescriptor foldingDescriptor;
        PsiElement psiElement = $this$getFoldingDescriptor_u24createFoldingDescriptor.getPsi();
        if (psiElement != null) {
            PsiElement psi = psiElement;
            boolean bl = false;
            Set dependencies = SetsKt.setOf((Object)psi);
            foldingDescriptor = new FoldingDescriptor(psi.getNode(), psi.getTextRange(), null, dependencies);
        } else {
            foldingDescriptor = null;
        }
        return foldingDescriptor;
    }

    public static final /* synthetic */ FoldingDescriptor access$getFoldingDescriptor(ResourceFoldingBuilder $this, UReferenceExpression $receiver) {
        return $this.getFoldingDescriptor($receiver);
    }

    static {
        Object[] objectArray = new ResourceType[]{ResourceType.STRING, ResourceType.DIMEN, ResourceType.INTEGER, ResourceType.PLURALS};
        RESOURCE_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/folding/ResourceFoldingBuilder$Companion;", "", "()V", "FOLD_MAX_LENGTH", "", "FORMAT", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "RESOURCE_TYPES", "", "Lcom/android/resources/ResourceType;", "UNIT_TEST_MODE", "", "intellij.android.kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

