/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.handlers;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002JF\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "firstEnterPosition", "", "Ljava/lang/Integer;", "isEnabled", "", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Companion", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownTableEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownTableEnterHandler.kt\norg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,73:1\n7#2,6:74\n7#2,6:80\n*S KotlinDebug\n*F\n+ 1 MarkdownTableEnterHandler.kt\norg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler\n*L\n50#1:74,6\n58#1:80,6\n*E\n"})
public final class MarkdownTableEnterHandler
extends EnterHandlerDelegateAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Integer firstEnterPosition;
    @NotNull
    private static final String insertTag = "<br/>";

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Integer cellIndex;
        MarkdownTableCell cell;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!this.isEnabled()) {
            EnterHandlerDelegate.Result result2 = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result2;
        }
        Integer enterPosition = this.firstEnterPosition;
        this.firstEnterPosition = null;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        int actualCaretOffset = editor2.getCaretModel().getCurrentCaret().getOffset();
        if (!TableUtils.isProbablyInsideTableCell(document2, actualCaretOffset)) {
            EnterHandlerDelegate.Result result3 = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result3;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
        MarkdownTableCell markdownTableCell = cell = TableUtils.findCell(file, actualCaretOffset);
        MarkdownTable table = markdownTableCell != null ? markdownTableCell.getParentTable() : null;
        MarkdownTableCell markdownTableCell2 = cell;
        Integer n = cellIndex = markdownTableCell2 != null ? Integer.valueOf(markdownTableCell2.getColumnIndex()) : null;
        if (cell == null || table == null || cellIndex == null) {
            EnterHandlerDelegate.Result result4 = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result4;
        }
        Integer n2 = enterPosition;
        if (n2 != null && actualCaretOffset == n2) {
            int start = actualCaretOffset - 5;
            int end = actualCaretOffset;
            if (actualCaretOffset > 5 && Intrinsics.areEqual((Object)document2.getText(new TextRange(start, end)), (Object)insertTag)) {
                Project project$iv = null;
                String name$iv = null;
                Object groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(document2, start, end){
                    final /* synthetic */ Document $document$inlined;
                    final /* synthetic */ int $start$inlined;
                    final /* synthetic */ int $end$inlined;
                    {
                        this.$document$inlined = document;
                        this.$start$inlined = n;
                        this.$end$inlined = n2;
                    }

                    public final void run() {
                        boolean bl = false;
                        this.$document$inlined.deleteString(this.$start$inlined, this.$end$inlined);
                    }
                }, name$iv, groupId$iv);
                caretOffset.set((Object)start);
            }
            EnterHandlerDelegate.Result result5 = super.preprocessEnter(file, editor2, caretOffset, caretAdvance, dataContext, originalHandler);
            Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"super.preprocessEnter(fi\u2026Context, originalHandler)");
            return result5;
        }
        caretAdvance.set((Object)5);
        Project project$iv = null;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(editor2){
            final /* synthetic */ Editor $editor$inlined;
            {
                this.$editor$inlined = editor2;
            }

            public final void run() {
                boolean bl = false;
                EditorModificationUtil.insertStringAtCaret((Editor)this.$editor$inlined, (String)"<br/>");
            }
        }, name$iv, groupId$iv);
        this.firstEnterPosition = actualCaretOffset + 5;
        return EnterHandlerDelegate.Result.Stop;
    }

    private final boolean isEnabled() {
        return MarkdownCodeInsightSettings.Companion.getInstance().getState().getInsertHtmlLineBreakInsideTables();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/handlers/MarkdownTableEnterHandler$Companion;", "", "()V", "insertTag", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

