/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionFormat;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.intellij.plugins.markdown.fileActions.export.MarkdownHtmlExportProvider;
import org.intellij.plugins.markdown.fileActions.export.MarkdownHtmlExportSettings;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownFileEditorUtils;
import org.intellij.plugins.markdown.fileActions.utils.MarkdownImportExportUtils;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlExporter;
import org.intellij.plugins.markdown.ui.preview.jcef.HtmlResourceSavingSettings;
import org.intellij.plugins.markdown.ui.preview.jcef.MarkdownJCEFHtmlPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u001c\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J8\u0010\u001d\u001a\u00020\f*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020$0#H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "()V", "formatDescription", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormatDescription", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "resourceDirField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "saveImagesCheckbox", "Ljavax/swing/JCheckBox;", "addSettingsListeners", "", "project", "Lcom/intellij/openapi/project/Project;", "createResourceDirField", "suggestedTargetFile", "Ljava/io/File;", "exportFile", "mdFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "outputFile", "", "saveSettings", "validate", "file", "createSettingsComponent", "Lcom/intellij/ui/dsl/builder/RowsRange;", "Lcom/intellij/ui/dsl/builder/Panel;", "saveHtml", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "path", "resDirPath", "Lorg/intellij/plugins/markdown/ui/preview/jcef/HtmlResourceSavingSettings;", "resultCallback", "Ljava/util/function/BiConsumer;", "", "Companion", "SaveSettingsListener", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownHtmlExportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownHtmlExportProvider.kt\norg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,163:1\n43#2,3:164\n43#2,3:167\n*S KotlinDebug\n*F\n+ 1 MarkdownHtmlExportProvider.kt\norg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider\n*L\n51#1:164,3\n123#1:167,3\n*E\n"})
public final class MarkdownHtmlExportProvider
implements MarkdownExportProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private JCheckBox saveImagesCheckbox;
    private TextFieldWithHistoryWithBrowseButton resourceDirField;
    @NotNull
    private static final String IMAGE_DIR_RESENT_KEYS = "ImportExportFile.ImageDir.RECENT_KEYS";
    @NotNull
    private static final MarkdownFileActionFormat format = new MarkdownFileActionFormat("HTML", "html");

    @Override
    @NotNull
    public MarkdownFileActionFormat getFormatDescription() {
        return format;
    }

    @Override
    public void exportFile(@NotNull Project project, @NotNull VirtualFile mdFile, @NotNull String outputFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mdFile, (String)"mdFile");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        this.saveSettings(project);
        MarkdownPreviewFileEditor markdownPreviewFileEditor = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, mdFile, true);
        if (markdownPreviewFileEditor == null) {
            return;
        }
        MarkdownPreviewFileEditor preview = markdownPreviewFileEditor;
        Object object = (WeakReference)preview.getUserData(MarkdownPreviewFileEditor.PREVIEW_BROWSER);
        if (object == null || (object = (MarkdownHtmlPanel)((Reference)object).get()) == null) {
            return;
        }
        Object htmlPanel = object;
        if (htmlPanel instanceof MarkdownJCEFHtmlPanel) {
            boolean $i$f$service = false;
            Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            this.saveHtml((MarkdownJCEFHtmlPanel)htmlPanel, outputFile, ((MarkdownHtmlExportSettings)object2).getResourceSavingSettings(), project, (arg_0, arg_1) -> MarkdownHtmlExportProvider.exportFile$lambda$0(project, arg_0, arg_1));
        }
    }

    @Override
    @Nullable
    public String validate(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MarkdownPreviewFileEditor preview = MarkdownFileEditorUtils.findMarkdownPreviewEditor(project, file, true);
        if (preview == null || !MarkdownImportExportUtils.INSTANCE.isJCEFPanelOpen(preview)) {
            Object[] objectArray = new Object[]{this.getFormatDescription().getFormatName()};
            return MarkdownBundle.message("markdown.export.validation.failure.msg", objectArray);
        }
        return null;
    }

    @Override
    @NotNull
    public RowsRange createSettingsComponent(@NotNull Panel $this$createSettingsComponent, @NotNull Project project, @NotNull File suggestedTargetFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createSettingsComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestedTargetFile, (String)"suggestedTargetFile");
        this.createResourceDirField(project, suggestedTargetFile);
        return $this$createSettingsComponent.rowsRange((Function1)new Function1<Panel, Unit>(this, project){
            final /* synthetic */ MarkdownHtmlExportProvider this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$rowsRange) {
                Intrinsics.checkNotNullParameter((Object)$this$rowsRange, (String)"$this$rowsRange");
                Panel.row$default((Panel)$this$rowsRange, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, this.$project){
                    final /* synthetic */ MarkdownHtmlExportProvider this$0;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = MarkdownBundle.message("markdown.export.to.html.save.images.checkbox", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.export\u2026ml.save.images.checkbox\")");
                        MarkdownHtmlExportProvider.access$setSaveImagesCheckbox$p(this.this$0, (JCheckBox)$this$row.checkBox(string).onChanged((Function1)new Function1<JBCheckBox, Unit>(this.this$0, this.$project){
                            final /* synthetic */ MarkdownHtmlExportProvider this$0;
                            final /* synthetic */ Project $project;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                super(1);
                            }

                            public final void invoke(@NotNull JBCheckBox it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                MarkdownHtmlExportProvider.access$saveSettings(this.this$0, this.$project);
                            }
                        }).gap(RightGap.SMALL).applyToComponent((Function1)createSettingsComponent.2.INSTANCE).getComponent());
                        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = MarkdownHtmlExportProvider.access$getResourceDirField$p(this.this$0);
                        if (textFieldWithHistoryWithBrowseButton == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceDirField");
                            textFieldWithHistoryWithBrowseButton = null;
                        }
                        Cell cell = $this$row.cell((JComponent)textFieldWithHistoryWithBrowseButton).align((Align)AlignX.FILL.INSTANCE).validationOnApply((Function2)createSettingsComponent.3.INSTANCE).focused();
                        JCheckBox jCheckBox = MarkdownHtmlExportProvider.access$getSaveImagesCheckbox$p(this.this$0);
                        if (jCheckBox == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
                            jCheckBox = null;
                        }
                        cell.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)jCheckBox));
                        MarkdownHtmlExportProvider.access$addSettingsListeners(this.this$0, this.$project);
                    }
                }), (int)1, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void createResourceDirField(Project project, File suggestedTargetFile) {
        void $this$createResourceDirField_u24lambda_u241;
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton;
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        MarkdownHtmlExportProvider markdownHtmlExportProvider = this;
        boolean bl = false;
        $this$createResourceDirField_u24lambda_u241.setTextFieldPreferredWidth(70);
        List resDirRecent = RecentsManager.getInstance((Project)project).getRecentEntries(IMAGE_DIR_RESENT_KEYS);
        if (resDirRecent != null) {
            ((TextFieldWithHistory)$this$createResourceDirField_u24lambda_u241.getChildComponent()).setHistory(resDirRecent);
        }
        String[] stringArray = new String[]{suggestedTargetFile.getParent(), FilesKt.getNameWithoutExtension((File)suggestedTargetFile)};
        ((TextFieldWithHistory)$this$createResourceDirField_u24lambda_u241.getChildComponent()).setText(FileUtil.join((String[])stringArray));
        $this$createResourceDirField_u24lambda_u241.addBrowseFolderListener(MarkdownBundle.message("markdown.import.export.dialog.target.directory", new Object[0]), MarkdownBundle.message("markdown.import.export.dialog.target.directory.description", new Object[0]), project, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        markdownHtmlExportProvider.resourceDirField = textFieldWithHistoryWithBrowseButton;
    }

    private final void addSettingsListeners(Project project) {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = this.resourceDirField;
        if (textFieldWithHistoryWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceDirField");
            textFieldWithHistoryWithBrowseButton = null;
        }
        ((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).getTextEditor().addFocusListener(new SaveSettingsListener(project));
    }

    private final void saveSettings(Project project) {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = this.resourceDirField;
        if (textFieldWithHistoryWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceDirField");
            textFieldWithHistoryWithBrowseButton = null;
        }
        String imageDir = ((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).getText();
        boolean $i$f$service = false;
        Class<MarkdownHtmlExportSettings> serviceClass$iv = MarkdownHtmlExportSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        MarkdownHtmlExportSettings exportSettings = (MarkdownHtmlExportSettings)object;
        JCheckBox jCheckBox = this.saveImagesCheckbox;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
            jCheckBox = null;
        }
        exportSettings.setSaveResources(jCheckBox.isSelected());
        Intrinsics.checkNotNullExpressionValue((Object)imageDir, (String)"imageDir");
        exportSettings.setResourceDirectory(imageDir);
        RecentsManager.getInstance((Project)project).registerRecentEntry(IMAGE_DIR_RESENT_KEYS, imageDir);
    }

    private final void saveHtml(MarkdownJCEFHtmlPanel $this$saveHtml, String path, HtmlResourceSavingSettings resDirPath, Project project, BiConsumer<String, Boolean> resultCallback) {
        $this$saveHtml.getCefBrowser().getSource(arg_0 -> MarkdownHtmlExportProvider.saveHtml$lambda$2(path, resDirPath, project, resultCallback, arg_0));
    }

    private static final void exportFile$lambda$0(Project $project, String path, Boolean ok) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ok, (String)"ok");
        if (ok.booleanValue()) {
            MarkdownImportExportUtils.INSTANCE.notifyAndRefreshIfExportSuccess(new File(path), $project);
        } else {
            Object[] objectArray = new Object[]{new File(path).getName()};
            String string = MarkdownBundle.message("markdown.export.failure.msg", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.export\u2026re.msg\", File(path).name)");
            MarkdownNotifications.showError$default(MarkdownNotifications.INSTANCE, $project, "markdown.export.failed", null, string, 4, null);
        }
    }

    private static final void saveHtml$lambda$2(String $path, HtmlResourceSavingSettings $resDirPath, Project $project, BiConsumer $resultCallback, String source) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$resDirPath, (String)"$resDirPath");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$resultCallback, (String)"$resultCallback");
        try {
            File file = new File($path);
            Intrinsics.checkNotNullExpressionValue((Object)source, (String)"source");
            new HtmlExporter(source, $resDirPath, $project, file).export();
            $resultCallback.accept($path, true);
        }
        catch (Exception e) {
            $resultCallback.accept($path, false);
        }
    }

    @NotNull
    public static final MarkdownFileActionFormat getFormat() {
        return Companion.getFormat();
    }

    public static final /* synthetic */ void access$setSaveImagesCheckbox$p(MarkdownHtmlExportProvider $this, JCheckBox jCheckBox) {
        $this.saveImagesCheckbox = jCheckBox;
    }

    public static final /* synthetic */ TextFieldWithHistoryWithBrowseButton access$getResourceDirField$p(MarkdownHtmlExportProvider $this) {
        return $this.resourceDirField;
    }

    public static final /* synthetic */ void access$addSettingsListeners(MarkdownHtmlExportProvider $this, Project project) {
        $this.addSettingsListeners(project);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$Companion;", "", "()V", "IMAGE_DIR_RESENT_KEYS", "", "Lorg/jetbrains/annotations/NonNls;", "format", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "getFormat$annotations", "getFormat", "()Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionFormat;", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarkdownFileActionFormat getFormat() {
            return format;
        }

        @JvmStatic
        public static /* synthetic */ void getFormat$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider$SaveSettingsListener;", "Ljava/awt/event/FocusListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/intellij/plugins/markdown/fileActions/export/MarkdownHtmlExportProvider;Lcom/intellij/openapi/project/Project;)V", "focusGained", "", "e", "Ljava/awt/event/FocusEvent;", "focusLost", "intellij.markdown.core"})
    private final class SaveSettingsListener
    implements FocusListener {
        @NotNull
        private final Project project;

        public SaveSettingsListener(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @Override
        public void focusGained(@Nullable FocusEvent e) {
        }

        @Override
        public void focusLost(@Nullable FocusEvent e) {
            FocusEvent focusEvent = e;
            Component component = focusEvent != null ? focusEvent.getComponent() : null;
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JTextField");
            JTextField textEditor = (JTextField)component;
            JCheckBox jCheckBox = MarkdownHtmlExportProvider.this.saveImagesCheckbox;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"saveImagesCheckbox");
                jCheckBox = null;
            }
            if (jCheckBox.isSelected()) {
                String string = textEditor.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textEditor.text");
                if (((CharSequence)string).length() > 0) {
                    MarkdownHtmlExportProvider.this.saveSettings(this.project);
                }
            }
        }
    }
}

