/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.googleDocs;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.drive.Drive;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.PathKt;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.importFrom.googleDocs.GoogleDocsFileLoader;
import org.intellij.plugins.markdown.fileActions.utils.GoogleCommonUtils;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\u0014\u0010\n\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsFileLoader;", "", "()V", "downloadFileFromDrive", "Lcom/intellij/openapi/vfs/VirtualFile;", "driveFiles", "Lcom/google/api/services/drive/Drive$Files;", "Lcom/google/api/services/drive/Drive;", "docsId", "", "getAllFilesFromDrive", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "handleResponseExceptions", "", "e", "Lcom/google/api/client/googleapis/json/GoogleJsonResponseException;", "project", "Lcom/intellij/openapi/project/Project;", "loadFileFromGoogleDisk", "moveContentFromTempFile", "Ljava/io/File;", "tempFile", "fileName", "Companion", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nGoogleDocsFileLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleDocsFileLoader.kt\norg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsFileLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n1#2:114\n10#3:115\n*S KotlinDebug\n*F\n+ 1 GoogleDocsFileLoader.kt\norg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsFileLoader\n*L\n110#1:115\n*E\n"})
public final class GoogleDocsFileLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String mimeType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final VirtualFile loadFileFromGoogleDisk(@NotNull Project project, @NotNull Credential credential, @NotNull String docsId) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)docsId, (String)"docsId");
        try {
            virtualFile = (VirtualFile)GoogleCommonUtils.INSTANCE.runProcessWithGoogleCredentials(project, credential, (Function1)new Function1<Credential, VirtualFile>(project, this, credential, docsId){
                final /* synthetic */ Project $project;
                final /* synthetic */ GoogleDocsFileLoader this$0;
                final /* synthetic */ Credential $credential;
                final /* synthetic */ String $docsId;
                {
                    this.$project = $project;
                    this.this$0 = $receiver;
                    this.$credential = $credential;
                    this.$docsId = $docsId;
                    super(1);
                }

                public final VirtualFile invoke(@NotNull Credential it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (VirtualFile)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> loadFileFromGoogleDisk.1.invoke$lambda$0(this.this$0, this.$credential, this.$docsId), MarkdownBundle.message("markdown.google.load.file.progress.title", new Object[0]), true, this.$project);
                }

                private static final VirtualFile invoke$lambda$0(GoogleDocsFileLoader this$0, Credential $credential, String $docsId) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$credential, (String)"$credential");
                    Intrinsics.checkNotNullParameter((Object)$docsId, (String)"$docsId");
                    Drive.Files driveFiles = GoogleDocsFileLoader.access$getAllFilesFromDrive(this$0, $credential);
                    return GoogleDocsFileLoader.access$downloadFileFromDrive(this$0, driveFiles, $docsId);
                }
            });
        }
        catch (GoogleJsonResponseException e) {
            this.handleResponseExceptions(e, project);
            virtualFile = null;
        }
        return virtualFile;
    }

    @RequiresBackgroundThread
    private final Drive.Files getAllFilesFromDrive(Credential credential) {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        Drive.Files files2 = new Drive.Builder(httpTransport, GoogleDocsFileLoader.Companion.getJsonFactory(), credential).build().files();
        Intrinsics.checkNotNullExpressionValue((Object)files2, (String)"Builder(httpTransport, j\u2026  .build()\n      .files()");
        return files2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    private final VirtualFile downloadFileFromDrive(Drive.Files driveFiles, String docsId) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Drive.Files $this$downloadFileFromDrive_u24lambda_u240 = driveFiles;
        boolean bl = false;
        $this$downloadFileFromDrive_u24lambda_u240.export(docsId, mimeType).executeAndDownloadTo(outputStream);
        String fileName = ((com.google.api.services.drive.model.File)$this$downloadFileFromDrive_u24lambda_u240.get(docsId).setFields("id, name").execute()).getName();
        File $this$downloadFileFromDrive_u24lambda_u242 = bl = File.createTempFile(fileName, ".docx");
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$downloadFileFromDrive_u24lambda_u242, (String)"downloadFileFromDrive$lambda$2");
        Closeable closeable = new FileOutputStream($this$downloadFileFromDrive_u24lambda_u242);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl3 = false;
            outputStream.writeTo(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File tempFile = bl;
        Intrinsics.checkNotNullExpressionValue((Object)tempFile, (String)"tempFile");
        Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
        File renamedFile = this.moveContentFromTempFile(tempFile, fileName);
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)renamedFile, (boolean)true);
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    private final File moveContentFromTempFile(File tempFile, String fileName) {
        try {
            Path targetFilePath = new File(tempFile.getParent(), fileName + ".docx").toPath();
            Object object = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
            Object $this$moveContentFromTempFile_u24lambda_u243 = object = Files.move(tempFile.toPath(), targetFilePath, (CopyOption[])object);
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$moveContentFromTempFile_u24lambda_u243, (String)"moveContentFromTempFile$lambda$3");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists((Path)$this$moveContentFromTempFile_u24lambda_u243, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                PathKt.createFile((Path)$this$moveContentFromTempFile_u24lambda_u243);
            }
            File file = object.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"move(tempFile.toPath(), \u2026File()\n        }.toFile()");
            return file;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return tempFile;
        }
    }

    private final void handleResponseExceptions(GoogleJsonResponseException e, Project project) {
        if (e.getStatusCode() == 404) {
            Object[] objectArray = MarkdownNotifications.INSTANCE;
            String string = MarkdownBundle.message("markdown.google.file.download.error.msg", new Object[0]);
            String string2 = MarkdownBundle.message("markdown.google.file.download.error.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"markdown.google\u2026le.download.error.title\")");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"markdown.google.file.download.error.msg\")");
            objectArray.showError(project, "markdown.export.failed", string2, string);
            objectArray = new Object[]{MarkdownBundle.message("markdown.google.file.download.error.msg", new Object[0])};
            LOG.debug(MarkdownBundle.message("markdown.google.file.download.error.title", new Object[0]), objectArray);
        } else {
            LOG.info(e.getLocalizedMessage());
        }
    }

    public static final /* synthetic */ Drive.Files access$getAllFilesFromDrive(GoogleDocsFileLoader $this, Credential credential) {
        return $this.getAllFilesFromDrive(credential);
    }

    public static final /* synthetic */ VirtualFile access$downloadFileFromDrive(GoogleDocsFileLoader $this, Drive.Files driveFiles, String docsId) {
        return $this.downloadFileFromDrive(driveFiles, docsId);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GoogleDocsFileLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsFileLoader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "jsonFactory", "Lcom/google/api/client/json/JsonFactory;", "getJsonFactory", "()Lcom/google/api/client/json/JsonFactory;", "mimeType", "", "intellij.markdown.core"})
    public static final class Companion {
        private Companion() {
        }

        private final JsonFactory getJsonFactory() {
            GsonFactory gsonFactory = GsonFactory.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)gsonFactory, (String)"getDefaultInstance()");
            return gsonFactory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

