/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.google.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountManager;
import org.intellij.plugins.markdown.google.accounts.GoogleAccountsListModel;
import org.intellij.plugins.markdown.google.utils.GoogleAccountsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/google/ui/GoogleChooseAccountDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "accountsListModel", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;", "accountManager", "Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;", "(Lcom/intellij/openapi/project/Project;Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountsListModel;Lorg/intellij/plugins/markdown/google/accounts/GoogleAccountManager;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nGoogleChooseAccountDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleChooseAccountDialog.kt\norg/intellij/plugins/markdown/google/ui/GoogleChooseAccountDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public final class GoogleChooseAccountDialog
extends DialogWrapper {
    @NotNull
    private final GoogleAccountsListModel accountsListModel;
    @NotNull
    private final GoogleAccountManager accountManager;

    public GoogleChooseAccountDialog(@NotNull Project project, @NotNull GoogleAccountsListModel accountsListModel, @NotNull GoogleAccountManager accountManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)accountsListModel), (String)"accountsListModel");
        Intrinsics.checkNotNullParameter((Object)((Object)accountManager), (String)"accountManager");
        super(project, false);
        this.accountsListModel = accountsListModel;
        this.accountManager = accountManager;
        this.setTitle(MarkdownBundle.message("markdown.google.accounts.dialog.title", new Object[0]));
        this.setOKButtonText(MarkdownBundle.message("markdown.google.accounts.dialog.ok.button", new Object[0]));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"disposable");
        DialogPanel it = dialogPanel = GoogleAccountsUtils.INSTANCE.createGoogleAccountPanel(disposable, this.accountsListModel, this.accountManager);
        boolean bl = false;
        it.reset();
        DialogPanel $this$createCenterPanel_u24lambda_u241 = dialogPanel;
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u241.setPreferredSize(new Dimension(650, 250));
        return (JComponent)dialogPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.accountsListModel.getSelectedAccount() == null ? new ValidationInfo(MarkdownBundle.message("markdown.google.accounts.choose.dialog.account.must.be.selected", new Object[0])) : null;
    }
}

