/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtils;
import org.intellij.plugins.markdown.lang.formatter.TablePostFormatProcessor$processText$;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/TablePostFormatProcessor;", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessor;", "()V", "obtainDocument", "Lcom/intellij/openapi/editor/Document;", "element", "Lcom/intellij/psi/PsiElement;", "processElement", "source", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "processTable", "", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "document", "processText", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "shouldReformat", "", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nTablePostFormatProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TablePostFormatProcessor.kt\norg/intellij/plugins/markdown/lang/formatter/TablePostFormatProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,64:1\n473#2:65\n*S KotlinDebug\n*F\n+ 1 TablePostFormatProcessor.kt\norg/intellij/plugins/markdown/lang/formatter/TablePostFormatProcessor\n*L\n37#1:65\n*E\n"})
public final class TablePostFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Language language = source.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"source.language");
        if (!(MarkdownLanguageUtils.INSTANCE.isMarkdownLanguage(language) && source instanceof MarkdownTable && this.shouldReformat(settings))) {
            return source;
        }
        Document document = this.obtainDocument(source);
        if (document == null) {
            return source;
        }
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)((MarkdownTable)source).getProject()).commitDocument(document2);
        this.processTable((MarkdownTable)source, document2);
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        Sequence elements2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (!(source instanceof MarkdownFile) || !this.shouldReformat(settings)) {
            return rangeToReformat;
        }
        Document document = this.obtainDocument((PsiElement)source);
        if (document == null) {
            return rangeToReformat;
        }
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)((MarkdownFile)source).getProject()).commitDocument(document2);
        PsiElement psiElement = ((MarkdownFile)source).getLastChild();
        Sequence sequence = psiElement != null ? PsiTreeUtilKt.siblings((PsiElement)psiElement, (boolean)false, (boolean)true) : null;
        if (sequence == null) {
            sequence = SequencesKt.emptySequence();
        }
        Sequence $this$filterIsInstance$iv = elements2 = sequence;
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)processText$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence tables = sequence2;
        for (MarkdownTable table : tables) {
            if (!rangeToReformat.intersects(table.getTextRange())) continue;
            this.processTable(table, document2);
            PsiDocumentManager.getInstance((Project)((MarkdownFile)source).getProject()).commitDocument(document2);
        }
        TextRange textRange = ((MarkdownFile)source).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"source.textRange");
        return textRange;
    }

    private final boolean shouldReformat(CodeStyleSettings settings) {
        CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(MarkdownCustomCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"settings.getCustomSettin\u2026tyleSettings::class.java)");
        MarkdownCustomCodeStyleSettings custom = (MarkdownCustomCodeStyleSettings)customCodeStyleSettings;
        return custom.FORMAT_TABLES;
    }

    private final void processTable(MarkdownTable table, Document document) {
        TableFormattingUtils.reformatAllColumns$default(TableFormattingUtils.INSTANCE, table, document, true, false, 8, null);
    }

    private final Document obtainDocument(PsiElement element2) {
        FileViewProvider viewProvider;
        Object object;
        if (element2 instanceof PsiFile) {
            object = ((PsiFile)element2).getViewProvider();
        } else {
            PsiFile psiFile = element2.getContainingFile();
            object = psiFile != null ? psiFile.getViewProvider() : null;
        }
        FileViewProvider fileViewProvider = viewProvider = object;
        return fileViewProvider != null ? fileViewProvider.getDocument() : null;
    }
}

