/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.converters.MavenConsumerPomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDomSoftAwareConverter;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;
import org.jetbrains.idea.maven.dom.model.MavenDomExtension;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenArtifactUtilKt;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.reposearch.DependencySearchService;

public abstract class MavenArtifactCoordinatesConverter
extends ResolvingConverter<String>
implements MavenDomSoftAwareConverter {
    public String fromString(@Nullable @NonNls String s, ConvertContext context2) {
        if (s == null) {
            return null;
        }
        MavenId id = MavenArtifactCoordinatesHelper.getId(context2);
        Project contextProject = context2.getProject();
        MavenIndicesManager manager = MavenIndicesManager.getInstance(contextProject);
        ConverterStrategy strategy = this.selectStrategy(context2);
        boolean isValid = strategy.isValid(id, manager, context2);
        if (!isValid) {
            MavenIndex localIndex = manager.getIndex().getLocalIndex();
            if (localIndex == null) {
                return null;
            }
            Path artifactPath = MavenUtil.getArtifactPath(Path.of(localIndex.getRepositoryPathOrUrl(), new String[0]), id, "pom", null);
            if (artifactPath != null && artifactPath.toFile().exists()) {
                MavenIndicesManager.getInstance(contextProject).scheduleArtifactIndexing(id, artifactPath.toFile());
                return s;
            }
            return null;
        }
        return s;
    }

    protected abstract boolean doIsValid(MavenId var1, MavenIndicesManager var2, ConvertContext var3);

    public String toString(@Nullable String s, ConvertContext context2) {
        return s;
    }

    @NotNull
    public Collection<String> getVariants(ConvertContext context2) {
        DependencySearchService searchService = DependencySearchService.getInstance((Project)context2.getProject());
        MavenId id = MavenArtifactCoordinatesHelper.getId(context2);
        MavenDomShortArtifactCoordinates coordinates = MavenArtifactCoordinatesHelper.getCoordinates(context2);
        Set<String> set = this.selectStrategy(context2).getVariants(id, searchService, coordinates);
        if (set == null) {
            MavenArtifactCoordinatesConverter.$$$reportNull$$$0(0);
        }
        return set;
    }

    protected abstract Set<String> doGetVariants(MavenId var1, DependencySearchService var2);

    public PsiElement resolve(String o, ConvertContext context2) {
        MavenId id = MavenArtifactCoordinatesHelper.getId(context2);
        PsiFile result2 = this.selectStrategy(context2).resolve(id, context2);
        return result2 != null ? result2 : super.resolve((Object)o, context2);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context2) {
        return this.selectStrategy(context2).getErrorMessage(s, context2);
    }

    @Override
    public boolean isSoft(@NotNull DomElement element) {
        DomElement pluginsElement;
        DomElement dependencies;
        DomElement dependencyOrPluginElement;
        if (element == null) {
            MavenArtifactCoordinatesConverter.$$$reportNull$$$0(1);
        }
        return (dependencyOrPluginElement = element.getParent()) instanceof MavenDomDependency ? (dependencies = dependencyOrPluginElement.getParent()) instanceof MavenDomDependencies && dependencies.getParent() instanceof MavenDomDependencyManagement : dependencyOrPluginElement instanceof MavenDomPlugin && (pluginsElement = dependencyOrPluginElement.getParent()) instanceof MavenDomPlugins && pluginsElement.getParent() instanceof MavenDomPluginManagement;
    }

    @Nullable
    protected VirtualFile getMavenProjectFile(ConvertContext context2) {
        PsiFile psiFile = context2.getFile().getOriginalFile();
        return psiFile.getVirtualFile();
    }

    private ConverterStrategy selectStrategy(ConvertContext context2) {
        DomElement parent = context2.getInvocationElement().getParent();
        if (parent instanceof MavenDomProjectModel) {
            return new ProjectStrategy();
        }
        if (parent instanceof MavenDomParent) {
            return new ParentStrategy((MavenDomParent)parent);
        }
        if (parent instanceof MavenDomDependency) {
            return new DependencyStrategy((MavenDomDependency)parent);
        }
        if (parent instanceof MavenDomExclusion) {
            return new ExclusionStrategy();
        }
        if (parent instanceof MavenDomPlugin) {
            return new PluginOrExtensionStrategy(true);
        }
        if (parent instanceof MavenDomExtension) {
            return new PluginOrExtensionStrategy(false);
        }
        return new ConverterStrategy();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSoft";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class ConverterStrategy {
        private ConverterStrategy() {
        }

        @Nls
        public String getErrorMessage(@Nullable String s, ConvertContext context2) {
            return MavenDomBundle.message("artifact.0.not.found", MavenArtifactCoordinatesHelper.getId(context2));
        }

        public boolean isValid(MavenId id, MavenIndicesManager manager, ConvertContext context2) {
            return MavenArtifactCoordinatesConverter.this.doIsValid(id, manager, context2) || this.resolveBySpecifiedPath() != null;
        }

        public Set<String> getVariants(MavenId id, DependencySearchService searchService, MavenDomShortArtifactCoordinates coordinates) {
            return MavenArtifactCoordinatesConverter.this.doGetVariants(id, searchService);
        }

        public PsiFile resolve(MavenId id, ConvertContext context2) {
            PsiManager psiManager = context2.getPsiManager();
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(psiManager.getProject());
            PsiFile result2 = this.resolveBySpecifiedPath();
            if (result2 != null) {
                return result2;
            }
            result2 = this.resolveInProjects(id, projectsManager, context2);
            if (result2 != null) {
                return result2;
            }
            return this.resolveInLocalRepository(id, projectsManager, psiManager);
        }

        @Nullable
        protected PsiFile resolveBySpecifiedPath() {
            return null;
        }

        private PsiFile resolveInProjects(MavenId id, MavenProjectsManager projectsManager, ConvertContext context2) {
            MavenProject project2 = this.resolveMavenProject(id, projectsManager, context2);
            return project2 == null ? null : context2.getPsiManager().findFile(project2.getFile());
        }

        private MavenProject resolveMavenProject(MavenId id, MavenProjectsManager projectsManager, ConvertContext context2) {
            if (MavenConsumerPomUtil.isAutomaticVersionFeatureEnabled(context2)) {
                return projectsManager.findSingleProjectInReactor(id);
            }
            return projectsManager.findProject(id);
        }

        private PsiFile resolveInLocalRepository(MavenId id, MavenProjectsManager projectsManager, PsiManager psiManager) {
            File file = MavenUtil.getRepositoryFile(psiManager.getProject(), id, "pom", null);
            if (null == file) {
                return null;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (virtualFile == null) {
                return null;
            }
            return psiManager.findFile(virtualFile);
        }
    }

    private class ProjectStrategy
    extends ConverterStrategy {
        private ProjectStrategy() {
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context2) {
            return null;
        }

        @Override
        public boolean isValid(MavenId id, MavenIndicesManager manager, ConvertContext context2) {
            return true;
        }
    }

    private class ParentStrategy
    extends ConverterStrategy {
        private final MavenDomParent myParent;

        ParentStrategy(MavenDomParent parent) {
            this.myParent = parent;
        }

        @Override
        public String getErrorMessage(@Nullable String s, ConvertContext context2) {
            return MavenDomBundle.message("project.0.not.found", MavenArtifactCoordinatesHelper.getId(context2));
        }

        @Override
        public PsiFile resolveBySpecifiedPath() {
            return (PsiFile)this.myParent.getRelativePath().getValue();
        }
    }

    private class DependencyStrategy
    extends ConverterStrategy {
        private final MavenDomDependency myDependency;

        DependencyStrategy(MavenDomDependency dependency) {
            this.myDependency = dependency;
        }

        @Override
        public String getErrorMessage(@Nullable String s, ConvertContext context2) {
            return MavenDomBundle.message("dependency.0.not.found", MavenArtifactCoordinatesHelper.getId(context2));
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context2) {
            MavenDomDependency managedDependency;
            MavenArtifact artifact;
            MavenProject mavenProject2;
            PsiFile res = super.resolve(id, context2);
            if (res != null) {
                return res;
            }
            DomElement parent = context2.getInvocationElement().getParent();
            if (!(parent instanceof MavenDomDependency)) {
                return null;
            }
            DependencyConflictId dependencyId = DependencyConflictId.create((MavenDomDependency)parent);
            if (dependencyId == null) {
                return null;
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context2.getProject());
            VirtualFile file = MavenArtifactCoordinatesConverter.this.getMavenProjectFile(context2);
            MavenProject mavenProject3 = mavenProject2 = file == null ? null : projectsManager.findProject(file);
            if (mavenProject2 != null && (artifact = mavenProject2.getDependencyArtifactIndex().findArtifacts(dependencyId)) != null && MavenArtifactUtilKt.resolved(artifact)) {
                return super.resolve(new MavenId(id.getGroupId(), id.getArtifactId(), artifact.getVersion()), context2);
            }
            if (StringUtil.isEmpty((String)id.getVersion()) && (managedDependency = MavenDomProjectProcessorUtils.searchManagingDependency((MavenDomDependency)parent)) != null) {
                GenericDomValue managedDependencyArtifactId = managedDependency.getArtifactId();
                return (PsiFile)RecursionManager.doPreventingRecursion((Object)managedDependencyArtifactId, (boolean)false, () -> {
                    PsiElement res1 = new GenericDomValueReference(managedDependencyArtifactId).resolve();
                    return res1 instanceof PsiFile ? (PsiFile)res1 : null;
                });
            }
            return null;
        }

        @Override
        public PsiFile resolveBySpecifiedPath() {
            return (PsiFile)this.myDependency.getSystemPath().getValue();
        }
    }

    private class ExclusionStrategy
    extends ConverterStrategy {
        private ExclusionStrategy() {
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context2) {
            return null;
        }

        @Override
        public boolean isValid(MavenId id, MavenIndicesManager manager, ConvertContext context2) {
            return true;
        }
    }

    private class PluginOrExtensionStrategy
    extends ConverterStrategy {
        private final boolean myPlugin;

        PluginOrExtensionStrategy(boolean isPlugin) {
            this.myPlugin = isPlugin;
        }

        @Override
        public String getErrorMessage(@Nullable String s, ConvertContext context2) {
            return this.myPlugin ? MavenDomBundle.message("plugin.0.not.found", MavenArtifactCoordinatesHelper.getId(context2)) : MavenDomBundle.message("build.extension.0.not.found", MavenArtifactCoordinatesHelper.getId(context2));
        }

        @Override
        public boolean isValid(MavenId id, MavenIndicesManager manager, ConvertContext context2) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                for (String each : MavenArtifactUtil.DEFAULT_GROUPS) {
                    if (!super.isValid(id = new MavenId(each, id.getArtifactId(), id.getVersion()), manager, context2)) continue;
                    return true;
                }
                return false;
            }
            return super.isValid(id, manager, context2);
        }

        @Override
        public Set<String> getVariants(MavenId id, DependencySearchService searchService, MavenDomShortArtifactCoordinates coordinates) {
            if (StringUtil.isEmpty((String)id.getGroupId())) {
                HashSet<String> result2 = new HashSet<String>();
                for (String each : MavenArtifactUtil.DEFAULT_GROUPS) {
                    id = new MavenId(each, id.getArtifactId(), id.getVersion());
                    result2.addAll(super.getVariants(id, searchService, coordinates));
                }
                return result2;
            }
            return super.getVariants(id, searchService, coordinates);
        }

        @Override
        public PsiFile resolve(MavenId id, ConvertContext context2) {
            MavenProject mavenProject2;
            PsiFile res = super.resolve(id, context2);
            if (res != null) {
                return res;
            }
            MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context2.getProject());
            VirtualFile file = MavenArtifactCoordinatesConverter.this.getMavenProjectFile(context2);
            MavenProject mavenProject3 = mavenProject2 = file == null ? null : projectsManager.findProject(file);
            if (mavenProject2 != null) {
                for (MavenPlugin plugin : mavenProject2.getPlugins()) {
                    if (!MavenArtifactUtil.isPluginIdEquals(id.getGroupId(), id.getArtifactId(), plugin.getGroupId(), plugin.getArtifactId())) continue;
                    return super.resolve(plugin.getMavenId(), context2);
                }
            }
            PsiManager psiManager = context2.getPsiManager();
            Path artifactFile = MavenArtifactUtil.getArtifactNioPath(projectsManager.getLocalRepository(), id.getGroupId(), id.getArtifactId(), id.getVersion(), "pom");
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(artifactFile);
            if (virtualFile != null) {
                return psiManager.findFile(virtualFile);
            }
            return null;
        }
    }

    public static class MyUpdateIndicesIntention
    implements IntentionAction {
        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                MyUpdateIndicesIntention.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = MavenDomBundle.message("fix.update.indices", new Object[0]);
            if (string == null) {
                MyUpdateIndicesIntention.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project2 == null) {
                MyUpdateIndicesIntention.$$$reportNull$$$0(2);
            }
            MavenIndicesManager.getInstance(project2).scheduleUpdateContentAll();
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
            if (project2 == null) {
                MyUpdateIndicesIntention.$$$reportNull$$$0(3);
            }
            return MavenUtil.isPomFile(project2, file.getVirtualFile()) && MavenIndicesManager.getInstance(project2).getIndex().getRemoteIndices().stream().anyMatch(i2 -> !"central".equals(i2.getRepositoryId()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesIntention";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter$MyUpdateIndicesIntention";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

