/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.google.common.collect.ImmutableMap;
import com.intellij.build.events.MessageEvent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.NonAcceptedJavaLevelIssue;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.importing.tree.MavenJavaVersionHolder;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenImportUtil {
    public static final String TEST_SUFFIX = ".test";
    public static final String MAIN_SUFFIX = ".main";
    private static final Map<String, LanguageLevel> MAVEN_IDEA_PLUGIN_LEVELS = ImmutableMap.of((Object)"JDK_1_3", (Object)LanguageLevel.JDK_1_3, (Object)"JDK_1_4", (Object)LanguageLevel.JDK_1_4, (Object)"JDK_1_5", (Object)LanguageLevel.JDK_1_5, (Object)"JDK_1_6", (Object)LanguageLevel.JDK_1_6, (Object)"JDK_1_7", (Object)LanguageLevel.JDK_1_7);

    @NotNull
    public static String getArtifactUrlForClassifierAndExtension(@NotNull MavenArtifact artifact, @Nullable String classifier, @Nullable String extension) {
        if (artifact == null) {
            MavenImportUtil.$$$reportNull$$$0(0);
        }
        String newPath = artifact.getPathForExtraArtifact(classifier, extension);
        String string = VirtualFileManager.constructUrl((String)"jar", (String)newPath) + "!/";
        if (string == null) {
            MavenImportUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getArtifactUrl(@NotNull MavenArtifact artifact, @NotNull MavenExtraArtifactType artifactType, @NotNull MavenProject project2) {
        if (artifact == null) {
            MavenImportUtil.$$$reportNull$$$0(2);
        }
        if (artifactType == null) {
            MavenImportUtil.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            MavenImportUtil.$$$reportNull$$$0(4);
        }
        Pair<String, String> result2 = project2.getClassifierAndExtension(artifact, artifactType);
        String classifier = (String)result2.first;
        String extension = (String)result2.second;
        return MavenImportUtil.getArtifactUrlForClassifierAndExtension(artifact, classifier, extension);
    }

    @NotNull
    public static LanguageLevel getSourceLanguageLevel(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(5);
        }
        return MavenImportUtil.getLanguageLevel(mavenProject2, () -> MavenImportUtil.getMavenLanguageLevel(mavenProject2, MavenImportUtil.isReleaseCompilerProp(mavenProject2), true, false));
    }

    @Nullable
    public static LanguageLevel getTargetLanguageLevel(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(6);
        }
        return MavenImportUtil.getMavenLanguageLevel(mavenProject2, MavenImportUtil.isReleaseCompilerProp(mavenProject2), false, false);
    }

    @Nullable
    public static LanguageLevel getTargetTestLanguageLevel(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(7);
        }
        return MavenImportUtil.getMavenLanguageLevel(mavenProject2, MavenImportUtil.isReleaseCompilerProp(mavenProject2), false, true);
    }

    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull MavenProject mavenProject2, @NotNull Supplier<LanguageLevel> supplier) {
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(8);
        }
        if (supplier == null) {
            MavenImportUtil.$$$reportNull$$$0(9);
        }
        LanguageLevel level = null;
        Element cfg = mavenProject2.getPluginConfiguration("com.googlecode", "maven-idea-plugin");
        if (cfg != null) {
            level = MAVEN_IDEA_PLUGIN_LEVELS.get(cfg.getChildTextTrim("jdkLevel"));
        }
        if (level == null) {
            level = supplier.get();
        }
        if (level == null) {
            level = MavenImportUtil.getDefaultLevel(mavenProject2);
        }
        if (level.isAtLeast(LanguageLevel.JDK_11)) {
            level = MavenImportUtil.adjustPreviewLanguageLevel(mavenProject2, level);
        }
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            MavenImportUtil.$$$reportNull$$$0(10);
        }
        return languageLevel;
    }

    @NotNull
    public static MavenJavaVersionHolder getMavenJavaVersions(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(11);
        }
        boolean useReleaseCompilerProp = MavenImportUtil.isReleaseCompilerProp(mavenProject2);
        LanguageLevel sourceVersion = MavenImportUtil.getMavenLanguageLevel(mavenProject2, useReleaseCompilerProp, true, false);
        LanguageLevel sourceTestVersion = MavenImportUtil.getMavenLanguageLevel(mavenProject2, useReleaseCompilerProp, true, true);
        LanguageLevel targetVersion = MavenImportUtil.getMavenLanguageLevel(mavenProject2, useReleaseCompilerProp, false, false);
        LanguageLevel targetTestVersion = MavenImportUtil.getMavenLanguageLevel(mavenProject2, useReleaseCompilerProp, false, true);
        return new MavenJavaVersionHolder(sourceVersion, targetVersion, sourceTestVersion, targetTestVersion);
    }

    @Nullable
    private static LanguageLevel getMavenLanguageLevel(@NotNull MavenProject mavenProject2, boolean useReleaseCompilerProp, boolean isSource, boolean isTest) {
        String mavenProjectLanguageLevel;
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(12);
        }
        String mavenProjectReleaseLevel = useReleaseCompilerProp ? (isTest ? mavenProject2.getTestReleaseLevel() : mavenProject2.getReleaseLevel()) : null;
        LanguageLevel level = LanguageLevel.parse((String)mavenProjectReleaseLevel);
        if (level == null && (level = LanguageLevel.parse((String)(mavenProjectLanguageLevel = MavenImportUtil.getMavenLanguageLevel(mavenProject2, isTest, isSource)))) == null && (StringUtil.isNotEmpty((String)mavenProjectLanguageLevel) || StringUtil.isNotEmpty((String)mavenProjectReleaseLevel))) {
            level = LanguageLevel.HIGHEST;
        }
        return level;
    }

    @NotNull
    public static LanguageLevel adjustLevelAndNotify(@NotNull Project project2, @NotNull LanguageLevel level) {
        if (project2 == null) {
            MavenImportUtil.$$$reportNull$$$0(13);
        }
        if (level == null) {
            MavenImportUtil.$$$reportNull$$$0(14);
        }
        if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted((LanguageLevel)level)) {
            LanguageLevel highestAcceptedLevel = AcceptedLanguageLevelsSettings.getHighestAcceptedLevel();
            if (highestAcceptedLevel.isLessThan(level)) {
                MavenProjectsManager.getInstance(project2).getSyncConsole().addBuildIssue(new NonAcceptedJavaLevelIssue(level), MessageEvent.Kind.WARNING);
            }
            level = highestAcceptedLevel.isAtLeast(level) ? LanguageLevel.HIGHEST : highestAcceptedLevel;
        }
        LanguageLevel languageLevel = level;
        if (languageLevel == null) {
            MavenImportUtil.$$$reportNull$$$0(15);
        }
        return languageLevel;
    }

    private static String getMavenLanguageLevel(MavenProject project2, boolean test, boolean source) {
        if (test) {
            return source ? project2.getTestSourceLevel() : project2.getTestTargetLevel();
        }
        return source ? project2.getSourceLevel() : project2.getTargetLevel();
    }

    @NotNull
    public static LanguageLevel getDefaultLevel(MavenProject mavenProject2) {
        MavenPlugin plugin = mavenProject2.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
        if (plugin != null && plugin.getVersion() != null) {
            if (VersionComparatorUtil.compare((String)"3.11.0", (String)plugin.getVersion()) <= 0) {
                LanguageLevel languageLevel = LanguageLevel.JDK_1_8;
                if (languageLevel == null) {
                    MavenImportUtil.$$$reportNull$$$0(16);
                }
                return languageLevel;
            }
            if (VersionComparatorUtil.compare((String)"3.9.0", (String)plugin.getVersion()) <= 0) {
                LanguageLevel languageLevel = LanguageLevel.JDK_1_7;
                if (languageLevel == null) {
                    MavenImportUtil.$$$reportNull$$$0(17);
                }
                return languageLevel;
            }
            if (VersionComparatorUtil.compare((String)"3.8.0", (String)plugin.getVersion()) <= 0) {
                LanguageLevel languageLevel = LanguageLevel.JDK_1_6;
                if (languageLevel == null) {
                    MavenImportUtil.$$$reportNull$$$0(18);
                }
                return languageLevel;
            }
            LanguageLevel languageLevel = LanguageLevel.JDK_1_5;
            if (languageLevel == null) {
                MavenImportUtil.$$$reportNull$$$0(19);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.JDK_1_5;
        if (languageLevel == null) {
            MavenImportUtil.$$$reportNull$$$0(20);
        }
        return languageLevel;
    }

    private static LanguageLevel adjustPreviewLanguageLevel(MavenProject mavenProject2, LanguageLevel level) {
        Element compilerArgs;
        Element compilerConfiguration = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-compiler-plugin");
        if (compilerConfiguration != null && (compilerArgs = compilerConfiguration.getChild("compilerArgs")) != null && (MavenImportUtil.isPreviewText(compilerArgs) || ContainerUtil.exists((Iterable)compilerArgs.getChildren("arg"), MavenImportUtil::isPreviewText) || ContainerUtil.exists((Iterable)compilerArgs.getChildren("compilerArg"), MavenImportUtil::isPreviewText))) {
            try {
                return LanguageLevel.valueOf((String)(level.name() + "_PREVIEW"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return level;
    }

    private static boolean isPreviewText(Element child) {
        return "--enable-preview".equals(child.getTextTrim());
    }

    public static boolean isReleaseCompilerProp(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(21);
        }
        return StringUtil.compareVersionNumbers((String)MavenUtil.getCompilerPluginVersion(mavenProject2), (String)"3.6") >= 0;
    }

    public static boolean isCompilerTestSupport(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(22);
        }
        return StringUtil.compareVersionNumbers((String)MavenUtil.getCompilerPluginVersion(mavenProject2), (String)"2.1") >= 0;
    }

    public static boolean isMainOrTestSubmodule(@NotNull String moduleName) {
        if (moduleName == null) {
            MavenImportUtil.$$$reportNull$$$0(23);
        }
        return MavenImportUtil.isMainModule(moduleName) || MavenImportUtil.isTestModule(moduleName);
    }

    public static boolean isMainModule(@NotNull String moduleName) {
        if (moduleName == null) {
            MavenImportUtil.$$$reportNull$$$0(24);
        }
        return moduleName.length() > 5 && moduleName.endsWith(MAIN_SUFFIX);
    }

    public static boolean isTestModule(@NotNull String moduleName) {
        if (moduleName == null) {
            MavenImportUtil.$$$reportNull$$$0(25);
        }
        return moduleName.length() > 5 && moduleName.endsWith(TEST_SUFFIX);
    }

    @NotNull
    public static String getParentModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            MavenImportUtil.$$$reportNull$$$0(26);
        }
        if (MavenImportUtil.isMainModule(moduleName)) {
            String string = StringUtil.trimEnd((String)moduleName, (String)MAIN_SUFFIX);
            if (string == null) {
                MavenImportUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        if (MavenImportUtil.isTestModule(moduleName)) {
            String string = StringUtil.trimEnd((String)moduleName, (String)TEST_SUFFIX);
            if (string == null) {
                MavenImportUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = moduleName;
        if (string == null) {
            MavenImportUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static String getModuleName(@NotNull MavenProject mavenProject2, @NotNull Project project2) {
        if (mavenProject2 == null) {
            MavenImportUtil.$$$reportNull$$$0(30);
        }
        if (project2 == null) {
            MavenImportUtil.$$$reportNull$$$0(31);
        }
        MavenProjectsTree projectsTree = MavenProjectsManager.getInstance(project2).getProjectsTree();
        return MavenImportUtil.getModuleName(mavenProject2, projectsTree, new HashMap<MavenProject, String>());
    }

    @Deprecated
    @NotNull
    public static String getModuleName(@NotNull MavenProject project2, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, String> moduleNameMap) {
        String parentName;
        MavenProject parentProject;
        Object moduleName;
        if (project2 == null) {
            MavenImportUtil.$$$reportNull$$$0(32);
        }
        if (projectsTree == null) {
            MavenImportUtil.$$$reportNull$$$0(33);
        }
        if (moduleNameMap == null) {
            MavenImportUtil.$$$reportNull$$$0(34);
        }
        if ((moduleName = moduleNameMap.get(project2)) != null) {
            String string = moduleName;
            if (string == null) {
                MavenImportUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        moduleName = project2.getMavenId().getArtifactId();
        if (moduleName == null) {
            return "";
        }
        if (project2.getParentId() != null && (parentProject = projectsTree.findProject(project2.getParentId())) != null && StringUtil.isNotEmpty((String)(parentName = MavenImportUtil.getModuleName(parentProject, projectsTree, moduleNameMap)))) {
            moduleName = parentName + "." + (String)moduleName;
        }
        moduleNameMap.put(project2, (String)moduleName);
        String string = moduleName;
        if (string == null) {
            MavenImportUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    public static Module createPreviewModule(Project project2, VirtualFile contentRoot) {
        return (Module)WriteAction.compute(() -> {
            Path modulePath = contentRoot.toNioPath().resolve(project2.getName() + ".iml");
            Module module2 = ModuleManager.getInstance((Project)project2).newModule(modulePath, ModuleTypeManager.getInstance().getDefaultModuleType().getId());
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
            modifiableModel.addContentEntry(contentRoot);
            modifiableModel.commit();
            ExternalSystemUtil.markModuleAsMaven((Module)module2, (boolean)true);
            return module2;
        });
    }

    private static boolean needSplitMainAndTest(MavenProject project2, MavenJavaVersionHolder mavenJavaVersions) {
        if (!Registry.is((String)"maven.import.separate.main.and.test.modules.when.needed")) {
            return false;
        }
        return !project2.isAggregator() && mavenJavaVersions.needSeparateTestModule() && MavenImportUtil.isCompilerTestSupport(project2);
    }

    @ApiStatus.Internal
    public static StandardMavenModuleType getModuleType(MavenProject project2, MavenJavaVersionHolder mavenJavaVersions) {
        if (MavenImportUtil.needSplitMainAndTest(project2, mavenJavaVersions)) {
            return StandardMavenModuleType.COMPOUND_MODULE;
        }
        if (project2.isAggregator()) {
            return StandardMavenModuleType.AGGREGATOR;
        }
        return StandardMavenModuleType.SINGLE_MODULE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 15, 16, 17, 18, 19, 20, 27, 28, 29, 35, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenImportUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 4: 
            case 13: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 21: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenImportUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactUrlForClassifierAndExtension";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustLevelAndNotify";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentModuleName";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactUrlForClassifierAndExtension";
                break;
            }
            case 1: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 36: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceLanguageLevel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetLanguageLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTestLanguageLevel";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMavenJavaVersions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMavenLanguageLevel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "adjustLevelAndNotify";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isReleaseCompilerProp";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isCompilerTestSupport";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isMainOrTestSubmodule";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isMainModule";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isTestModule";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getParentModuleName";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10, 15, 16, 17, 18, 19, 20, 27, 28, 29, 35, 36 -> new IllegalStateException(string);
        };
    }
}

