/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.importing.tree.MavenJavaVersionHolder;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportContext;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDataWithDependencies;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDependencyProvider;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportData;
import org.jetbrains.idea.maven.importing.tree.MavenTreeModuleImportData;
import org.jetbrains.idea.maven.importing.tree.ModuleData;
import org.jetbrains.idea.maven.importing.tree.SplittedMainAndTestModules;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenLog;

public class MavenProjectImportContextProvider {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final MavenProjectsTree myProjectsTree;
    @NotNull
    protected final MavenImportingSettings myImportingSettings;
    @NotNull
    protected final HashMap<MavenProject, String> myMavenProjectToModuleName;

    public MavenProjectImportContextProvider(@NotNull Project project2, @NotNull MavenProjectsTree projectsTree, @NotNull MavenImportingSettings importingSettings, @NotNull HashMap<MavenProject, String> mavenProjectToModuleName) {
        if (project2 == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(0);
        }
        if (projectsTree == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(1);
        }
        if (importingSettings == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(2);
        }
        if (mavenProjectToModuleName == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(3);
        }
        this.myProject = project2;
        this.myProjectsTree = projectsTree;
        this.myImportingSettings = importingSettings;
        this.myMavenProjectToModuleName = mavenProjectToModuleName;
    }

    public MavenModuleImportContext getContext(@NotNull Map<MavenProject, MavenProjectChanges> projectsWithChanges2) {
        if (projectsWithChanges2 == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(4);
        }
        ModuleImportDataContext importDataContext = this.getModuleImportDataContext(projectsWithChanges2);
        ModuleImportDataDependencyContext importDataDependencyContext = this.getFlattenModuleDataDependencyContext(importDataContext);
        return new MavenModuleImportContext(importDataDependencyContext.changedModuleDataWithDependencies, importDataDependencyContext.allModuleDataWithDependencies, importDataContext.moduleNameByProject, importDataContext.hasChanges);
    }

    @NotNull
    private ModuleImportDataContext getModuleImportDataContext(@NotNull Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges) {
        if (projectsToImportWithChanges == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(5);
        }
        boolean hasChanges = false;
        ArrayList<MavenProjectImportData> allModules = new ArrayList<MavenProjectImportData>();
        TreeMap<MavenId, MavenProjectImportData> moduleImportDataByMavenId = new TreeMap<MavenId, MavenProjectImportData>(Comparator.comparing(MavenId::getKey));
        for (Map.Entry<MavenProject, MavenProjectChanges> each : projectsToImportWithChanges.entrySet()) {
            MavenProject project2 = each.getKey();
            MavenProjectChanges changes = each.getValue();
            String moduleName = this.getModuleName(project2);
            if (StringUtil.isEmpty((String)moduleName)) {
                MavenLog.LOG.warn("[import context] empty module name for project " + project2);
                continue;
            }
            MavenProjectImportData mavenProjectImportData = this.getModuleImportData(project2, moduleName, changes);
            if (changes.hasChanges()) {
                hasChanges = true;
            }
            moduleImportDataByMavenId.put(project2.getMavenId(), mavenProjectImportData);
            allModules.add(mavenProjectImportData);
        }
        return new ModuleImportDataContext(allModules, this.myMavenProjectToModuleName, moduleImportDataByMavenId, hasChanges);
    }

    @Nullable
    protected String getModuleName(MavenProject project2) {
        return this.myMavenProjectToModuleName.get(project2);
    }

    @NotNull
    private ModuleImportDataDependencyContext getFlattenModuleDataDependencyContext(ModuleImportDataContext context2) {
        ArrayList<MavenTreeModuleImportData> allModuleDataWithDependencies = new ArrayList<MavenTreeModuleImportData>();
        ArrayList<MavenTreeModuleImportData> changedModuleDataWithDependencies = new ArrayList<MavenTreeModuleImportData>();
        MavenModuleImportDependencyProvider dependencyProvider = new MavenModuleImportDependencyProvider(context2.moduleImportDataByMavenId, this.myImportingSettings, this.myProjectsTree);
        for (MavenProjectImportData importData : context2.importData) {
            MavenModuleImportDataWithDependencies importDataWithDependencies = dependencyProvider.getDependencies(importData);
            List<MavenTreeModuleImportData> mavenModuleImportDataList = MavenProjectImportContextProvider.splitToModules(importDataWithDependencies);
            for (MavenTreeModuleImportData moduleImportData : mavenModuleImportDataList) {
                if (moduleImportData.getChanges().hasChanges()) {
                    changedModuleDataWithDependencies.add(moduleImportData);
                }
                allModuleDataWithDependencies.add(moduleImportData);
            }
        }
        return new ModuleImportDataDependencyContext(allModuleDataWithDependencies, changedModuleDataWithDependencies);
    }

    @NotNull
    protected static List<MavenTreeModuleImportData> splitToModules(MavenModuleImportDataWithDependencies dataWithDependencies) {
        SplittedMainAndTestModules mainAndTestModules = dataWithDependencies.getModuleImportData().getSplittedMainAndTestModules();
        MavenProject project2 = dataWithDependencies.getModuleImportData().getMavenProject();
        ModuleData moduleData = dataWithDependencies.getModuleImportData().getModuleData();
        MavenProjectChanges changes = dataWithDependencies.getModuleImportData().getChanges();
        if (mainAndTestModules != null) {
            ArrayList<MavenTreeModuleImportData> result2 = new ArrayList<MavenTreeModuleImportData>(3);
            result2.add(new MavenTreeModuleImportData(project2, moduleData, Collections.emptyList(), dataWithDependencies.getModuleImportData().getChanges()));
            result2.add(new MavenTreeModuleImportData(project2, mainAndTestModules.getMainData(), dataWithDependencies.getMainDependencies(), changes));
            List dependencies = ContainerUtil.concat(dataWithDependencies.getTestDependencies(), dataWithDependencies.getMainDependencies());
            result2.add(new MavenTreeModuleImportData(project2, mainAndTestModules.getTestData(), dependencies, changes));
            ArrayList<MavenTreeModuleImportData> arrayList = result2;
            if (arrayList == null) {
                MavenProjectImportContextProvider.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        List<MavenTreeModuleImportData> list = List.of(new MavenTreeModuleImportData(project2, moduleData, ContainerUtil.concat(dataWithDependencies.getMainDependencies(), dataWithDependencies.getTestDependencies()), changes));
        if (list == null) {
            MavenProjectImportContextProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected MavenProjectImportData getModuleImportData(MavenProject project2, String moduleName, MavenProjectChanges changes) {
        MavenJavaVersionHolder setUpJavaVersions = MavenImportUtil.getMavenJavaVersions(project2);
        MavenJavaVersionHolder javaVersions = this.adjustJavaVersions(setUpJavaVersions);
        StandardMavenModuleType type2 = MavenImportUtil.getModuleType(project2, javaVersions);
        ModuleData moduleData = new ModuleData(moduleName, type2, javaVersions);
        if (type2 != StandardMavenModuleType.COMPOUND_MODULE) {
            return new MavenProjectImportData(project2, moduleData, changes, null);
        }
        String moduleMainName = moduleName + ".main";
        ModuleData mainData = new ModuleData(moduleMainName, StandardMavenModuleType.MAIN_ONLY, javaVersions);
        String moduleTestName = moduleName + ".test";
        ModuleData testData = new ModuleData(moduleTestName, StandardMavenModuleType.TEST_ONLY, javaVersions);
        SplittedMainAndTestModules mainAndTestModules = new SplittedMainAndTestModules(mainData, testData);
        return new MavenProjectImportData(project2, moduleData, changes, mainAndTestModules);
    }

    private MavenJavaVersionHolder adjustJavaVersions(MavenJavaVersionHolder holder) {
        return new MavenJavaVersionHolder(holder.sourceLevel == null ? null : MavenImportUtil.adjustLevelAndNotify(this.myProject, holder.sourceLevel), holder.targetLevel == null ? null : MavenImportUtil.adjustLevelAndNotify(this.myProject, holder.targetLevel), holder.testSourceLevel == null ? null : MavenImportUtil.adjustLevelAndNotify(this.myProject, holder.testSourceLevel), holder.testTargetLevel == null ? null : MavenImportUtil.adjustLevelAndNotify(this.myProject, holder.testTargetLevel));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjectToModuleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsWithChanges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsToImportWithChanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "splitToModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleImportDataContext";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class ModuleImportDataContext {
        @NotNull
        final List<MavenProjectImportData> importData;
        @NotNull
        final Map<MavenProject, String> moduleNameByProject;
        @NotNull
        final Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId;
        final boolean hasChanges;

        private ModuleImportDataContext(@NotNull List<MavenProjectImportData> importData, @NotNull Map<MavenProject, String> moduleNameByProject, @NotNull Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId, boolean hasChanges) {
            if (importData == null) {
                ModuleImportDataContext.$$$reportNull$$$0(0);
            }
            if (moduleNameByProject == null) {
                ModuleImportDataContext.$$$reportNull$$$0(1);
            }
            if (moduleImportDataByMavenId == null) {
                ModuleImportDataContext.$$$reportNull$$$0(2);
            }
            this.importData = importData;
            this.moduleNameByProject = moduleNameByProject;
            this.moduleImportDataByMavenId = moduleImportDataByMavenId;
            this.hasChanges = hasChanges;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleNameByProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleImportDataByMavenId";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider$ModuleImportDataContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleImportDataDependencyContext {
        @NotNull
        final List<MavenTreeModuleImportData> allModuleDataWithDependencies;
        @NotNull
        final List<MavenTreeModuleImportData> changedModuleDataWithDependencies;

        private ModuleImportDataDependencyContext(@NotNull List<MavenTreeModuleImportData> allModuleDataWithDependencies, @NotNull List<MavenTreeModuleImportData> changedModuleDataWithDependencies) {
            if (allModuleDataWithDependencies == null) {
                ModuleImportDataDependencyContext.$$$reportNull$$$0(0);
            }
            if (changedModuleDataWithDependencies == null) {
                ModuleImportDataDependencyContext.$$$reportNull$$$0(1);
            }
            this.allModuleDataWithDependencies = allModuleDataWithDependencies;
            this.changedModuleDataWithDependencies = changedModuleDataWithDependencies;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allModuleDataWithDependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changedModuleDataWithDependencies";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectImportContextProvider$ModuleImportDataDependencyContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

