/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.workspaceModel;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenAfterImportConfigurator;
import org.jetbrains.idea.maven.importing.workspaceModel.MavenProjectWithModulesData;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceProjectImporterKt;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/AfterImportConfiguratorsTask;", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "contextData", "Lcom/intellij/openapi/util/UserDataHolderBase;", "appliedProjectsWithModules", "", "Lorg/jetbrains/idea/maven/importing/workspaceModel/MavenProjectWithModulesData;", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/util/UserDataHolderBase;Ljava/util/List;)V", "doPerform", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lorg/jetbrains/idea/maven/utils/MavenProgressIndicator;", "perform", "embeddersManager", "Lorg/jetbrains/idea/maven/project/MavenEmbeddersManager;", "console", "Lorg/jetbrains/idea/maven/project/MavenConsole;", "intellij.maven"})
final class AfterImportConfiguratorsTask
implements MavenProjectsProcessorTask {
    @NotNull
    private final UserDataHolderBase contextData;
    @NotNull
    private final List<MavenProjectWithModulesData<Module>> appliedProjectsWithModules;

    public AfterImportConfiguratorsTask(@NotNull UserDataHolderBase contextData, @NotNull List<MavenProjectWithModulesData<Module>> appliedProjectsWithModules2) {
        Intrinsics.checkNotNullParameter((Object)contextData, (String)"contextData");
        Intrinsics.checkNotNullParameter(appliedProjectsWithModules2, (String)"appliedProjectsWithModules");
        this.contextData = contextData;
        this.appliedProjectsWithModules = appliedProjectsWithModules2;
    }

    @Override
    public void perform(@NotNull Project project2, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console2, @NotNull MavenProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)embeddersManager, (String)"embeddersManager");
        Intrinsics.checkNotNullParameter((Object)console2, (String)"console");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        ExternalSystemStatUtilKt.runImportActivitySync((Project)project2, (ProjectSystemId)projectSystemId, AfterImportConfiguratorsTask.class, (Function0)((Function0)new Function0<Unit>(this, project2, indicator){
            final /* synthetic */ AfterImportConfiguratorsTask this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ MavenProgressIndicator $indicator;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$indicator = $indicator;
                super(0);
            }

            public final void invoke() {
                AfterImportConfiguratorsTask.access$doPerform(this.this$0, this.$project, this.$indicator);
            }
        }));
    }

    private final void doPerform(Project project2, MavenProgressIndicator indicator) {
        MavenAfterImportConfigurator.Context context2 = new MavenAfterImportConfigurator.Context(this, project2, indicator){
            private final /* synthetic */ UserDataHolderBase $$delegate_0;
            @NotNull
            private final Project project;
            @NotNull
            private final Sequence<MavenProjectWithModulesData<Module>> mavenProjectsWithModules;
            @NotNull
            private final MavenProgressIndicator mavenProgressIndicator;
            {
                this.$$delegate_0 = AfterImportConfiguratorsTask.access$getContextData$p($receiver);
                this.project = $project;
                this.mavenProjectsWithModules = CollectionsKt.asSequence((Iterable)AfterImportConfiguratorsTask.access$getAppliedProjectsWithModules$p($receiver));
                this.mavenProgressIndicator = $indicator;
            }

            @Nullable
            public <T> T getUserData(@NotNull Key<T> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return (T)this.$$delegate_0.getUserData(p0);
            }

            public <T> void putUserData(@NotNull Key<T> p0, @Nullable T p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                this.$$delegate_0.putUserData(p0, p1);
            }

            @NotNull
            public Project getProject() {
                return this.project;
            }

            @NotNull
            public Sequence<MavenProjectWithModulesData<Module>> getMavenProjectsWithModules() {
                return this.mavenProjectsWithModules;
            }

            @NotNull
            public MavenProgressIndicator getMavenProgressIndicator() {
                return this.mavenProgressIndicator;
            }
        };
        for (MavenAfterImportConfigurator configurator : WorkspaceProjectImporterKt.getAFTER_IMPORT_CONFIGURATOR_EP().getExtensionList()) {
            indicator.checkCanceled();
            try {
                configurator.afterImport(context2);
            }
            catch (Exception e) {
                MavenLog.LOG.error("Exception in MavenAfterImportConfigurator.afterImport, skipping it.", (Throwable)e);
            }
        }
    }

    public static final /* synthetic */ void access$doPerform(AfterImportConfiguratorsTask $this, Project project2, MavenProgressIndicator indicator) {
        $this.doPerform(project2, indicator);
    }

    public static final /* synthetic */ UserDataHolderBase access$getContextData$p(AfterImportConfiguratorsTask $this) {
        return $this.contextData;
    }

    public static final /* synthetic */ List access$getAppliedProjectsWithModules$p(AfterImportConfiguratorsTask $this) {
        return $this.appliedProjectsWithModules;
    }
}

