/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchProvider;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/idea/maven/onlinecompletion/IndexBasedCompletionProvider;", "Lorg/jetbrains/idea/reposearch/DependencySearchProvider;", "myIndex", "Lorg/jetbrains/idea/maven/indices/MavenIndex;", "(Lorg/jetbrains/idea/maven/indices/MavenIndex;)V", "index", "Lorg/jetbrains/idea/maven/indices/MavenSearchIndex;", "getIndex", "()Lorg/jetbrains/idea/maven/indices/MavenSearchIndex;", "fulltextSearch", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/jetbrains/idea/reposearch/RepositoryArtifactData;", "searchString", "", "isLocal", "", "nonExactMatches", "template", "real", "search", "mavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "suggestPrefix", "groupId", "artifactId", "intellij.maven"})
public final class IndexBasedCompletionProvider
implements DependencySearchProvider {
    @NotNull
    private final MavenIndex myIndex;

    public IndexBasedCompletionProvider(@NotNull MavenIndex myIndex) {
        Intrinsics.checkNotNullParameter((Object)myIndex, (String)"myIndex");
        this.myIndex = myIndex;
    }

    @NotNull
    public CompletableFuture<List<RepositoryArtifactData>> fulltextSearch(@NotNull String searchString) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        return this.search(new MavenId(searchString));
    }

    @NotNull
    public CompletableFuture<List<RepositoryArtifactData>> suggestPrefix(@Nullable String groupId, @Nullable String artifactId) {
        return this.search(new MavenId(groupId, artifactId, null));
    }

    private final CompletableFuture<List<RepositoryArtifactData>> search(MavenId mavenId) {
        CompletableFuture<List<RepositoryArtifactData>> completableFuture = CompletableFuture.supplyAsync(() -> IndexBasedCompletionProvider.search$lambda$1(this, mavenId));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync {\n    buildL\u2026      }\n      }\n    }\n  }");
        return completableFuture;
    }

    private final boolean nonExactMatches(String template, String real) {
        char[] cArray = new char[]{'-', '.'};
        List splittedTemplate = StringsKt.split$default((CharSequence)template, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'-', '.'};
        List splittedReal = StringsKt.split$default((CharSequence)real, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        if (splittedTemplate.size() == 1 || splittedReal.size() == 1) {
            return StringUtil.startsWith((CharSequence)template, (CharSequence)real) || StringUtil.startsWith((CharSequence)real, (CharSequence)template);
        }
        int matches = 0;
        int n = Math.min(splittedReal.size(), splittedTemplate.size());
        for (int i2 = 0; i2 < n; ++i2) {
            if (StringUtil.startsWith((CharSequence)((CharSequence)splittedTemplate.get(i2)), (CharSequence)((CharSequence)splittedReal.get(i2))) || StringUtil.startsWith((CharSequence)((CharSequence)splittedReal.get(i2)), (CharSequence)((CharSequence)splittedTemplate.get(i2)))) {
                ++matches;
            }
            if (matches < 2) continue;
            return true;
        }
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    @NotNull
    public final MavenSearchIndex getIndex() {
        return this.myIndex;
    }

    private static final List search$lambda$1(IndexBasedCompletionProvider this$0, MavenId $mavenId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mavenId, (String)"$mavenId");
        List $this$search_u24lambda_u241_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (String groupId : this$0.myIndex.getGroupIds()) {
            if (groupId == null) continue;
            CharSequence charSequence = $mavenId.getGroupId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = $mavenId.getGroupId();
                Intrinsics.checkNotNull((Object)string);
                if (!this$0.nonExactMatches(groupId, string)) continue;
            }
            for (String artifactId : this$0.myIndex.getArtifactIds(groupId)) {
                CharSequence charSequence2 = $mavenId.getArtifactId();
                if (!(charSequence2 == null || charSequence2.length() == 0)) {
                    Intrinsics.checkNotNullExpressionValue((Object)artifactId, (String)"artifactId");
                    String string = $mavenId.getArtifactId();
                    Intrinsics.checkNotNull((Object)string);
                    if (!this$0.nonExactMatches(artifactId, string)) continue;
                }
                if (artifactId == null) continue;
                Set<String> set = this$0.myIndex.getVersions(groupId, artifactId);
                Intrinsics.checkNotNullExpressionValue(set, (String)"myIndex.getVersions(groupId, artifactId)");
                MavenRepositoryArtifactInfo info = new MavenRepositoryArtifactInfo(groupId, artifactId, (Collection)set);
                $this$search_u24lambda_u241_u24lambda_u240.add(info);
            }
        }
        return CollectionsKt.build((List)list);
    }
}

