/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenDisablePanelCheckbox;
import org.jetbrains.idea.maven.project.MavenGeneralPanel;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenGeneralSettingsEditor
extends SettingsEditor<MavenRunConfiguration> {
    private final MavenGeneralPanel myPanel;
    private JCheckBox myUseProjectSettings;
    private final Project myProject;

    public MavenGeneralSettingsEditor(@NotNull Project project2) {
        if (project2 == null) {
            MavenGeneralSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myPanel = new MavenGeneralPanel();
    }

    protected void resetEditorFrom(@NotNull MavenRunConfiguration s) {
        boolean localTarget;
        if (s == null) {
            MavenGeneralSettingsEditor.$$$reportNull$$$0(1);
        }
        boolean bl = localTarget = MavenRunConfiguration.getTargetName(this) == null;
        if (localTarget) {
            this.myUseProjectSettings.setSelected(s.getGeneralSettings() == null);
        } else {
            this.myUseProjectSettings.setSelected(false);
        }
        if (s.getGeneralSettings() == null) {
            MavenGeneralSettings settings = MavenProjectsManager.getInstance(this.myProject).getGeneralSettings();
            this.myPanel.initializeFormData(settings, this.myProject);
        } else {
            this.myPanel.initializeFormData(s.getGeneralSettings(), this.myProject);
        }
    }

    protected void applyEditorTo(@NotNull MavenRunConfiguration runConfiguration) throws ConfigurationException {
        String targetName;
        if (runConfiguration == null) {
            MavenGeneralSettingsEditor.$$$reportNull$$$0(2);
        }
        boolean localTarget = (targetName = MavenRunConfiguration.getTargetName(this)) == null;
        this.myUseProjectSettings.setEnabled(localTarget);
        if (!localTarget) {
            this.myUseProjectSettings.setSelected(false);
            this.myUseProjectSettings.setToolTipText(MavenConfigurableBundle.message("maven.settings.on.targets.general.use.project.settings.tooltip", new Object[0]));
        } else {
            this.myUseProjectSettings.setToolTipText(MavenConfigurableBundle.message("maven.settings.general.use.project.settings.tooltip", new Object[0]));
        }
        if (this.myUseProjectSettings.isSelected()) {
            runConfiguration.setGeneralSettings(null);
        } else {
            MavenGeneralSettings generalSettings = runConfiguration.getGeneralSettings();
            this.myPanel.applyTargetEnvironmentConfiguration(runConfiguration.getProject(), targetName);
            if (generalSettings != null) {
                this.myPanel.setData(generalSettings);
            } else {
                MavenGeneralSettings settings = MavenProjectsManager.getInstance(this.myProject).getGeneralSettings().clone();
                this.myPanel.setData(settings);
                runConfiguration.setGeneralSettings(settings);
            }
        }
    }

    @NotNull
    protected JComponent createEditor() {
        Pair<JPanel, JCheckBox> pair = MavenDisablePanelCheckbox.createPanel(this.myPanel.createComponent(), MavenProjectBundle.message("label.use.project.settings", new Object[0]));
        this.myUseProjectSettings = (JCheckBox)pair.second;
        JComponent jComponent = (JComponent)pair.first;
        if (jComponent == null) {
            MavenGeneralSettingsEditor.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenGeneralSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenGeneralSettingsEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

