/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesReloadContext;
import com.intellij.openapi.externalSystem.autoimport.settings.ReadAsyncSupplier;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.MavenImportSpec;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.project.MavenImportListener;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsAware;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsManagerWatcher;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00130\u00130\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J \u0010\u001c\u001a\n \u0018*\u0004\u0018\u00010\u00130\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J(\u0010\u001f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020'H\u0016J<\u0010(\u001a\u00020&2\u0006\u0010#\u001a\u00020$2*\u0010)\u001a&\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0 \u0012\u0004\u0012\u00020&0*H\u0002J\u0018\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectsAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "project", "Lcom/intellij/openapi/project/Project;", "manager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "watcher", "Lorg/jetbrains/idea/maven/project/MavenProjectsManagerWatcher;", "backgroundExecutor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/idea/maven/project/MavenProjectsManager;Lorg/jetbrains/idea/maven/project/MavenProjectsManagerWatcher;Ljava/util/concurrent/ExecutorService;)V", "isImportCompleted", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "settingsFiles", "", "", "getSettingsFiles", "()Ljava/util/Set;", "collectSettingsFiles", "Lkotlin/sequences/Sequence;", "kotlin.jvm.PlatformType", "hasPomFile", "", "rootDirectory", "join", "parentPath", "relativePath", "partitionSettingsFiles", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemSettingsFilesReloadContext;", "reloadProject", "", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "submitSettingsFilesPartition", "action", "Lkotlin/Function1;", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectsAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectsAware.kt\norg/jetbrains/idea/maven/project/MavenProjectsAware\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,120:1\n1229#2,2:121\n*S KotlinDebug\n*F\n+ 1 MavenProjectsAware.kt\norg/jetbrains/idea/maven/project/MavenProjectsAware\n*L\n84#1:121,2\n*E\n"})
public final class MavenProjectsAware
implements ExternalSystemProjectAware {
    @NotNull
    private final MavenProjectsManager manager;
    @NotNull
    private final MavenProjectsManagerWatcher watcher;
    @NotNull
    private final ExecutorService backgroundExecutor;
    @NotNull
    private final AtomicBooleanProperty isImportCompleted;
    @NotNull
    private final ExternalSystemProjectId projectId;

    public MavenProjectsAware(@NotNull Project project2, @NotNull MavenProjectsManager manager, @NotNull MavenProjectsManagerWatcher watcher, @NotNull ExecutorService backgroundExecutor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)watcher, (String)"watcher");
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        this.manager = manager;
        this.watcher = watcher;
        this.backgroundExecutor = backgroundExecutor;
        this.isImportCompleted = new AtomicBooleanProperty(true);
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"SYSTEM_ID");
        String string = project2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        this.projectId = new ExternalSystemProjectId(projectSystemId, string);
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)this.manager);
        Topic<MavenImportListener> topic = MavenImportListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new MavenImportListener(){

            @Override
            public void importFinished(@NotNull Collection<MavenProject> importedProjects, @NotNull List<Module> newModules) {
                Intrinsics.checkNotNullParameter(importedProjects, (String)"importedProjects");
                Intrinsics.checkNotNullParameter(newModules, (String)"newModules");
                isImportCompleted.set(true);
            }

            @Override
            public void importStarted() {
                isImportCompleted.set(false);
            }
        });
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    @NotNull
    public Set<String> getSettingsFiles() {
        return SequencesKt.toSet((Sequence)SequencesKt.map(this.collectSettingsFiles(), (Function1)settingsFiles.1.INSTANCE));
    }

    public void subscribe(@NotNull ExternalSystemProjectListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.isImportCompleted.afterReset(parentDisposable, (Function0)new Function0<Unit>(listener2){
            final /* synthetic */ ExternalSystemProjectListener $listener;
            {
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$listener.onProjectReloadStart();
            }
        });
        this.isImportCompleted.afterSet(parentDisposable, (Function0)new Function0<Unit>(listener2){
            final /* synthetic */ ExternalSystemProjectListener $listener;
            {
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$listener.onProjectReloadFinish(ExternalSystemRefreshStatus.SUCCESS);
            }
        });
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FileDocumentManager.getInstance().saveAllDocuments();
        ExternalSystemSettingsFilesReloadContext settingsFilesContext = context2.getSettingsFilesContext();
        if (context2.getHasUndefinedModifications()) {
            this.manager.forceUpdateAllProjectsOrFindAllAvailablePomFiles(new MavenImportSpec(true, true, context2.isExplicitReload()));
        } else {
            this.submitSettingsFilesPartition(settingsFilesContext, (Function1<? super Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>>, Unit>)((Function1)new Function1<Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>>, Unit>(settingsFilesContext, this, context2){
                final /* synthetic */ ExternalSystemSettingsFilesReloadContext $settingsFilesContext;
                final /* synthetic */ MavenProjectsAware this$0;
                final /* synthetic */ ExternalSystemProjectReloadContext $context;
                {
                    this.$settingsFilesContext = $settingsFilesContext;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>> pair) {
                    Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                    List filesToUpdate = (List)pair.component1();
                    List filesToDelete = (List)pair.component2();
                    Set updated = SetsKt.plus((Set)this.$settingsFilesContext.getCreated(), (Iterable)this.$settingsFilesContext.getUpdated());
                    Set deleted = this.$settingsFilesContext.getDeleted();
                    if (updated.size() == filesToUpdate.size() && deleted.size() == filesToDelete.size()) {
                        MavenProjectsAware.access$getWatcher$p(this.this$0).scheduleUpdate(filesToUpdate, filesToDelete, new MavenImportSpec(false, true, this.$context.isExplicitReload()));
                    } else {
                        MavenProjectsAware.access$getManager$p(this.this$0).forceUpdateAllProjectsOrFindAllAvailablePomFiles(new MavenImportSpec(false, true, this.$context.isExplicitReload()));
                    }
                }
            }));
        }
    }

    private final void submitSettingsFilesPartition(ExternalSystemSettingsFilesReloadContext context2, Function1<? super Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>>, Unit> action) {
        new ReadAsyncSupplier.Builder((Function0)new Function0<Pair<? extends List<? extends VirtualFile>, ? extends List<? extends VirtualFile>>>(this, context2){
            final /* synthetic */ MavenProjectsAware this$0;
            final /* synthetic */ ExternalSystemSettingsFilesReloadContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Pair<List<VirtualFile>, List<VirtualFile>> invoke() {
                return MavenProjectsAware.access$partitionSettingsFiles(this.this$0, this.$context);
            }
        }).build((Executor)this.backgroundExecutor).supply((Disposable)this.manager, action);
    }

    private final Pair<List<VirtualFile>, List<VirtualFile>> partitionSettingsFiles(ExternalSystemSettingsFilesReloadContext context2) {
        List updated = new ArrayList();
        List deleted = new ArrayList();
        for (VirtualFile projectsFile : this.manager.getProjectsTree().getProjectsFiles()) {
            String path;
            Intrinsics.checkNotNullExpressionValue((Object)projectsFile.getPath(), (String)"projectsFile.path");
            if (context2.getCreated().contains(path)) {
                Intrinsics.checkNotNullExpressionValue((Object)projectsFile, (String)"projectsFile");
                updated.add(projectsFile);
            }
            if (context2.getUpdated().contains(path)) {
                Intrinsics.checkNotNullExpressionValue((Object)projectsFile, (String)"projectsFile");
                updated.add(projectsFile);
            }
            if (!context2.getDeleted().contains(path)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)projectsFile, (String)"projectsFile");
            deleted.add(projectsFile);
        }
        return TuplesKt.to((Object)updated, (Object)deleted);
    }

    private final boolean hasPomFile(String rootDirectory) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullExpressionValue((Object)MavenConstants.POM_NAMES, (String)"POM_NAMES");
            Sequence $this$any$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])MavenConstants.POM_NAMES), (Function1)((Function1)new Function1<String, String>(this, rootDirectory){
                final /* synthetic */ MavenProjectsAware this$0;
                final /* synthetic */ String $rootDirectory;
                {
                    this.this$0 = $receiver;
                    this.$rootDirectory = $rootDirectory;
                    super(1);
                }

                public final String invoke(String it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return MavenProjectsAware.access$join(this.this$0, this.$rootDirectory, it);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!this.manager.getProjectsTree().isPotentialProject(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final Sequence<String> collectSettingsFiles() {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MavenProjectsAware this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        v0 = MavenProjectsAware.access$getManager$p(this.this$0).getProjectsTree().getManagedFilesPaths();
                        Intrinsics.checkNotNullExpressionValue(v0, (String)"manager.projectsTree.managedFilesPaths");
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v1 = $this$sequence.yieldAll((Iterable)v0, (Continuation)this);
                        if (v1 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        v2 = MavenProjectsAware.access$getManager$p(this.this$0).getProjectsTree().getProjectsFiles();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"manager.projectsTree.projectsFiles");
                        var3_4 = v2;
                        var12_5 = $this$sequence;
                        $i$f$map = false;
                        var5_8 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var10_13 = (VirtualFile)item$iv$iv;
                            var13_15 = destination$iv$iv;
                            $i$a$-map-MavenProjectsAware$collectSettingsFiles$1$1 = false;
                            var13_15.add(it.getPath());
                        }
                        this.L$0 = $this$sequence;
                        this.label = 2;
                        v3 = var12_5.yieldAll((Iterable)((List)destination$iv$iv), (Continuation)this);
                        if (v3 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl43
                    }
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl43:
                        // 2 sources

                        var3_4 = MavenProjectsAware.access$getManager$p(this.this$0).getProjectsTree().getProjects().iterator();
lbl44:
                        // 4 sources

                        while (var3_4.hasNext()) {
                            mavenProject = var3_4.next();
                            ProgressManager.checkCanceled();
                            Intrinsics.checkNotNullExpressionValue((Object)mavenProject.getDirectory(), (String)"mavenProject.directory");
                            var6_9 = mavenProject.getModulePaths();
                            Intrinsics.checkNotNullExpressionValue(var6_9, (String)"mavenProject.modulePaths");
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = rootDirectory;
                            this.label = 3;
                            v4 = $this$sequence.yieldAll((Iterable)var6_9, (Continuation)this);
                            if (v4 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl65
                        }
                        break;
                    }
                    case 3: {
                        rootDirectory = (String)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl65:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = rootDirectory;
                        this.label = 4;
                        v5 = $this$sequence.yield((Object)MavenProjectsAware.access$join(this.this$0, rootDirectory, "/.mvn/jvm.config"), (Continuation)this);
                        if (v5 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl79
                    }
                    case 4: {
                        rootDirectory = (String)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl79:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = rootDirectory;
                        this.label = 5;
                        v6 = $this$sequence.yield((Object)MavenProjectsAware.access$join(this.this$0, rootDirectory, "/.mvn/maven.config"), (Continuation)this);
                        if (v6 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl93
                    }
                    case 5: {
                        rootDirectory = (String)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl93:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = rootDirectory;
                        this.label = 6;
                        v7 = $this$sequence.yield((Object)MavenProjectsAware.access$join(this.this$0, rootDirectory, "/.mvn/wrapper/maven-wrapper.properties"), (Continuation)this);
                        if (v7 == var14_2) {
                            return var14_2;
                        }
                        ** GOTO lbl107
                    }
                    case 6: {
                        rootDirectory = (String)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl107:
                        // 2 sources

                        if (!MavenProjectsAware.access$hasPomFile(this.this$0, rootDirectory)) ** GOTO lbl44
                        this.L$0 = $this$sequence;
                        this.L$1 = var3_4;
                        this.L$2 = null;
                        this.label = 7;
                        v8 = $this$sequence.yield((Object)MavenProjectsAware.access$join(this.this$0, rootDirectory, "profiles.xml"), (Continuation)this);
                        if (v8 != var14_2) ** GOTO lbl44
                        return var14_2;
                    }
                    case 7: {
                        var3_4 = (Iterator<MavenProject>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
                        ** GOTO lbl44
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final String join(String parentPath, String relativePath) {
        return new File(parentPath, relativePath).getPath();
    }

    public static final /* synthetic */ MavenProjectsManagerWatcher access$getWatcher$p(MavenProjectsAware $this) {
        return $this.watcher;
    }

    public static final /* synthetic */ MavenProjectsManager access$getManager$p(MavenProjectsAware $this) {
        return $this.manager;
    }

    public static final /* synthetic */ Pair access$partitionSettingsFiles(MavenProjectsAware $this, ExternalSystemSettingsFilesReloadContext context2) {
        return $this.partitionSettingsFiles(context2);
    }

    public static final /* synthetic */ String access$join(MavenProjectsAware $this, String parentPath, String relativePath) {
        return $this.join(parentPath, relativePath);
    }

    public static final /* synthetic */ boolean access$hasPomFile(MavenProjectsAware $this, String rootDirectory) {
        return $this.hasPomFile(rootDirectory);
    }
}

