/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectChangesBuilder;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectsTreeUpdateResult;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ParallelRunner;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

public final class MavenProjectsTree {
    private static final Logger LOG = Logger.getInstance(MavenProjectsTree.class);
    private static final String STORAGE_VERSION = MavenProjectsTree.class.getSimpleName() + ".7";
    private final Object myStateLock;
    private final ReentrantReadWriteLock myStructureLock;
    private final Lock myStructureReadLock;
    private final Lock myStructureWriteLock;
    private volatile Set<String> myManagedFilesPaths;
    private volatile List<String> myIgnoredFilesPaths;
    private volatile List<String> myIgnoredFilesPatterns;
    private volatile Pattern myIgnoredFilesPatternsCache;
    private MavenExplicitProfiles myExplicitProfiles;
    private final MavenExplicitProfiles myTemporarilyRemovedExplicitProfiles;
    private final List<MavenProject> myRootProjects;
    private final Map<VirtualFile, MavenProjectTimestamp> myTimestamps;
    private final MavenWorkspaceMap myWorkspaceMap;
    private final Map<MavenId, MavenProject> myMavenIdToProjectMapping;
    private final Map<VirtualFile, MavenProject> myVirtualFileToProjectMapping;
    private final Map<MavenProject, List<MavenProject>> myAggregatorToModuleMapping;
    private final Map<MavenProject, MavenProject> myModuleToAggregatorMapping;
    private final DisposableWrapperList<Listener> myListeners;
    @NotNull
    private final Project myProject;
    private final MavenProjectReaderProjectLocator myProjectLocator;

    public MavenProjectsTree(@NotNull Project project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(0);
        }
        this.myStateLock = new Object();
        this.myStructureLock = new ReentrantReadWriteLock();
        this.myStructureReadLock = this.myStructureLock.readLock();
        this.myStructureWriteLock = this.myStructureLock.writeLock();
        this.myManagedFilesPaths = new LinkedHashSet<String>();
        this.myIgnoredFilesPaths = new ArrayList<String>();
        this.myIgnoredFilesPatterns = new ArrayList<String>();
        this.myExplicitProfiles = MavenExplicitProfiles.NONE;
        this.myTemporarilyRemovedExplicitProfiles = new MavenExplicitProfiles(new HashSet(), new HashSet());
        this.myRootProjects = new ArrayList<MavenProject>();
        this.myTimestamps = new HashMap<VirtualFile, MavenProjectTimestamp>();
        this.myWorkspaceMap = new MavenWorkspaceMap();
        this.myMavenIdToProjectMapping = new HashMap<MavenId, MavenProject>();
        this.myVirtualFileToProjectMapping = new HashMap<VirtualFile, MavenProject>();
        this.myAggregatorToModuleMapping = new HashMap<MavenProject, List<MavenProject>>();
        this.myModuleToAggregatorMapping = new HashMap<MavenProject, MavenProject>();
        this.myListeners = new DisposableWrapperList();
        this.myProjectLocator = new MavenProjectReaderProjectLocator(){

            @Override
            public VirtualFile findProjectFile(MavenId coordinates) {
                MavenProject project2 = MavenProjectsTree.this.findProject(coordinates);
                return project2 == null ? null : project2.getFile();
            }
        };
        this.myProject = project2;
    }

    @NotNull
    Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(1);
        }
        return project2;
    }

    public MavenProjectReaderProjectLocator getProjectLocator() {
        return this.myProjectLocator;
    }

    @Nullable
    public static MavenProjectsTree read(Project project2, Path file) throws IOException {
        DataInputStream in;
        MavenProjectsTree result2;
        block9: {
            result2 = new MavenProjectsTree(project2);
            in = new DataInputStream(new BufferedInputStream(PathKt.inputStream((Path)file)));
            if (STORAGE_VERSION.equals(in.readUTF())) break block9;
            MavenProjectsTree mavenProjectsTree = null;
            in.close();
            return mavenProjectsTree;
        }
        try {
            try {
                result2.myManagedFilesPaths = MavenProjectsTree.readCollection(in, new LinkedHashSet());
                result2.myIgnoredFilesPaths = MavenProjectsTree.readCollection(in, new ArrayList());
                result2.myIgnoredFilesPatterns = MavenProjectsTree.readCollection(in, new ArrayList());
                result2.myExplicitProfiles = new MavenExplicitProfiles(MavenProjectsTree.readCollection(in, new HashSet()), MavenProjectsTree.readCollection(in, new HashSet()));
                result2.myRootProjects.addAll(MavenProjectsTree.readProjectsRecursively(in, result2));
            }
            catch (IOException e) {
                in.close();
                PathKt.delete((Path)file);
                throw e;
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        finally {
            in.close();
        }
        return result2;
    }

    private static <T extends Collection<String>> T readCollection(DataInputStream in, T result2) throws IOException {
        int count = in.readInt();
        while (count-- > 0) {
            result2.add((String)in.readUTF());
        }
        return result2;
    }

    private static void writeCollection(DataOutputStream out, Collection<String> list) throws IOException {
        out.writeInt(list.size());
        for (String each : list) {
            out.writeUTF(each);
        }
    }

    private static List<MavenProject> readProjectsRecursively(DataInputStream in, MavenProjectsTree tree) throws IOException {
        int count = in.readInt();
        ArrayList<MavenProject> result2 = new ArrayList<MavenProject>(count);
        while (count-- > 0) {
            MavenProject project2 = MavenProject.read(in);
            MavenProjectTimestamp timestamp = MavenProjectTimestamp.read(in);
            List<MavenProject> modules = MavenProjectsTree.readProjectsRecursively(in, tree);
            if (project2 == null) continue;
            result2.add(project2);
            tree.myTimestamps.put(project2.getFile(), timestamp);
            tree.myVirtualFileToProjectMapping.put(project2.getFile(), project2);
            tree.fillIDMaps(project2);
            if (modules.isEmpty()) continue;
            tree.myAggregatorToModuleMapping.put(project2, modules);
            for (MavenProject eachModule : modules) {
                tree.myModuleToAggregatorMapping.put(eachModule, project2);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull Path file) throws IOException {
        if (file == null) {
            MavenProjectsTree.$$$reportNull$$$0(2);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.withReadLock(() -> {
                try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(PathKt.outputStream((Path)file, (OpenOption[])new OpenOption[0])));){
                    out.writeUTF(STORAGE_VERSION);
                    MavenProjectsTree.writeCollection(out, this.myManagedFilesPaths);
                    MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPaths);
                    MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPatterns);
                    MavenProjectsTree.writeCollection(out, this.myExplicitProfiles.getEnabledProfiles());
                    MavenProjectsTree.writeCollection(out, this.myExplicitProfiles.getDisabledProfiles());
                    this.writeProjectsRecursively(out, this.myRootProjects);
                }
            });
        }
    }

    private void writeProjectsRecursively(DataOutputStream out, List<MavenProject> mavenProjects2) throws IOException {
        out.writeInt(mavenProjects2.size());
        for (MavenProject mavenProject2 : mavenProjects2) {
            mavenProject2.write(out);
            MavenProjectTimestamp timestamp = this.myTimestamps.getOrDefault(mavenProject2.getFile(), MavenProjectTimestamp.NULL);
            timestamp.write(out);
            this.writeProjectsRecursively(out, this.getModules(mavenProject2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<String> getManagedFilesPaths() {
        Object object = this.myStateLock;
        // MONITORENTER : object
        ArrayList<String> arrayList = new ArrayList<String>(this.myManagedFilesPaths);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        MavenProjectsTree.$$$reportNull$$$0(3);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetManagedFilesPathsAndProfiles(List<String> paths, MavenExplicitProfiles profiles2) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths = new LinkedHashSet<String>(paths);
        }
        this.setExplicitProfiles(profiles2);
    }

    @TestOnly
    public void resetManagedFilesAndProfiles(List<VirtualFile> files2, MavenExplicitProfiles profiles2) {
        this.resetManagedFilesPathsAndProfiles(MavenUtil.collectPaths(files2), profiles2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedFilesWithProfiles(List<VirtualFile> files2, MavenExplicitProfiles profiles2) {
        MavenExplicitProfiles newProfiles;
        ArrayList<String> newFiles;
        Object object = this.myStateLock;
        synchronized (object) {
            newFiles = new ArrayList<String>(this.myManagedFilesPaths);
            newFiles.addAll(MavenUtil.collectPaths(files2));
            newProfiles = this.myExplicitProfiles.clone();
            newProfiles.getEnabledProfiles().addAll(profiles2.getEnabledProfiles());
            newProfiles.getDisabledProfiles().addAll(profiles2.getDisabledProfiles());
        }
        this.resetManagedFilesPathsAndProfiles(newFiles, newProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedFiles(List<VirtualFile> files2) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths.removeAll(MavenUtil.collectPaths(files2));
        }
    }

    public List<VirtualFile> getExistingManagedFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (String path : this.getManagedFilesPaths()) {
            VirtualFile f = LocalFileSystem.getInstance().findFileByPath(path);
            if (f == null || !f.exists()) continue;
            result2.add(f);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPaths);
        }
    }

    public void setIgnoredFilesPaths(List<String> paths) {
        this.doChangeIgnoreStatus(() -> {
            this.myIgnoredFilesPaths = new ArrayList<String>(paths);
        });
    }

    public void removeIgnoredFilesPaths(Collection<String> paths) {
        this.doChangeIgnoreStatus(() -> this.myIgnoredFilesPaths.removeAll(paths));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIgnoredState(MavenProject project2) {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(project2.getPath());
        }
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored) {
        this.setIgnoredState(projects, ignored, false);
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored, boolean fromImport) {
        List pomPaths = ContainerUtil.map(projects, project2 -> project2.getPath());
        this.setIgnoredStateForPoms(pomPaths, ignored, fromImport);
    }

    @ApiStatus.Internal
    public void setIgnoredStateForPoms(List<String> pomPaths, boolean ignored) {
        this.doSetIgnoredState(pomPaths, ignored, false);
    }

    @ApiStatus.Internal
    public void setIgnoredStateForPoms(List<String> pomPaths, boolean ignored, boolean fromImport) {
        this.doSetIgnoredState(pomPaths, ignored, fromImport);
    }

    private void doSetIgnoredState(List<String> pomPaths, boolean ignored, boolean fromImport) {
        this.doChangeIgnoreStatus(() -> {
            if (ignored) {
                this.myIgnoredFilesPaths.addAll(pomPaths);
            } else {
                this.myIgnoredFilesPaths.removeAll(pomPaths);
            }
        }, fromImport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPatterns() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPatterns);
        }
    }

    public void setIgnoredFilesPatterns(List<String> patterns) {
        this.doChangeIgnoreStatus(() -> {
            this.myIgnoredFilesPatternsCache = null;
            this.myIgnoredFilesPatterns = new ArrayList<String>(patterns);
        });
    }

    private void doChangeIgnoreStatus(Runnable runnable) {
        this.doChangeIgnoreStatus(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeIgnoreStatus(Runnable runnable, boolean fromImport) {
        List<MavenProject> ignoredAfter;
        List<MavenProject> ignoredBefore;
        Object object = this.myStateLock;
        synchronized (object) {
            ignoredBefore = this.getIgnoredProjects();
            runnable.run();
            ignoredAfter = this.getIgnoredProjects();
        }
        ArrayList<MavenProject> ignored = new ArrayList<MavenProject>(ignoredAfter);
        ignored.removeAll(ignoredBefore);
        ArrayList<MavenProject> unignored = new ArrayList<MavenProject>(ignoredBefore);
        unignored.removeAll(ignoredAfter);
        if (ignored.isEmpty() && unignored.isEmpty()) {
            return;
        }
        this.fireProjectsIgnoredStateChanged(ignored, unignored, fromImport);
    }

    private List<MavenProject> getIgnoredProjects() {
        ArrayList<MavenProject> result2 = new ArrayList<MavenProject>();
        for (MavenProject each : this.getProjects()) {
            if (!this.isIgnored(each)) continue;
            result2.add(each);
        }
        return result2;
    }

    public boolean isIgnored(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(4);
        }
        String path = project2.getPath();
        return this.isIgnored(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIgnored(String projectPath) {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(projectPath) || this.matchesIgnoredFilesPatterns(projectPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesIgnoredFilesPatterns(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            if (this.myIgnoredFilesPatternsCache == null) {
                this.myIgnoredFilesPatternsCache = Pattern.compile(Strings.translateMasks(this.myIgnoredFilesPatterns));
            }
            return this.myIgnoredFilesPatternsCache.matcher(path).matches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExplicitProfiles getExplicitProfiles() {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myExplicitProfiles.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitProfiles(MavenExplicitProfiles explicitProfiles) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myExplicitProfiles = explicitProfiles.clone();
        }
        this.fireProfilesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExplicitProfiles() {
        Collection<String> available = this.getAvailableProfiles();
        Object object = this.myStateLock;
        synchronized (object) {
            MavenProjectsTree.updateExplicitProfiles(this.myExplicitProfiles.getEnabledProfiles(), this.myTemporarilyRemovedExplicitProfiles.getEnabledProfiles(), available);
            MavenProjectsTree.updateExplicitProfiles(this.myExplicitProfiles.getDisabledProfiles(), this.myTemporarilyRemovedExplicitProfiles.getDisabledProfiles(), available);
        }
    }

    private static void updateExplicitProfiles(Collection<String> explicitProfiles, Collection<String> temporarilyRemovedExplicitProfiles, Collection<String> available) {
        HashSet<String> removedProfiles = new HashSet<String>(explicitProfiles);
        removedProfiles.removeAll(available);
        temporarilyRemovedExplicitProfiles.addAll(removedProfiles);
        HashSet<String> restoredProfiles = new HashSet<String>(temporarilyRemovedExplicitProfiles);
        restoredProfiles.retainAll(available);
        temporarilyRemovedExplicitProfiles.removeAll(restoredProfiles);
        explicitProfiles.removeAll(removedProfiles);
        explicitProfiles.addAll(restoredProfiles);
    }

    public Collection<String> getAvailableProfiles() {
        HashSet<String> res = new HashSet<String>();
        for (MavenProject each : this.getProjects()) {
            res.addAll(each.getProfilesIds());
        }
        return res;
    }

    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        ArrayListSet result2 = new ArrayListSet();
        HashSet<String> available = new HashSet<String>();
        HashSet active = new HashSet();
        for (MavenProject each : this.getProjects()) {
            available.addAll(each.getProfilesIds());
            active.addAll(each.getActivatedProfilesIds().getEnabledProfiles());
        }
        Collection enabledProfiles = this.getExplicitProfiles().getEnabledProfiles();
        Collection disabledProfiles = this.getExplicitProfiles().getDisabledProfiles();
        for (String each : available) {
            MavenProfileKind state2 = disabledProfiles.contains(each) ? MavenProfileKind.NONE : (enabledProfiles.contains(each) ? MavenProfileKind.EXPLICIT : (active.contains(each) ? MavenProfileKind.IMPLICIT : MavenProfileKind.NONE));
            result2.add(Pair.create((Object)each, (Object)state2));
        }
        return result2;
    }

    @Deprecated
    public void updateAll(boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process) {
        this.updateAll(force, generalSettings, process.getIndicator());
    }

    @ApiStatus.Internal
    public MavenProjectsTreeUpdateResult updateAll(boolean force, MavenGeneralSettings generalSettings, ProgressIndicator process) {
        List<VirtualFile> managedFiles = this.getExistingManagedFiles();
        MavenExplicitProfiles explicitProfiles = this.getExplicitProfiles();
        MavenProjectReader projectReader = new MavenProjectReader(this.myProject);
        MavenProjectsTreeUpdateResult updated = this.update(managedFiles, true, force, explicitProfiles, projectReader, generalSettings, process);
        Collection obsoleteFiles = ContainerUtil.subtract(this.getRootProjectsFiles(), managedFiles);
        MavenProjectsTreeUpdateResult deleted = this.delete(projectReader, obsoleteFiles, explicitProfiles, generalSettings, process);
        return updated.plus(deleted);
    }

    @ApiStatus.Internal
    public MavenProjectsTreeUpdateResult update(Collection<VirtualFile> files2, boolean force, MavenGeneralSettings generalSettings, ProgressIndicator process) {
        return this.update(files2, false, force, this.getExplicitProfiles(), new MavenProjectReader(this.myProject), generalSettings, process);
    }

    private MavenProjectsTreeUpdateResult update(Collection<VirtualFile> files2, boolean updateModules, boolean forceRead, MavenExplicitProfiles explicitProfiles, MavenProjectReader projectReader, MavenGeneralSettings generalSettings, ProgressIndicator process) {
        UpdateContext updateContext = new UpdateContext();
        MavenProjectsTreeUpdater updater = new MavenProjectsTreeUpdater(this, explicitProfiles, updateContext, projectReader, generalSettings, process, updateModules);
        HashSet<VirtualFile> filesToAddModules = new HashSet<VirtualFile>();
        for (VirtualFile file : files2) {
            if (null == this.findProject(file)) {
                filesToAddModules.add(file);
            }
            updater.updateProjects(List.of(new UpdateSpec(file, forceRead)));
        }
        for (MavenProject aggregator : this.getProjects()) {
            for (VirtualFile moduleFile : aggregator.getExistingModuleFiles()) {
                if (!filesToAddModules.contains(moduleFile)) continue;
                filesToAddModules.remove(moduleFile);
                MavenProject mavenProject2 = this.findProject(moduleFile);
                if (null == mavenProject2 || !this.reconnect(aggregator, mavenProject2)) continue;
                updateContext.updated(mavenProject2, MavenProjectChanges.NONE);
            }
        }
        for (VirtualFile file : filesToAddModules) {
            MavenProject mavenProject3 = this.findProject(file);
            if (null == mavenProject3) continue;
            this.addRootModule(mavenProject3);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary();
        return updateContext.toUpdateResult();
    }

    private MavenProjectTimestamp calculateTimestamp(MavenProject mavenProject2, MavenExplicitProfiles explicitProfiles, MavenGeneralSettings generalSettings) {
        return (MavenProjectTimestamp)ReadAction.compute(() -> {
            long pomTimestamp = MavenProjectsTree.getFileTimestamp(mavenProject2.getFile());
            MavenProject parent = this.findParent(mavenProject2);
            long parentLastReadStamp = parent == null ? -1L : parent.getLastReadStamp();
            VirtualFile profilesXmlFile = mavenProject2.getProfilesXmlFile();
            long profilesTimestamp = MavenProjectsTree.getFileTimestamp(profilesXmlFile);
            VirtualFile jvmConfigFile = MavenUtil.getConfigFile(mavenProject2, "/.mvn/jvm.config");
            long jvmConfigTimestamp = MavenProjectsTree.getFileTimestamp(jvmConfigFile);
            VirtualFile mavenConfigFile = MavenUtil.getConfigFile(mavenProject2, "/.mvn/maven.config");
            long mavenConfigTimestamp = MavenProjectsTree.getFileTimestamp(mavenConfigFile);
            long userSettingsTimestamp = MavenProjectsTree.getFileTimestamp(generalSettings.getEffectiveUserSettingsFile());
            long globalSettingsTimestamp = MavenProjectsTree.getFileTimestamp(generalSettings.getEffectiveGlobalSettingsFile());
            int profilesHashCode = explicitProfiles.hashCode();
            return new MavenProjectTimestamp(pomTimestamp, parentLastReadStamp, profilesTimestamp, userSettingsTimestamp, globalSettingsTimestamp, profilesHashCode, jvmConfigTimestamp, mavenConfigTimestamp);
        });
    }

    public String toString() {
        return "MavenProjectsTree{myRootProjects=" + this.myRootProjects + ", myProject=" + this.myProject + "}";
    }

    private static long getFileTimestamp(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return -1L;
        }
        return file.getTimeStamp();
    }

    public boolean isManagedFile(VirtualFile moduleFile) {
        return this.isManagedFile(moduleFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManagedFile(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            for (String each : this.myManagedFilesPaths) {
                if (!FileUtil.pathsEqual((String)each, (String)path)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isPotentialProject(String path) {
        if (this.isManagedFile(path)) {
            return true;
        }
        for (MavenProject each : this.getProjects()) {
            if (VfsUtilCore.pathEqualsTo((VirtualFile)each.getFile(), (String)path)) {
                return true;
            }
            if (!each.getModulePaths().contains(path)) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public MavenProjectsTreeUpdateResult delete(List<VirtualFile> files2, MavenGeneralSettings generalSettings, ProgressIndicator process) {
        return this.delete(new MavenProjectReader(this.myProject), files2, this.getExplicitProfiles(), generalSettings, process);
    }

    private MavenProjectsTreeUpdateResult delete(MavenProjectReader projectReader, Collection<VirtualFile> files2, MavenExplicitProfiles explicitProfiles, MavenGeneralSettings generalSettings, ProgressIndicator process) {
        UpdateContext updateContext = new UpdateContext();
        HashSet<MavenProject> inheritorsToUpdate = new HashSet<MavenProject>();
        for (VirtualFile each : files2) {
            MavenProject mavenProject2 = this.findProject(each);
            if (mavenProject2 == null) continue;
            inheritorsToUpdate.addAll(this.findInheritors(mavenProject2));
            this.doDelete(this.findAggregator(mavenProject2), mavenProject2, updateContext);
        }
        inheritorsToUpdate.removeAll(updateContext.getDeletedProjects());
        MavenProjectsTreeUpdater updater = new MavenProjectsTreeUpdater(this, explicitProfiles, updateContext, projectReader, generalSettings, process, false);
        ArrayList<UpdateSpec> updateSpecs = new ArrayList<UpdateSpec>();
        for (MavenProject mavenProject3 : inheritorsToUpdate) {
            updateSpecs.add(new UpdateSpec(mavenProject3.getFile(), false));
        }
        updater.updateProjects(updateSpecs);
        for (MavenProject mavenProject3 : inheritorsToUpdate) {
            if (!this.reconnectRoot(mavenProject3)) continue;
            updateContext.updated(mavenProject3, MavenProjectChanges.NONE);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary();
        return updateContext.toUpdateResult();
    }

    private void doDelete(MavenProject aggregator, MavenProject project2, UpdateContext updateContext) {
        for (MavenProject each : this.getModules(project2)) {
            if (this.isManagedFile(each.getPath())) {
                if (!this.reconnectRoot(each)) continue;
                updateContext.updated(each, MavenProjectChanges.NONE);
                continue;
            }
            this.doDelete(project2, each, updateContext);
        }
        this.withWriteLock(() -> {
            if (aggregator != null) {
                this.removeModule(aggregator, project2);
            } else {
                this.myRootProjects.remove(project2);
            }
            this.myTimestamps.remove(project2.getFile());
            this.myVirtualFileToProjectMapping.remove(project2.getFile());
            this.clearIDMaps(project2.getMavenId());
            this.myAggregatorToModuleMapping.remove(project2);
            this.myModuleToAggregatorMapping.remove(project2);
        });
        updateContext.deleted(project2);
    }

    private void fillIDMaps(MavenProject mavenProject2) {
        MavenId id = mavenProject2.getMavenId();
        this.myWorkspaceMap.register(id, new File(mavenProject2.getFile().getPath()));
        this.myMavenIdToProjectMapping.put(id, mavenProject2);
    }

    private void clearIDMaps(MavenId mavenId) {
        if (null == mavenId) {
            return;
        }
        this.myWorkspaceMap.unregister(mavenId);
        this.myMavenIdToProjectMapping.remove(mavenId);
    }

    private static Path mavenProjectToNioPath(@NotNull MavenProject mavenProject2) {
        if (mavenProject2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(5);
        }
        return Path.of(mavenProject2.getFile().getParent().getPath(), new String[0]);
    }

    private void addRootModule(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(6);
        }
        this.withWriteLock(() -> {
            this.myRootProjects.add(project2);
            this.myRootProjects.sort(Comparator.comparing(MavenProjectsTree::mavenProjectToNioPath));
        });
    }

    private boolean reconnect(@NotNull MavenProject newAggregator, @NotNull MavenProject project2) {
        MavenProject prevAggregator;
        if (newAggregator == null) {
            MavenProjectsTree.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(8);
        }
        if ((prevAggregator = this.findAggregator(project2)) == newAggregator) {
            return false;
        }
        this.withWriteLock(() -> {
            if (prevAggregator != null) {
                this.removeModule(prevAggregator, project2);
            } else {
                this.myRootProjects.remove(project2);
            }
            this.addModule(newAggregator, project2);
        });
        return true;
    }

    private boolean reconnectRoot(@NotNull MavenProject project2) {
        MavenProject prevAggregator;
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(9);
        }
        if ((prevAggregator = this.findAggregator(project2)) == null) {
            return false;
        }
        this.withWriteLock(() -> {
            this.removeModule(prevAggregator, project2);
            this.addRootModule(project2);
        });
        return true;
    }

    public boolean hasProjects() {
        return this.withReadLock(() -> !this.myRootProjects.isEmpty());
    }

    public List<MavenProject> getRootProjects() {
        return this.withReadLock(() -> new ArrayList<MavenProject>(this.myRootProjects));
    }

    private static void updateCrc(CRC32 crc, int x) {
        crc.update(x & 0xFF);
        crc.update((x >>>= 8) & 0xFF);
        crc.update((x >>>= 8) & 0xFF);
        crc.update(x >>>= 8);
    }

    private static void updateCrc(CRC32 crc, long l) {
        MavenProjectsTree.updateCrc(crc, (int)l);
        MavenProjectsTree.updateCrc(crc, (int)(l >>> 32));
    }

    private static void updateCrc(CRC32 crc, @Nullable String s) {
        if (s == null) {
            crc.update(111);
        } else {
            MavenProjectsTree.updateCrc(crc, s.hashCode());
            crc.update(s.length() & 0xFF);
        }
    }

    @NotNull
    public static Collection<String> getFilterExclusions(MavenProject mavenProject2) {
        Element config = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (config == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                MavenProjectsTree.$$$reportNull$$$0(10);
            }
            return set;
        }
        List<String> customNonFilteredExtensions = MavenJDOMUtil.findChildrenValuesByPath(config, "nonFilteredFileExtensions", "nonFilteredFileExtension");
        if (customNonFilteredExtensions.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                MavenProjectsTree.$$$reportNull$$$0(11);
            }
            return set;
        }
        List<String> list = Collections.unmodifiableList(customNonFilteredExtensions);
        if (list == null) {
            MavenProjectsTree.$$$reportNull$$$0(12);
        }
        return list;
    }

    public int getFilterConfigCrc(@NotNull ProjectFileIndex fileIndex) {
        if (fileIndex == null) {
            MavenProjectsTree.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.withReadLock(() -> {
            final CRC32 crc = new CRC32();
            MavenExplicitProfiles profiles2 = this.myExplicitProfiles;
            if (profiles2 != null) {
                MavenProjectsTree.updateCrc(crc, profiles2.hashCode());
            }
            Collection<MavenProject> allProjects = this.myVirtualFileToProjectMapping.values();
            crc.update(allProjects.size() & 0xFF);
            for (MavenProject mavenProject2 : allProjects) {
                VirtualFile pomFile = mavenProject2.getFile();
                Module module2 = fileIndex.getModuleForFile(pomFile);
                if (module2 == null || !Comparing.equal((Object)fileIndex.getContentRootForFile(pomFile), (Object)pomFile.getParent())) continue;
                MavenProjectsTree.updateCrc(crc, module2.getName());
                MavenId mavenId = mavenProject2.getMavenId();
                MavenProjectsTree.updateCrc(crc, mavenId.getGroupId());
                MavenProjectsTree.updateCrc(crc, mavenId.getArtifactId());
                MavenProjectsTree.updateCrc(crc, mavenId.getVersion());
                MavenId parentId = mavenProject2.getParentId();
                if (parentId != null) {
                    MavenProjectsTree.updateCrc(crc, parentId.getGroupId());
                    MavenProjectsTree.updateCrc(crc, parentId.getArtifactId());
                    MavenProjectsTree.updateCrc(crc, parentId.getVersion());
                }
                MavenProjectsTree.updateCrc(crc, mavenProject2.getDirectory());
                MavenProjectsTree.updateCrc(crc, MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject2).pattern());
                MavenProjectsTree.updateCrc(crc, mavenProject2.getModelMap().hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject2.getResources().hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject2.getTestResources().hashCode());
                MavenProjectsTree.updateCrc(crc, MavenProjectsTree.getFilterExclusions(mavenProject2).hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject2.getProperties().hashCode());
                for (String each : mavenProject2.getFilterPropertiesFiles()) {
                    File file = new File(each);
                    MavenProjectsTree.updateCrc(crc, file.lastModified());
                }
                XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
                Writer crcWriter = new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) {
                        int end = off + len;
                        for (int i2 = off; i2 < end; ++i2) {
                            crc.update(cbuf[i2]);
                        }
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void close() {
                    }
                };
                try {
                    Element warPluginCfg;
                    Element resourcePluginCfg = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
                    if (resourcePluginCfg != null) {
                        outputter.output(resourcePluginCfg, crcWriter);
                    }
                    if ((warPluginCfg = mavenProject2.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin")) == null) continue;
                    outputter.output(warPluginCfg, crcWriter);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            return (int)crc.getValue();
        });
    }

    public List<VirtualFile> getRootProjectsFiles() {
        return MavenUtil.collectFiles(this.getRootProjects());
    }

    public List<MavenProject> getProjects() {
        return this.withReadLock(() -> new ArrayList<MavenProject>(this.myVirtualFileToProjectMapping.values()));
    }

    public List<MavenProject> getNonIgnoredProjects() {
        return this.withReadLock(() -> {
            ArrayList<MavenProject> result2 = new ArrayList<MavenProject>();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (this.isIgnored(each)) continue;
                result2.add(each);
            }
            return result2;
        });
    }

    public List<VirtualFile> getProjectsFiles() {
        return this.withReadLock(() -> new ArrayList<VirtualFile>(this.myVirtualFileToProjectMapping.keySet()));
    }

    @NotNull
    private MavenProject findOrCreateProject(VirtualFile f) {
        MavenProject mavenProject2 = this.findProject(f);
        MavenProject mavenProject3 = null == mavenProject2 ? new MavenProject(f) : mavenProject2;
        if (mavenProject3 == null) {
            MavenProjectsTree.$$$reportNull$$$0(14);
        }
        return mavenProject3;
    }

    @Nullable
    public MavenProject findProject(VirtualFile f) {
        return this.withReadLock(() -> this.myVirtualFileToProjectMapping.get(f));
    }

    @Nullable
    public MavenProject findProject(MavenId id) {
        return this.withReadLock(() -> this.myMavenIdToProjectMapping.get(id));
    }

    @Nullable
    public MavenProject findProject(MavenArtifact artifact) {
        return this.findProject(artifact.getMavenId());
    }

    public MavenProject findSingleProjectInReactor(MavenId id) {
        return this.withReadLock(() -> ((Optional)StreamEx.ofValues(this.myMavenIdToProjectMapping).collect(MoreCollectors.onlyOne(it -> StringUtil.equals((CharSequence)it.getMavenId().getArtifactId(), (CharSequence)id.getArtifactId()) && StringUtil.equals((CharSequence)it.getMavenId().getGroupId(), (CharSequence)id.getGroupId())))).orElse(null));
    }

    MavenWorkspaceMap getWorkspaceMap() {
        return this.withReadLock(() -> this.myWorkspaceMap.copy());
    }

    public MavenProject findAggregator(MavenProject project2) {
        return this.withReadLock(() -> this.myModuleToAggregatorMapping.get(project2));
    }

    @NotNull
    public Collection<MavenProject> collectAggregators(@NotNull Collection<MavenProject> mavenProjects2) {
        if (mavenProjects2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(15);
        }
        HashSet<MavenProject> mavenProjectsToSkip = new HashSet<MavenProject>();
        Iterator<MavenProject> iterator = mavenProjects2.iterator();
        block0: while (iterator.hasNext()) {
            MavenProject mavenProject3;
            MavenProject aggregator = mavenProject3 = iterator.next();
            while ((aggregator = this.findAggregator(aggregator)) != null) {
                if (!mavenProjects2.contains(aggregator)) continue;
                mavenProjectsToSkip.add(mavenProject3);
                continue block0;
            }
        }
        List<MavenProject> list = mavenProjects2.stream().filter(mavenProject2 -> !mavenProjectsToSkip.contains(mavenProject2)).toList();
        if (list == null) {
            MavenProjectsTree.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public MavenProject findRootProject(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(17);
        }
        MavenProject mavenProject2 = this.withReadLock(() -> {
            MavenProject rootProject = project2;
            MavenProject aggregator;
            while ((aggregator = this.myModuleToAggregatorMapping.get(rootProject)) != null) {
                rootProject = aggregator;
            }
            return rootProject;
        });
        if (mavenProject2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(18);
        }
        return mavenProject2;
    }

    public List<MavenProject> getModules(MavenProject aggregator) {
        return this.withReadLock(() -> {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            return modules == null ? Collections.emptyList() : new ArrayList<MavenProject>(modules);
        });
    }

    private void addModule(@NotNull MavenProject aggregator, @NotNull MavenProject module2) {
        if (aggregator == null) {
            MavenProjectsTree.$$$reportNull$$$0(19);
        }
        if (module2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(20);
        }
        this.withWriteLock(() -> {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules == null) {
                modules = new ArrayList<MavenProject>();
                this.myAggregatorToModuleMapping.put(aggregator, modules);
            }
            modules.add(module2);
            this.myModuleToAggregatorMapping.put(module2, aggregator);
        });
    }

    private void removeModule(MavenProject aggregator, MavenProject module2) {
        this.withWriteLock(() -> {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules == null) {
                return;
            }
            modules.remove(module2);
            if (modules.isEmpty()) {
                this.myAggregatorToModuleMapping.remove(aggregator);
            }
            this.myModuleToAggregatorMapping.remove(module2);
        });
    }

    private MavenProject findParent(MavenProject project2) {
        return this.findProject(project2.getParentId());
    }

    public Collection<MavenProject> findInheritors(MavenProject project2) {
        if (project2.isNew()) {
            return List.of();
        }
        return this.withReadLock(() -> {
            ArrayList<MavenProject> result2 = null;
            MavenId id = project2.getMavenId();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (each == project2 || !id.equals((Object)each.getParentId())) continue;
                if (result2 == null) {
                    result2 = new ArrayList<MavenProject>();
                }
                result2.add(each);
            }
            return result2 == null ? List.of() : result2;
        });
    }

    public List<MavenProject> getDependentProjects(Collection<MavenProject> projects) {
        return this.withReadLock(() -> {
            ArrayList<MavenProject> result2 = null;
            ObjectOpenCustomHashSet projectIds = new ObjectOpenCustomHashSet(projects.size(), (Hash.Strategy)new MavenCoordinateHashCodeStrategy());
            for (MavenProject project2 : projects) {
                projectIds.add(project2.getMavenId());
            }
            Set projectPaths = FileCollectionFactory.createCanonicalFileSet();
            for (MavenProject project3 : projects) {
                projectPaths.add(new File(project3.getFile().getPath()));
            }
            for (MavenProject project3 : this.myVirtualFileToProjectMapping.values()) {
                boolean isDependent = false;
                Set<String> pathsInStack = project3.getModulePaths();
                for (String path : pathsInStack) {
                    if (!projectPaths.contains(new File(path))) continue;
                    isDependent = true;
                    break;
                }
                if (!isDependent) {
                    for (MavenArtifact dep : project3.getDependencies()) {
                        if (!projectIds.contains(dep)) continue;
                        isDependent = true;
                        break;
                    }
                }
                if (!isDependent) continue;
                if (result2 == null) {
                    result2 = new ArrayList<MavenProject>();
                }
                result2.add(project3);
            }
            return result2 == null ? Collections.emptyList() : result2;
        });
    }

    public <Result> Result visit(Visitor<Result> visitor) {
        for (MavenProject each : this.getRootProjects()) {
            if (visitor.isDone()) break;
            this.doVisit(each, visitor);
        }
        return visitor.getResult();
    }

    private <Result> void doVisit(MavenProject project2, Visitor<Result> visitor) {
        if (!visitor.isDone() && visitor.shouldVisit(project2)) {
            visitor.visit(project2);
            for (MavenProject each : this.getModules(project2)) {
                if (visitor.isDone()) break;
                this.doVisit(each, visitor);
            }
            visitor.leave(project2);
        }
    }

    public void addListener(@NotNull Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            MavenProjectsTree.$$$reportNull$$$0(21);
        }
        if (disposable == null) {
            MavenProjectsTree.$$$reportNull$$$0(22);
        }
        if (!this.myListeners.contains((Object)l)) {
            this.myListeners.add((Object)l, disposable);
        } else {
            MavenLog.LOG.warn("Trying to add the same listener twice");
        }
    }

    @ApiStatus.Internal
    void addListenersFrom(MavenProjectsTree other) {
        this.myListeners.addAll(other.myListeners);
    }

    void fireProfilesChanged() {
        for (Listener each : this.myListeners) {
            each.profilesChanged();
        }
    }

    void fireProjectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
        if (ignored == null) {
            MavenProjectsTree.$$$reportNull$$$0(23);
        }
        if (unignored == null) {
            MavenProjectsTree.$$$reportNull$$$0(24);
        }
        for (Listener each : this.myListeners) {
            each.projectsIgnoredStateChanged(ignored, unignored, fromImport);
        }
    }

    void fireProjectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
        if (updated == null) {
            MavenProjectsTree.$$$reportNull$$$0(25);
        }
        if (deleted == null) {
            MavenProjectsTree.$$$reportNull$$$0(26);
        }
        for (Listener each : this.myListeners) {
            each.projectsUpdated(updated, deleted);
        }
    }

    void fireProjectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
        if (projectWithChanges == null) {
            MavenProjectsTree.$$$reportNull$$$0(27);
        }
        for (Listener each : this.myListeners) {
            each.projectResolved(projectWithChanges, nativeMavenProject);
        }
    }

    void firePluginsResolved(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(28);
        }
        for (Listener each : this.myListeners) {
            each.pluginsResolved(project2);
        }
    }

    void fireFoldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        if (projectWithChanges == null) {
            MavenProjectsTree.$$$reportNull$$$0(29);
        }
        for (Listener each : this.myListeners) {
            each.foldersResolved(projectWithChanges);
        }
    }

    void fireArtifactsDownloaded(@NotNull MavenProject project2) {
        if (project2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(30);
        }
        for (Listener each : this.myListeners) {
            each.artifactsDownloaded(project2);
        }
    }

    public MavenProjectsTree getCopyForReimport() {
        return this.withReadLock(() -> {
            MavenProjectsTree result2 = new MavenProjectsTree(this.myProject);
            result2.myExplicitProfiles = this.myExplicitProfiles;
            result2.myRootProjects.addAll(this.myRootProjects);
            result2.myIgnoredFilesPaths.addAll(this.myIgnoredFilesPaths);
            result2.myIgnoredFilesPatterns.addAll(this.myIgnoredFilesPatterns);
            MavenProjectsTree.deepCopyInto(this.myAggregatorToModuleMapping, result2.myAggregatorToModuleMapping);
            result2.myIgnoredFilesPatternsCache = this.myIgnoredFilesPatternsCache;
            result2.myManagedFilesPaths.addAll(this.myManagedFilesPaths);
            result2.myMavenIdToProjectMapping.putAll(this.myMavenIdToProjectMapping);
            result2.myModuleToAggregatorMapping.putAll(this.myModuleToAggregatorMapping);
            result2.myVirtualFileToProjectMapping.putAll(this.myVirtualFileToProjectMapping);
            result2.myTimestamps.putAll(this.myTimestamps);
            this.myWorkspaceMap.copyInto(result2.myWorkspaceMap);
            return result2;
        });
    }

    private static <K, V> Map<K, List<V>> deepCopyInto(Map<K, List<V>> from, Map<K, List<V>> to) {
        return MavenProjectsTree.deepCopyInto(from, to, Function.identity());
    }

    private static <K, V> Map<K, List<V>> deepCopyInto(Map<K, List<V>> from, Map<K, List<V>> to, Function<V, V> copyFunc) {
        for (Map.Entry<K, List<V>> entry : from.entrySet()) {
            ArrayList<V> newVal = new ArrayList<V>(entry.getValue().size());
            for (V v : entry.getValue()) {
                newVal.add(copyFunc.apply(v));
            }
            to.put(entry.getKey(), newVal);
        }
        return to;
    }

    private <T extends Throwable> void withReadLock(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            MavenProjectsTree.$$$reportNull$$$0(31);
        }
        this.myStructureReadLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.myStructureReadLock.unlock();
        }
    }

    private <T extends Throwable, V> V withReadLock(@NotNull ThrowableCallable<T, V> callable) throws T {
        if (callable == null) {
            MavenProjectsTree.$$$reportNull$$$0(32);
        }
        this.myStructureReadLock.lock();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.myStructureReadLock.unlock();
        }
    }

    private <T extends Throwable> void withWriteLock(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            MavenProjectsTree.$$$reportNull$$$0(33);
        }
        this.myStructureWriteLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.myStructureWriteLock.unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 10, 11, 12, 14, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAggregator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjects";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aggregator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unignored";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updated";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectWithChanges";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagedFilesPaths";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterExclusions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAggregators";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mavenProjectToNioPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRootModule";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reconnect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reconnectRoot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFilterConfigCrc";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAggregators";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findRootProject";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectsIgnoredStateChanged";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectsUpdated";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectResolved";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "firePluginsResolved";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fireFoldersResolved";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fireArtifactsDownloaded";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "withReadLock";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "withWriteLock";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 10, 11, 12, 14, 16, 18 -> new IllegalStateException(string);
        };
    }

    private static final class MavenProjectTimestamp {
        private final long myPomTimestamp;
        private final long myParentLastReadStamp;
        private final long myProfilesTimestamp;
        private final long myUserSettingsTimestamp;
        private final long myGlobalSettingsTimestamp;
        private final long myExplicitProfilesHashCode;
        private final long myJvmConfigTimestamp;
        private final long myMavenConfigTimestamp;
        private static MavenProjectTimestamp NULL = new MavenProjectTimestamp(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);

        private MavenProjectTimestamp(long pomTimestamp, long parentLastReadStamp, long profilesTimestamp, long userSettingsTimestamp, long globalSettingsTimestamp, long explicitProfilesHashCode, long jvmConfigTimestamp, long mavenConfigTimestamp) {
            this.myPomTimestamp = pomTimestamp;
            this.myParentLastReadStamp = parentLastReadStamp;
            this.myProfilesTimestamp = profilesTimestamp;
            this.myUserSettingsTimestamp = userSettingsTimestamp;
            this.myGlobalSettingsTimestamp = globalSettingsTimestamp;
            this.myExplicitProfilesHashCode = explicitProfilesHashCode;
            this.myJvmConfigTimestamp = jvmConfigTimestamp;
            this.myMavenConfigTimestamp = mavenConfigTimestamp;
        }

        public static MavenProjectTimestamp read(DataInputStream in) throws IOException {
            return new MavenProjectTimestamp(in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong());
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeLong(this.myPomTimestamp);
            out.writeLong(this.myParentLastReadStamp);
            out.writeLong(this.myProfilesTimestamp);
            out.writeLong(this.myUserSettingsTimestamp);
            out.writeLong(this.myGlobalSettingsTimestamp);
            out.writeLong(this.myExplicitProfilesHashCode);
            out.writeLong(this.myJvmConfigTimestamp);
            out.writeLong(this.myMavenConfigTimestamp);
        }

        public String toString() {
            return "(" + this.myPomTimestamp + ":" + this.myParentLastReadStamp + ":" + this.myProfilesTimestamp + ":" + this.myUserSettingsTimestamp + ":" + this.myGlobalSettingsTimestamp + ":" + this.myExplicitProfilesHashCode + ":" + this.myJvmConfigTimestamp + ":" + this.myMavenConfigTimestamp + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenProjectTimestamp timestamp = (MavenProjectTimestamp)o;
            if (this.myPomTimestamp != timestamp.myPomTimestamp) {
                return false;
            }
            if (this.myParentLastReadStamp != timestamp.myParentLastReadStamp) {
                return false;
            }
            if (this.myProfilesTimestamp != timestamp.myProfilesTimestamp) {
                return false;
            }
            if (this.myUserSettingsTimestamp != timestamp.myUserSettingsTimestamp) {
                return false;
            }
            if (this.myGlobalSettingsTimestamp != timestamp.myGlobalSettingsTimestamp) {
                return false;
            }
            if (this.myExplicitProfilesHashCode != timestamp.myExplicitProfilesHashCode) {
                return false;
            }
            if (this.myJvmConfigTimestamp != timestamp.myJvmConfigTimestamp) {
                return false;
            }
            return this.myMavenConfigTimestamp == timestamp.myMavenConfigTimestamp;
        }

        public int hashCode() {
            int result2 = 0;
            result2 = 31 * result2 + (int)(this.myPomTimestamp ^ this.myPomTimestamp >>> 32);
            result2 = 31 * result2 + (int)(this.myParentLastReadStamp ^ this.myParentLastReadStamp >>> 32);
            result2 = 31 * result2 + (int)(this.myProfilesTimestamp ^ this.myProfilesTimestamp >>> 32);
            result2 = 31 * result2 + (int)(this.myUserSettingsTimestamp ^ this.myUserSettingsTimestamp >>> 32);
            result2 = 31 * result2 + (int)(this.myGlobalSettingsTimestamp ^ this.myGlobalSettingsTimestamp >>> 32);
            result2 = 31 * result2 + (int)(this.myExplicitProfilesHashCode ^ this.myExplicitProfilesHashCode >>> 32);
            result2 = 31 * result2 + (int)(this.myJvmConfigTimestamp ^ this.myJvmConfigTimestamp >>> 32);
            result2 = 31 * result2 + (int)(this.myMavenConfigTimestamp ^ this.myMavenConfigTimestamp >>> 32);
            return result2;
        }
    }

    private class UpdateContext {
        private final Map<MavenProject, MavenProjectChanges> updatedProjectsWithChanges = new ConcurrentHashMap<MavenProject, MavenProjectChanges>();
        private final Set<MavenProject> deletedProjects = ConcurrentHashMap.newKeySet();

        private UpdateContext() {
        }

        public void updated(MavenProject project2, @NotNull MavenProjectChanges changes) {
            if (changes == null) {
                UpdateContext.$$$reportNull$$$0(0);
            }
            this.deletedProjects.remove(project2);
            this.updatedProjectsWithChanges.compute(project2, (__, previousChanges) -> previousChanges == null ? changes : MavenProjectChangesBuilder.merged(changes, previousChanges));
        }

        public void deleted(MavenProject project2) {
            this.updatedProjectsWithChanges.remove(project2);
            this.deletedProjects.add(project2);
        }

        public MavenProjectsTreeUpdateResult toUpdateResult() {
            return new MavenProjectsTreeUpdateResult(this.mapToListWithPairs(), new ArrayList<MavenProject>(this.deletedProjects));
        }

        public void fireUpdatedIfNecessary() {
            if (this.updatedProjectsWithChanges.isEmpty() && this.deletedProjects.isEmpty()) {
                return;
            }
            List<Pair<MavenProject, MavenProjectChanges>> updated = this.mapToListWithPairs();
            ArrayList<MavenProject> deleted = new ArrayList<MavenProject>(this.deletedProjects);
            MavenProjectsTree.this.fireProjectsUpdated(updated, deleted);
        }

        @NotNull
        private List<Pair<MavenProject, MavenProjectChanges>> mapToListWithPairs() {
            ArrayList<Pair<MavenProject, MavenProjectChanges>> result2 = new ArrayList<Pair<MavenProject, MavenProjectChanges>>(this.updatedProjectsWithChanges.size());
            for (Map.Entry<MavenProject, MavenProjectChanges> entry : this.updatedProjectsWithChanges.entrySet()) {
                entry.getKey().getProblems();
                result2.add((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
            }
            ArrayList<Pair<MavenProject, MavenProjectChanges>> arrayList = result2;
            if (arrayList == null) {
                UpdateContext.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        public Collection<MavenProject> getDeletedProjects() {
            return this.deletedProjects;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsTree$UpdateContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsTree$UpdateContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mapToListWithPairs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updated";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MavenProjectsTreeUpdater {
        private final MavenProjectsTree tree;
        private final MavenExplicitProfiles explicitProfiles;
        private final UpdateContext updateContext;
        private final MavenProjectReader reader;
        private final MavenGeneralSettings generalSettings;
        private final ProgressIndicator process;
        private final ConcurrentHashMap<VirtualFile, Boolean> updated = new ConcurrentHashMap();
        private final boolean updateModules;

        MavenProjectsTreeUpdater(MavenProjectsTree tree, MavenExplicitProfiles profiles2, UpdateContext context2, MavenProjectReader reader, MavenGeneralSettings settings, ProgressIndicator process, boolean updateModules) {
            this.tree = tree;
            this.explicitProfiles = profiles2;
            this.updateContext = context2;
            this.reader = reader;
            this.generalSettings = settings;
            this.process = process;
            this.updateModules = updateModules;
        }

        private boolean startUpdate(VirtualFile mavenProjectFile, boolean forceRead) {
            String projectPath = mavenProjectFile.getPath();
            if (this.tree.isIgnored(projectPath)) {
                return false;
            }
            Ref previousUpdateRef = new Ref();
            this.updated.compute(mavenProjectFile, (file, value) -> {
                previousUpdateRef.set(value);
                return Boolean.TRUE.equals(value) || forceRead;
            });
            Boolean previousUpdate = (Boolean)previousUpdateRef.get();
            if (null != previousUpdate && !forceRead || Boolean.TRUE.equals(previousUpdate)) {
                MavenLog.LOG.debug("Has already been updated (%s): %s; forceRead: %s".formatted(previousUpdate, mavenProjectFile, forceRead));
                return false;
            }
            if (null != this.process) {
                this.process.setText(MavenProjectBundle.message("maven.reading.pom", projectPath));
                this.process.setText2("");
            }
            return true;
        }

        private boolean readPomIfNeeded(MavenProject mavenProject2, boolean forceRead) {
            boolean readPom;
            MavenProjectTimestamp timestamp = this.tree.calculateTimestamp(mavenProject2, this.explicitProfiles, this.generalSettings);
            boolean timeStampChanged = !timestamp.equals(this.tree.myTimestamps.get(mavenProject2.getFile()));
            boolean bl = readPom = forceRead || timeStampChanged;
            if (readPom) {
                MavenId oldProjectId = mavenProject2.isNew() ? null : mavenProject2.getMavenId();
                MavenId oldParentId = mavenProject2.getParentId();
                MavenProjectChanges readChanges = mavenProject2.read(this.generalSettings, this.explicitProfiles, this.reader, this.tree.myProjectLocator);
                this.tree.withWriteLock(() -> {
                    this.tree.clearIDMaps(oldProjectId);
                    this.tree.myVirtualFileToProjectMapping.put(mavenProject2.getFile(), mavenProject2);
                    this.tree.fillIDMaps(mavenProject2);
                });
                if (Comparing.equal((Object)oldParentId, (Object)mavenProject2.getParentId())) {
                    this.tree.myTimestamps.put(mavenProject2.getFile(), timestamp);
                } else {
                    MavenProjectTimestamp newTimestamp = this.tree.calculateTimestamp(mavenProject2, this.explicitProfiles, this.generalSettings);
                    this.tree.myTimestamps.put(mavenProject2.getFile(), newTimestamp);
                }
                MavenProjectChanges forcedChanges = forceRead ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
                MavenProjectChangesBuilder changes = MavenProjectChangesBuilder.merged(forcedChanges, readChanges);
                this.updateContext.updated(mavenProject2, changes);
            }
            return readPom;
        }

        private void handleRemovedModules(MavenProject mavenProject2, List<MavenProject> prevModules, List<VirtualFile> existingModuleFiles) {
            List removedModules = ContainerUtil.filter(prevModules, prevModule -> !existingModuleFiles.contains(prevModule.getFile()));
            for (MavenProject module2 : removedModules) {
                VirtualFile moduleFile = module2.getFile();
                if (this.tree.isManagedFile(moduleFile)) {
                    if (!this.tree.reconnectRoot(module2)) continue;
                    this.updateContext.updated(module2, MavenProjectChanges.NONE);
                    continue;
                }
                this.tree.removeModule(mavenProject2, module2);
                this.tree.doDelete(mavenProject2, module2, this.updateContext);
            }
        }

        private void reconnectModuleFiles(MavenProject mavenProject2, List<VirtualFile> modulesFilesToReconnect) {
            for (VirtualFile file : modulesFilesToReconnect) {
                MavenProject module2 = this.tree.findProject(file);
                if (null == module2 || !this.tree.reconnect(mavenProject2, module2)) continue;
                this.updateContext.updated(module2, MavenProjectChanges.NONE);
            }
        }

        private List<VirtualFile> collectModuleFilesToReconnect(MavenProject mavenProject2, List<VirtualFile> existingModuleFiles) {
            ArrayList<VirtualFile> modulesFilesToReconnect = new ArrayList<VirtualFile>();
            for (VirtualFile moduleFile : existingModuleFiles) {
                MavenProject currentAggregator;
                boolean isNewModule;
                MavenProject foundModule = this.tree.findProject(moduleFile);
                boolean bl = isNewModule = foundModule == null;
                if (!isNewModule && (currentAggregator = this.tree.findAggregator(foundModule)) != null && currentAggregator != mavenProject2) {
                    MavenLog.LOG.info("Module " + moduleFile + " is already included into " + mavenProject2.getFile());
                    continue;
                }
                modulesFilesToReconnect.add(moduleFile);
            }
            return modulesFilesToReconnect;
        }

        private List<VirtualFile> collectModuleFilesToUpdate(List<VirtualFile> moduleFilesToReconnect, boolean updateExistingModules) {
            if (updateExistingModules) {
                return moduleFilesToReconnect;
            }
            return ContainerUtil.filter(moduleFilesToReconnect, moduleFile -> null == this.tree.findProject((VirtualFile)moduleFile));
        }

        private List<VirtualFile> collectChildFilesToUpdate(MavenProject mavenProject2, Collection<MavenProject> prevChildren) {
            HashSet<MavenProject> children = new HashSet<MavenProject>(prevChildren);
            children.removeAll(this.updateContext.getDeletedProjects());
            children.addAll(this.tree.findInheritors(mavenProject2));
            return ContainerUtil.map(children, child -> child.getFile());
        }

        private void update(VirtualFile mavenProjectFile, boolean forceRead) {
            if (!this.startUpdate(mavenProjectFile, forceRead)) {
                return;
            }
            MavenProject mavenProject2 = this.tree.findOrCreateProject(mavenProjectFile);
            List<MavenProject> prevModules = this.tree.getModules(mavenProject2);
            Collection<MavenProject> prevChildren = this.tree.findInheritors(mavenProject2);
            boolean readPom = this.readPomIfNeeded(mavenProject2, forceRead);
            List<VirtualFile> existingModuleFiles = mavenProject2.getExistingModuleFiles();
            this.handleRemovedModules(mavenProject2, prevModules, existingModuleFiles);
            List<VirtualFile> modulesFilesToReconnect = this.collectModuleFilesToReconnect(mavenProject2, existingModuleFiles);
            boolean updateExistingModules = readPom || this.updateModules;
            List<VirtualFile> modulesFilesToUpdate = this.collectModuleFilesToUpdate(modulesFilesToReconnect, updateExistingModules);
            boolean forceReadModules = this.updateModules && forceRead;
            List moduleUpdates = ContainerUtil.map(modulesFilesToUpdate, moduleFile -> new UpdateSpec((VirtualFile)moduleFile, forceReadModules));
            this.updateProjects(moduleUpdates);
            this.reconnectModuleFiles(mavenProject2, modulesFilesToReconnect);
            List<VirtualFile> childFilesToUpdate = this.collectChildFilesToUpdate(mavenProject2, prevChildren);
            List childUpdates = ContainerUtil.map(childFilesToUpdate, childFile -> new UpdateSpec((VirtualFile)childFile, readPom));
            this.updateProjects(childUpdates);
        }

        public void updateProjects(@NotNull List<UpdateSpec> specs) {
            if (specs == null) {
                MavenProjectsTreeUpdater.$$$reportNull$$$0(0);
            }
            if (specs.isEmpty()) {
                return;
            }
            ParallelRunner.runInParallel(specs, spec -> this.update(spec.mavenProjectFile(), spec.forceRead()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specs", "org/jetbrains/idea/maven/project/MavenProjectsTree$MavenProjectsTreeUpdater", "updateProjects"));
        }
    }

    private record UpdateSpec(VirtualFile mavenProjectFile, boolean forceRead) {
    }

    @FunctionalInterface
    private static interface ThrowableCallable<T extends Throwable, V> {
        public V call() throws T;
    }

    public static abstract class Visitor<Result> {
        private Result result;

        public boolean shouldVisit(MavenProject project2) {
            return true;
        }

        public abstract void visit(MavenProject var1);

        public void leave(MavenProject node2) {
        }

        public void setResult(Result result2) {
            this.result = result2;
        }

        public Result getResult() {
            return this.result;
        }

        public boolean isDone() {
            return this.result != null;
        }
    }

    public static interface Listener
    extends EventListener {
        default public void profilesChanged() {
        }

        default public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
            if (ignored == null) {
                Listener.$$$reportNull$$$0(0);
            }
            if (unignored == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            if (updated == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (deleted == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        default public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
            if (projectWithChanges == null) {
                Listener.$$$reportNull$$$0(4);
            }
        }

        default public void pluginsResolved(@NotNull MavenProject project2) {
            if (project2 == null) {
                Listener.$$$reportNull$$$0(5);
            }
        }

        default public void foldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
            if (projectWithChanges == null) {
                Listener.$$$reportNull$$$0(6);
            }
        }

        default public void artifactsDownloaded(@NotNull MavenProject project2) {
            if (project2 == null) {
                Listener.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unignored";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updated";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deleted";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectWithChanges";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsTree$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsIgnoredStateChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsUpdated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectResolved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginsResolved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "foldersResolved";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "artifactsDownloaded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static final class MavenCoordinateHashCodeStrategy
    implements Hash.Strategy<MavenCoordinate> {
        public int hashCode(MavenCoordinate object) {
            String artifactId = object == null ? null : object.getArtifactId();
            return artifactId == null ? 0 : artifactId.hashCode();
        }

        public boolean equals(MavenCoordinate o1, MavenCoordinate o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return Objects.equals(o1.getArtifactId(), o2.getArtifactId()) && Objects.equals(o1.getVersion(), o2.getVersion()) && Objects.equals(o1.getGroupId(), o2.getGroupId());
        }
    }

    public static abstract class SimpleVisitor
    extends Visitor<Object> {
    }
}

