/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.ui.configuration.actions.ModuleDeleteProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class RemoveManagedFilesAction
extends MavenAction {
    @Override
    protected boolean isVisible(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoveManagedFilesAction.$$$reportNull$$$0(0);
        }
        if (!super.isVisible(e)) {
            return false;
        }
        DataContext context2 = e.getDataContext();
        Project project2 = MavenActionUtil.getProject(context2);
        if (project2 == null) {
            return false;
        }
        List<VirtualFile> selectedFiles2 = MavenActionUtil.getMavenProjectsFiles(context2);
        if (selectedFiles2.size() == 0) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        for (VirtualFile pomXml : selectedFiles2) {
            MavenProject mavenProject2 = projectsManager.findProject(pomXml);
            if (mavenProject2 == null) {
                return false;
            }
            MavenProject aggregator = projectsManager.findAggregator(mavenProject2);
            while (aggregator != null && !projectsManager.isManagedFile(aggregator.getFile())) {
                aggregator = projectsManager.findAggregator(aggregator);
            }
            if (aggregator == null || selectedFiles2.contains(aggregator.getFile())) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context2;
        Project project2;
        if (e == null) {
            RemoveManagedFilesAction.$$$reportNull$$$0(1);
        }
        if ((project2 = MavenActionUtil.getProject(context2 = e.getDataContext())) == null) {
            return;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        List<VirtualFile> selectedFiles2 = MavenActionUtil.getMavenProjectsFiles(context2);
        ArrayList<VirtualFile> removableFiles = new ArrayList<VirtualFile>();
        ArrayList<String> filesToUnIgnore = new ArrayList<String>();
        ArrayList<Module> modulesToRemove = new ArrayList<Module>();
        for (VirtualFile pomXml : selectedFiles2) {
            if (projectsManager.isManagedFile(pomXml)) {
                MavenProject managedProject = projectsManager.findProject(pomXml);
                if (managedProject == null) continue;
                RemoveManagedFilesAction.addModuleToRemoveList(projectsManager, modulesToRemove, managedProject);
                projectsManager.getModules(managedProject).forEach(mp -> {
                    RemoveManagedFilesAction.addModuleToRemoveList(projectsManager, modulesToRemove, mp);
                    filesToUnIgnore.add(mp.getFile().getPath());
                });
                removableFiles.add(pomXml);
                filesToUnIgnore.add(pomXml.getPath());
                continue;
            }
            RemoveManagedFilesAction.notifyUserIfNeeded(context2, projectsManager, selectedFiles2, pomXml);
        }
        List names = ContainerUtil.map(modulesToRemove, m -> m.getName());
        int returnCode = Messages.showOkCancelDialog((String)ExternalSystemBundle.message((String)"action.detach.external.confirmation.prompt", (Object[])new Object[]{"Maven", names.size(), names}), (String)RemoveManagedFilesAction.getActionTitle(names), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        if (returnCode != 0) {
            return;
        }
        RemoveManagedFilesAction.removeModules(ModuleManager.getInstance((Project)project2), modulesToRemove);
        projectsManager.removeManagedFiles(removableFiles);
        projectsManager.removeIgnoredFilesPaths(filesToUnIgnore);
    }

    @Nls
    private static String getActionTitle(List<String> names) {
        return StringUtil.pluralize((String)ExternalSystemBundle.message((String)"action.detach.external.project.text", (Object[])new Object[]{"Maven"}), (int)names.size());
    }

    private static void addModuleToRemoveList(MavenProjectsManager manager, List<Module> modulesToRemove, MavenProject project2) {
        Module module2 = manager.findModule(project2);
        if (module2 == null) {
            return;
        }
        modulesToRemove.add(module2);
    }

    private static void removeModules(ModuleManager moduleManager, List<Module> modulesToRemove) {
        WriteAction.run(() -> {
            SmartList usingModels = new SmartList();
            block0: for (Module module2 : modulesToRemove) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                    if (!(entry instanceof ModuleOrderEntry)) continue;
                    usingModels.add(moduleRootManager.getModifiableModel());
                    continue block0;
                }
            }
            ModifiableModuleModel moduleModel = moduleManager.getModifiableModel();
            for (Module module3 : modulesToRemove) {
                ModuleDeleteProvider.removeModule((Module)module3, (Collection)usingModels, (ModifiableModuleModel)moduleModel);
            }
            ModifiableModelCommitter.multiCommit((Collection)usingModels, (ModifiableModuleModel)moduleModel);
        });
    }

    private static void notifyUserIfNeeded(DataContext context2, MavenProjectsManager projectsManager, List<VirtualFile> selectedFiles2, VirtualFile pomXml) {
        MavenProject mavenProject2 = projectsManager.findProject(pomXml);
        assert (mavenProject2 != null);
        MavenProject aggregator = projectsManager.findAggregator(mavenProject2);
        while (aggregator != null && !projectsManager.isManagedFile(aggregator.getFile())) {
            aggregator = projectsManager.findAggregator(aggregator);
        }
        if (aggregator != null && !selectedFiles2.contains(aggregator.getFile())) {
            RemoveManagedFilesAction.notifyUser(context2, mavenProject2, aggregator);
        }
    }

    private static void notifyUser(DataContext context2, MavenProject mavenProject2, MavenProject aggregator) {
        String aggregatorDescription = " (" + aggregator.getMavenId().getDisplayString() + ")";
        Notification notification = new Notification("Maven", MavenProjectBundle.message("maven.module.remove.failed", new Object[0]), MavenProjectBundle.message("maven.module.remove.failed.explanation", mavenProject2.getDisplayName(), aggregatorDescription), NotificationType.ERROR);
        notification.setImportant(true);
        notification.notify(MavenActionUtil.getProject(context2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/maven/project/actions/RemoveManagedFilesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

