/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.server.MavenArtifactResolutionRequest;
import org.jetbrains.idea.maven.server.MavenArtifactResolveResult;
import org.jetbrains.idea.maven.server.MavenBuildPathsChange;
import org.jetbrains.idea.maven.server.MavenGoalExecutionRequest;
import org.jetbrains.idea.maven.server.MavenGoalExecutionResult;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.PluginResolutionRequest;
import org.jetbrains.idea.maven.server.PluginResolutionResponse;
import org.jetbrains.idea.maven.server.ProjectResolutionRequest;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenEmbedderWrapper
extends MavenRemoteObjectWrapper<MavenServerEmbedder> {
    private final Project myProject;

    MavenEmbedderWrapper(@NotNull Project project2) {
        if (project2 == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(0);
        }
        super(null);
        this.myProject = project2;
    }

    @Override
    @NotNull
    protected synchronized MavenServerEmbedder getOrCreateWrappee() throws RemoteException {
        MavenServerEmbedder embedder = (MavenServerEmbedder)super.getOrCreateWrappee();
        try {
            embedder.ping(ourToken);
        }
        catch (RemoteException e) {
            this.onError();
            embedder = (MavenServerEmbedder)super.getOrCreateWrappee();
        }
        MavenServerEmbedder mavenServerEmbedder = embedder;
        if (mavenServerEmbedder == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(1);
        }
        return mavenServerEmbedder;
    }

    private MavenWorkspaceMap convertWorkspaceMap(@Nullable MavenWorkspaceMap map) {
        if (null == map) {
            return null;
        }
        RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(this.myProject);
        if (transformer == RemotePathTransformerFactory.Transformer.ID) {
            return map;
        }
        return MavenWorkspaceMap.copy((MavenWorkspaceMap)map, transformer::toRemotePath);
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProject(@NotNull Collection<VirtualFile> files2, @NotNull MavenExplicitProfiles explicitProfiles, @Nullable ProgressIndicator indicator, @Nullable MavenSyncConsole syncConsole, @Nullable MavenConsole console2, @Nullable MavenWorkspaceMap workspaceMap, boolean updateSnapshots) throws MavenProcessCanceledException {
        if (files2 == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(2);
        }
        if (explicitProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(3);
        }
        RemotePathTransformerFactory.Transformer transformer = files2.isEmpty() ? RemotePathTransformerFactory.Transformer.ID : RemotePathTransformerFactory.createForProject(this.myProject);
        List ioFiles = ContainerUtil.map(files2, file -> new File(transformer.toRemotePath(file.getPath())));
        MavenWorkspaceMap serverWorkspaceMap = this.convertWorkspaceMap(workspaceMap);
        ProjectResolutionRequest request = new ProjectResolutionRequest(ioFiles, explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles(), serverWorkspaceMap, updateSnapshots);
        Collection results = this.runLongRunningTask((embedder, taskId) -> embedder.resolveProjects(taskId, request, ourToken), indicator, syncConsole, console2);
        if (transformer != RemotePathTransformerFactory.Transformer.ID) {
            for (MavenServerExecutionResult result2 : results) {
                MavenServerExecutionResult.ProjectData data2 = result2.projectData;
                if (data2 == null) continue;
                new MavenBuildPathsChange((Function1<? super String, String>)((Function1)s -> transformer.toIdePath((String)s)), (Function1<? super String, Boolean>)((Function1)s -> transformer.canBeRemotePath((String)s))).perform(data2.mavenModel);
            }
        }
        Collection collection = results;
        if (collection == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull VirtualFile file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(5);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(6);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(7);
        }
        return this.evaluateEffectivePom(new File(file.getPath()), new ArrayList<String>(activeProfiles), new ArrayList<String>(inactiveProfiles));
    }

    @Nullable
    public String evaluateEffectivePom(@NotNull File file, @NotNull Collection<String> activeProfiles, @NotNull Collection<String> inactiveProfiles) throws MavenProcessCanceledException {
        if (file == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(8);
        }
        if (activeProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(9);
        }
        if (inactiveProfiles == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(10);
        }
        return this.performCancelable(() -> this.getOrCreateWrappee().evaluateEffectivePom(file, new ArrayList(activeProfiles), new ArrayList(inactiveProfiles), ourToken));
    }

    @Deprecated
    @NotNull
    public MavenArtifact resolve(@NotNull MavenArtifactInfo info, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (info == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(11);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(12);
        }
        List<MavenArtifactResolutionRequest> requests = List.of(new MavenArtifactResolutionRequest(info, remoteRepositories));
        MavenArtifact mavenArtifact = this.resolveArtifacts(requests, null, null, null).get(0);
        if (mavenArtifact == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(13);
        }
        return mavenArtifact;
    }

    @NotNull
    public List<MavenArtifact> resolveArtifacts(@NotNull Collection<MavenArtifactResolutionRequest> requests, @Nullable ProgressIndicator indicator, @Nullable MavenSyncConsole syncConsole, @Nullable MavenConsole console2) throws MavenProcessCanceledException {
        if (requests == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(14);
        }
        List list = this.runLongRunningTask((embedder, taskId) -> embedder.resolveArtifacts(taskId, new ArrayList(requests), ourToken), indicator, syncConsole, console2);
        if (list == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public List<MavenArtifact> resolveTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (artifacts == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(16);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(17);
        }
        List list = this.performCancelable((RemoteObjectWrapper.RetriableCancelable<MavenArtifactResolveResult, E>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$resolveTransitively$6(java.util.List java.util.List ), ()Lorg/jetbrains/idea/maven/server/MavenArtifactResolveResult;)((MavenEmbedderWrapper)this, artifacts, remoteRepositories)).mavenResolvedArtifacts;
        if (list == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public MavenArtifactResolveResult resolveArtifactTransitively(@NotNull List<MavenArtifactInfo> artifacts, @NotNull List<MavenRemoteRepository> remoteRepositories) throws MavenProcessCanceledException {
        if (artifacts == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(19);
        }
        if (remoteRepositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(20);
        }
        MavenArtifactResolveResult mavenArtifactResolveResult = this.performCancelable(() -> this.getOrCreateWrappee().resolveArtifactsTransitively(new ArrayList(artifacts), new ArrayList(remoteRepositories), ourToken));
        if (mavenArtifactResolveResult == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(21);
        }
        return mavenArtifactResolveResult;
    }

    public List<PluginResolutionResponse> resolvePlugins(@NotNull Collection<Pair<MavenId, NativeMavenProjectHolder>> mavenPluginRequests, @Nullable MavenProgressIndicator progressIndicator, @Nullable MavenConsole console2) throws MavenProcessCanceledException {
        if (mavenPluginRequests == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(22);
        }
        ArrayList<PluginResolutionRequest> pluginResolutionRequests = new ArrayList<PluginResolutionRequest>();
        for (Pair<MavenId, NativeMavenProjectHolder> mavenPluginRequest : mavenPluginRequests) {
            MavenId mavenPluginId = (MavenId)mavenPluginRequest.first;
            try {
                int id = ((NativeMavenProjectHolder)mavenPluginRequest.second).getId();
                pluginResolutionRequests.add(new PluginResolutionRequest(mavenPluginId, id));
            }
            catch (RemoteException e) {
                MavenLog.LOG.warn("Cannot resolve plugin: " + mavenPluginId);
            }
        }
        ProgressIndicator indicator = null == progressIndicator ? null : progressIndicator.getIndicator();
        MavenSyncConsole syncConsole = null == progressIndicator ? null : progressIndicator.getSyncConsole();
        return this.runLongRunningTask((embedder, taskId) -> embedder.resolvePlugins(taskId, (Collection)pluginResolutionRequests, ourToken), indicator, syncConsole, console2);
    }

    public Collection<MavenArtifact> resolvePlugin(@NotNull MavenPlugin plugin, @NotNull NativeMavenProjectHolder nativeMavenProject) throws MavenProcessCanceledException {
        if (plugin == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(23);
        }
        if (nativeMavenProject == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(24);
        }
        MavenId mavenId = plugin.getMavenId();
        return this.resolvePlugins(List.of(Pair.create((Object)mavenId, (Object)nativeMavenProject)), null, null).stream().flatMap(resolutionResult2 -> resolutionResult2.getArtifacts().stream()).collect(Collectors.toSet());
    }

    public MavenModel readModel(File file) throws MavenProcessCanceledException {
        return this.performCancelable(() -> this.getOrCreateWrappee().readModel(file, ourToken));
    }

    @NotNull
    public List<MavenGoalExecutionResult> executeGoal(@NotNull Collection<MavenGoalExecutionRequest> requests, @NotNull String goal, @Nullable MavenProgressIndicator progressIndicator, @Nullable MavenConsole console2) throws MavenProcessCanceledException {
        if (requests == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(25);
        }
        if (goal == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(26);
        }
        ProgressIndicator indicator = null == progressIndicator ? null : progressIndicator.getIndicator();
        MavenSyncConsole syncConsole = null == progressIndicator ? null : progressIndicator.getSyncConsole();
        List list = this.runLongRunningTask((embedder, taskId) -> embedder.executeGoal(taskId, new ArrayList(requests), goal, ourToken), indicator, syncConsole, console2);
        if (list == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public Set<MavenRemoteRepository> resolveRepositories(@NotNull Collection<MavenRemoteRepository> repositories) {
        if (repositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(28);
        }
        Set set = this.perform(() -> this.getOrCreateWrappee().resolveRepositories(new ArrayList(repositories), ourToken));
        if (set == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(29);
        }
        return set;
    }

    public Collection<MavenArchetype> getInnerArchetypes(@NotNull Path catalogPath) {
        if (catalogPath == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(30);
        }
        return this.perform(() -> this.getOrCreateWrappee().getLocalArchetypes(ourToken, catalogPath.toString()));
    }

    public Collection<MavenArchetype> getRemoteArchetypes(@NotNull String url) {
        if (url == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(31);
        }
        return this.perform(() -> this.getOrCreateWrappee().getRemoteArchetypes(ourToken, url));
    }

    @Nullable
    public Map<String, String> resolveAndGetArchetypeDescriptor(@NotNull String groupId, @NotNull String artifactId, @NotNull String version2, @NotNull List<MavenRemoteRepository> repositories, @Nullable String url) {
        if (groupId == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(32);
        }
        if (artifactId == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(33);
        }
        if (version2 == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(34);
        }
        if (repositories == null) {
            MavenEmbedderWrapper.$$$reportNull$$$0(35);
        }
        return this.perform(() -> this.getOrCreateWrappee().resolveAndGetArchetypeDescriptor(groupId, artifactId, version2, new ArrayList(repositories), url, ourToken));
    }

    @TestOnly
    public MavenServerEmbedder getEmbedder() throws RemoteException {
        return this.getOrCreateWrappee();
    }

    public void release() {
        MavenServerEmbedder w = (MavenServerEmbedder)this.getWrappee();
        if (w == null) {
            return;
        }
        try {
            w.release(ourToken);
        }
        catch (RemoteException e) {
            this.handleRemoteError(e);
        }
    }

    @Deprecated(forRemoval=true)
    public void clearCachesFor(MavenId projectId) {
    }

    protected abstract <R> R runLongRunningTask(@NotNull LongRunningEmbedderTask<R> var1, @Nullable ProgressIndicator var2, @Nullable MavenSyncConsole var3, @Nullable MavenConsole var4) throws MavenProcessCanceledException;

    private /* synthetic */ MavenArtifactResolveResult lambda$resolveTransitively$6(List artifacts, List remoteRepositories) throws RemoteException, MavenServerProcessCanceledException, RuntimeException {
        return this.getOrCreateWrappee().resolveArtifactsTransitively(new ArrayList(artifacts), new ArrayList(remoteRepositories), ourToken);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 13, 15, 18, 21, 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenEmbedderWrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitProfiles";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRepositories";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenPluginRequests";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeMavenProject";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goal";
                break;
            }
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catalogPath";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenEmbedderWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateWrappee";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProject";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTransitively";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifactTransitively";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "executeGoal";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 27: 
            case 29: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveProject";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluateEffectivePom";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifacts";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveTransitively";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveArtifactTransitively";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugins";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugin";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeGoal";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveRepositories";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getInnerArchetypes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteArchetypes";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndGetArchetypeDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 13, 15, 18, 21, 27, 29 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    protected static interface LongRunningEmbedderTask<R> {
        public R run(MavenServerEmbedder var1, String var2) throws RemoteException, MavenServerProcessCanceledException;
    }
}

