/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;

@Service(value={Service.Level.PROJECT})
public final class MavenRehighlighter
implements Disposable {
    private final MergingUpdateQueue queue;

    public MavenRehighlighter(@NotNull Project project2) {
        if (project2 == null) {
            MavenRehighlighter.$$$reportNull$$$0(0);
        }
        this.queue = new MergingUpdateQueue(this.getClass().getSimpleName(), 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, true);
    }

    public void dispose() {
    }

    public static void install(final @NotNull Project project2, @NotNull MavenProjectsManager projectsManager) {
        if (project2 == null) {
            MavenRehighlighter.$$$reportNull$$$0(1);
        }
        if (projectsManager == null) {
            MavenRehighlighter.$$$reportNull$$$0(2);
        }
        projectsManager.addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                MavenRehighlighter.rehighlight(project2, null);
            }
        });
        projectsManager.addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                if (updated == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (deleted == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (Pair<MavenProject, MavenProjectChanges> each : updated) {
                    MavenRehighlighter.rehighlight(project2, (MavenProject)each.first);
                }
            }

            @Override
            public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
                if (projectWithChanges == null) {
                    2.$$$reportNull$$$0(2);
                }
                MavenRehighlighter.rehighlight(project2, (MavenProject)projectWithChanges.first);
            }

            @Override
            public void pluginsResolved(@NotNull MavenProject mavenProject2) {
                if (mavenProject2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                MavenRehighlighter.rehighlight(project2, mavenProject2);
            }

            @Override
            public void foldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
                if (projectWithChanges == null) {
                    2.$$$reportNull$$$0(4);
                }
                MavenRehighlighter.rehighlight(project2, (MavenProject)projectWithChanges.first);
            }

            @Override
            public void artifactsDownloaded(@NotNull MavenProject mavenProject2) {
                if (mavenProject2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                MavenRehighlighter.rehighlight(project2, mavenProject2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updated";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deleted";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectWithChanges";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mavenProject";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenRehighlighter$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectsUpdated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectResolved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginsResolved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "foldersResolved";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "artifactsDownloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void rehighlight(@NotNull Project project2) {
        if (project2 == null) {
            MavenRehighlighter.$$$reportNull$$$0(3);
        }
        MavenRehighlighter.rehighlight(project2, null);
    }

    public static void rehighlight(@NotNull Project project2, @Nullable MavenProject mavenProject2) {
        if (project2 == null) {
            MavenRehighlighter.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!project2.isDisposed()) {
                ((MavenRehighlighter)project2.getService(MavenRehighlighter.class)).queue.queue((Update)new MyUpdate(project2, mavenProject2));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsManager";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenRehighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "rehighlight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyUpdate
    extends Update {
        private final Project myProject;
        private final MavenProject myMavenProject;

        MyUpdate(Project project2, MavenProject mavenProject2) {
            super((Object)project2);
            this.myProject = project2;
            this.myMavenProject = mavenProject2;
        }

        public void run() {
            if (this.myMavenProject == null) {
                for (VirtualFile each : FileEditorManager.getInstance((Project)this.myProject).getOpenFiles()) {
                    this.doRehighlightMavenFile(each);
                }
            } else {
                this.doRehighlightMavenFile(this.myMavenProject.getFile());
            }
        }

        private void doRehighlightMavenFile(VirtualFile file) {
            if (!FileTypeManager.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE)) {
                return;
            }
            Document doc = FileDocumentManager.getInstance().getCachedDocument(file);
            if (doc == null) {
                return;
            }
            PsiFile psi = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(doc);
            if (psi == null) {
                return;
            }
            if (!MavenDomUtil.isMavenFile(psi)) {
                return;
            }
            DaemonCodeAnalyzer daemon = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
            daemon.restart(psi);
        }

        public boolean canEat(@NotNull Update update) {
            if (update == null) {
                MyUpdate.$$$reportNull$$$0(0);
            }
            return this.myMavenProject == null || this.myMavenProject == ((MyUpdate)update).myMavenProject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "org/jetbrains/idea/maven/utils/MavenRehighlighter$MyUpdate", "canEat"));
        }
    }
}

