/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.build.events.MessageEvent;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.service.execution.InvalidSdkException;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkFinder;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstallRequest;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkListDownloader;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkPredicate;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.navigation.Place;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.CannotStartServerException;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.WslMavenDistribution;
import org.jetbrains.idea.maven.server.wsl.BuildIssueWslJdk;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslCache;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J2\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\tH\u0007J:\u0010\u0018\u001a\u00020\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0007J&\u0010\u001f\u001a\u00020\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0013H\u0007J#\u0010$\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b%2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0007J?\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H'0+H\u0007\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u00010\t2\b\u00101\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u00102\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0014\u00103\u001a\u0004\u0018\u00010\t2\b\u00104\u001a\u0004\u0018\u00010\u0013H\u0007J\"\u00105\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u00106\u001a\u00020/2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001f\u00107\u001a\u0004\u0018\u000108*\u00020\t2\n\b\u0002\u00109\u001a\u0004\u0018\u00010\u0013H\u0001\u00a2\u0006\u0002\b:J\u0014\u0010;\u001a\u00020\u0011*\u00020\t2\u0006\u0010<\u001a\u00020\u0011H\u0007J\u0016\u0010=\u001a\u0004\u0018\u00010\u0011*\u00020\t2\u0006\u0010>\u001a\u00020\u0011H\u0007J\u0018\u0010?\u001a\u0004\u0018\u00010\u0011*\u00020\t2\b\u00109\u001a\u0004\u0018\u00010\u0013H\u0007J*\u0010@\u001a\u00020\u0011*\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u00109\u001a\u0004\u0018\u00010\u00132\b\u0010A\u001a\u0004\u0018\u00010\u0013H\u0007J\f\u0010B\u001a\u00020\u0011*\u00020\tH\u0007J\u0018\u0010C\u001a\u0004\u0018\u00010\u0011*\u00020\t2\b\u0010D\u001a\u0004\u0018\u00010\u0013H\u0007J\u0016\u0010E\u001a\u00020\u0011*\u00020\t2\b\u0010A\u001a\u0004\u0018\u00010\u0013H\u0007\u00a8\u0006F"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenWslUtil;", "Lorg/jetbrains/idea/maven/utils/MavenUtil;", "()V", "checkWslJdkAndShowNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "findOrDownloadNewJdk", "projectWslDistr", "Lcom/intellij/execution/wsl/WSLDistribution;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "notification", "Lcom/intellij/notification/Notification;", "listener", "Lcom/intellij/notification/NotificationListener;", "getGlobalSettings", "Ljava/io/File;", "globalSettingsPath", "", "mavenConfig", "Lorg/jetbrains/idea/maven/config/MavenConfig;", "getJdkPath", "wslDistribution", "getLocalRepo", "overriddenLocalRepository", "mavenHome", "mavenSettingsFile", "getPropertiesFromMavenOpts", "", "distribution", "getUserSettings", "userSettingsPath", "getWslDistribution", "getWslJdk", "name", "resolveMavenHome", "Lorg/jetbrains/annotations/Nullable;", "resolveWslAware", "T", "ordinary", "Ljava/util/function/Supplier;", "wsl", "Ljava/util/function/Function;", "(Lcom/intellij/openapi/project/Project;Ljava/util/function/Supplier;Ljava/util/function/Function;)Ljava/lang/Object;", "restartMavenConnectorsIfJdkIncorrect", "sameDistributions", "", "first", "second", "tryGetWslDistribution", "tryGetWslDistributionForPath", "path", "trySetUpExistingJdk", "useWslMaven", "getDefaultMavenDistribution", "Lorg/jetbrains/idea/maven/server/WslMavenDistribution;", "overriddenMavenHome", "getDefaultMavenDistribution$intellij_maven", "getWindowsFile", "wslFile", "getWslFile", "windowsFile", "resolveGlobalSettingsFile", "resolveLocalRepository", "overriddenUserSettingsFile", "resolveM2Dir", "resolveMavenHomeDirectory", "overrideMavenHome", "resolveUserSettingsFile", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenWslUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenWslUtil.kt\norg/jetbrains/idea/maven/utils/MavenWslUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,452:1\n1#2:453\n43#3,3:454\n3792#4:457\n4307#4,2:458\n1855#5,2:460\n*S KotlinDebug\n*F\n+ 1 MavenWslUtil.kt\norg/jetbrains/idea/maven/utils/MavenWslUtil\n*L\n365#1:454,3\n365#1:457\n365#1:458,2\n297#1:460,2\n*E\n"})
public final class MavenWslUtil
extends MavenUtil {
    @NotNull
    public static final MavenWslUtil INSTANCE = new MavenWslUtil();

    private MavenWslUtil() {
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @NotNull
    public static final Sdk getWslJdk(@NotNull Project project, @NotNull String name) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            v0 = MavenWslUtil.tryGetWslDistribution(project);
            if (v0 == null) {
                throw new IllegalStateException("project " + project + " is not WSL based");
            }
            projectWslDistr = v0;
            if (!Intrinsics.areEqual((Object)name, (Object)"#JAVA_HOME")) break block10;
            v1 = MavenWslCache.Companion.getInstance().wslEnv(projectWslDistr);
            if (v1 == null || (v1 = v1.get("JAVA_HOME")) == null) ** GOTO lbl-1000
            it = v1;
            $i$a$-let-MavenWslUtil$getWslJdk$jdk$1 = false;
            v2 = projectWslDistr.getWindowsPath((String)it);
            v1 = v2;
            if (v2 != null) {
                it = v1;
                $i$a$-let-MavenWslUtil$getWslJdk$jdk$2 = false;
                v3 = JavaSdk.getInstance().createJdk("", (String)it);
            } else lbl-1000:
            // 2 sources

            {
                v3 = jdk = null;
            }
            if (jdk != null && jdk.getSdkType() instanceof JavaSdkType) {
                return jdk;
            }
        }
        if (Intrinsics.areEqual((Object)name, (Object)"#USE_PROJECT_JDK")) {
            jdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (jdk != null && jdk.getSdkType() instanceof JavaSdkType) {
                if (Intrinsics.areEqual((Object)projectWslDistr, (Object)MavenWslUtil.tryGetWslDistributionForPath(jdk.getHomePath()))) {
                    return jdk;
                }
            }
            MavenProjectsManager.getInstance(project).getSyncConsole().addBuildIssue(new BuildIssueWslJdk(), MessageEvent.Kind.ERROR);
            throw new InvalidSdkException(name);
        }
        sdkByExactName = MavenUtil.getSdkByExactName(name);
        if (sdkByExactName != null) {
            if (Intrinsics.areEqual((Object)projectWslDistr, (Object)MavenWslUtil.tryGetWslDistributionForPath(sdkByExactName.getHomePath()))) {
                return sdkByExactName;
            }
        }
        v4 = MavenUtil.suggestProjectSdk(project);
        if (v4 == null) {
            throw new InvalidSdkException(name);
        }
        return v4;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getPropertiesFromMavenOpts(@NotNull WSLDistribution distribution) {
        Intrinsics.checkNotNullParameter((Object)distribution, (String)"distribution");
        Map<String, String> map = MavenWslCache.Companion.getInstance().wslEnv(distribution);
        Map<String, String> map2 = MavenUtil.parseMavenProperties(map != null ? map.get("MAVEN_OPTS") : null);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"parseMavenProperties(Mav\u2026tion)?.get(\"MAVEN_OPTS\"))");
        return map2;
    }

    @JvmStatic
    @NotNull
    public static final WSLDistribution getWslDistribution(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string = project2.getBasePath();
        if (string == null) {
            throw new IllegalArgumentException("Project " + project2 + " with null base path");
        }
        String basePath = string;
        WSLDistribution wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(basePath);
        if (wSLDistribution == null) {
            throw new IllegalArgumentException("Distribution for path " + basePath + " not found, check your WSL installation");
        }
        return wSLDistribution;
    }

    @JvmStatic
    @Nullable
    public static final WSLDistribution tryGetWslDistribution(@NotNull Project project2) {
        WSLDistribution wSLDistribution;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string = project2.getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(it);
        } else {
            wSLDistribution = null;
        }
        return wSLDistribution;
    }

    @JvmStatic
    @Nullable
    public static final WSLDistribution tryGetWslDistributionForPath(@Nullable String path) {
        WSLDistribution wSLDistribution;
        String string = path;
        if (string != null) {
            String it = string;
            boolean bl = false;
            wSLDistribution = WslPath.Companion.getDistributionByWindowsUncPath(it);
        } else {
            wSLDistribution = null;
        }
        return wSLDistribution;
    }

    @JvmStatic
    @NotNull
    public static final File resolveUserSettingsFile(@NotNull WSLDistribution $this$resolveUserSettingsFile, @Nullable String overriddenUserSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveUserSettingsFile, (String)"<this>");
        if (MavenUtil.isEmptyOrSpaces(overriddenUserSettingsFile)) {
            return new File(MavenWslUtil.resolveM2Dir($this$resolveUserSettingsFile), "settings.xml");
        }
        return new File(overriddenUserSettingsFile);
    }

    @JvmStatic
    @Nullable
    public static final File resolveGlobalSettingsFile(@NotNull WSLDistribution $this$resolveGlobalSettingsFile, @Nullable String overriddenMavenHome) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveGlobalSettingsFile, (String)"<this>");
        File file = MavenWslUtil.resolveMavenHomeDirectory($this$resolveGlobalSettingsFile, overriddenMavenHome);
        if (file == null) {
            return null;
        }
        File directory = file;
        return new File(new File(directory, "conf"), "settings.xml");
    }

    @JvmStatic
    @NotNull
    public static final File resolveM2Dir(@NotNull WSLDistribution $this$resolveM2Dir) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveM2Dir, (String)"<this>");
        Map<String, String> map = MavenWslCache.Companion.getInstance().wslEnv($this$resolveM2Dir);
        String userHome = map != null ? map.get("HOME") : null;
        CharSequence charSequence = userHome;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new CannotStartServerException(SyncBundle.message("maven.sync.wsl.userhome.cannot.resolve", new Object[0]));
        }
        return MavenWslUtil.getWindowsFile($this$resolveM2Dir, new File(userHome, ".m2"));
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @Nullable
    public static final File resolveMavenHomeDirectory(@NotNull WSLDistribution $this$resolveMavenHomeDirectory, @Nullable String overrideMavenHome) {
        block18: {
            block17: {
                Intrinsics.checkNotNullParameter((Object)$this$resolveMavenHomeDirectory, (String)"<this>");
                MavenLog.LOG.debug("resolving maven home on WSL with override = \"" + overrideMavenHome + "\"");
                if (overrideMavenHome != null) {
                    if (Intrinsics.areEqual((Object)overrideMavenHome, (Object)"Bundled (Maven 3)")) {
                        return MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome().toFile();
                    }
                    home = new File(overrideMavenHome);
                    if (MavenUtil.isValidMavenHome(home)) {
                        MavenLog.LOG.debug("resolved maven home as " + overrideMavenHome);
                        return home;
                    }
                    MavenLog.LOG.debug("Maven home " + overrideMavenHome + " on WSL is invalid");
                    return null;
                }
                v0 = MavenWslCache.Companion.getInstance().wslEnv($this$resolveMavenHomeDirectory);
                v1 = m2home = v0 != null ? v0.get("M2_HOME") : null;
                if (m2home != null && !MavenUtil.isEmptyOrSpaces(m2home)) {
                    v2 = $this$resolveMavenHomeDirectory.getWindowsPath(m2home);
                    if (v2 != null) {
                        p0 = v2;
                        $i$a$-let-MavenWslUtil$resolveMavenHomeDirectory$homeFromEnv$1 = false;
                        v3 = new File(p0);
                    } else {
                        v3 = homeFromEnv = null;
                    }
                    if (MavenUtil.isValidMavenHome(homeFromEnv)) {
                        MavenLog.LOG.debug("resolved maven home using $M2_HOME as " + homeFromEnv);
                        return homeFromEnv;
                    }
                    MavenLog.LOG.debug("Maven home using $M2_HOME is invalid");
                    return null;
                }
                v4 = $this$resolveMavenHomeDirectory.getWindowsPath("/usr/share/maven");
                if (v4 != null) {
                    p0 = v4;
                    $i$a$-let-MavenWslUtil$resolveMavenHomeDirectory$home$1 = false;
                    v5 = new File(p0);
                } else {
                    v5 = home = null;
                }
                if (MavenUtil.isValidMavenHome(home)) {
                    MavenLog.LOG.debug("Maven home found at /usr/share/maven");
                    return home;
                }
                v6 = $this$resolveMavenHomeDirectory.getWindowsPath("/usr/share/maven2");
                if (v6 != null) {
                    p0 = v6;
                    $i$a$-let-MavenWslUtil$resolveMavenHomeDirectory$1 = false;
                    v7 = new File(p0);
                } else {
                    v7 = home = null;
                }
                if (MavenUtil.isValidMavenHome(home)) {
                    MavenLog.LOG.debug("Maven home found at /usr/share/maven2");
                    return home;
                }
                v8 = new WSLCommandLineOptions().setExecuteCommandInLoginShell(true);
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"WSLCommandLineOptions()\n\u2026CommandInLoginShell(true)");
                options = v8;
                var7_8 = new String[]{"which", "mvn"};
                v9 = $this$resolveMavenHomeDirectory.executeOnWsl(CollectionsKt.listOf((Object[])var7_8), options, 10000, null);
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"this.executeOnWsl(listOf\u2026\"), options, 10000, null)");
                processOutput = v9;
                if (processOutput.getExitCode() != 0) break block18;
                v10 = processOutput.getStdout();
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"processOutput.stdout");
                var8_13 = StringsKt.lines((CharSequence)v10);
                for (T var10_15 : var8_13) {
                    it = (String)var10_15;
                    $i$a$-find-MavenWslUtil$resolveMavenHomeDirectory$path$1 = false;
                    v11 = ((CharSequence)it).length() > 0;
                    if (!v11) continue;
                    v12 = var10_15;
                    break block17;
                }
                v12 = null;
            }
            if ((v13 = (String)v12) == null) ** GOTO lbl-1000
            p0 = v13;
            $i$a$-let-MavenWslUtil$resolveMavenHomeDirectory$path$2 = false;
            v14 = $this$resolveMavenHomeDirectory.resolveSymlink(p0);
            v13 = v14;
            if (v14 == null) ** GOTO lbl-1000
            p0 = v13;
            $i$a$-let-MavenWslUtil$resolveMavenHomeDirectory$path$3 = false;
            v15 = $this$resolveMavenHomeDirectory.getWindowsPath(p0);
            v13 = v15;
            if (v15 != null) {
                p0 = v13;
                $i$a$-let-MavenWslUtil$resolveMavenHomeDirectory$path$4 = false;
                v16 = new File(p0);
            } else lbl-1000:
            // 3 sources

            {
                v16 = path = null;
            }
            if (path != null) {
                return path;
            }
        }
        MavenLog.LOG.debug("mvn not found in $PATH");
        MavenLog.LOG.debug("Maven home not found on " + $this$resolveMavenHomeDirectory.getPresentableName());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @NotNull
    public static final File resolveLocalRepository(@NotNull WSLDistribution $this$resolveLocalRepository, @Nullable String overriddenLocalRepository, @Nullable String overriddenMavenHome, @Nullable String overriddenUserSettingsFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$resolveLocalRepository, (String)"<this>");
        if (overriddenLocalRepository != null && !MavenUtil.isEmptyOrSpaces(overriddenLocalRepository)) {
            return new File(overriddenLocalRepository);
        }
        File file2 = MavenUtil.doResolveLocalRepository(MavenWslUtil.resolveUserSettingsFile($this$resolveLocalRepository, overriddenUserSettingsFile), MavenWslUtil.resolveGlobalSettingsFile($this$resolveLocalRepository, overriddenMavenHome));
        if (file2 != null) {
            File it = file2;
            boolean bl = false;
            File file3 = MavenWslUtil.getWindowsFile($this$resolveLocalRepository, it);
            if (file3 != null) {
                file = file3;
                return file;
            }
        }
        file = new File(MavenWslUtil.resolveM2Dir($this$resolveLocalRepository), "repository");
        return file;
    }

    @JvmStatic
    @Nullable
    public static final WslMavenDistribution getDefaultMavenDistribution$intellij_maven(@NotNull WSLDistribution $this$getDefaultMavenDistribution, @Nullable String overriddenMavenHome) {
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultMavenDistribution, (String)"<this>");
        File file = MavenWslUtil.resolveMavenHomeDirectory($this$getDefaultMavenDistribution, overriddenMavenHome);
        if (file == null) {
            return null;
        }
        File file2 = file;
        String string = $this$getDefaultMavenDistribution.getWslPath(file2.getPath());
        if (string == null) {
            return null;
        }
        String wslFile = string;
        return new WslMavenDistribution($this$getDefaultMavenDistribution, wslFile, "default");
    }

    public static /* synthetic */ WslMavenDistribution getDefaultMavenDistribution$intellij_maven$default(WSLDistribution wSLDistribution, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return MavenWslUtil.getDefaultMavenDistribution$intellij_maven(wSLDistribution, string);
    }

    @JvmStatic
    @Nullable
    public static final String getJdkPath(@NotNull WSLDistribution wslDistribution) {
        Intrinsics.checkNotNullParameter((Object)wslDistribution, (String)"wslDistribution");
        Map<String, String> map = MavenWslCache.Companion.getInstance().wslEnv(wslDistribution);
        return map != null ? map.get("JDK_HOME") : null;
    }

    @JvmStatic
    @NotNull
    public static final File getWindowsFile(@NotNull WSLDistribution $this$getWindowsFile, @NotNull File wslFile) {
        Intrinsics.checkNotNullParameter((Object)$this$getWindowsFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)wslFile, (String)"wslFile");
        String p0 = FileUtil.toSystemIndependentName((String)wslFile.getPath());
        boolean bl = false;
        p0 = $this$getWindowsFile.getWindowsPath(p0);
        boolean bl2 = false;
        return new File(p0);
    }

    @JvmStatic
    @Nullable
    public static final File getWslFile(@NotNull WSLDistribution $this$getWslFile, @NotNull File windowsFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$getWslFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)windowsFile, (String)"windowsFile");
        String p0 = windowsFile.getPath();
        boolean bl = false;
        String string = $this$getWslFile.getWslPath(p0);
        if (string != null) {
            p0 = string;
            boolean bl2 = false;
            file = new File(p0);
        } else {
            file = null;
        }
        return file;
    }

    @JvmStatic
    public static final <T> T resolveWslAware(@Nullable Project project2, @NotNull Supplier<T> ordinary, @NotNull Function<WSLDistribution, T> wsl) {
        Project project3;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(ordinary, (String)"ordinary");
                Intrinsics.checkNotNullParameter(wsl, (String)"wsl");
                if (project2 == null && MavenUtil.isMavenUnitTestModeEnabled()) {
                    MavenLog.LOG.error("resolveWslAware: Project is null");
                }
                if ((project3 = project2) == null) break block4;
                Project it = project3;
                boolean bl = false;
                WSLDistribution wSLDistribution = MavenWslUtil.tryGetWslDistribution(it);
                project3 = wSLDistribution;
                if (wSLDistribution != null) break block5;
            }
            return ordinary.get();
        }
        Project wslDistribution = project3;
        return wsl.apply((WSLDistribution)wslDistribution);
    }

    @JvmStatic
    @NotNull
    public static final File getLocalRepo(@Nullable Project project2, @Nullable String overriddenLocalRepository, @Nullable String mavenHome, @Nullable String mavenSettingsFile, @Nullable MavenConfig mavenConfig) {
        Ref.ObjectRef settingPath = new Ref.ObjectRef();
        settingPath.element = mavenSettingsFile;
        if (StringUtil.isEmptyOrSpaces((String)mavenSettingsFile)) {
            Object object = mavenConfig;
            if (object == null || (object = ((MavenConfig)object).getFilePath(MavenConfigSettings.ALTERNATE_USER_SETTINGS)) == null) {
                object = "";
            }
            settingPath.element = object;
        }
        File file = MavenWslUtil.resolveWslAware(project2, () -> MavenWslUtil.getLocalRepo$lambda$16(overriddenLocalRepository, mavenHome, settingPath), arg_0 -> MavenWslUtil.getLocalRepo$lambda$17(overriddenLocalRepository, mavenHome, settingPath, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolveWslAware(project,\u2026avenHome, settingPath) })");
        return file;
    }

    @JvmStatic
    @NotNull
    public static final File getUserSettings(@Nullable Project project2, @Nullable String userSettingsPath, @Nullable MavenConfig mavenConfig) {
        Ref.ObjectRef settingPath = new Ref.ObjectRef();
        settingPath.element = userSettingsPath;
        if (StringUtil.isEmptyOrSpaces((String)userSettingsPath)) {
            Object object = mavenConfig;
            if (object == null || (object = ((MavenConfig)object).getFilePath(MavenConfigSettings.ALTERNATE_USER_SETTINGS)) == null) {
                object = "";
            }
            settingPath.element = object;
        }
        File file = MavenWslUtil.resolveWslAware(project2, () -> MavenWslUtil.getUserSettings$lambda$18(settingPath), arg_0 -> MavenWslUtil.getUserSettings$lambda$19(settingPath, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"resolveWslAware(project,\u2026tingsFile(settingPath) })");
        return file;
    }

    @JvmStatic
    @Nullable
    public static final File getGlobalSettings(@Nullable Project project2, @Nullable String globalSettingsPath, @Nullable MavenConfig mavenConfig) {
        String filePath;
        MavenConfig mavenConfig2 = mavenConfig;
        String string = filePath = mavenConfig2 != null ? mavenConfig2.getFilePath(MavenConfigSettings.ALTERNATE_GLOBAL_SETTINGS) : null;
        if (filePath != null) {
            return new File(filePath);
        }
        return MavenWslUtil.resolveWslAware(project2, () -> MavenWslUtil.getGlobalSettings$lambda$20(globalSettingsPath), arg_0 -> MavenWslUtil.getGlobalSettings$lambda$21(globalSettingsPath, arg_0));
    }

    @JvmStatic
    @Nullable
    public static final File resolveMavenHome(@Nullable Project project2, @Nullable String mavenHome) {
        return MavenWslUtil.resolveWslAware(project2, () -> MavenWslUtil.resolveMavenHome$lambda$22(mavenHome), arg_0 -> MavenWslUtil.resolveMavenHome$lambda$23(mavenHome, arg_0));
    }

    @JvmStatic
    public static final boolean useWslMaven(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        WSLDistribution wSLDistribution = MavenWslUtil.tryGetWslDistribution(project2);
        if (wSLDistribution == null) {
            return false;
        }
        WSLDistribution projectWslDistr = wSLDistribution;
        Sdk sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        WSLDistribution wSLDistribution2 = MavenWslUtil.tryGetWslDistributionForPath(sdk != null ? sdk.getHomePath() : null);
        if (wSLDistribution2 == null) {
            return true;
        }
        WSLDistribution jdkWslDistr = wSLDistribution2;
        return Intrinsics.areEqual((Object)jdkWslDistr.getId(), (Object)projectWslDistr.getId());
    }

    @JvmStatic
    public static final boolean sameDistributions(@Nullable WSLDistribution first, @Nullable WSLDistribution second) {
        WSLDistribution wSLDistribution = first;
        WSLDistribution wSLDistribution2 = second;
        return Intrinsics.areEqual((Object)(wSLDistribution != null ? wSLDistribution.getId() : null), (Object)(wSLDistribution2 != null ? wSLDistribution2.getId() : null));
    }

    @JvmStatic
    public static final void restartMavenConnectorsIfJdkIncorrect(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ApplicationManager.getApplication().invokeLater(() -> MavenWslUtil.restartMavenConnectorsIfJdkIncorrect$lambda$26(project2));
    }

    @JvmStatic
    public static final void checkWslJdkAndShowNotification(@Nullable Project project2) {
        Project project3 = project2;
        Intrinsics.checkNotNull((Object)project3);
        WSLDistribution projectWslDistr = MavenWslUtil.tryGetWslDistribution(project3);
        Sdk sdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (sdk == null) {
            return;
        }
        WSLDistribution jdkWslDistr = MavenWslUtil.tryGetWslDistributionForPath(sdk.getHomePath());
        String FIX_STR = "FIX";
        String OPEN_STR = "OPEN";
        if (MavenWslUtil.sameDistributions(projectWslDistr, jdkWslDistr)) {
            return;
        }
        NotificationListener listener2 = new NotificationListener(OPEN_STR, project2, projectWslDistr, sdk){
            final /* synthetic */ String $OPEN_STR;
            final /* synthetic */ Project $project;
            final /* synthetic */ WSLDistribution $projectWslDistr;
            final /* synthetic */ Sdk $sdk;
            {
                this.$OPEN_STR = $OPEN_STR;
                this.$project = $project;
                this.$projectWslDistr = $projectWslDistr;
                this.$sdk = $sdk;
            }

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getDescription(), (Object)this.$OPEN_STR)) {
                    ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance((Project)this.$project);
                    ShowSettingsUtil.getInstance().editConfigurable(this.$project, (Configurable)configurable, () -> checkWslJdkAndShowNotification.listener.1.hyperlinkUpdate$lambda$0(configurable));
                } else {
                    if (MavenWslUtil.access$trySetUpExistingJdk(MavenWslUtil.INSTANCE, this.$project, this.$projectWslDistr, notification)) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> checkWslJdkAndShowNotification.listener.1.hyperlinkUpdate$lambda$1(this.$project, this.$projectWslDistr, this.$sdk, notification, this));
                }
            }

            private static final void hyperlinkUpdate$lambda$0(ProjectStructureConfigurable $configurable) {
                Place place = new Place().putPath("category", (Object)$configurable.getProjectConfig());
                Intrinsics.checkNotNullExpressionValue((Object)place, (String)"Place().putPath(\n       \u2026nfigurable.projectConfig)");
                Place place2 = place;
                $configurable.navigateTo(place2, true);
            }

            private static final void hyperlinkUpdate$lambda$1(Project $project, WSLDistribution $projectWslDistr, Sdk $sdk, Notification $notification, checkWslJdkAndShowNotification.listener.1 this$0) {
                Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                MavenWslUtil.access$findOrDownloadNewJdk(MavenWslUtil.INSTANCE, $project, $projectWslDistr, $sdk, $notification, this$0);
            }
        };
        if (projectWslDistr != null && jdkWslDistr == null) {
            Object[] objectArray = new Object[]{OPEN_STR, FIX_STR};
            new Notification("Maven", MavenProjectBundle.message("wsl.windows.jdk.used.for.wsl", new Object[0]), MavenProjectBundle.message("wsl.windows.jdk.used.for.wsl.descr", objectArray), NotificationType.WARNING).setListener(listener2).notify(project2);
        } else if (projectWslDistr == null && jdkWslDistr != null) {
            Object[] objectArray = new Object[]{OPEN_STR, FIX_STR};
            new Notification("Maven", MavenProjectBundle.message("wsl.wsl.jdk.used.for.windows", new Object[0]), MavenProjectBundle.message("wsl.wsl.jdk.used.for.windows.descr", objectArray), NotificationType.WARNING).setListener(listener2).notify(project2);
        } else if (projectWslDistr != null && jdkWslDistr != null) {
            Object[] objectArray = new Object[]{OPEN_STR, FIX_STR};
            new Notification("Maven", MavenProjectBundle.message("wsl.different.wsl.jdk.used", new Object[0]), MavenProjectBundle.message("wsl.different.wsl.jdk.used.descr", objectArray), NotificationType.WARNING).setListener(listener2).notify(project2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean trySetUpExistingJdk(Project project2, WSLDistribution projectWslDistr, Notification notification) {
        void $this$filterTo$iv$iv;
        boolean $i$f$service = false;
        Object[] serviceClass$iv = ProjectJdkTable.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        Sdk[] sdkArray = ((ProjectJdkTable)object).getAllJdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"service<ProjectJdkTable>().allJdks");
        Object[] $this$filter$iv = sdkArray;
        boolean $i$f$filter = false;
        serviceClass$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            WSLDistribution wSLDistribution;
            String string;
            Sdk it = (Sdk)element$iv$iv;
            boolean bl = false;
            WSLDistribution wSLDistribution2 = projectWslDistr;
            String string2 = string = it.getHomePath();
            if (string2 != null) {
                void p0;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"homePath");
                String string3 = string;
                WslPath.Companion companion = WslPath.Companion;
                String string4 = string3;
                WSLDistribution wSLDistribution3 = wSLDistribution2;
                boolean bl2 = false;
                wSLDistribution = companion.getDistributionByWindowsUncPath((String)p0);
                wSLDistribution2 = wSLDistribution3;
            } else {
                wSLDistribution = null;
            }
            if (!MavenWslUtil.sameDistributions(wSLDistribution2, wSLDistribution)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable = (List)destination$iv$iv;
        Comparator comparator2 = VersionComparatorUtil.COMPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)comparator2, (String)"COMPARATOR");
        Comparator comparator3 = comparator2;
        Sdk sdk = (Sdk)CollectionsKt.maxWithOrNull((Iterable)iterable, (Comparator)new Comparator(comparator3){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Sdk sdk = (Sdk)a;
                Comparator comparator2 = this.$comparator;
                boolean bl = false;
                Sdk it = (Sdk)b;
                String string = it.getVersionString();
                bl = false;
                String string2 = it.getVersionString();
                return comparator2.compare(string, string2);
            }
        });
        if (sdk == null) {
            return false;
        }
        WriteAction.runAndWait(() -> MavenWslUtil.trySetUpExistingJdk$lambda$30(project2, sdk, notification));
        return true;
    }

    private final void findOrDownloadNewJdk(Project project2, WSLDistribution projectWslDistr, Sdk sdk, Notification notification, NotificationListener listener2) {
        String string = MavenProjectBundle.message("wsl.jdk.searching", new Object[0]);
        Task.Backgroundable jdkTask2 = new Task.Backgroundable(projectWslDistr, listener2, project2, notification, string){
            final /* synthetic */ WSLDistribution $projectWslDistr;
            final /* synthetic */ NotificationListener $listener;
            final /* synthetic */ Project $project;
            final /* synthetic */ Notification $notification;
            {
                this.$projectWslDistr = $projectWslDistr;
                this.$listener = $listener;
                this.$project = $project;
                this.$notification = $notification;
                super(null, $super_call_param$1, false);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                boolean $i$f$service22 = false;
                Class<JdkFinder> serviceClass$iv = JdkFinder.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                List list = ((JdkFinder)object).suggestHomePaths();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"service<JdkFinder>().suggestHomePaths()");
                Iterable iterable = list;
                WSLDistribution $i$f$service22 = this.$projectWslDistr;
                boolean $i$f$filter = false;
                object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!MavenWslUtil.sameDistributions($i$f$service22, WslPath.Companion.getDistributionByWindowsUncPath(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String sdkPath = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                if (sdkPath != null) {
                    WriteAction.runAndWait(() -> findOrDownloadNewJdk.jdkTask.1.run$lambda$1(sdkPath, this.$project, this.$notification));
                    return;
                }
                JdkInstaller installer = JdkInstaller.Companion.getInstance();
                JdkPredicate jdkPredicate = this.$projectWslDistr != null ? JdkPredicate.Companion.forWSL$default((JdkPredicate.Companion)JdkPredicate.Companion, null, (int)1, null) : JdkPredicate.Companion.default();
                List model = JdkListDownloader.Companion.getInstance().downloadModelForJdkInstaller(indicator, jdkPredicate);
                if (model.isEmpty()) {
                    new Notification("Maven", MavenProjectBundle.message("maven.wsl.jdk.fix.failed", new Object[0]), MavenProjectBundle.message("maven.wsl.jdk.fix.failed.descr", new Object[0]), NotificationType.ERROR).setListener(this.$listener).notify(this.$project);
                } else {
                    this.setTitle(MavenProjectBundle.message("wsl.jdk.downloading", new Object[0]));
                    Path homeDir = installer.defaultInstallDir((JdkItem)model.get(0), this.$projectWslDistr);
                    JdkInstallRequest request = installer.prepareJdkInstallation((JdkItem)model.get(0), homeDir);
                    installer.installJdk(request, indicator, this.$project);
                    this.$notification.hideBalloon();
                }
            }

            private static final void run$lambda$1(String $sdkPath, Project $project, Notification $notification) {
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
                SdkType sdkType = (SdkType)JavaSdk.getInstance();
                Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
                Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getInstance().allJdks");
                String string = SdkConfigurationUtil.createUniqueSdkName((SdkType)sdkType, (String)$sdkPath, (Collection)ArraysKt.toList((Object[])sdkArray));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createUniqueSdkName(Java\u2026tance().allJdks.toList())");
                String jdkName = string;
                Sdk sdk = JavaSdk.getInstance().createJdk(jdkName, $sdkPath);
                Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInstance().createJdk(jdkName, sdkPath)");
                Sdk newJdk = sdk;
                ProjectJdkTable.getInstance().addJdk(newJdk);
                ProjectRootManagerEx.getInstance((Project)$project).setProjectSdk(newJdk);
                $notification.hideBalloon();
            }
        };
        ProgressManager.getInstance().run((Task)jdkTask2);
    }

    private static final File getLocalRepo$lambda$16(String $overriddenLocalRepository, String $mavenHome, Ref.ObjectRef $settingPath) {
        Intrinsics.checkNotNullParameter((Object)$settingPath, (String)"$settingPath");
        return MavenUtil.resolveLocalRepository($overriddenLocalRepository, $mavenHome, (String)$settingPath.element);
    }

    private static final File getLocalRepo$lambda$17(String $overriddenLocalRepository, String $mavenHome, Ref.ObjectRef $settingPath, WSLDistribution wsl) {
        Intrinsics.checkNotNullParameter((Object)$settingPath, (String)"$settingPath");
        Intrinsics.checkNotNullParameter((Object)wsl, (String)"wsl");
        return MavenWslUtil.resolveLocalRepository(wsl, $overriddenLocalRepository, $mavenHome, (String)$settingPath.element);
    }

    private static final File getUserSettings$lambda$18(Ref.ObjectRef $settingPath) {
        Intrinsics.checkNotNullParameter((Object)$settingPath, (String)"$settingPath");
        return MavenUtil.resolveUserSettingsFile((String)$settingPath.element);
    }

    private static final File getUserSettings$lambda$19(Ref.ObjectRef $settingPath, WSLDistribution wsl) {
        Intrinsics.checkNotNullParameter((Object)$settingPath, (String)"$settingPath");
        Intrinsics.checkNotNullParameter((Object)wsl, (String)"wsl");
        return MavenWslUtil.resolveUserSettingsFile(wsl, (String)$settingPath.element);
    }

    private static final File getGlobalSettings$lambda$20(String $globalSettingsPath) {
        return MavenUtil.resolveGlobalSettingsFile($globalSettingsPath);
    }

    private static final File getGlobalSettings$lambda$21(String $globalSettingsPath, WSLDistribution wsl) {
        Intrinsics.checkNotNullParameter((Object)wsl, (String)"wsl");
        return MavenWslUtil.resolveGlobalSettingsFile(wsl, $globalSettingsPath);
    }

    private static final File resolveMavenHome$lambda$22(String $mavenHome) {
        return MavenUtil.resolveMavenHomeDirectory($mavenHome);
    }

    private static final File resolveMavenHome$lambda$23(String $mavenHome, WSLDistribution wsl) {
        Intrinsics.checkNotNullParameter((Object)wsl, (String)"wsl");
        return MavenWslUtil.resolveMavenHomeDirectory(wsl, $mavenHome);
    }

    private static final void restartMavenConnectorsIfJdkIncorrect$lambda$26$lambda$25(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        WSLDistribution projectWslDistr = MavenWslUtil.tryGetWslDistribution($project);
        boolean needReset = false;
        Collection<MavenServerConnector> collection = MavenServerManager.getInstance().getAllConnectors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getInstance().allConnectors");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenServerConnector it = (MavenServerConnector)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getProject(), (Object)$project)) continue;
            WSLDistribution jdkWslDistr = MavenWslUtil.tryGetWslDistributionForPath(it.getJdk().getHomePath());
            if ((projectWslDistr == null || Intrinsics.areEqual((Object)it.getSupportType(), (Object)"WSL")) && MavenWslUtil.sameDistributions(projectWslDistr, jdkWslDistr)) continue;
            needReset = true;
            MavenServerManager.getInstance().shutdownConnector(it, true);
        }
        if (!needReset) {
            MavenProjectsManager.getInstance($project).getEmbeddersManager().reset();
        }
    }

    private static final void restartMavenConnectorsIfJdkIncorrect$lambda$26(Project $project) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> MavenWslUtil.restartMavenConnectorsIfJdkIncorrect$lambda$26$lambda$25($project), SyncBundle.message("maven.sync.restarting", new Object[0]), false, $project);
    }

    private static final void trySetUpExistingJdk$lambda$30(Project $project, Sdk $sdk, Notification $notification) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        ProjectRootManagerEx.getInstance((Project)$project).setProjectSdk($sdk);
        $notification.hideBalloon();
    }

    public static final /* synthetic */ boolean access$trySetUpExistingJdk(MavenWslUtil $this, Project project2, WSLDistribution projectWslDistr, Notification notification) {
        return $this.trySetUpExistingJdk(project2, projectWslDistr, notification);
    }

    public static final /* synthetic */ void access$findOrDownloadNewJdk(MavenWslUtil $this, Project project2, WSLDistribution projectWslDistr, Sdk sdk, Notification notification, NotificationListener listener2) {
        $this.findOrDownloadNewJdk(project2, projectWslDistr, sdk, notification, listener2);
    }
}

