/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.collaboration.ui.icon.AsyncImageIconsProvider;
import com.intellij.collaboration.ui.icon.CachingIconsProvider;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.collaboration.ui.toolwindow.ReviewToolwindowProjectContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.CoroutinesKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectConnection;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccount;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabLazyProject;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestId;
import org.jetbrains.plugins.gitlab.mergerequest.diff.GitLabMergeRequestDiffBridge;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestsFilesController;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestsFilesControllerImpl;
import org.jetbrains.plugins.gitlab.mergerequest.ui.GitLabProjectUIContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018RN\u0010\u0019\u001aB\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001d0\u001d \u001c* \u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0019\u0010&\u001a\u00070\u0013\u00a2\u0006\u0002\b'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0015R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/GitLabProjectUIContext;", "Lcom/intellij/collaboration/ui/toolwindow/ReviewToolwindowProjectContext;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectConnection;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectConnection;)V", "account", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "getAccount", "()Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccount;", "avatarIconProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getAvatarIconProvider", "()Lcom/intellij/collaboration/ui/icon/IconsProvider;", "connectionId", "", "getConnectionId", "()Ljava/lang/String;", "currentUser", "getCurrentUser", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "diffBridgeStore", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestId$Simple;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/gitlab/mergerequest/diff/GitLabMergeRequestDiffBridge;", "filesController", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestsFilesController;", "getFilesController", "()Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestsFilesController;", "projectData", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabLazyProject;", "getProjectData", "()Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabLazyProject;", "projectName", "Lorg/jetbrains/annotations/Nls;", "getProjectName", "tokenRefreshFlow", "Lkotlinx/coroutines/flow/Flow;", "", "getTokenRefreshFlow", "()Lkotlinx/coroutines/flow/Flow;", "getDiffBridge", "mr", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestId;", "Companion", "intellij.vcs.gitlab"})
public final class GitLabProjectUIContext
implements ReviewToolwindowProjectContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String connectionId;
    @NotNull
    private final String projectName;
    @NotNull
    private final GitLabUserDTO currentUser;
    @NotNull
    private final GitLabLazyProject projectData;
    private final Cache<GitLabMergeRequestId.Simple, GitLabMergeRequestDiffBridge> diffBridgeStore;
    @NotNull
    private final GitLabMergeRequestsFilesController filesController;
    @NotNull
    private final IconsProvider<GitLabUserDTO> avatarIconProvider;
    @NotNull
    private final GitLabAccount account;
    @NotNull
    private final Flow<Unit> tokenRefreshFlow;

    private GitLabProjectUIContext(CoroutineScope cs, Project project, GitLabProjectConnection connection) {
        this.connectionId = connection.getId();
        this.projectName = connection.getRepo().getRepository().getProjectPath().getName();
        this.currentUser = connection.getCurrentUser();
        this.projectData = connection.getProjectData();
        this.diffBridgeStore = Caffeine.newBuilder().weakValues().build();
        this.filesController = new GitLabMergeRequestsFilesControllerImpl(project, connection);
        this.avatarIconProvider = (IconsProvider)new CachingIconsProvider((IconsProvider)new AsyncImageIconsProvider(cs, (AsyncImageIconsProvider.AsyncImageLoader)connection.getImageLoader()), null, 2, null);
        this.account = connection.getAccount();
        this.tokenRefreshFlow = connection.getTokenRefreshFlow();
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)cs, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GitLabProjectUIContext this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getFilesController().closeAllFiles((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final String getConnectionId() {
        return this.connectionId;
    }

    @NotNull
    public String getProjectName() {
        return this.projectName;
    }

    @NotNull
    public final GitLabUserDTO getCurrentUser() {
        return this.currentUser;
    }

    @NotNull
    public final GitLabLazyProject getProjectData() {
        return this.projectData;
    }

    @NotNull
    public final GitLabMergeRequestsFilesController getFilesController() {
        return this.filesController;
    }

    @NotNull
    public final IconsProvider<GitLabUserDTO> getAvatarIconProvider() {
        return this.avatarIconProvider;
    }

    @NotNull
    public final GitLabAccount getAccount() {
        return this.account;
    }

    @NotNull
    public final Flow<Unit> getTokenRefreshFlow() {
        return this.tokenRefreshFlow;
    }

    @NotNull
    public final GitLabMergeRequestDiffBridge getDiffBridge(@NotNull GitLabMergeRequestId mr) {
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        Object object = this.diffBridgeStore.get((Object)new GitLabMergeRequestId.Simple(mr), arg_0 -> GitLabProjectUIContext.getDiffBridge$lambda$0(getDiffBridge.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"diffBridgeStore.get(GitL\u2026RequestDiffBridge()\n    }");
        return (GitLabMergeRequestDiffBridge)object;
    }

    private static final GitLabMergeRequestDiffBridge getDiffBridge$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (GitLabMergeRequestDiffBridge)$tmp0.invoke(p0);
    }

    public /* synthetic */ GitLabProjectUIContext(CoroutineScope cs, Project project, GitLabProjectConnection connection, DefaultConstructorMarker $constructor_marker) {
        this(cs, project, connection);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/GitLabProjectUIContext$Companion;", "", "()V", "GitLabProjectUIContext", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/GitLabProjectUIContext;", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectConnection;", "GitLabProjectUIContext$intellij_vcs_gitlab", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitLabProjectUIContext GitLabProjectUIContext$intellij_vcs_gitlab(@NotNull CoroutineScope $this$GitLabProjectUIContext, @NotNull Project project, @NotNull GitLabProjectConnection connection) {
            Intrinsics.checkNotNullParameter((Object)$this$GitLabProjectUIContext, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            return new GitLabProjectUIContext($this$GitLabProjectUIContext, project, connection, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

