/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateLanguage;
import org.jetbrains.plugins.textmate.TextMateService;

public final class TextMateFileType
extends LanguageFileType
implements FileTypeIdentifiableByVirtualFile,
PlainTextLikeFileType {
    public static final TextMateFileType INSTANCE = new TextMateFileType();

    private TextMateFileType() {
        super((Language)TextMateLanguage.LANGUAGE);
    }

    @NotNull
    public String getName() {
        return "textmate";
    }

    @NotNull
    public String getDescription() {
        String string = TextMateBundle.message("filetype.textmate.description", new Object[0]);
        if (string == null) {
            TextMateFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Text;
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        if (file == null) {
            TextMateFileType.$$$reportNull$$$0(1);
        }
        if (file.isDirectory()) {
            return false;
        }
        CharSequence fileName = file.getNameSequence();
        FileType originalFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return TextMateFileType.isTypeShouldBeReplacedByTextMateType(originalFileType) && TextMateService.getInstance().getLanguageDescriptorByFileName(fileName) != null;
    }

    private static boolean isTypeShouldBeReplacedByTextMateType(@Nullable FileType registeredType) {
        return registeredType == UnknownFileType.INSTANCE || registeredType == INSTANCE || registeredType == PlainTextFileType.INSTANCE;
    }

    public boolean isReadOnly() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/TextMateFileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/TextMateFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMyFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    static final class TextMateFileDetector
    implements FileTypeRegistry.FileTypeDetector {
        TextMateFileDetector() {
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file == null) {
                TextMateFileDetector.$$$reportNull$$$0(0);
            }
            if (firstBytes == null) {
                TextMateFileDetector.$$$reportNull$$$0(1);
            }
            if (file.isDirectory()) {
                return null;
            }
            if (firstCharsIfText == null) {
                return null;
            }
            CharSequence fileName = file.getNameSequence();
            FileType originalFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
            if (!TextMateFileType.isTypeShouldBeReplacedByTextMateType(originalFileType)) {
                return null;
            }
            boolean textMateRecognizesMe = false;
            try {
                textMateRecognizesMe = TextMateService.getInstance().getLanguageDescriptorByFileName(fileName) != null;
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (!textMateRecognizesMe) {
                return null;
            }
            return INSTANCE;
        }

        public int getDesiredContentPrefixLength() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstBytes";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/textmate/TextMateFileType$TextMateFileDetector";
            objectArray[2] = "detect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

