/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.bundles.BundleReaderKt;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMatePreferences;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.plist.CompositePlistReader;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a(\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0001H\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b\u001a\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b*\n\u0010\u0017\"\u00020\u00182\u00020\u0018\u00a8\u0006\u0019"}, d2={"readPlist", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "inputStream", "Ljava/io/InputStream;", "plistReader", "Lorg/jetbrains/plugins/textmate/plist/PlistReader;", "debugName", "", "readPlistInDirectory", "Lkotlin/sequences/Sequence;", "directory", "Ljava/nio/file/Path;", "glob", "readPreferencesFromPlist", "Lorg/jetbrains/plugins/textmate/bundles/TextMatePreferences;", "plist", "readSnippetFromPlist", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateSnippet;", "explicitUuid", "readSublimeBundle", "Lorg/jetbrains/plugins/textmate/bundles/TextMateBundleReader;", "path", "readTextMateBundle", "TextMateScopeName", "", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nBundleReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleReader.kt\norg/jetbrains/plugins/textmate/bundles/BundleReaderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1#2:163\n1549#3:164\n1620#3,3:165\n*S KotlinDebug\n*F\n+ 1 BundleReader.kt\norg/jetbrains/plugins/textmate/bundles/BundleReaderKt\n*L\n123#1:164\n123#1:165,3\n*E\n"})
public final class BundleReaderKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final TextMateBundleReader readTextMateBundle(@NotNull Path path) {
        Plist plist2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CompositePlistReader plistReader = new CompositePlistReader();
        Path infoPlistPath = path.resolve("info.plist");
        Intrinsics.checkNotNullExpressionValue((Object)infoPlistPath, (String)"infoPlistPath");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(infoPlistPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
        Closeable closeable = inputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl = false;
            plist2 = plistReader.read(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Plist infoPlist = plist2;
        String bundleName = infoPlist.getPlistValue("name", PathsKt.getName((Path)path)).getString();
        return new TextMateBundleReader(bundleName, path, plistReader){
            @NotNull
            private final String bundleName;
            final /* synthetic */ Path $path;
            final /* synthetic */ CompositePlistReader $plistReader;
            {
                this.$path = $path;
                this.$plistReader = $plistReader;
                Intrinsics.checkNotNullExpressionValue((Object)$bundleName, (String)"bundleName");
                this.bundleName = $bundleName;
            }

            @NotNull
            public String getBundleName() {
                return this.bundleName;
            }

            @NotNull
            public Sequence<TextMateGrammar> readGrammars() {
                Path path = this.$path.resolve("Syntaxes");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path.resolve(\"Syntaxes\")");
                return SequencesKt.map((Sequence)BundleReaderKt.access$readPlistInDirectory(path, this.$plistReader, "*.{tmLanguage,plist,tmLanguage.json}"), (Function1)readTextMateBundle.readGrammars.1.INSTANCE);
            }

            @NotNull
            public Sequence<TextMatePreferences> readPreferences() {
                Path path = this.$path.resolve("Preferences");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path.resolve(\"Preferences\")");
                return SequencesKt.mapNotNull((Sequence)BundleReaderKt.access$readPlistInDirectory(path, this.$plistReader, "*.{tmPreferences,plist}"), (Function1)readTextMateBundle.readPreferences.1.INSTANCE);
            }

            @NotNull
            public Sequence<TextMateSnippet> readSnippets() {
                Path path = this.$path.resolve("Snippets");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path.resolve(\"Snippets\")");
                return SequencesKt.mapNotNull((Sequence)BundleReaderKt.access$readPlistInDirectory(path, this.$plistReader, "*.{tmSnippet,plist}"), (Function1)((Function1)new Function1<Plist, TextMateSnippet>(this.$path){
                    final /* synthetic */ Path $path;
                    {
                        this.$path = $path;
                        super(1);
                    }

                    @Nullable
                    public final TextMateSnippet invoke(@NotNull Plist plist2) {
                        Intrinsics.checkNotNullParameter((Object)plist2, (String)"plist");
                        return BundleReaderKt.access$readSnippetFromPlist(plist2, ((Object)this.$path).toString());
                    }
                }));
            }
        };
    }

    @NotNull
    public static final TextMateBundleReader readSublimeBundle(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CompositePlistReader plistReader = new CompositePlistReader();
        return new TextMateBundleReader(path, plistReader){
            @NotNull
            private final String bundleName;
            final /* synthetic */ Path $path;
            final /* synthetic */ CompositePlistReader $plistReader;
            {
                this.$path = $path;
                this.$plistReader = $plistReader;
                this.bundleName = PathsKt.getName((Path)$path);
            }

            @NotNull
            public String getBundleName() {
                return this.bundleName;
            }

            @NotNull
            public Sequence<TextMateGrammar> readGrammars() {
                return SequencesKt.map((Sequence)BundleReaderKt.access$readPlistInDirectory(this.$path, this.$plistReader, "*.{tmLanguage,plist,tmLanguage.json}"), (Function1)readSublimeBundle.readGrammars.1.INSTANCE);
            }

            @NotNull
            public Sequence<TextMatePreferences> readPreferences() {
                return SequencesKt.mapNotNull((Sequence)BundleReaderKt.access$readPlistInDirectory(this.$path, this.$plistReader, "*.{tmPreferences,plist}"), (Function1)readSublimeBundle.readPreferences.1.INSTANCE);
            }

            @NotNull
            public Sequence<TextMateSnippet> readSnippets() {
                return SequencesKt.mapNotNull((Sequence)BundleReaderKt.access$readPlistInDirectory(this.$path, this.$plistReader, "*.plist"), (Function1)((Function1)new Function1<Plist, TextMateSnippet>(this.$path){
                    final /* synthetic */ Path $path;
                    {
                        this.$path = $path;
                        super(1);
                    }

                    @Nullable
                    public final TextMateSnippet invoke(@NotNull Plist plist2) {
                        Intrinsics.checkNotNullParameter((Object)plist2, (String)"plist");
                        return BundleReaderKt.access$readSnippetFromPlist(plist2, ((Object)this.$path).toString());
                    }
                }));
            }
        };
    }

    private static final TextMateSnippet readSnippetFromPlist(Plist plist2, String explicitUuid) {
        String string;
        String it = string = plist2.getPlistValue("tabTrigger", "").getString();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        String string2 = ((CharSequence)it).length() > 0 ? string : null;
        if (string2 == null) {
            return null;
        }
        String key = string2;
        String it2 = it = plist2.getPlistValue(Constants.StringKey.CONTENT.value, "").getString();
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
        String string3 = ((CharSequence)it2).length() > 0 ? it : null;
        if (string3 == null) {
            return null;
        }
        String content = string3;
        String it3 = it2 = plist2.getPlistValue("name", "").getString();
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
        String string4 = ((CharSequence)it3).length() > 0 ? it2 : null;
        if (string4 == null) {
            string4 = key;
        }
        String name = string4;
        String scope = plist2.getPlistValue("scope", "").getString();
        String description = plist2.getPlistValue("description", "").getString();
        String uuid = plist2.getPlistValue("uuid", explicitUuid).getString();
        return new TextMateSnippet(key, content, scope, name, description, uuid);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextMatePreferences readPreferencesFromPlist(Plist plist2) {
        TextMatePreferences textMatePreferences;
        Object object = plist2.getPlistValue("scope");
        if (object != null && (object = ((PListValue)object).getString()) != null) {
            Object scopeName = object;
            boolean bl = false;
            Object object2 = plist2.getPlistValue("settings");
            if (object2 != null && (object2 = ((PListValue)object2).getPlist()) != null) {
                List list;
                Object settings = object2;
                boolean bl2 = false;
                Set<TextMateBracePair> highlightingPairs = PreferencesReadUtil.readPairs(((Plist)settings).getPlistValue("highlightingPairs"));
                Set<TextMateBracePair> smartTypingPairs = PreferencesReadUtil.readPairs(((Plist)settings).getPlistValue("smartTypingPairs"));
                IndentationRules indentationRules = PreferencesReadUtil.loadIndentationRules((Plist)settings);
                Intrinsics.checkNotNullExpressionValue((Object)indentationRules, (String)"loadIndentationRules(settings)");
                IndentationRules indentationRules2 = indentationRules;
                PListValue pListValue = ((Plist)settings).getPlistValue("shellVariables");
                if (pListValue != null) {
                    void $this$mapTo$iv$iv;
                    PListValue variables = pListValue;
                    boolean bl3 = false;
                    List<PListValue> list2 = variables.getArray();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"variables.array");
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Plist variablePlist;
                        void variable;
                        PListValue pListValue2 = (PListValue)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)variable.getPlist(), (String)"variable.plist");
                        collection.add(new TextMateShellVariable((CharSequence)scopeName, variablePlist.getPlistValue("name", "").getString(), variablePlist.getPlistValue("value", "").getString()));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List variables = list;
                TextMateTextAttributes customHighlightingAttributes = TextMateTextAttributes.fromPlist((Plist)settings);
                textMatePreferences = new TextMatePreferences((CharSequence)scopeName, variables, highlightingPairs, smartTypingPairs, indentationRules2, customHighlightingAttributes);
            } else {
                textMatePreferences = null;
            }
        } else {
            textMatePreferences = null;
        }
        return textMatePreferences;
    }

    private static final Sequence<Plist> readPlistInDirectory(Path directory, PlistReader plistReader, String glob) {
        Object object;
        Object object2;
        try {
            boolean bl = false;
            object2 = Result.constructor-impl((Object)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)PathsKt.listDirectoryEntries((Path)directory, (String)glob)), (Function1)((Function1)new Function1<Path, Plist>(plistReader){
                final /* synthetic */ PlistReader $plistReader;
                {
                    this.$plistReader = $plistReader;
                    super(1);
                }

                @Nullable
                public final Plist invoke(@NotNull Path child) {
                    Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                    OpenOption[] openOptionArray = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream(child, Arrays.copyOf(openOptionArray, openOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
                    InputStream inputStream2 = inputStream;
                    int n = 8192;
                    return BundleReaderKt.readPlist(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n), this.$plistReader, ((Object)child).toString());
                }
            })));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            if (!(e instanceof NoSuchFileException)) {
                TextMateBundleReader.Companion.getLogger$intellij_textmate_core().warn("Can't load plists from directory: " + ((Object)directory).toString(), e);
            }
            object = SequencesKt.emptySequence();
        }
        return (Sequence)object;
    }

    static /* synthetic */ Sequence readPlistInDirectory$default(Path path, PlistReader plistReader, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "*";
        }
        return BundleReaderKt.readPlistInDirectory(path, plistReader, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Plist readPlist(@NotNull InputStream inputStream, @NotNull PlistReader plistReader, @NotNull String debugName) {
        Object object;
        block8: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)plistReader, (String)"plistReader");
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            try {
                boolean bl = false;
                object2 = inputStream;
                Throwable throwable = null;
                try {
                    Object it = (InputStream)object2;
                    boolean bl2 = false;
                    it = plistReader.read((InputStream)it);
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object = Result.constructor-impl((Object)it);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block8;
            Object e = object2 = throwable;
            boolean bl = false;
            TextMateBundleReader.Companion.getLogger$intellij_textmate_core().warn("Can't load plist from file: " + debugName, (Throwable)e);
        }
        return (Plist)(Result.isFailure-impl((Object)object) ? null : object);
    }

    public static final /* synthetic */ Sequence access$readPlistInDirectory(Path directory, PlistReader plistReader, String glob) {
        return BundleReaderKt.readPlistInDirectory(directory, plistReader, glob);
    }

    public static final /* synthetic */ TextMatePreferences access$readPreferencesFromPlist(Plist plist2) {
        return BundleReaderKt.readPreferencesFromPlist(plist2);
    }

    public static final /* synthetic */ TextMateSnippet access$readSnippetFromPlist(Plist plist2, String explicitUuid) {
        return BundleReaderKt.readSnippetFromPlist(plist2, explicitUuid);
    }
}

