/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.module.JpsModule;

public class ModuleChunk {
    private static final NotNullFunction<JpsModule, String> GET_NAME = dom -> dom.getName();
    private final Set<JpsModule> myModules;
    private final boolean myContainsTests;
    private final Set<ModuleBuildTarget> myTargets;

    public ModuleChunk(@NotNull Set<ModuleBuildTarget> targets) {
        if (targets == null) {
            ModuleChunk.$$$reportNull$$$0(0);
        }
        boolean containsTests = false;
        this.myTargets = targets;
        this.myModules = new LinkedHashSet<JpsModule>();
        for (ModuleBuildTarget target : targets) {
            this.myModules.add(target.getModule());
            containsTests |= target.isTests();
        }
        this.myContainsTests = containsTests;
    }

    @Nls
    @NotNull
    public String getPresentableShortName() {
        String name;
        String first = this.myModules.iterator().next().getName();
        if (this.myModules.size() > 1) {
            name = JpsBuildBundle.message("target.description.0.and.1.more", first, this.myModules.size() - 1);
            String fullName = this.getName();
            if (fullName.length() < name.length()) {
                name = fullName;
            }
        } else {
            name = first;
        }
        if (this.containsTests()) {
            String string = JpsBuildBundle.message("target.description.tests.of.0", name);
            if (string == null) {
                ModuleChunk.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            ModuleChunk.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        if (this.myModules.size() == 1) {
            String string = this.myModules.iterator().next().getName();
            if (string == null) {
                ModuleChunk.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = StringUtil.join(this.myModules, GET_NAME, (String)",");
        if (string == null) {
            ModuleChunk.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Set<JpsModule> getModules() {
        Set<JpsModule> set = this.myModules;
        if (set == null) {
            ModuleChunk.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean containsTests() {
        return this.myContainsTests;
    }

    @NotNull
    public Set<ModuleBuildTarget> getTargets() {
        Set<ModuleBuildTarget> set = this.myTargets;
        if (set == null) {
            ModuleChunk.$$$reportNull$$$0(6);
        }
        return set;
    }

    public String toString() {
        return this.getName();
    }

    public ModuleBuildTarget representativeTarget() {
        return this.myTargets.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/ModuleChunk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/ModuleChunk";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableShortName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

