/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;

public abstract class Difference {
    public static final int NONE = 0;
    public static final int ACCESS = 1;
    public static final int TYPE = 2;
    public static final int VALUE = 4;
    public static final int SIGNATURE = 8;
    public static final int SUPERCLASS = 16;
    public static final int USAGES = 32;
    public static final int ANNOTATIONS = 64;
    public static final int CONSTANT_REFERENCES = 128;

    public static boolean weakerAccess(int me, int than) {
        return Difference.isPrivate(me) && !Difference.isPrivate(than) || Difference.isProtected(me) && Difference.isPublic(than) || Difference.isPackageLocal(me) && (than & 5) != 0;
    }

    public static boolean isPrivate(int access) {
        return (access & 2) != 0;
    }

    public static boolean isPublic(int access) {
        return (access & 1) != 0;
    }

    public static boolean isProtected(int access) {
        return (access & 4) != 0;
    }

    public static boolean isPackageLocal(int access) {
        return (access & 7) == 0;
    }

    public static <T, D extends Difference> Specifier<T, D> make(@Nullable Set<T> past, @Nullable Set<T> now) {
        Set changed;
        boolean nowEmpty;
        boolean pastEmpty = past == null || past.isEmpty();
        boolean bl = nowEmpty = now == null || now.isEmpty();
        if (pastEmpty && nowEmpty) {
            return new Specifier<T, D>(){

                @Override
                public Collection<T> added() {
                    return Collections.emptySet();
                }

                @Override
                public Collection<T> removed() {
                    return Collections.emptySet();
                }

                @Override
                public Collection<Pair<T, D>> changed() {
                    return Collections.emptySet();
                }

                @Override
                public boolean unchanged() {
                    return true;
                }
            };
        }
        if (pastEmpty) {
            final Set<T> _now = Collections.unmodifiableSet(now);
            return new Specifier<T, D>(){

                @Override
                public Collection<T> added() {
                    return _now;
                }

                @Override
                public Collection<T> removed() {
                    return Collections.emptySet();
                }

                @Override
                public Collection<Pair<T, D>> changed() {
                    return Collections.emptySet();
                }

                @Override
                public boolean unchanged() {
                    return false;
                }
            };
        }
        if (nowEmpty) {
            final Set<T> _past = Collections.unmodifiableSet(past);
            return new Specifier<T, D>(){

                @Override
                public Collection<T> added() {
                    return Collections.emptySet();
                }

                @Override
                public Collection<T> removed() {
                    return _past;
                }

                @Override
                public Collection<Pair<T, D>> changed() {
                    return Collections.emptySet();
                }

                @Override
                public boolean unchanged() {
                    return false;
                }
            };
        }
        final HashSet<T> added = new HashSet<T>(now);
        added.removeAll(past);
        final HashSet<T> removed = new HashSet<T>(past);
        removed.removeAll(now);
        if (Difference.canContainChangedElements(past, now)) {
            changed = new HashSet();
            HashSet<T> intersect = new HashSet<T>(past);
            HashMap<T, T> nowMap = new HashMap<T, T>();
            for (T s : now) {
                if (!intersect.contains(s)) continue;
                nowMap.put(s, s);
            }
            intersect.retainAll(now);
            for (Object x : intersect) {
                Proto px = (Proto)x;
                Proto py = (Proto)nowMap.get(x);
                Difference diff = py.difference(px);
                if (diff.no()) continue;
                changed.add(Pair.create((Object)x, (Object)diff));
            }
        } else {
            changed = Collections.emptySet();
        }
        return new Specifier<T, D>(){

            @Override
            public Collection<T> added() {
                return added;
            }

            @Override
            public Collection<T> removed() {
                return removed;
            }

            @Override
            public Collection<Pair<T, D>> changed() {
                return changed;
            }

            @Override
            public boolean unchanged() {
                return changed.isEmpty() && added.isEmpty() && removed.isEmpty();
            }
        };
    }

    private static <T> boolean canContainChangedElements(Collection<T> past, Collection<T> now) {
        if (past != null && now != null && !past.isEmpty() && !now.isEmpty()) {
            return past.iterator().next() instanceof Proto;
        }
        return false;
    }

    public abstract int base();

    public abstract boolean no();

    public abstract boolean accessRestricted();

    public abstract boolean accessExpanded();

    public abstract int addedModifiers();

    public abstract int removedModifiers();

    public abstract boolean packageLocalOn();

    public abstract boolean hadValue();

    public abstract Specifier<TypeRepr.ClassType, Difference> annotations();

    public static interface Specifier<T, D extends Difference> {
        public Collection<T> added();

        public Collection<T> removed();

        public Collection<Pair<T, D>> changed();

        public boolean unchanged();
    }
}

